
# Loading additional proc with user specified bodies to compute parameter values.
source [file join [file dirname [file dirname [info script]]] gui/sine_v1_0.gtcl]

# Definitional proc to organize widgets for parameters.
proc init_gui { IPINST } {
  ipgui::add_param $IPINST -name "Component_Name"
  #Adding Page
  set Page_0 [ipgui::add_page $IPINST -name "Page 0"]
  ipgui::add_param $IPINST -name "IN_AXIS_BITS_PER_REAL" -parent ${Page_0}
  ipgui::add_param $IPINST -name "OUT_AXIS_BITS_PER_REAL" -parent ${Page_0}
  ipgui::add_param $IPINST -name "SAMPLES_PER_CLOCK" -parent ${Page_0}
  ipgui::add_param $IPINST -name "TDEST_WIDTH" -parent ${Page_0}
  ipgui::add_param $IPINST -name "TID_WIDTH" -parent ${Page_0}


}

proc update_PARAM_VALUE.IN_AXIS_BUS_WIDTH { PARAM_VALUE.IN_AXIS_BUS_WIDTH PARAM_VALUE.IN_AXIS_BITS_PER_REAL PARAM_VALUE.SAMPLES_PER_CLOCK } {
	# Procedure called to update IN_AXIS_BUS_WIDTH when any of the dependent parameters in the arguments change
	
	set IN_AXIS_BUS_WIDTH ${PARAM_VALUE.IN_AXIS_BUS_WIDTH}
	set IN_AXIS_BITS_PER_REAL ${PARAM_VALUE.IN_AXIS_BITS_PER_REAL}
	set SAMPLES_PER_CLOCK ${PARAM_VALUE.SAMPLES_PER_CLOCK}
	set values(IN_AXIS_BITS_PER_REAL) [get_property value $IN_AXIS_BITS_PER_REAL]
	set values(SAMPLES_PER_CLOCK) [get_property value $SAMPLES_PER_CLOCK]
	set_property value [gen_USERPARAMETER_IN_AXIS_BUS_WIDTH_VALUE $values(IN_AXIS_BITS_PER_REAL) $values(SAMPLES_PER_CLOCK)] $IN_AXIS_BUS_WIDTH
}

proc validate_PARAM_VALUE.IN_AXIS_BUS_WIDTH { PARAM_VALUE.IN_AXIS_BUS_WIDTH } {
	# Procedure called to validate IN_AXIS_BUS_WIDTH
	return true
}

proc update_PARAM_VALUE.IN_REMAINDER_BITS { PARAM_VALUE.IN_REMAINDER_BITS PARAM_VALUE.IN_AXIS_BITS_PER_REAL PARAM_VALUE.TABLE_ADDRESS_BITS } {
	# Procedure called to update IN_REMAINDER_BITS when any of the dependent parameters in the arguments change
	
	set IN_REMAINDER_BITS ${PARAM_VALUE.IN_REMAINDER_BITS}
	set IN_AXIS_BITS_PER_REAL ${PARAM_VALUE.IN_AXIS_BITS_PER_REAL}
	set TABLE_ADDRESS_BITS ${PARAM_VALUE.TABLE_ADDRESS_BITS}
	set values(IN_AXIS_BITS_PER_REAL) [get_property value $IN_AXIS_BITS_PER_REAL]
	set values(TABLE_ADDRESS_BITS) [get_property value $TABLE_ADDRESS_BITS]
	set_property value [gen_USERPARAMETER_IN_REMAINDER_BITS_VALUE $values(IN_AXIS_BITS_PER_REAL) $values(TABLE_ADDRESS_BITS)] $IN_REMAINDER_BITS
}

proc validate_PARAM_VALUE.IN_REMAINDER_BITS { PARAM_VALUE.IN_REMAINDER_BITS } {
	# Procedure called to validate IN_REMAINDER_BITS
	return true
}

proc update_PARAM_VALUE.NUM_ROMS { PARAM_VALUE.NUM_ROMS PARAM_VALUE.SAMPLES_PER_CLOCK } {
	# Procedure called to update NUM_ROMS when any of the dependent parameters in the arguments change
	
	set NUM_ROMS ${PARAM_VALUE.NUM_ROMS}
	set SAMPLES_PER_CLOCK ${PARAM_VALUE.SAMPLES_PER_CLOCK}
	set values(SAMPLES_PER_CLOCK) [get_property value $SAMPLES_PER_CLOCK]
	set_property value [gen_USERPARAMETER_NUM_ROMS_VALUE $values(SAMPLES_PER_CLOCK)] $NUM_ROMS
}

proc validate_PARAM_VALUE.NUM_ROMS { PARAM_VALUE.NUM_ROMS } {
	# Procedure called to validate NUM_ROMS
	return true
}

proc update_PARAM_VALUE.OUT_AXIS_BUS_WIDTH { PARAM_VALUE.OUT_AXIS_BUS_WIDTH PARAM_VALUE.OUT_AXIS_BITS_PER_REAL PARAM_VALUE.SAMPLES_PER_CLOCK } {
	# Procedure called to update OUT_AXIS_BUS_WIDTH when any of the dependent parameters in the arguments change
	
	set OUT_AXIS_BUS_WIDTH ${PARAM_VALUE.OUT_AXIS_BUS_WIDTH}
	set OUT_AXIS_BITS_PER_REAL ${PARAM_VALUE.OUT_AXIS_BITS_PER_REAL}
	set SAMPLES_PER_CLOCK ${PARAM_VALUE.SAMPLES_PER_CLOCK}
	set values(OUT_AXIS_BITS_PER_REAL) [get_property value $OUT_AXIS_BITS_PER_REAL]
	set values(SAMPLES_PER_CLOCK) [get_property value $SAMPLES_PER_CLOCK]
	set_property value [gen_USERPARAMETER_OUT_AXIS_BUS_WIDTH_VALUE $values(OUT_AXIS_BITS_PER_REAL) $values(SAMPLES_PER_CLOCK)] $OUT_AXIS_BUS_WIDTH
}

proc validate_PARAM_VALUE.OUT_AXIS_BUS_WIDTH { PARAM_VALUE.OUT_AXIS_BUS_WIDTH } {
	# Procedure called to validate OUT_AXIS_BUS_WIDTH
	return true
}

proc update_PARAM_VALUE.OUT_SHIFT_BITS { PARAM_VALUE.OUT_SHIFT_BITS PARAM_VALUE.TABLE_VALUE_BITS PARAM_VALUE.OUT_AXIS_BITS_PER_REAL } {
	# Procedure called to update OUT_SHIFT_BITS when any of the dependent parameters in the arguments change
	
	set OUT_SHIFT_BITS ${PARAM_VALUE.OUT_SHIFT_BITS}
	set TABLE_VALUE_BITS ${PARAM_VALUE.TABLE_VALUE_BITS}
	set OUT_AXIS_BITS_PER_REAL ${PARAM_VALUE.OUT_AXIS_BITS_PER_REAL}
	set values(TABLE_VALUE_BITS) [get_property value $TABLE_VALUE_BITS]
	set values(OUT_AXIS_BITS_PER_REAL) [get_property value $OUT_AXIS_BITS_PER_REAL]
	set_property value [gen_USERPARAMETER_OUT_SHIFT_BITS_VALUE $values(TABLE_VALUE_BITS) $values(OUT_AXIS_BITS_PER_REAL)] $OUT_SHIFT_BITS
}

proc validate_PARAM_VALUE.OUT_SHIFT_BITS { PARAM_VALUE.OUT_SHIFT_BITS } {
	# Procedure called to validate OUT_SHIFT_BITS
	return true
}

proc update_PARAM_VALUE.TABLE_BITS { PARAM_VALUE.TABLE_BITS PARAM_VALUE.TABLE_VALUE_BITS PARAM_VALUE.TABLE_SLOPE_BITS } {
	# Procedure called to update TABLE_BITS when any of the dependent parameters in the arguments change
	
	set TABLE_BITS ${PARAM_VALUE.TABLE_BITS}
	set TABLE_VALUE_BITS ${PARAM_VALUE.TABLE_VALUE_BITS}
	set TABLE_SLOPE_BITS ${PARAM_VALUE.TABLE_SLOPE_BITS}
	set values(TABLE_VALUE_BITS) [get_property value $TABLE_VALUE_BITS]
	set values(TABLE_SLOPE_BITS) [get_property value $TABLE_SLOPE_BITS]
	set_property value [gen_USERPARAMETER_TABLE_BITS_VALUE $values(TABLE_VALUE_BITS) $values(TABLE_SLOPE_BITS)] $TABLE_BITS
}

proc validate_PARAM_VALUE.TABLE_BITS { PARAM_VALUE.TABLE_BITS } {
	# Procedure called to validate TABLE_BITS
	return true
}

proc update_PARAM_VALUE.TABLE_LENGTH { PARAM_VALUE.TABLE_LENGTH PARAM_VALUE.TABLE_ADDRESS_BITS } {
	# Procedure called to update TABLE_LENGTH when any of the dependent parameters in the arguments change
	
	set TABLE_LENGTH ${PARAM_VALUE.TABLE_LENGTH}
	set TABLE_ADDRESS_BITS ${PARAM_VALUE.TABLE_ADDRESS_BITS}
	set values(TABLE_ADDRESS_BITS) [get_property value $TABLE_ADDRESS_BITS]
	set_property value [gen_USERPARAMETER_TABLE_LENGTH_VALUE $values(TABLE_ADDRESS_BITS)] $TABLE_LENGTH
}

proc validate_PARAM_VALUE.TABLE_LENGTH { PARAM_VALUE.TABLE_LENGTH } {
	# Procedure called to validate TABLE_LENGTH
	return true
}

proc update_PARAM_VALUE.TDEST_DUMMY_WIDTH { PARAM_VALUE.TDEST_DUMMY_WIDTH PARAM_VALUE.TDEST_WIDTH } {
	# Procedure called to update TDEST_DUMMY_WIDTH when any of the dependent parameters in the arguments change
	
	set TDEST_DUMMY_WIDTH ${PARAM_VALUE.TDEST_DUMMY_WIDTH}
	set TDEST_WIDTH ${PARAM_VALUE.TDEST_WIDTH}
	set values(TDEST_WIDTH) [get_property value $TDEST_WIDTH]
	set_property value [gen_USERPARAMETER_TDEST_DUMMY_WIDTH_VALUE $values(TDEST_WIDTH)] $TDEST_DUMMY_WIDTH
}

proc validate_PARAM_VALUE.TDEST_DUMMY_WIDTH { PARAM_VALUE.TDEST_DUMMY_WIDTH } {
	# Procedure called to validate TDEST_DUMMY_WIDTH
	return true
}

proc update_PARAM_VALUE.TID_DUMMY_WIDTH { PARAM_VALUE.TID_DUMMY_WIDTH PARAM_VALUE.TID_WIDTH } {
	# Procedure called to update TID_DUMMY_WIDTH when any of the dependent parameters in the arguments change
	
	set TID_DUMMY_WIDTH ${PARAM_VALUE.TID_DUMMY_WIDTH}
	set TID_WIDTH ${PARAM_VALUE.TID_WIDTH}
	set values(TID_WIDTH) [get_property value $TID_WIDTH]
	set_property value [gen_USERPARAMETER_TID_DUMMY_WIDTH_VALUE $values(TID_WIDTH)] $TID_DUMMY_WIDTH
}

proc validate_PARAM_VALUE.TID_DUMMY_WIDTH { PARAM_VALUE.TID_DUMMY_WIDTH } {
	# Procedure called to validate TID_DUMMY_WIDTH
	return true
}

proc update_PARAM_VALUE.IN_AXIS_BITS_PER_REAL { PARAM_VALUE.IN_AXIS_BITS_PER_REAL } {
	# Procedure called to update IN_AXIS_BITS_PER_REAL when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.IN_AXIS_BITS_PER_REAL { PARAM_VALUE.IN_AXIS_BITS_PER_REAL } {
	# Procedure called to validate IN_AXIS_BITS_PER_REAL
	return true
}

proc update_PARAM_VALUE.OUT_AXIS_BITS_PER_REAL { PARAM_VALUE.OUT_AXIS_BITS_PER_REAL } {
	# Procedure called to update OUT_AXIS_BITS_PER_REAL when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.OUT_AXIS_BITS_PER_REAL { PARAM_VALUE.OUT_AXIS_BITS_PER_REAL } {
	# Procedure called to validate OUT_AXIS_BITS_PER_REAL
	return true
}

proc update_PARAM_VALUE.SAMPLES_PER_CLOCK { PARAM_VALUE.SAMPLES_PER_CLOCK } {
	# Procedure called to update SAMPLES_PER_CLOCK when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.SAMPLES_PER_CLOCK { PARAM_VALUE.SAMPLES_PER_CLOCK } {
	# Procedure called to validate SAMPLES_PER_CLOCK
	return true
}

proc update_PARAM_VALUE.SINE_DELAY { PARAM_VALUE.SINE_DELAY } {
	# Procedure called to update SINE_DELAY when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.SINE_DELAY { PARAM_VALUE.SINE_DELAY } {
	# Procedure called to validate SINE_DELAY
	return true
}

proc update_PARAM_VALUE.TABLE_ADDRESS_BITS { PARAM_VALUE.TABLE_ADDRESS_BITS } {
	# Procedure called to update TABLE_ADDRESS_BITS when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.TABLE_ADDRESS_BITS { PARAM_VALUE.TABLE_ADDRESS_BITS } {
	# Procedure called to validate TABLE_ADDRESS_BITS
	return true
}

proc update_PARAM_VALUE.TABLE_SLOPE_BITS { PARAM_VALUE.TABLE_SLOPE_BITS } {
	# Procedure called to update TABLE_SLOPE_BITS when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.TABLE_SLOPE_BITS { PARAM_VALUE.TABLE_SLOPE_BITS } {
	# Procedure called to validate TABLE_SLOPE_BITS
	return true
}

proc update_PARAM_VALUE.TABLE_VALUE_BITS { PARAM_VALUE.TABLE_VALUE_BITS } {
	# Procedure called to update TABLE_VALUE_BITS when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.TABLE_VALUE_BITS { PARAM_VALUE.TABLE_VALUE_BITS } {
	# Procedure called to validate TABLE_VALUE_BITS
	return true
}

proc update_PARAM_VALUE.TDEST_WIDTH { PARAM_VALUE.TDEST_WIDTH } {
	# Procedure called to update TDEST_WIDTH when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.TDEST_WIDTH { PARAM_VALUE.TDEST_WIDTH } {
	# Procedure called to validate TDEST_WIDTH
	return true
}

proc update_PARAM_VALUE.TID_WIDTH { PARAM_VALUE.TID_WIDTH } {
	# Procedure called to update TID_WIDTH when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.TID_WIDTH { PARAM_VALUE.TID_WIDTH } {
	# Procedure called to validate TID_WIDTH
	return true
}


proc update_MODELPARAM_VALUE.SAMPLES_PER_CLOCK { MODELPARAM_VALUE.SAMPLES_PER_CLOCK PARAM_VALUE.SAMPLES_PER_CLOCK } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.SAMPLES_PER_CLOCK}] ${MODELPARAM_VALUE.SAMPLES_PER_CLOCK}
}

proc update_MODELPARAM_VALUE.IN_AXIS_BITS_PER_REAL { MODELPARAM_VALUE.IN_AXIS_BITS_PER_REAL PARAM_VALUE.IN_AXIS_BITS_PER_REAL } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.IN_AXIS_BITS_PER_REAL}] ${MODELPARAM_VALUE.IN_AXIS_BITS_PER_REAL}
}

proc update_MODELPARAM_VALUE.OUT_AXIS_BITS_PER_REAL { MODELPARAM_VALUE.OUT_AXIS_BITS_PER_REAL PARAM_VALUE.OUT_AXIS_BITS_PER_REAL } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.OUT_AXIS_BITS_PER_REAL}] ${MODELPARAM_VALUE.OUT_AXIS_BITS_PER_REAL}
}

proc update_MODELPARAM_VALUE.TID_WIDTH { MODELPARAM_VALUE.TID_WIDTH PARAM_VALUE.TID_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TID_WIDTH}] ${MODELPARAM_VALUE.TID_WIDTH}
}

proc update_MODELPARAM_VALUE.TDEST_WIDTH { MODELPARAM_VALUE.TDEST_WIDTH PARAM_VALUE.TDEST_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TDEST_WIDTH}] ${MODELPARAM_VALUE.TDEST_WIDTH}
}

proc update_MODELPARAM_VALUE.TABLE_ADDRESS_BITS { MODELPARAM_VALUE.TABLE_ADDRESS_BITS PARAM_VALUE.TABLE_ADDRESS_BITS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TABLE_ADDRESS_BITS}] ${MODELPARAM_VALUE.TABLE_ADDRESS_BITS}
}

proc update_MODELPARAM_VALUE.TABLE_VALUE_BITS { MODELPARAM_VALUE.TABLE_VALUE_BITS PARAM_VALUE.TABLE_VALUE_BITS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TABLE_VALUE_BITS}] ${MODELPARAM_VALUE.TABLE_VALUE_BITS}
}

proc update_MODELPARAM_VALUE.TABLE_SLOPE_BITS { MODELPARAM_VALUE.TABLE_SLOPE_BITS PARAM_VALUE.TABLE_SLOPE_BITS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TABLE_SLOPE_BITS}] ${MODELPARAM_VALUE.TABLE_SLOPE_BITS}
}

proc update_MODELPARAM_VALUE.SINE_DELAY { MODELPARAM_VALUE.SINE_DELAY PARAM_VALUE.SINE_DELAY } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.SINE_DELAY}] ${MODELPARAM_VALUE.SINE_DELAY}
}

proc update_MODELPARAM_VALUE.NUM_ROMS { MODELPARAM_VALUE.NUM_ROMS PARAM_VALUE.NUM_ROMS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.NUM_ROMS}] ${MODELPARAM_VALUE.NUM_ROMS}
}

proc update_MODELPARAM_VALUE.TABLE_LENGTH { MODELPARAM_VALUE.TABLE_LENGTH PARAM_VALUE.TABLE_LENGTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TABLE_LENGTH}] ${MODELPARAM_VALUE.TABLE_LENGTH}
}

proc update_MODELPARAM_VALUE.IN_REMAINDER_BITS { MODELPARAM_VALUE.IN_REMAINDER_BITS PARAM_VALUE.IN_REMAINDER_BITS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.IN_REMAINDER_BITS}] ${MODELPARAM_VALUE.IN_REMAINDER_BITS}
}

proc update_MODELPARAM_VALUE.TABLE_BITS { MODELPARAM_VALUE.TABLE_BITS PARAM_VALUE.TABLE_BITS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TABLE_BITS}] ${MODELPARAM_VALUE.TABLE_BITS}
}

proc update_MODELPARAM_VALUE.OUT_SHIFT_BITS { MODELPARAM_VALUE.OUT_SHIFT_BITS PARAM_VALUE.OUT_SHIFT_BITS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.OUT_SHIFT_BITS}] ${MODELPARAM_VALUE.OUT_SHIFT_BITS}
}

proc update_MODELPARAM_VALUE.IN_AXIS_BUS_WIDTH { MODELPARAM_VALUE.IN_AXIS_BUS_WIDTH PARAM_VALUE.IN_AXIS_BUS_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.IN_AXIS_BUS_WIDTH}] ${MODELPARAM_VALUE.IN_AXIS_BUS_WIDTH}
}

proc update_MODELPARAM_VALUE.OUT_AXIS_BUS_WIDTH { MODELPARAM_VALUE.OUT_AXIS_BUS_WIDTH PARAM_VALUE.OUT_AXIS_BUS_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.OUT_AXIS_BUS_WIDTH}] ${MODELPARAM_VALUE.OUT_AXIS_BUS_WIDTH}
}

proc update_MODELPARAM_VALUE.TID_DUMMY_WIDTH { MODELPARAM_VALUE.TID_DUMMY_WIDTH PARAM_VALUE.TID_DUMMY_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TID_DUMMY_WIDTH}] ${MODELPARAM_VALUE.TID_DUMMY_WIDTH}
}

proc update_MODELPARAM_VALUE.TDEST_DUMMY_WIDTH { MODELPARAM_VALUE.TDEST_DUMMY_WIDTH PARAM_VALUE.TDEST_DUMMY_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TDEST_DUMMY_WIDTH}] ${MODELPARAM_VALUE.TDEST_DUMMY_WIDTH}
}

