
//
// Copyright (C) 2022 Ross Martin
//
// Versions
//
// 2022.01.08  Coding begun
// 

/* verilator lint_off PINMISSING  */
/* verilator lint_off WIDTHEXPAND  */
/* verilator lint_off WIDTHTRUNC  */
/* verilator lint_off UNDRIVEN  */


function automatic integer BxB_fatal(string text);

   $error("\"%s\"", text);   
   
   // Function return value intentionally omitted to cause an error, in case other methods do not.
endfunction // fatal

`undef w
`undef r
`undef w
`define w assign
`undef r
`define r always@(posedge clk)
`timescale  1 ps / 1 ps

`include "bram_based_ram.vh"

   
/* verilator lint_off DECLFILENAME  */
(* DONT_TOUCH = "YES" *)
module bram_column
/* verilator lint_on DECLFILENAME  */
  #(  
      parameter  LENGTH                       = 1024,
      parameter  WIDTH                        = 72,
      parameter  EXTRA_ADDRESS_REGISTERS      = 0,
      parameter  ADDRESS_BITS                 = $clog2(LENGTH),
      parameter  READ_WRITE_MODE              = "NO_CHANGE"
   )
   (
      input                    clk,
      input                    resetn,
      input                    write_enable_i,
      input [ADDRESS_BITS-1:0] write_addr_i,
      input [WIDTH-1:0]        write_data_i,
      input [ADDRESS_BITS-1:0] read_addr_i,
      output [WIDTH-1:0]       read_data_ro
   );
   
   localparam  MAX_WIDTH_SINGLE_COLUMN      = bram_based_ram_width(LENGTH);
   localparam  CASCADE                      = bram_based_ram_cascade(LENGTH);
   localparam  USE_BRAM18                   = bram_based_ram_use_bram18(LENGTH, WIDTH);
   localparam  POST_CASCADE_ADDRESS_BITS    = bram_based_ram_post_cascade_address_bits(LENGTH);
   localparam  POST_CASCADE_ADDRESS_LENGTH  = bram_based_ram_post_cascade_address_bits(LENGTH);
   localparam  CASCADE_BITS                 = $clog2(CASCADE);
   localparam  DELAY                        = bram_based_ram_register_delay(LENGTH);
   localparam  WIDTH_THIS_COLUMN            = USE_BRAM18 ? MAX_WIDTH_SINGLE_COLUMN/2 : MAX_WIDTH_SINGLE_COLUMN;
   localparam  EXTRA_REGISTERS              = bram_based_ram_extra_registers(LENGTH);
   
   localparam ADDR_SHIFT = (WIDTH_THIS_COLUMN ==  0)  ?       0      :
                           (WIDTH_THIS_COLUMN ==  1)  ?       0      :
                           (WIDTH_THIS_COLUMN ==  2)  ?       1      :
                           (WIDTH_THIS_COLUMN ==  4)  ?       2      :
                           (WIDTH_THIS_COLUMN ==  9)  ?       3      :
                           (WIDTH_THIS_COLUMN == 18)  ?       4      :
                           (WIDTH_THIS_COLUMN == 36)  ?       5      :
                           (WIDTH_THIS_COLUMN == 72)  ?       6      :
                           /**/                               BxB_fatal("Bad ADDR Shift in bram_column")  ;
   
   genvar                              c;

   initial $display("Column of LENGTH=%0d, WIDTH=%0d implemented with CASCADE=%0d (%0d BRAM%0d)",
                     LENGTH, WIDTH, CASCADE, CASCADE, USE_BRAM18 ? 18 : 36);
   
   generate

      if(!USE_BRAM18)
        begin : gen_blk_not_bram18

           wire [31:0]                           CASDINA  [0:CASCADE];
           wire [3:0]                            CASDINPA [0:CASCADE];
           wire [31:0]                           CASDINB  [0:CASCADE];
           wire [3:0]                            CASDINPB [0:CASCADE];

           `w CASDINA[0] = 0;
           `w CASDINPA[0] = 0;
           `w CASDINB[0] = 0;
           `w CASDINPB[0] = 0;
           
           for(c=0; c<CASCADE; c=c+1)
             begin : cascade_loop

                localparam CASCADE_ORDER_A = (CASCADE==1)  ?  "NONE"    :
                                             c==0          ?  "FIRST"   :
                                             c==CASCADE-1  ?  "LAST"    :
                                             /**/             "MIDDLE"  ;

                localparam CASCADE_ORDER_B = (WIDTH_THIS_COLUMN==72) ? CASCADE_ORDER_A : "NONE";

                wire [WIDTH_THIS_COLUMN-1:0]          write_data_w;
                wire [WIDTH_THIS_COLUMN-1:0]          data_in;
                wire [WIDTH_THIS_COLUMN-1:0]          data_out;
                wire [31:0]                           DINADIN;
                wire [3:0]                            DINPADINP;
                wire [31:0]                           DINBDIN;
                wire [3:0]                            DINPBDINP;
                wire [31:0]                           DOUTADOUT;
                wire [3:0]                            DOUTPADOUTP;
                wire [31:0]                           DOUTBDOUT;
                wire [3:0]                            DOUTPBDOUTP;
                wire [POST_CASCADE_ADDRESS_BITS-1:0]  wr_addr_w;
                wire [POST_CASCADE_ADDRESS_BITS-1:0]  wr_addr_d;
                wire [POST_CASCADE_ADDRESS_BITS-1:0]  rd_addr_w;
                wire [POST_CASCADE_ADDRESS_BITS-1:0]  rd_addr_d;
                wire                                  wr_en_this_bram_w;
                wire                                  wr_en_this_bram_d;
                wire                                  rd_en_this_bram_w;
                wire                                  rd_en_this_bram_d;
                wire                                  rd_en_this_bram_not_d;

                `w write_data_w = write_data_i;  // Extend to full bit width, if lesser.
                
                //delay #(.DELAY(1+c), .BIT_WIDTH(WIDTH_THIS_COLUMN)) data_delay ( .clk(clk), .in_i(write_data_i), .out_o(data_in));
                all_register_delay #(.DELAY(EXTRA_REGISTERS), .BIT_WIDTH(WIDTH_THIS_COLUMN)) data_delay ( .clk(clk), .in_i(write_data_w), .out_o(data_in));
                
                if     (WIDTH_THIS_COLUMN==72)
                  begin : gen_blk_width_72
                     `w DINADIN   = data_in[31:0];
                     `w DINBDIN   = data_in[63:32];
                     `w DINPADINP = data_in[67:64];
                     `w DINPBDINP = data_in[71:68];
                     `w data_out[31:0]  = DOUTADOUT;
                     `w data_out[63:32] = DOUTBDOUT;
                     `w data_out[67:64] = DOUTPADOUTP; 
                     `w data_out[71:68] = DOUTPBDOUTP; 
                  end
                else if(WIDTH_THIS_COLUMN==36)
                  begin : gen_blk_width_36
                     `w DINBDIN   = data_in[31:0];
                     `w DINPBDINP = data_in[35:32];
                     `w data_out[31:0]  = DOUTADOUT;
                     `w data_out[35:32] = DOUTPADOUTP;
                  end
                else if(WIDTH_THIS_COLUMN==18)
                  begin : gen_blk_width_18
                     `w DINBDIN   = data_in[15:0];
                     `w DINPBDINP = data_in[17:16];
                     `w data_out[15:0]  = DOUTADOUT[15:0];
                     `w data_out[17:16] = DOUTPADOUTP[1:0];
                  end
                else if(WIDTH_THIS_COLUMN==9)
                  begin : gen_blk_width_9
                     `w DINBDIN   = data_in[7:0];
                     `w DINPBDINP = data_in[8];
                     `w data_out[7:0]  = DOUTADOUT[7:0];
                     `w data_out[8]    = DOUTPADOUTP[0];
                  end
                else if(WIDTH_THIS_COLUMN==4)
                  begin : gen_blk_width_4
                     `w DINBDIN   = data_in[3:0];
                     `w DINPBDINP = 0;
                     `w data_out  = DOUTADOUT[3:0];
                  end
                else if(WIDTH_THIS_COLUMN==2)
                  begin : gen_blk_width_2
                     `w DINBDIN   = data_in[1:0];
                     `w DINPBDINP = 0;
                     `w data_out  = DOUTADOUT[1:0];
                  end
                else if(WIDTH_THIS_COLUMN==1)
                  begin : gen_blk_width_1
                     `w DINBDIN   = data_in[0];
                     `w DINPBDINP = 0;
                     `w data_out  = DOUTADOUT[0];
                  end

                `w wr_addr_w = write_addr_i[POST_CASCADE_ADDRESS_BITS-1:0];
                `w rd_addr_w = read_addr_i[POST_CASCADE_ADDRESS_BITS-1:0];

                //delay #(.DELAY(1+c), .BIT_WIDTH(POST_CASCADE_ADDRESS_BITS)) wraddr_delay ( .clk(clk), .in_i(wr_addr_w), .out_o(wr_addr_d));
                //delay #(.DELAY(1+c), .BIT_WIDTH(POST_CASCADE_ADDRESS_BITS)) rdaddr_delay ( .clk(clk), .in_i(rd_addr_w), .out_o(rd_addr_d));
                all_register_delay #(.DELAY(EXTRA_REGISTERS+EXTRA_ADDRESS_REGISTERS), .BIT_WIDTH(POST_CASCADE_ADDRESS_BITS)) wraddr_delay ( .clk(clk), .in_i(wr_addr_w), .out_o(wr_addr_d));
                all_register_delay #(.DELAY(EXTRA_REGISTERS+EXTRA_ADDRESS_REGISTERS), .BIT_WIDTH(POST_CASCADE_ADDRESS_BITS)) rdaddr_delay ( .clk(clk), .in_i(rd_addr_w), .out_o(rd_addr_d));

                if(CASCADE==1)
                  begin : gen_blk_cascade_1
                     `w wr_en_this_bram_d = 1;
                     `w rd_en_this_bram_d = 1;
                     `w rd_en_this_bram_not_d = !rd_en_this_bram_d;
                  end
                else
                  begin : gen_blk_cascade_not_1
                     wire [CASCADE_BITS-1:0]                 wr_sel_addr_w;
                     wire [CASCADE_BITS-1:0]                 rd_sel_addr_w;
                     `w wr_sel_addr_w = write_addr_i[POST_CASCADE_ADDRESS_BITS +: CASCADE_BITS];
                     `w rd_sel_addr_w = read_addr_i [POST_CASCADE_ADDRESS_BITS +: CASCADE_BITS];
                     `w wr_en_this_bram_w = (wr_sel_addr_w==c);
                     `w rd_en_this_bram_w = (rd_sel_addr_w==c);
                     //delay #(.DELAY(1+c), .BIT_WIDTH(1)) wr_en_delay ( .clk(clk), .in_i(wr_en_this_bram_w), .out_o(wr_en_this_bram_d));
                     //delay #(.DELAY(1+c), .BIT_WIDTH(1)) rd_en_delay ( .clk(clk), .in_i(rd_en_this_bram_w), .out_o(rd_en_this_bram_d));
                     all_register_delay #(.DELAY(EXTRA_REGISTERS+EXTRA_ADDRESS_REGISTERS), .BIT_WIDTH(1)) wr_en_delay ( .clk(clk), .in_i(wr_en_this_bram_w), .out_o(wr_en_this_bram_d));
                     all_register_delay #(.DELAY(EXTRA_REGISTERS+EXTRA_ADDRESS_REGISTERS), .BIT_WIDTH(1)) rd_en_delay ( .clk(clk), .in_i(rd_en_this_bram_w), .out_o(rd_en_this_bram_d));
                     all_register_delay #(.DELAY(EXTRA_REGISTERS+EXTRA_ADDRESS_REGISTERS), .BIT_WIDTH(1)) rd_en_not_delay ( .clk(clk), .in_i(!rd_en_this_bram_w), .out_o(rd_en_this_bram_not_d));
                  end

                wire [14:0]                                  ADDRARDADDR;
                wire [14:0]                                  ADDRBWRADDR;

                `w ADDRARDADDR = rd_addr_d << ADDR_SHIFT;
                `w ADDRBWRADDR = wr_addr_d << ADDR_SHIFT;

                //delay #(.DELAY(EXTRA_ADDRESS_REGISTERS),  .BIT_WIDTH(15)) read_addr_delay  ( .clk(clk), .in_i(rd_addr_d << ADDR_SHIFT), .out_o(ADDRARDADDR) );
                //delay #(.DELAY(EXTRA_ADDRESS_REGISTERS),  .BIT_WIDTH(15)) read_addr_delay  ( .clk(clk), .in_i(wr_addr_d << ADDR_SHIFT), .out_o(ADDRBWRADDR) );

                RAMB36E2      #( .CASCADE_ORDER_A      (  CASCADE_ORDER_A     ),
                                 .CASCADE_ORDER_B      (  CASCADE_ORDER_B     ),
                                 .CLOCK_DOMAINS        (  "COMMON"            ),
                                 .DOA_REG              (  (c==CASCADE-1)      ),
                                 .DOB_REG              (  (c==CASCADE-1)      ),
                                 .ENADDRENA            (  "FALSE"             ),
                                 .ENADDRENB            (  "FALSE"             ),
                                 .EN_ECC_PIPE          (  "FALSE"             ),
                                 .EN_ECC_READ          (  "FALSE"             ),
                                 .EN_ECC_WRITE         (  "FALSE"             ),
                                 .INIT_A               (  36'h000000000       ),
                                 .INIT_B               (  36'h000000000       ),
                                 .INIT_FILE            (  "NONE"              ),
                                 .RDADDRCHANGEA        (  "FALSE"             ),
                                 .RDADDRCHANGEB        (  "FALSE"             ),
                                 .READ_WIDTH_A         (  WIDTH_THIS_COLUMN   ),
                                 .READ_WIDTH_B         (  0                   ),
                                 .RSTREG_PRIORITY_A    (  "RSTREG"            ),
                                 .RSTREG_PRIORITY_B    (  "RSTREG"            ),
                                 .SIM_COLLISION_CHECK  (  "ALL"               ),
                                 .SLEEP_ASYNC          (  "FALSE"             ),
                                 .SRVAL_A              (  36'h000000000       ),
                                 .SRVAL_B              (  36'h000000000       ),
                                 .WRITE_MODE_A         (  READ_WRITE_MODE     ),
                                 .WRITE_MODE_B         (  READ_WRITE_MODE     ),
                                 .WRITE_WIDTH_A        (  0                   ),
                                 .WRITE_WIDTH_B        (  WIDTH_THIS_COLUMN   ))
                bram36         ( .ADDRARDADDR          (  ADDRARDADDR         ),
                                 .ADDRBWRADDR          (  ADDRBWRADDR         ),
                                 .ADDRENA              (  1'b1                ),
                                 .ADDRENB              (  1'b1                ),
                                 .CASDIMUXA            (  1'b0                ),
                                 .CASDIMUXB            (  1'b0                ),
                                 .CASDINA              (  CASDINA[c]          ),
                                 .CASDINB              (  CASDINB[c]          ),
                                 .CASDINPA             (  CASDINPA[c]         ),
                                 .CASDINPB             (  CASDINPB[c]         ),
                                 .CASDOUTA             (  CASDINA[c+1]        ),
                                 .CASDOUTPA            (  CASDINPA[c+1]       ),
                                 .CASDOUTB             (  CASDINB[c+1]        ),
                                 .CASDOUTPB            (  CASDINPB[c+1]       ),
                                 .CASDOMUXA            (  (c==CASCADE-1) ? 1'b0 : rd_en_this_bram_not_d  ),
                                 .CASDOMUXB            (  (c==CASCADE-1) ? 1'b0 : rd_en_this_bram_not_d  ),
                                 .CASDOMUXEN_A         (  1'b1                ),
                                 .CASDOMUXEN_B         (  1'b1                ),
                                 .CASINDBITERR         (  1'b0                ),
                                 .CASINSBITERR         (  1'b0                ),
                                 .CASOREGIMUXA         (  (c==CASCADE-1) ? rd_en_this_bram_not_d : 1'b0 ),
                                 .CASOREGIMUXB         (  (c==CASCADE-1) ? rd_en_this_bram_not_d : 1'b0 ),
                                 .CASOREGIMUXEN_A      (  1'b1                ),
                                 .CASOREGIMUXEN_B      (  1'b1                ),
                                 .CLKARDCLK            (  clk                 ),
                                 .CLKBWRCLK            (  clk                 ),
                                 .DINADIN              (  DINADIN             ),
                                 .DINBDIN              (  DINBDIN             ),
                                 .DINPADINP            (  DINPADINP           ),
                                 .DINPBDINP            (  DINPBDINP           ),
                                 .DOUTADOUT            (  DOUTADOUT           ),
                                 .DOUTBDOUT            (  DOUTBDOUT           ),
                                 .DOUTPADOUTP          (  DOUTPADOUTP         ),
                                 .DOUTPBDOUTP          (  DOUTPBDOUTP         ),
                                 .ECCPIPECE            (  1'b0                ),
                                 .ENARDEN              (  rd_en_this_bram_d   ),  // Read enable, for simple dual port memory
                                 .ENBWREN              (  wr_en_this_bram_d   ),  // Write enable, for simple dual port memory
                                 .INJECTDBITERR        (  1'b0                ),
                                 .INJECTSBITERR        (  1'b0                ),
                                 .REGCEAREGCE          (  1'b1                ),
                                 .REGCEB               (  1'b1                ),
                                 .RSTRAMARSTRAM        (  1'b0                ),
                                 .RSTRAMB              (  1'b0                ),
                                 .RSTREGARSTREG        (  1'b0                ),
                                 .RSTREGB              (  1'b0                ),
                                 .SLEEP                (  1'b0                ),
                                 .WEA                  (  4'h0                ),
                                 .WEBWE                (  8'hFF               ));

                if(c==CASCADE-1)
		  begin : gen_blk_last_cascade
                     `w read_data_ro = data_out[WIDTH-1:0];
                  end
             end // for (c=0; c>CASCADE; c=c+1)
        end // if (!USE_BRAM18)
      else
        begin : gen_blk_bram18  // BRAM18 below

           wire [15:0]                           CASDINA  [0:CASCADE];
           wire [1:0]                            CASDINPA [0:CASCADE];
           wire [15:0]                           CASDINB  [0:CASCADE];
           wire [1:0]                            CASDINPB [0:CASCADE];

           `w CASDINA[0] = 0;
           `w CASDINPA[0] = 0;
           `w CASDINB[0] = 0;
           `w CASDINPB[0] = 0;
           
           for(c=0; c<CASCADE; c=c+1)
             begin : cascade_loop_2

                localparam CASCADE_ORDER_A = (CASCADE==1)  ?  "NONE"    :
                                             c==0          ?  "FIRST"   :
                                             c==CASCADE-1  ?  "LAST"    :
                                             /**/             "MIDDLE"  ;

                localparam CASCADE_ORDER_B = (WIDTH_THIS_COLUMN==36) ? CASCADE_ORDER_A : "NONE";
                
                wire [WIDTH_THIS_COLUMN-1:0]          data_in;
                wire [WIDTH_THIS_COLUMN-1:0]          data_out;
                wire [15:0]                           DINADIN;
                wire [1:0]                            DINPADINP;
                wire [15:0]                           DINBDIN;
                wire [1:0]                            DINPBDINP;
                wire [15:0]                           DOUTADOUT;
                wire [1:0]                            DOUTPADOUTP;
                wire [15:0]                           DOUTBDOUT;
                wire [1:0]                            DOUTPBDOUTP;
                wire [POST_CASCADE_ADDRESS_BITS-1:0]  wr_addr_w;
                wire [POST_CASCADE_ADDRESS_BITS-1:0]  wr_addr_d;
                wire [POST_CASCADE_ADDRESS_BITS-1:0]  rd_addr_w;
                wire [POST_CASCADE_ADDRESS_BITS-1:0]  rd_addr_d;
                wire                                  wr_en_this_bram_w;
                wire                                  wr_en_this_bram_d;
                wire                                  rd_en_this_bram_w;
                wire                                  rd_en_this_bram_d;
                wire                                  rd_en_this_bram_not_d;

                //delay #(.DELAY(1+c), .BIT_WIDTH(WIDTH_THIS_COLUMN)) data_delay ( .clk(clk), .in_i(write_data_i), .out_o(data_in));
                all_register_delay #(.DELAY(EXTRA_REGISTERS), .BIT_WIDTH(WIDTH_THIS_COLUMN)) data_delay ( .clk(clk), .in_i(write_data_i), .out_o(data_in));
                
                if     (WIDTH_THIS_COLUMN==36)
                  begin : gen_blk_width_36
                     `w DINADIN   = data_in[15:0];
                     `w DINBDIN   = data_in[31:16];
                     `w DINPADINP = data_in[33:32];
                     `w DINPBDINP = data_in[35:34];
                     `w data_out[15:0]  = DOUTADOUT;
                     `w data_out[31:16] = DOUTBDOUT;
                     `w data_out[33:32] = DOUTPADOUTP; 
                     `w data_out[35:34] = DOUTPBDOUTP; 
                  end
                else if(WIDTH_THIS_COLUMN==18)
                  begin : gen_blk_width_18
                     `w DINBDIN   = data_in[15:0];
                     `w DINPBDINP = data_in[17:16];
                     `w data_out[15:0]  = DOUTADOUT[15:0];
                     `w data_out[17:16] = DOUTPADOUTP[1:0];
                  end
                else if(WIDTH_THIS_COLUMN==9)
                  begin : gen_blk_width_9
                     `w DINBDIN   = data_in[7:0];
                     `w DINPBDINP = data_in[8];
                     `w data_out[7:0]  = DOUTADOUT[7:0];
                     `w data_out[8]    = DOUTPADOUTP[0];
                  end
                else if(WIDTH_THIS_COLUMN==4)
                  begin : gen_blk_width_4
                     `w DINBDIN   = data_in[3:0];
                     `w DINPBDINP = 0;
                     `w data_out  = DOUTADOUT[3:0];
                  end
                else if(WIDTH_THIS_COLUMN==2)
                  begin : gen_blk_width_2
                     `w DINBDIN   = data_in[1:0];
                     `w DINPBDINP = 0;
                     `w data_out  = DOUTADOUT[1:0];
                  end
                else if(WIDTH_THIS_COLUMN==1)
                  begin : gen_blk_width_1
                     `w DINBDIN   = data_in[0];
                     `w DINPBDINP = 0;
                     `w data_out  = DOUTADOUT[0];
                  end

                `w wr_addr_w = write_addr_i[POST_CASCADE_ADDRESS_BITS-1:0];
                `w rd_addr_w = read_addr_i[POST_CASCADE_ADDRESS_BITS-1:0];

                //delay #(.DELAY(1+c), .BIT_WIDTH(POST_CASCADE_ADDRESS_BITS)) wraddr_delay ( .clk(clk), .in_i(wr_addr_w), .out_o(wr_addr_d));
                //delay #(.DELAY(1+c), .BIT_WIDTH(POST_CASCADE_ADDRESS_BITS)) rdaddr_delay ( .clk(clk), .in_i(rd_addr_w), .out_o(rd_addr_d));
                all_register_delay #(.DELAY(EXTRA_REGISTERS+EXTRA_ADDRESS_REGISTERS), .BIT_WIDTH(POST_CASCADE_ADDRESS_BITS)) wraddr_delay ( .clk(clk), .in_i(wr_addr_w), .out_o(wr_addr_d));
                all_register_delay #(.DELAY(EXTRA_REGISTERS+EXTRA_ADDRESS_REGISTERS), .BIT_WIDTH(POST_CASCADE_ADDRESS_BITS)) rdaddr_delay ( .clk(clk), .in_i(rd_addr_w), .out_o(rd_addr_d));

                if(CASCADE==1)
                  begin : gen_blk_cascade_1
                     `w wr_en_this_bram_d = 1;
                     `w rd_en_this_bram_d = 1;
                     `w rd_en_this_bram_not_d = !rd_en_this_bram_d;
                  end
                else
                  begin : gen_blk_cascade_not_1
                     wire [CASCADE_BITS-1:0]                 wr_sel_addr_w;
                     wire [CASCADE_BITS-1:0]                 rd_sel_addr_w;
                     `w wr_sel_addr_w = write_addr_i[POST_CASCADE_ADDRESS_BITS +: CASCADE_BITS];
                     `w rd_sel_addr_w = read_addr_i [POST_CASCADE_ADDRESS_BITS +: CASCADE_BITS];
                     `w wr_en_this_bram_w = (wr_sel_addr_w==c);
                     `w rd_en_this_bram_w = (rd_sel_addr_w==c);
                     //delay #(.DELAY(1+c), .BIT_WIDTH(1)) wr_en_delay ( .clk(clk), .in_i(wr_en_this_bram_w), .out_o(wr_en_this_bram_d));
                     //delay #(.DELAY(1+c), .BIT_WIDTH(1)) rd_en_delay ( .clk(clk), .in_i(rd_en_this_bram_w), .out_o(rd_en_this_bram_d));
                     all_register_delay #(.DELAY(EXTRA_REGISTERS+EXTRA_ADDRESS_REGISTERS), .BIT_WIDTH(1)) wr_en_delay ( .clk(clk), .in_i(wr_en_this_bram_w), .out_o(wr_en_this_bram_d));
                     all_register_delay #(.DELAY(EXTRA_REGISTERS+EXTRA_ADDRESS_REGISTERS), .BIT_WIDTH(1)) rd_en_delay ( .clk(clk), .in_i(rd_en_this_bram_w), .out_o(rd_en_this_bram_d));
                     all_register_delay #(.DELAY(EXTRA_REGISTERS+EXTRA_ADDRESS_REGISTERS), .BIT_WIDTH(1)) rd_en_not_delay ( .clk(clk), .in_i(!rd_en_this_bram_w), .out_o(rd_en_this_bram_not_d));
                  end

                wire [13:0]                                  ADDRARDADDR;
                wire [13:0]                                  ADDRBWRADDR;

                `w ADDRARDADDR = rd_addr_d << ADDR_SHIFT;
                `w ADDRBWRADDR = wr_addr_d << ADDR_SHIFT;
                
                RAMB18E2      #( .CASCADE_ORDER_A      (  CASCADE_ORDER_A     ),
                                 .CASCADE_ORDER_B      (  CASCADE_ORDER_B     ),
                                 .CLOCK_DOMAINS        (  "COMMON"            ),
                                 .DOA_REG              (  c==CASCADE-1        ),
                                 .DOB_REG              (  c==CASCADE-1        ),
                                 .ENADDRENA            (  "FALSE"             ),
                                 .ENADDRENB            (  "FALSE"             ),
                                 .INIT_A               (  18'h00000           ),
                                 .INIT_B               (  18'h00000           ),
                                 .INIT_FILE            (  "NONE"              ),
                                 .RDADDRCHANGEA        (  "FALSE"             ),
                                 .RDADDRCHANGEB        (  "FALSE"             ),
                                 .READ_WIDTH_A         (  WIDTH_THIS_COLUMN   ),
                                 .READ_WIDTH_B         (  0                   ),
                                 .RSTREG_PRIORITY_A    (  "RSTREG"            ),
                                 .RSTREG_PRIORITY_B    (  "RSTREG"            ),
                                 .SIM_COLLISION_CHECK  (  "ALL"               ),
                                 .SLEEP_ASYNC          (  "FALSE"             ),
                                 .SRVAL_A              (  18'h00000           ),
                                 .SRVAL_B              (  18'h00000           ),
                                 .WRITE_MODE_A         (  READ_WRITE_MODE     ),
                                 .WRITE_MODE_B         (  READ_WRITE_MODE     ),
                                 .WRITE_WIDTH_A        (  0                   ),
                                 .WRITE_WIDTH_B        (  WIDTH_THIS_COLUMN   ))
                bram18         ( .ADDRARDADDR          (  ADDRARDADDR         ),
                                 .ADDRBWRADDR          (  ADDRBWRADDR         ),
                                 .ADDRENA              (  1'b1                ),
                                 .ADDRENB              (  1'b1                ),
                                 .CASDIMUXA            (  1'b0                ),
                                 .CASDIMUXB            (  1'b0                ),
                                 .CASDINA              (  CASDINA[c]          ),
                                 .CASDINB              (  CASDINB[c]          ),
                                 .CASDINPA             (  CASDINPA[c]         ),
                                 .CASDINPB             (  CASDINPB[c]         ),
                                 .CASDOUTA             (  CASDINA[c+1]        ),
                                 .CASDOUTPA            (  CASDINPA[c+1]       ),
                                 .CASDOUTB             (  CASDINB[c+1]        ),
                                 .CASDOUTPB            (  CASDINPB[c+1]       ),
                                 .CASDOMUXA            (  (c==CASCADE-1) ? 1'b0 : rd_en_this_bram_not_d  ),
                                 .CASDOMUXB            (  (c==CASCADE-1) ? 1'b0 : rd_en_this_bram_not_d  ),
                                 .CASDOMUXEN_A         (  1'b1                ),
                                 .CASDOMUXEN_B         (  1'b1                ),
                                 .CASOREGIMUXA         (  (c==CASCADE-1) ? rd_en_this_bram_not_d : 1'b0 ),
                                 .CASOREGIMUXB         (  (c==CASCADE-1) ? rd_en_this_bram_not_d : 1'b0 ),
                                 .CASOREGIMUXEN_A      (  1'b1                ),
                                 .CASOREGIMUXEN_B      (  1'b1                ),
                                 .CLKARDCLK            (  clk                 ),
                                 .CLKBWRCLK            (  clk                 ),
                                 .DINADIN              (  DINADIN             ),
                                 .DINBDIN              (  DINBDIN             ),
                                 .DINPADINP            (  DINPADINP           ),
                                 .DINPBDINP            (  DINPBDINP           ),
                                 .DOUTADOUT            (  DOUTADOUT           ),
                                 .DOUTBDOUT            (  DOUTBDOUT           ),
                                 .DOUTPADOUTP          (  DOUTPADOUTP         ),
                                 .DOUTPBDOUTP          (  DOUTPBDOUTP         ),
                                 .ENARDEN              (  rd_en_this_bram_d   ),  // Read enable, for simple dual port memory
                                 .ENBWREN              (  wr_en_this_bram_d   ),  // Write enable, for simple dual port memory
                                 .REGCEAREGCE          (  1'b1                ),
                                 .REGCEB               (  1'b1                ),
                                 .RSTRAMARSTRAM        (  1'b0                ),
                                 .RSTRAMB              (  1'b0                ),
                                 .RSTREGARSTREG        (  1'b0                ),
                                 .RSTREGB              (  1'b0                ),
                                 .SLEEP                (  1'b0                ),
                                 .WEA                  (  2'h0                ),
                                 .WEBWE                (  4'hF                ));

                if(c==CASCADE-1)
		  begin : gen_blk_last_cascade
                     `w read_data_ro = data_out[WIDTH-1:0];
                  end
             end // for (c=0; c>CASCADE; c=c+1)
        end // if (!USE_BRAM18)

   endgenerate
           
endmodule


module bram_based_ram
  #(  
      parameter  LENGTH                       = 1024,
      parameter  WIDTH                        = 72,
      parameter  EXTRA_ADDRESS_REGISTERS      = 0,
      parameter  ADDRESS_BITS                 = $clog2(LENGTH),
      parameter  READ_WRITE_MODE              = "NO_CHANGE"
   )
   (
    input                    clk,
    input                    resetn,
    input                    write_enable_i,
    input [ADDRESS_BITS-1:0] write_addr_i,
    input [WIDTH-1:0]        write_data_i,
    input [ADDRESS_BITS-1:0] read_addr_i,
    output [WIDTH-1:0]       read_data_ro
   );
   
   localparam  MAX_WIDTH_SINGLE_COLUMN      = bram_based_ram_width(LENGTH);
   
   genvar                      w;
   
   generate

      initial
        begin : initial_block_begin
           if(WIDTH % MAX_WIDTH_SINGLE_COLUMN == 0)
             begin : initial_a
                $display("bram_based_ram of length %0d width %0d implemented with %0d columns of width %0d cascade %0d.\n",
                         LENGTH, WIDTH, WIDTH/MAX_WIDTH_SINGLE_COLUMN, MAX_WIDTH_SINGLE_COLUMN,
                         bram_based_ram_cascade(LENGTH));
             end
           else
             begin : initial_b
                $display("bram_based_ram of length %0d width %0d implemented with %0d columns of width %0d and a final column of width %0d cascade %0d.\n",
                         LENGTH, WIDTH, WIDTH/MAX_WIDTH_SINGLE_COLUMN, MAX_WIDTH_SINGLE_COLUMN,
                         WIDTH - (WIDTH/MAX_WIDTH_SINGLE_COLUMN) * MAX_WIDTH_SINGLE_COLUMN,
                         bram_based_ram_cascade(LENGTH));
             end
        end
                
      for(w=WIDTH; w>0; w=w-MAX_WIDTH_SINGLE_COLUMN)
        begin : width_loop
           localparam THIS_COLUMN_START = WIDTH-w;
           localparam THIS_COLUMN_WIDTH = (w<MAX_WIDTH_SINGLE_COLUMN) ? w : MAX_WIDTH_SINGLE_COLUMN;

	   wire [ADDRESS_BITS-1:0] write_addr_w;
	   wire [ADDRESS_BITS-1:0] read_addr_w;

	   localparam EXTRA_ADDRESS_REGISTERS_COLUMN = (EXTRA_ADDRESS_REGISTERS>1) ? EXTRA_ADDRESS_REGISTERS-1 : EXTRA_ADDRESS_REGISTERS;
	   
	   if(EXTRA_ADDRESS_REGISTERS>1)
	     begin : gen_blk_more_than_1_address_registers
		(* DONT_TOUCH = "YES" *) reg [ADDRESS_BITS-1:0] write_addr_r;
		(* DONT_TOUCH = "YES" *) reg [ADDRESS_BITS-1:0] read_addr_r;

		`r write_addr_r <= write_addr_i;
		`r read_addr_r  <= read_addr_i;

		`w write_addr_w = write_addr_r;
		`w read_addr_w  = read_addr_r;
	     end // if (EXTRA_ADDRESS_REGISTERS>1)
	   else
	     begin : gen_blk_zero_or_one_address_registers
		`w write_addr_w = write_addr_i;
		`w read_addr_w  = read_addr_i;
	     end
	   
           
           bram_column #( .LENGTH                   (  LENGTH                                                ),
                          .WIDTH                    (  THIS_COLUMN_WIDTH                                     ),
                          .EXTRA_ADDRESS_REGISTERS  (  EXTRA_ADDRESS_REGISTERS_COLUMN                        ),
                          .READ_WRITE_MODE          (  READ_WRITE_MODE                                       ))
           this_column  ( .clk                      (  clk                                                   ),
                          .resetn                   (  resetn                                                ),
                          .write_enable_i           (  write_enable_i                                        ),
                          .write_addr_i             (  write_addr_w                                          ),
                          .write_data_i             (  write_data_i[THIS_COLUMN_START +: THIS_COLUMN_WIDTH]  ),
                          .read_addr_i              (  read_addr_w                                           ),
                          .read_data_ro             (  read_data_ro[THIS_COLUMN_START +: THIS_COLUMN_WIDTH]  ));
        end

   endgenerate

endmodule

/* verilator lint_on PINMISSING  */
/* verilator lint_on WIDTHEXPAND  */
/* verilator lint_on WIDTHTRUNC  */
/* verilator lint_on UNDRIVEN  */
