//
// Copyright (C) 2018 Ross Martin
//
// Versions
//
// 2018.01.25  Coding begun

`undef w
`define w assign
`undef r
`define r always@(posedge clk)
`timescale  1 ps / 1 ps   
   
/* verilator lint_off WIDTHEXPAND  */
/* verilator lint_off WIDTHTRUNC  */
   
module bxb_sync_delay_2
  #( 
     parameter   DELAY                = 0,
     parameter   BIT_WIDTH            = 1,
     parameter   RESET_VALUE          = 1,

     parameter   BRAM_DESIRABILITY_PERCENT    = 50,  // Scale of 0 to 100
     parameter   URAM_DESIRABILITY_PERCENT    = 50   // Scale of 0 to 100
   )
   (
     input                  clk,
     input                  resetn,
     input [BIT_WIDTH-1:0]  in_i,
     output [BIT_WIDTH-1:0] out_o
   );

   localparam COUNTER_BITS  = $clog2(DELAY);
   localparam COUNTER_LUTS  = 2*COUNTER_BITS;
   localparam DELAY_LUTS    = DELAY / 64;
   localparam INITIAL_DELAY = 64;
   localparam MAX_COUNT_1   = DELAY - INITIAL_DELAY - 3;
   localparam MAX_COUNT_2   = DELAY - INITIAL_DELAY - 2;
   localparam TOTAL_BITS    = BIT_WIDTH*DELAY;
   localparam SHIFTED_BITS  = TOTAL_BITS - BIT_WIDTH;

   localparam NEW_TOTAL_BITS    = BIT_WIDTH*(DELAY-1);
   localparam NEW_SHIFTED_BITS  = NEW_TOTAL_BITS - BIT_WIDTH;

   genvar                          i;
   
   generate
      if(DELAY<0)
        begin : gen_blk_negative_delay
	   //initial $BxB_fatal(100);
           error_module error (clk); // Negative delay value
	   //localparam ERROR = BxB_fatal("Negative delay in bxb_sync_delay.v");
        end
      else if(DELAY==0)
        begin : gen_blk_zero_delay
           `w out_o = in_i;
        end
      else if(DELAY==1)
        begin : gen_blk_delay_1
           //(* DONT_TOUCH="YES" *) 
	   reg [BIT_WIDTH-1:0] buffer_r = RESET_VALUE;;
           `r buffer_r <= resetn ? in_i : RESET_VALUE;
           `w out_o = buffer_r;
        end
      else if(DELAY==2)
        begin : gen_blk_delay_2
           reg [BIT_WIDTH-1:0] buffer_r = RESET_VALUE;
           //(* DONT_TOUCH="YES" *) 
	   reg [BIT_WIDTH-1:0] buffer_rr = RESET_VALUE;
           `r buffer_r <= resetn ? in_i : RESET_VALUE;
           `r buffer_rr <= resetn ? buffer_r : RESET_VALUE;
           `w out_o = buffer_rr;
        end
//      else if(DELAY<=20)
//        begin
//           reg [TOTAL_BITS-1:0] buffer_r = 0;
//           wire [BIT_WIDTH-1:0] one_reset_val = RESET_VALUE;
//           wire [TOTAL_BITS-1:0] reset_val = { DELAY { one_reset_val } };
//           
//           `r buffer_r <= resetn ? { buffer_r[SHIFTED_BITS-1:0] , in_i } : reset_val;
//           `w out_o = buffer_r[SHIFTED_BITS +: BIT_WIDTH];
//        end
      else if(DELAY<=20)
        begin : gen_blk_delay_less_than_21
	   localparam [BIT_WIDTH-1:0] ONE_RESET_VALUE = RESET_VALUE;
           reg [NEW_TOTAL_BITS-1:0] buffer_r = { (DELAY-1) { ONE_RESET_VALUE } };
           wire [BIT_WIDTH-1:0] one_reset_val = RESET_VALUE;
           wire [NEW_TOTAL_BITS-1:0] reset_val = { (DELAY-1) { one_reset_val } };
	   // (* DONT_TOUCH="YES" *)  DONT_TOUCH was originally to keep out_r out of a delay line.  It doesn't help here, since
	   // a delay line can't have a reset, so it is precluded here anyway.  
	   reg [BIT_WIDTH-1:0] 	     out_r = RESET_VALUE;
           
           `r buffer_r <= resetn ? { buffer_r[NEW_SHIFTED_BITS-1:0] , in_i } : reset_val;
           `r out_r <= resetn ? buffer_r[NEW_SHIFTED_BITS +: BIT_WIDTH] : RESET_VALUE;
	   `w out_o = out_r;
        end
      else if(DELAY<4100)
        begin : gen_blk_delay_less_than_4100

           localparam              COUNTER_RESET_COUNT  =  DELAY-3;
           reg [COUNTER_BITS-1:0]  counter_r            =  COUNTER_RESET_COUNT;
           reg                     counter_nonzero_r    =  1;
           reg [BIT_WIDTH-1:0]     out_r                =  RESET_VALUE;
           reg [BIT_WIDTH-1:0]     out_rr               =  RESET_VALUE;
           wire [BIT_WIDTH-1:0]    in_d;
           
           delay         #( .BRAM_DESIRABILITY_PERCENT(BRAM_DESIRABILITY_PERCENT),
                            .URAM_DESIRABILITY_PERCENT(URAM_DESIRABILITY_PERCENT),
                            .DELAY( DELAY-2 ), 
                            .BIT_WIDTH( BIT_WIDTH )) 
           normal_delay   ( .clk(clk), 
                            .in_i(in_i), 
                            .out_o(in_d) );
           
           `r counter_r <= !resetn       ?  COUNTER_RESET_COUNT  :
                           counter_r==0  ?  0                    :
                           /**/             counter_r-1          ;

           `r counter_nonzero_r <= !resetn ? 1 : (counter_r!=0);
           
           `r out_r <= !resetn            ?  RESET_VALUE  :
                       counter_nonzero_r  ?  RESET_VALUE  :
                       /**/                  in_d         ;

           `r out_rr <= !resetn ? RESET_VALUE : out_r;
           `w out_o = out_rr;

           // Below here for testing
           //reg [TOTAL_BITS-1:0]    buffer_r = 0;
           //wire [BIT_WIDTH-1:0]    one_reset_val = RESET_VALUE;
           //wire [TOTAL_BITS-1:0]   reset_val = { DELAY { one_reset_val } };
           //wire                    out_o2;
           //
           //`r buffer_r <= resetn ? { buffer_r[SHIFTED_BITS-1:0] , in_i } : reset_val;
           //`w out_o2 = buffer_r[SHIFTED_BITS +: BIT_WIDTH];
           //
           //`r begin
           //   if(out_o==out_o2) 
           //     $display("DELAY=%4d, BW=%2d, out_o=%3d, out_o2=%3d", DELAY, BIT_WIDTH, out_o, out_o2);
           //   else
           //     $display("DELAY=%4d, BW=%2d, out_o=%3d, out_o2=%3d  ********************", DELAY, BIT_WIDTH, out_o, out_o2);
           //end
        end
      else
        begin : gen_blk_delay_large

           //reg [BIT_WIDTH-1:1]      sync_hold = 0;

           // Hold all higher bits of sync.  Total delay must not be more than the time between sync bit 0 going high.
          // `r sync_hold <= in_i[0] ? in_i[BIT_WIDTH-1:1] : sync_hold;

           wire  [BIT_WIDTH-1:0]        in_d;
           wire [BIT_WIDTH-1:0]       out_o_alt;
           
           bxb_sync_delay_2       #( .BRAM_DESIRABILITY_PERCENT(BRAM_DESIRABILITY_PERCENT),
                               .URAM_DESIRABILITY_PERCENT(URAM_DESIRABILITY_PERCENT),
                               .DELAY ( INITIAL_DELAY ), 
                               .BIT_WIDTH( BIT_WIDTH ), 
                               .RESET_VALUE( RESET_VALUE ))
           initial_delay     ( .clk(clk), 
                               .resetn(resetn), 
                               .in_i(in_i), 
                               .out_o(in_d) );
           
           for( i = 0; i<BIT_WIDTH; i = i + 1 )
             begin : bit_width_loop

                wire                    in_w;
                wire [COUNTER_BITS-1:0] counter_1_w;
                reg [COUNTER_BITS-1:0]  counter_1_r      = 0;
                reg                     in_progress_1_r  = 0;
                reg                     in_progress_1_rr = 0;
                reg                     done_1_r         = 0;

                `w in_w = in_d[i];
                
                `r in_progress_1_r  <= resetn && ((in_w && !in_progress_1_r) || (in_progress_1_r && (counter_1_r!=1))) ;
                `r in_progress_1_rr <= resetn && in_progress_1_r;
                `r done_1_r         <= resetn && in_progress_1_rr && !in_progress_1_r;
                
                //`r counter_1_r      <= (in_w && !in_progress_1_r)  ?  MAX_COUNT_1      :   // sel 10
                //                       in_progress_1_r             ?  counter_1_r - 1  :   // sel 01 and sel 11
                //                       /* default */                  0                ;   // sel 00
                             
		wire [1:0] 	       counter_1_sel;

		`w counter_1_sel = { in_w, in_progress_1_r };

		muxadd2 #( .SEL_0_IN_A("INPUT_CONST_0"), .SEL_1_IN_A("INPUT_0"),       .SEL_2_IN_A("INPUT_CONST_0"), .SEL_3_IN_A("INPUT_0"),
			   .SEL_0_NEG_A(0),              .SEL_1_NEG_A(0),              .SEL_2_NEG_A(0),              .SEL_3_NEG_A(0),
			   .SEL_0_IN_B("INPUT_CONST_0"), .SEL_1_IN_B("INPUT_CONST_2"), .SEL_2_IN_B("INPUT_CONST_1"), .SEL_3_IN_B("INPUT_CONST_2"),
			   .SEL_0_NEG_B(0),              .SEL_1_NEG_B(1),              .SEL_2_NEG_B(0),              .SEL_3_NEG_B(1),
			   .CONST_0(0), .CONST_1(MAX_COUNT_1), .CONST_2(1), .WIDTH(COUNTER_BITS))
		counter_1 (.sel(counter_1_sel), .input_0(counter_1_r), .input_1({COUNTER_BITS{1'b0}}), .input_2({COUNTER_BITS{1'b0}}), .out(counter_1_w));

		`r counter_1_r <= resetn ? counter_1_w : 0;
		
		
                wire [COUNTER_BITS-1:0] counter_2_w;
                reg [COUNTER_BITS-1:0]  counter_2_r      = 0;
                reg                     in_progress_2_r  = 0;
                reg                     done_2_r         = 0;

                `r in_progress_2_r <= (!resetn) || in_w || (counter_2_r>1);
                `r done_2_r        <= resetn && !in_progress_2_r;
                
                //`r counter_2_r     <= in_w             ?  MAX_COUNT_2     :  // sel 10 and 11
                //                      in_progress_2_r  ?  counter_2_r - 1 :  // sel 01
                //                      /* default */       0               ;  // sel 00
    
		wire [1:0] 	       counter_2_sel;

		`w counter_2_sel = { in_w, in_progress_2_r };

		muxadd2 #( .SEL_0_IN_A("INPUT_CONST_0"), .SEL_1_IN_A("INPUT_0"),       .SEL_2_IN_A("INPUT_CONST_0"), .SEL_3_IN_A("INPUT_CONST_0"),
			   .SEL_0_NEG_A(0),              .SEL_1_NEG_A(0),              .SEL_2_NEG_A(0),              .SEL_3_NEG_A(0),
			   .SEL_0_IN_B("INPUT_CONST_0"), .SEL_1_IN_B("INPUT_CONST_2"), .SEL_2_IN_B("INPUT_CONST_1"), .SEL_3_IN_B("INPUT_CONST_1"),
			   .SEL_0_NEG_B(0),              .SEL_1_NEG_B(1),              .SEL_2_NEG_B(0),              .SEL_3_NEG_B(0),
			   .CONST_0(0), .CONST_1(MAX_COUNT_2), .CONST_2(1), .WIDTH(COUNTER_BITS))
		counter_2 (.sel(counter_2_sel), .input_0(counter_2_r), .input_1({COUNTER_BITS{1'b0}}), .input_2({COUNTER_BITS{1'b0}}), .out(counter_2_w));

		`r counter_2_r <= resetn ? counter_2_w : (i==0) ? MAX_COUNT_2 : 0;
            

                reg                    sync_delayed_r = 0;

                `r sync_delayed_r  <=  (!resetn)                ?  RESET_VALUE     :
                                       done_1_r                 ?  1               :
                                       done_2_r                 ?  0               :
                                       /* default */               sync_delayed_r  ;

                // For testing
                //                `w out_o_alt[i] = sync_delayed_r;

                `w out_o[i] = sync_delayed_r;
             end
            
           // For testing
           //reg [TOTAL_BITS-1:0]        buffer_r = 0;
           //wire [BIT_WIDTH-1:0]        one_reset_val = 1;
           //wire [TOTAL_BITS-1:0]       reset_val = { DELAY { one_reset_val } };
           //
           //`r buffer_r <= resetn ? { buffer_r[SHIFTED_BITS-1:0] , in_i } : reset_val;
           //`w out_o = buffer_r[SHIFTED_BITS +: BIT_WIDTH];
           //
           //`r if(DELAY==2060) $display("DELAY=%1d, resetn=%1d, in_i=%1d, out_o=%1d, out_o_alt=%1d", DELAY, resetn, in_i, out_o, out_o_alt);
           
        end

   endgenerate
            
endmodule // bxb_sync_delay


/* verilator lint_on WIDTHEXPAND  */
/* verilator lint_on WIDTHTRUNC  */
