
# Loading additional proc with user specified bodies to compute parameter values.
source [file join [file dirname [file dirname [info script]]] gui/split_v1_0.gtcl]

# Definitional proc to organize widgets for parameters.
proc init_gui { IPINST } {
  ipgui::add_param $IPINST -name "Component_Name"
  #Adding Page
  set Page_0 [ipgui::add_page $IPINST -name "Page 0"]
  ipgui::add_param $IPINST -name "AXIS_SAMPLES_PER_CLOCK" -parent ${Page_0}
  ipgui::add_param $IPINST -name "IN_AXIS_BITS_PER_SAMPLE" -parent ${Page_0}
  ipgui::add_param $IPINST -name "OUT_AXIS_BITS_PER_SAMPLE" -parent ${Page_0}
  ipgui::add_param $IPINST -name "SHIFT_RIGHT" -parent ${Page_0}
  ipgui::add_param $IPINST -name "TDEST_WIDTH" -parent ${Page_0}
  ipgui::add_param $IPINST -name "TID_WIDTH" -parent ${Page_0}


}

proc update_PARAM_VALUE.IN_AXIS_BUS_WIDTH { PARAM_VALUE.IN_AXIS_BUS_WIDTH PARAM_VALUE.IN_AXIS_BITS_PER_SAMPLE PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK } {
	# Procedure called to update IN_AXIS_BUS_WIDTH when any of the dependent parameters in the arguments change
	
	set IN_AXIS_BUS_WIDTH ${PARAM_VALUE.IN_AXIS_BUS_WIDTH}
	set IN_AXIS_BITS_PER_SAMPLE ${PARAM_VALUE.IN_AXIS_BITS_PER_SAMPLE}
	set AXIS_SAMPLES_PER_CLOCK ${PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK}
	set values(IN_AXIS_BITS_PER_SAMPLE) [get_property value $IN_AXIS_BITS_PER_SAMPLE]
	set values(AXIS_SAMPLES_PER_CLOCK) [get_property value $AXIS_SAMPLES_PER_CLOCK]
	set_property value [gen_USERPARAMETER_IN_AXIS_BUS_WIDTH_VALUE $values(IN_AXIS_BITS_PER_SAMPLE) $values(AXIS_SAMPLES_PER_CLOCK)] $IN_AXIS_BUS_WIDTH
}

proc validate_PARAM_VALUE.IN_AXIS_BUS_WIDTH { PARAM_VALUE.IN_AXIS_BUS_WIDTH } {
	# Procedure called to validate IN_AXIS_BUS_WIDTH
	return true
}

proc update_PARAM_VALUE.OUT_AXIS_BUS_WIDTH { PARAM_VALUE.OUT_AXIS_BUS_WIDTH PARAM_VALUE.OUT_AXIS_BITS_PER_SAMPLE PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK } {
	# Procedure called to update OUT_AXIS_BUS_WIDTH when any of the dependent parameters in the arguments change
	
	set OUT_AXIS_BUS_WIDTH ${PARAM_VALUE.OUT_AXIS_BUS_WIDTH}
	set OUT_AXIS_BITS_PER_SAMPLE ${PARAM_VALUE.OUT_AXIS_BITS_PER_SAMPLE}
	set AXIS_SAMPLES_PER_CLOCK ${PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK}
	set values(OUT_AXIS_BITS_PER_SAMPLE) [get_property value $OUT_AXIS_BITS_PER_SAMPLE]
	set values(AXIS_SAMPLES_PER_CLOCK) [get_property value $AXIS_SAMPLES_PER_CLOCK]
	set_property value [gen_USERPARAMETER_OUT_AXIS_BUS_WIDTH_VALUE $values(OUT_AXIS_BITS_PER_SAMPLE) $values(AXIS_SAMPLES_PER_CLOCK)] $OUT_AXIS_BUS_WIDTH
}

proc validate_PARAM_VALUE.OUT_AXIS_BUS_WIDTH { PARAM_VALUE.OUT_AXIS_BUS_WIDTH } {
	# Procedure called to validate OUT_AXIS_BUS_WIDTH
	return true
}

proc update_PARAM_VALUE.TDEST_DUMMY_WIDTH { PARAM_VALUE.TDEST_DUMMY_WIDTH PARAM_VALUE.TDEST_WIDTH } {
	# Procedure called to update TDEST_DUMMY_WIDTH when any of the dependent parameters in the arguments change
	
	set TDEST_DUMMY_WIDTH ${PARAM_VALUE.TDEST_DUMMY_WIDTH}
	set TDEST_WIDTH ${PARAM_VALUE.TDEST_WIDTH}
	set values(TDEST_WIDTH) [get_property value $TDEST_WIDTH]
	set_property value [gen_USERPARAMETER_TDEST_DUMMY_WIDTH_VALUE $values(TDEST_WIDTH)] $TDEST_DUMMY_WIDTH
}

proc validate_PARAM_VALUE.TDEST_DUMMY_WIDTH { PARAM_VALUE.TDEST_DUMMY_WIDTH } {
	# Procedure called to validate TDEST_DUMMY_WIDTH
	return true
}

proc update_PARAM_VALUE.TID_DUMMY_WIDTH { PARAM_VALUE.TID_DUMMY_WIDTH PARAM_VALUE.TID_WIDTH } {
	# Procedure called to update TID_DUMMY_WIDTH when any of the dependent parameters in the arguments change
	
	set TID_DUMMY_WIDTH ${PARAM_VALUE.TID_DUMMY_WIDTH}
	set TID_WIDTH ${PARAM_VALUE.TID_WIDTH}
	set values(TID_WIDTH) [get_property value $TID_WIDTH]
	set_property value [gen_USERPARAMETER_TID_DUMMY_WIDTH_VALUE $values(TID_WIDTH)] $TID_DUMMY_WIDTH
}

proc validate_PARAM_VALUE.TID_DUMMY_WIDTH { PARAM_VALUE.TID_DUMMY_WIDTH } {
	# Procedure called to validate TID_DUMMY_WIDTH
	return true
}

proc update_PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK { PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK } {
	# Procedure called to update AXIS_SAMPLES_PER_CLOCK when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK { PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK } {
	# Procedure called to validate AXIS_SAMPLES_PER_CLOCK
	return true
}

proc update_PARAM_VALUE.IN_AXIS_BITS_PER_SAMPLE { PARAM_VALUE.IN_AXIS_BITS_PER_SAMPLE } {
	# Procedure called to update IN_AXIS_BITS_PER_SAMPLE when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.IN_AXIS_BITS_PER_SAMPLE { PARAM_VALUE.IN_AXIS_BITS_PER_SAMPLE } {
	# Procedure called to validate IN_AXIS_BITS_PER_SAMPLE
	return true
}

proc update_PARAM_VALUE.OUT_AXIS_BITS_PER_SAMPLE { PARAM_VALUE.OUT_AXIS_BITS_PER_SAMPLE } {
	# Procedure called to update OUT_AXIS_BITS_PER_SAMPLE when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.OUT_AXIS_BITS_PER_SAMPLE { PARAM_VALUE.OUT_AXIS_BITS_PER_SAMPLE } {
	# Procedure called to validate OUT_AXIS_BITS_PER_SAMPLE
	return true
}

proc update_PARAM_VALUE.SHIFT_RIGHT { PARAM_VALUE.SHIFT_RIGHT } {
	# Procedure called to update SHIFT_RIGHT when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.SHIFT_RIGHT { PARAM_VALUE.SHIFT_RIGHT } {
	# Procedure called to validate SHIFT_RIGHT
	return true
}

proc update_PARAM_VALUE.TDEST_WIDTH { PARAM_VALUE.TDEST_WIDTH } {
	# Procedure called to update TDEST_WIDTH when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.TDEST_WIDTH { PARAM_VALUE.TDEST_WIDTH } {
	# Procedure called to validate TDEST_WIDTH
	return true
}

proc update_PARAM_VALUE.TID_WIDTH { PARAM_VALUE.TID_WIDTH } {
	# Procedure called to update TID_WIDTH when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.TID_WIDTH { PARAM_VALUE.TID_WIDTH } {
	# Procedure called to validate TID_WIDTH
	return true
}


proc update_MODELPARAM_VALUE.AXIS_SAMPLES_PER_CLOCK { MODELPARAM_VALUE.AXIS_SAMPLES_PER_CLOCK PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK}] ${MODELPARAM_VALUE.AXIS_SAMPLES_PER_CLOCK}
}

proc update_MODELPARAM_VALUE.IN_AXIS_BITS_PER_SAMPLE { MODELPARAM_VALUE.IN_AXIS_BITS_PER_SAMPLE PARAM_VALUE.IN_AXIS_BITS_PER_SAMPLE } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.IN_AXIS_BITS_PER_SAMPLE}] ${MODELPARAM_VALUE.IN_AXIS_BITS_PER_SAMPLE}
}

proc update_MODELPARAM_VALUE.OUT_AXIS_BITS_PER_SAMPLE { MODELPARAM_VALUE.OUT_AXIS_BITS_PER_SAMPLE PARAM_VALUE.OUT_AXIS_BITS_PER_SAMPLE } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.OUT_AXIS_BITS_PER_SAMPLE}] ${MODELPARAM_VALUE.OUT_AXIS_BITS_PER_SAMPLE}
}

proc update_MODELPARAM_VALUE.TID_WIDTH { MODELPARAM_VALUE.TID_WIDTH PARAM_VALUE.TID_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TID_WIDTH}] ${MODELPARAM_VALUE.TID_WIDTH}
}

proc update_MODELPARAM_VALUE.TDEST_WIDTH { MODELPARAM_VALUE.TDEST_WIDTH PARAM_VALUE.TDEST_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TDEST_WIDTH}] ${MODELPARAM_VALUE.TDEST_WIDTH}
}

proc update_MODELPARAM_VALUE.SHIFT_RIGHT { MODELPARAM_VALUE.SHIFT_RIGHT PARAM_VALUE.SHIFT_RIGHT } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.SHIFT_RIGHT}] ${MODELPARAM_VALUE.SHIFT_RIGHT}
}

proc update_MODELPARAM_VALUE.IN_AXIS_BUS_WIDTH { MODELPARAM_VALUE.IN_AXIS_BUS_WIDTH PARAM_VALUE.IN_AXIS_BUS_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.IN_AXIS_BUS_WIDTH}] ${MODELPARAM_VALUE.IN_AXIS_BUS_WIDTH}
}

proc update_MODELPARAM_VALUE.OUT_AXIS_BUS_WIDTH { MODELPARAM_VALUE.OUT_AXIS_BUS_WIDTH PARAM_VALUE.OUT_AXIS_BUS_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.OUT_AXIS_BUS_WIDTH}] ${MODELPARAM_VALUE.OUT_AXIS_BUS_WIDTH}
}

proc update_MODELPARAM_VALUE.TID_DUMMY_WIDTH { MODELPARAM_VALUE.TID_DUMMY_WIDTH PARAM_VALUE.TID_DUMMY_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TID_DUMMY_WIDTH}] ${MODELPARAM_VALUE.TID_DUMMY_WIDTH}
}

proc update_MODELPARAM_VALUE.TDEST_DUMMY_WIDTH { MODELPARAM_VALUE.TDEST_DUMMY_WIDTH PARAM_VALUE.TDEST_DUMMY_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TDEST_DUMMY_WIDTH}] ${MODELPARAM_VALUE.TDEST_DUMMY_WIDTH}
}

