
//
// Copyright (C) 2021 Ross D. Martin
//

`timescale 1ps / 1ps

`define w assign
`define r always@(posedge clk)


module pn
  #(
    parameter   PN_TAP = 13
    )
   (
    input      clk,
    input      enable,
    input      in_i,
    output reg out_o
    );

   reg [15:0]    pn_r           = 0;
   wire          pn_in_w;

   initial out_o = 1;

   `w pn_in_w = in_i ^ out_o ^ pn_r[PN_TAP];
   `r pn_r <= enable ? { pn_r[14:0], pn_in_w } : pn_r;
   `r out_o <= pn_r[PN_TAP];
   
endmodule
