#!/bin/bash

exec 3>&1

depends()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Xilinx's tool $tool must be installed to run this script."
	echo ""
	exit 20
    fi
}

convert_xsa()
{
    XSA="$1"

    if [ ! -f "$XSA" ]; then
	
	echo ""
	echo "Usage: $0 file.xsa"
	echo ""
	echo "  Creates \"file.fsbl\"."
	echo ""
	exit 20
	
    fi

    export DESIGN=`basename $XSA | sed 's/[.].*//'`
    OUT=${DESIGN}_FSBL.elf

    if [ -f $OUT_DIR/$OUT ]; then

	if [ $XSA -nt $OUT_DIR/$OUT ]; then
	    echo "Rebuilding FSBL \"$OUT_DIR/$OUT\"; the XSA file \"$XSA\" is newer."
	    rm -f $OUT_DIR/$OUT
	else
	    echo "Skipping build of FSBL \"$OUT_DIR/$OUT\"; the XSA file \"$XSA\" is older."
	    return
	fi
    else
	echo "No FSBL \"$OUT_DIR/$OUT\" exists; building it."
    fi
    
    depends xsct

    BUILD_DIR=tmp-$DESIGN
    rm -rf $BUILD_DIR
    mkdir -p $BUILD_DIR
    
    cp $XSA $BUILD_DIR/$DESIGN.xsa

    cat >$BUILD_DIR/create_fsbl.tcl <<EOF
hsi open_hw_design $DESIGN.xsa
set cpu_name [lindex [hsi get_cells -filter {IP_TYPE==PROCESSOR}] 0]
platform create -name hw0 -hw $DESIGN.xsa -proc \$cpu_name -os standalone -arch 64-bit -out ./build/sdk 
exec echo ""
exec echo "Beginning patch script."
exec ./do_patch.sh
exec echo "Patch script ended."
exec echo ""
platform generate
EOF

    cat >$BUILD_DIR/do_patch.sh <<EOF
#!/bin/bash

exec 1>&3

echo ""
echo "Adding BxB extras to FSBL files created by xsct."
echo ""

EXTRAS_SCRIPT=../inputs/${DESIGN}/mods.sh

if [ -f "\$EXTRAS_SCRIPT" ]; then
    echo "Executing BxB FSBL extras script \"\$EXTRAS_SCRIPT\"."
    . \$EXTRAS_SCRIPT
else
    echo "No BxB FSBL extras script \"\$EXTRAS_SCRIPT\" found."
fi

#echo "Saving off a copy of the files for debugging, before building."
#echo cp -r ../$BUILD_DIR ../`basename ${XSA}`-build-tmp-before-generate
#cp -r ../$BUILD_DIR ../`basename ${XSA}`-before-generate
#
#fixed_dir=../`basename ${XSA}`-before-generate-fixed
#
#echo "Checking for directory \"$fixed_dir\", to replace code with it."
#
#if [ -d "$fixed_dir" ]; then
#
#   mkdir old
#   mv * old/
#   cp -r ../"$fixed_dir"/* .
#
#   echo "Replaced files with files from \"$fixed_dir\"."
#fi
#
#sleep 5

#exit 100
EOF

    chmod ugo+x $BUILD_DIR/do_patch.sh

    FSBL="$BUILD_DIR/build/sdk/hw0/export/hw0/sw/hw0/boot/fsbl.elf"
    #SYSTEM_TOP_BIT="$BUILD_DIR/build/sdk/hw0/hw/$DESIGN.bit"

    echo ""
    echo "Running Xilinx xsct to build $OUT from $XSA."
    echo ""
    
    ( cd $BUILD_DIR; xsct create_fsbl.tcl )


    if [ ! -f "$FSBL" ]; then
	
	echo ""
	echo "Creation of First Stage Boot Loader (FSBL) failed."
	echo ""
	exit 20
	
    else

	cp $FSBL $OUT_DIR/$OUT
	echo "Creation of First Stage Boot Loader (FSBL) succeeded.  Output is $OUT_DIR/$OUT"

    fi

    rm -rf $BUILD_DIR
}


OUT_DIR=out
#rm -rf $OUT_DIR
mkdir -p $OUT_DIR


for file in ../inputs/XSA/*.xsa; do

    convert_xsa $file

done
