#!/bin/bash

if [ -x bootgen/bootgen ]; then
    echo ""
    echo "  bootgen appears to already be built.  If you"
    echo "  want to rebuild it, run veryclean.sh first."
    echo ""
    exit 0
fi


rm -rf bootgen

if [ ! -f bootgen.tgz ]; then
    echo ""
    echo ""
    echo "  Have no local copy of bootgen source.  Fetching and creating local copy."
    echo ""
    echo ""
    git clone https://github.com/Xilinx/bootgen
    #(cd dtg; git checkout xilinx-v2020.2)
    tar czf bootgen.tgz bootgen
else
    tar xzf bootgen.tgz
fi

if [ -f /proc/cpuinfo -a -f /proc/loadavg ]; then
    CPUs_minus_1=`cat /proc/cpuinfo | grep processor | tail -1 | sed 's/.*://'`
else
    CPUs_minus_1=0
fi

CPUs=$((CPUs_minus_1 + 1))

MAXJOBS=$(( 3 * CPUs / 4 - 1 ))

if [ $MAXJOBS -lt 1 ]; then
   MAXJOBS=1
fi

echo "Will run parallel build with $MAXJOBS threads."


(cd bootgen; make -j$MAXJOBS)

