#!/bin/bash -e

myerror()
{
    echo ""
    echo "ERROR at this step.  Aborting."
    echo ""
    exit 20
}


if [ ! -f ../kernel/out/Image.gz ]; then
    echo ""
    echo "You must build in the kernel directory before this one, since"
    echo "the kernel's Image.gz is required here."
    echo ""
    exit 20
fi


echo "**********************************************************************"
echo "**"
echo "**   Building First Stage BootLoader (FSBL)"
echo "**"
echo "**********************************************************************"
(cd FSBL && ./build.sh) || myerror

#
# The Linux kernel is now in another directory, since both boot
# (for image.ub) and filesystem (for modules) depend on it.
#
#echo "**********************************************************************"
#echo "**"
#echo "**   Building Linux kernel"
#echo "**"
#echo "**********************************************************************"
#(cd kernel && ./build.sh) || myerror

echo "**********************************************************************"
echo "**"
echo "**   Building U-BOOT executables: dtc, dumpimage, mkimage"
echo "**"
echo "**********************************************************************"
(cd U-BOOT && ./exebuild.sh) || myerror

echo "**********************************************************************"
echo "**"
echo "**   Building device tree files"
echo "**"
echo "**********************************************************************"
(cd device_tree_gen && ./build.sh) || myerror

echo "**********************************************************************"
echo "**"
echo "**   Building U-BOOT u-boot.elf files"
echo "**"
echo "**********************************************************************"
(cd U-BOOT && ./build.sh) || myerror

echo "**********************************************************************"
echo "**"
echo "**   Building pmufw.elf"
echo "**"
echo "**********************************************************************"
(cd PMUFW && ./build.sh) || myerror

echo "**********************************************************************"
echo "**"
echo "**   Building bl31.elf"
echo "**"
echo "**********************************************************************"
(cd BL31 && ./build.sh) || myerror

echo "**********************************************************************"
echo "**"
echo "**   Building bootgen"
echo "**"
echo "**********************************************************************"
(cd bootgen && ./build.sh) || myerror

echo "**********************************************************************"
echo "**"
echo "**   Building BOOT_BIN outputs"
echo "**"
echo "**********************************************************************"
(cd BOOT_BIN && ./build.sh) || myerror

echo "**********************************************************************"
echo "**"
echo "**   Building BOOT_SCR outputs"
echo "**"
echo "**********************************************************************"
(cd BOOT_SCR && ./build.sh) || myerror

echo "**********************************************************************"
echo "**"
echo "**   Building image.ub files"
echo "**"
echo "**********************************************************************"
(cd IMAGE_UB && ./build.sh) || myerror


rm -rf out

for file in BOOT_BIN/out/*; do
    name=`basename $file | sed 's/_BOOT.BIN//'`
    mkdir -p out/$name
    cp BOOT_SCR/out/BOOT.SCR            out/$name/
    cp $file                            out/$name/BOOT.BIN
    cp IMAGE_UB/out/${name}_image.ub    out/$name/image.ub
done

echo ""
echo ""
echo "Script finished successfully."
echo ""
echo "Output files are in out:"
echo ""
ls out/*

echo ""
echo "To use the files, rename the appropriate file to BOOT.BIN, rename the apprpriate file to image.ub,"
echo "and copy BOOT.BIN, image.ub, and BOOT.SCR onto a VFAT-formatted sd card.  Use this to boot your board."
echo ""
