#!/bin/bash

#
# Note that for some reason the psgtr clock specified
# for the DisplayPort only works if set to 1 for RFSoC4x2,
# even through the correct value appears to be 0, and
# 0 is in the XSA.  Something is very odd here, since
# if an XSA is used specifying 1, it generates an FSBL
# that prevents the DisplaPort from working.  I think
# perhaps the FSBL is doing something to change the
# DisplayPort clock number?  How can it do that?
#
# There is definitely a Xilinx bug here, either in
# the FSBL code produced by Vivado, or by the Xilinx
# device tree generator, or both.  The best we can
# do is try to work around it, since the FSBL appears
# to change the PSGTR clock numbers, and we so far
# have no way to know what they are changed to.  Yet
# the device tree must have the changed numbers to
# work.  This only affects things if using USB,
# DisplayPort, or PCIe, because only those use the
# PSGTR clocks.
#

#
# Method 1 is using the old HSI in XSCT.
#   This method generates a very old style device tree with
#   lane0 etc in the xilinx_dpsub section.  However,
#   it works with u-boot-xlnx, and some editing was added
#   so it works with the Linux kernel also.
#
# Method 2 uses the createdts command in XSCT.
#   This method generates a device tree that almost
#   works with the Linux kernel for DisplayPort, and 
#   requires little editing.  It uses psgtr rather 
#   than lane in the phy.  However, it doesn't
#   work with u-boot-xlnx, so it needs a method
#   along the lines of Method 1 to feed u_boot_xlinx,
#   then it can be used with the Linux kernel.
#
# Method 3 uses the sdtgen command in XSCT.
#   This method seems to be very similar to Method 2,
#   with similar strengths and weaknesses.
#
# Method 4 uses PetaLInux.
#   This method also doesn't produce a device tree
#   compatible with u-boot-xlnx
#
# Method 5 uses XSCT with commands extracted from
#   Petalinux.  This makes it immensely faster,
#   less cumbersome, and more direct than the
#   Petalinux implementation.  It achieves similar
#   results however, producing a device tree that
#   is not compatible with u-boot-xlnx.
#
# Method 6 currently doesn't work.  It was an attempt
#   to generate a device tree via gen-machine-conf,
#   extracting it from the System Device Tree.
#   There are some comments in it regarding trying
#   to get gen-machine-conf to work.  The version
#   of this program at the time I obtained it had
#   entirely different command line arguments
#   than were described in web page documentation.
#
# Method 7 is a C++ program that I wrote myself to
#   do the job, having gotten frustrated with
#   the lack of visibility and control of the
#   other methods.
#
# After some experimentation with the methods that
# don't work with u-boot-xlnx, the problem goes away
# if the generated zynqmp.dtsi and zynqmp-clk-ccf.dtsi
# are both replaced with files from a working board
# support package.  So the issue is somewhere in them.
# Note that both files need to be replaced.  So perhaps
# there are multiple errors in each.  This hasn't been
# tracked down further.
#

#
# Given 
#

for file in ../inputs/XSA/*.xsa; do

    #./convert_xsa_to_device_tree_method_1.sh $file
    #./convert_xsa_to_device_tree_method_1_old.sh $file
    #./convert_xsa_to_device_tree_method_2.sh $file
    #./convert_xsa_to_device_tree_method_3.sh $file
    #./convert_xsa_to_device_tree_method_4.sh $file
    #./convert_xsa_to_device_tree_method_5.sh $file
    #./convert_xsa_to_device_tree_method_6.sh $file
    #./convert_xsa_to_device_tree_method_7.sh $file
    ./convert_xsa_to_device_tree_method_8.sh $file

done


