#!/bin/bash -e

depend_exe()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Tool \"$tool\" must be built to run this script.  Run exebuild.sh there."
	echo ""
	exit 20
    fi
}

depend_dir()
{
    dir="$1"
    if [ ! -d "$dir" ]; then
	echo ""
	echo "The Linux kernel source code must be installed in ../kernel/linux-6.15"
	echo "to run this script.  Try running build in the kernel directory."
	echo ""
	exit 20
    fi
}

IN_XSA="$1"

if [ ! -f "$IN_XSA" ]; then
    echo "Usage: $0 XSA_FILE.xsa"
    exit 20
fi

OUTDIR=out

DESIGN=`basename "$IN_XSA" | sed 's/[.].*//'`
DTS="$OUTDIR/${DESIGN}.dts"
DTB="$OUTDIR/${DESIGN}.dtb"
XSA="${DESIGN}.xsa"

TMPDIR=tmp-$DESIGN


if [ ! -f "$DTS" ]; then
    echo "No Device Tree \"$DTS\" exists; building it."
elif [ ! -f "$DTB" ]; then
    echo "No Device Tree \"$DTB\" exists; building it."
else
    if [ "$IN_XSA" -nt "$DTS" ]; then
	echo "Rebuilding \"$DTS\"; the XSA file \"$IN_XSA\" is newer."
    elif [ "$IN_XSA" -nt "$DTB" ]; then
	echo "Rebuilding \"$DTB\"; the XSA file \"$IN_XSA\" is newer."
    else
	echo "Skipping build of \"$DTS\" and \"$DTB\"; the XSA file \"$IN_XSA\" is older."
	exit 0
    fi
fi

depend_exe ../U-BOOT/exe/dtc
#depend_dir ../kernel/linux-xlnx

rm -f "$DTS" "$DTB"

rm -rf "$TMPDIR"
mkdir -p "$TMPDIR"
mkdir -p "$OUTDIR"


cp "$IN_XSA" "$TMPDIR/$XSA"

(cd "$TMPDIR"; unzip "$XSA")

HWH=`echo "$TMPDIR"/*.hwh`

if [ ! -f "$HWH" ]; then
    echo ""
    echo "  The XSA file wasn't properly unzipped, to find the Hardware Handoff HWH file."
    echo ""
    exit 20
fi

(cd hwh_to_dts; make)

hwh_to_dts/hwh_to_dts/exe/hwh_to_dts "$HWH" "$TMPDIR/my_system.dts"

#
# Use the device tree info shipped with the Linux kernel.
#
# Doesn't work.  Fails to bring up USB clocks.  uboot doesn't work with it.
# Didn't fully investigate why.
#
#cp ../../kernel/linux-*/arch/arm64/boot/dts/xilinx/zynqmp*.dtsi "$TMPDIR"/
#cp -r ../../kernel/linux-*/include "$TMPDIR"/

if [ ! -f device-tree-xlnx.tgz ]; then
    echo ""
    echo ""
    echo "  Have no local copy of device-tree-xlnx.  Fetching and creating local copy."
    echo ""
    echo ""
    git clone https://github.com/Xilinx/device-tree-xlnx
    #(cd dtg; git checkout xilinx-v2020.2)
    tar czf device-tree-xlnx.tgz device-tree-xlnx
else
    tar xzf device-tree-xlnx.tgz
fi

cp -r device-tree-xlnx/device_tree/data/kernel_dtsi/2021.2/include "$TMPDIR"/
cp ./device-tree-xlnx/device_tree/data/kernel_dtsi/2021.2/zynqmp/* "$TMPDIR"/


cpp -nostdinc -I "$TMPDIR"/include -I "$TMPDIR"/include/dt-bindings -I "$TMPDIR"/include/dt-bindings/clock -I arch  -undef -x assembler-with-cpp  "$TMPDIR"/my_system.dts -o - | sed 's@.*bootargs.*@  bootargs = "earlycon console=ttyPS0,115200 clk_ignore_unused rootwait root=/dev/mmcblk0p2 rw earlyprintk net.ifnames=0";@' >$DTS

../U-BOOT/exe/dtc -@ -o "$DTB" "$DTS"

if [ -f "$DTS" -a -f "$DTB" ]; then
    echo ""
    echo "SUCCESS!  Device tree created in \"${DTS}\"."
    echo "          Compiled version in \"${DTB}\"."
    echo ""
    rm -rf "$TMPDIR" device-tree-xlnx
else
    echo ""
    echo "ERROR!  Couldn't create device tree $DTS of compiled version $DTB."
    echo "Leaving intermediate files for debugging."
    echo ""
fi
