
/*
 * Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., http://www.fsf.org/about/contact/
 *
 */


#include "BasicList.hh"

BasicList::~BasicList()
{
  BasicListElement *a;

  //
  // Must be careful here.  Deleting one element from the list may cause actions that also
  // come back to affect the list.  So keep the list valid when an element is deleted
  // by calling the remove() method.
  //
  a = first_element;
  while(a)
    {
      remove(a);
      a = first_element;
    }
}

void
BasicList::addAtEnd(BasicListElement* e)
{
  if(last_element==0)
    {
      first_element = last_element = e;
    }
  else
    {
      e->previous_element         = last_element;
      e->next_element             = 0;
      last_element->next_element  = e;
      last_element                = e;
    }
}

void
BasicList::remove(BasicListElement* e)
{
  if(last_element == e)
    {
      last_element               = e->previous_element;

      if(last_element)
	last_element->next_element = 0;
      else
	first_element = 0;
    }
  else if (first_element==e)
    {
      first_element                   = e->next_element;

      if(first_element)
	first_element->previous_element = 0;
      else
	last_element = 0;
    }
  else
    {
      e->previous_element->next_element = e->next_element;
      e->next_element->previous_element = e->previous_element;
    }

  delete e;
}


void
BasicList::replace_extract(BasicListElement* orig, BasicListElement* replacement)
{
  replacement->previous_element = orig->previous_element;
  replacement->next_element     = orig->next_element;

  if(orig->previous_element==0)
    first_element = replacement;
  else
    orig->previous_element->next_element = replacement;

  if(orig->next_element==0)
    last_element = replacement;
  else
    orig->next_element->previous_element = replacement;
}
