
/*
 * Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., http://www.fsf.org/about/contact/
 *
 */


#ifndef PARSE_SUPPORT_HH
#define PARSE_SUPPORT_HH

#include "readstream.hh"
#include "String.hh"

//
// REALLY basic
//
int isInString(char c, const char* s);
int isNotInString(char c, const char* s);
bool equalToLengthOfFirst(const char* s1, const char* s2);

//
// Basic.
//
int skipChars(readstream& a, const char* chars);
int skipUntilChars(readstream&a, const char* chars);
void parse_error(readstream& r);
void parse_warning(readstream& r, const char* s);

//
// More Advanced.
//
int   readInt(readstream& a);
long  readLong(readstream& a);
float readFloat(readstream& a);

String readQuotedString(readstream& a);
String readExtendedQuotedString(readstream& a);
String readPossiblyQuotedString(readstream& r, const char* terms);

int   readString(readstream& a, char* buf, const char* terms, int maxsize);
int   readStringWithEscape(readstream& a, char* buff, const char* terms, const char escape, int maxsize);
bool  validVariable(char* buf);
int   readVariable(readstream& a, char* buf, const char* terms, int maxsize);
int   readMultipinVariable(readstream& a, char* buf, const char* terms, int maxsize);
int   readMultipinVariableTD(readstream& a, char* buf, const char* terms, int maxsize);

int   readStringKnownChars(readstream& a, char* buf, const char* chars, int maxsize);

int   matchString(readstream& a, const char* s);

int   matchStringAlpha(readstream& a, const char* s);

int   matchStringI(readstream& a, const char* s);

//
// Most Advanced.
//
int skipCommentsCpp(readstream& a);
int skipCommentsSh(readstream& a);
int skipCommentsVerilog(readstream& a);
int skipCommentsVerilogNoNewline(readstream& a);
int skipCommentsUCF(readstream& a);

#endif
