
/*
 * Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., http://www.fsf.org/about/contact/
 *
 */


#ifndef READSTREAM_HH
#define READSTREAM_HH

#include <stdio.h>
#include <stdlib.h>

#undef getchar
#undef ungetchar

#define READSTREAM_BUFFERSIZE   1024
#define MAXFILENAMELEN           200

class readstream
{
  char filename[MAXFILENAMELEN];
  FILE *fp;
  unsigned char buffer[READSTREAM_BUFFERSIZE];
  int readindex;
  int writeindex;
  int num_in_buffer;
  int eof;
  int linenumber;
  long fileposition;

  readstream& operator=(readstream& r) { printf("Illegal readstream copy.\n"); exit(10); return r; }
  readstream(readstream& r) { printf("Illegal readstream copy.\n"); exit(10); }

public:

  readstream(const char* name);
  readstream(FILE* fp);
  ~readstream();

  int getchar();
  void ungetchar();
  void pushchar(char c) { printf("pushchar not implemented yet.\n"); }
  int getchars(char* buff, int num);
  void ungetchars(int num);

  int rewindToStartOfLine(); // returns number of characters

  int getlinenumber() { return linenumber; }
  const char* getfilename() { return filename; }
  int   geteof()      { return eof>1 || (eof==1 && num_in_buffer==0); }
};

#endif
