#!/bin/bash

depend_exe()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Tool \"$tool\" must be built to run this script.  Run exebuild.sh there."
	echo ""
	exit 20
    fi
}

depends()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Xilinx's tool $tool must be installed to run this script."
	echo ""
	exit 20
    fi
}

IN_XSA="$1"

if [ ! -f "$IN_XSA" ]; then
    echo "Usage: $0 XSA_FILE.xsa"
    exit 20
fi

OUTDIR=out
TMPDIR=tmp

DESIGN=`basename "$IN_XSA" | sed 's/[.].*//'`
DTS="$OUTDIR/${DESIGN}.dts"
DTB="$OUTDIR/${DESIGN}.dtb"
XSA="$TMPDIR/${DESIGN}.xsa"

if [ ! -f "$DTS" ]; then
    echo "No Device Tree \"$DTS\" exists; building it."
elif [ ! -f "$DTB" ]; then
    echo "No Device Tree \"$DTB\" exists; building it."
else
    if [ "$IN_XSA" -nt "$DTS" ]; then
	echo "Rebuilding \"$DTS\"; the XSA file \"$XSA\" is newer."
    elif [ "$IN_XSA" -nt "$DTB" ]; then
	echo "Rebuilding \"$DTB\"; the XSA file \"$XSA\" is newer."
    else
	echo "Skipping build of \"$DTS\" and \"$DTB\"; the XSA file \"$XSA\" is older."
	exit 0
    fi
fi

depend_exe ../u-boot-xlnx/exe/dtc
depends xsct

rm -f "$DTS" "$DTB"


mkdir -p "$TMPDIR"
mkdir -p "$OUTDIR"


cp "$IN_XSA" "$XSA"

rm -rf dtg dts

if [ ! -f device-tree-xlnx.tgz ]; then
    echo ""
    echo ""
    echo "  Have no local copy of device-tree-xlnx.  Fetching and creating local copy."
    echo ""
    echo ""
    git clone https://github.com/Xilinx/device-tree-xlnx
    #(cd dtg; git checkout xilinx-v2020.2)
    tar czf device-tree-xlnx.tgz device-tree-xlnx
else
    tar xzf device-tree-xlnx.tgz
fi

xsct <<EOF
hsi open_hw_design $XSA
hsi set_repo_path device-tree-xlnx
hsi create_sw_design device-tree -os device_tree -proc psu_cortexa53_0
hsi set_property CONFIG.remove_pl true [hsi::get_os]
#hsi set_property CONFIG.mainline_kernel v6.12 [hsi::get_os]
hsi set_property CONFIG.bootargs "earlycon console=ttyPS0,115200 clk_ignore_unused rootwait root=/dev/mmcblk0p2 rw earlyprintk net.ifnames=0"  [hsi::get_os]
#hsi set_property CONFIG.overlay_custom_dts file.dts [hsi::get_os]
hsi generate_target -dir "$TMPDIR"
hsi close_hw_design [hsi::current_hw_design]
EOF

#cpp -nostdinc -I include -I arch  -undef -x assembler-with-cpp  "$TMPDIR"/system-top.dts -o - | sed 's@.*bootargs.*@  bootargs = "earlycon console=ttyPS0,115200 clk_ignore_unused rootwait root=/dev/mmcblk0p2 rw earlyprintk net.ifnames=0";@' >$DTS

cpp -nostdinc -I "$TMPDIR"/include -I arch  -undef -x assembler-with-cpp  "$TMPDIR"/system-top.dts -o - >$DTS

../u-boot-xlnx/exe/dtc -@ -o "$DTB" "$DTS"

if [ -f "$DTS" -a -f "$DTB" ]; then
    echo ""
    echo "SUCCESS!  Device tree created in \"${DTS}\"."
    echo "          Compiled version in \"${DTB}\"."
    echo ""
    rm -rf "$TMPDIR" device-tree-xlnx
else
    echo ""
    echo "ERROR!  Couldn't create device tree $DTS of compiled version $DTB."
    echo "Leaving intermediate files for debugging."
    echo ""
fi
