#!/bin/bash

depend_exe()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Tool \"$tool\" must be built to run this script.  Run exebuild.sh there."
	echo ""
	exit 20
    fi
}

depends()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Xilinx's tool $tool must be installed to run this script."
	echo ""
	exit 20
    fi
}

IN_XSA="$1"

if [ ! -f "$IN_XSA" ]; then
    echo "Usage: $0 XSA_FILE.xsa"
    exit 20
fi

OUTDIR=out
TMPDIR=tmp

rm -rf "$TMPDIR"

DESIGN=`basename "$IN_XSA" | sed 's/[.].*//'`
DTS="$OUTDIR/${DESIGN}.dts"
DTB="$OUTDIR/${DESIGN}.dtb"
XSA="${DESIGN}.xsa"

if [ ! -f "$DTS" ]; then
    echo "No Device Tree \"$DTS\" exists; building it."
elif [ ! -f "$DTB" ]; then
    echo "No Device Tree \"$DTB\" exists; building it."
else
    if [ "$IN_XSA" -nt "$DTS" ]; then
	echo "Rebuilding \"$DTS\"; the XSA file \"$IN_XSA\" is newer."
    elif [ "$IN_XSA" -nt "$DTB" ]; then
	echo "Rebuilding \"$DTB\"; the XSA file \"$IN_XSA\" is newer."
    else
	echo "Skipping build of \"$DTS\" and \"$DTB\"; the XSA file \"$IN_XSA\" is older."
	exit 0
    fi
fi

depend_exe ../u-boot-xlnx/exe/dtc
depends petalinux-build

rm -f "$DTS" "$DTB"


mkdir -p "$TMPDIR"
mkdir -p "$OUTDIR"


cp "$IN_XSA" "$TMPDIR/$XSA"

rm -rf dtg dts

( cd "$TMPDIR";         petalinux-create --type project --template zynqMP --name DTGEN  )
( cd "$TMPDIR"/DTGEN;   petalinux-config --get-hw-description ../$XSA                   )
( cd "$TMPDIR"/DTGEN;   petalinux-build -c device-tree                                  )


cp "$TMPDIR"/DTGEN/images/linux/system.dtb $DTB

../u-boot-xlnx/exe/dtc "$DTB" -o "$DTS"

#cpp -nostdinc -I "$TMPDIR"/include -I arch  -undef -x assembler-with-cpp  "$TMPDIR"/system-top.dts -o - >$DTS

#../u-boot-xlnx/exe/dtc -@ -o "$DTB" "$DTS"

if [ -f "$DTS" -a -f "$DTB" ]; then
    echo ""
    echo "SUCCESS!  Device tree created in \"${DTS}\"."
    echo "          Compiled version in \"${DTB}\"."
    echo ""
    #rm -rf "$TMPDIR" device-tree-xlnx
else
    echo ""
    echo "ERROR!  Couldn't create device tree $DTS of compiled version $DTB."
    echo "Leaving intermediate files for debugging."
    echo ""
fi
