#!/bin/bash

depend_exe()
{
    tool="$1"
    if [ "`which $tool`" = "" ]; then
	echo ""
	echo "Tool \"$tool\" must be built to run this script.  Run exebuild.sh there."
	echo ""
	exit 20
    fi
}

depend_dir()
{
    dir="$1"
    if [ ! -d "$dir" ]; then
	echo ""
	echo "The Linux kernel source code must be installed in ../kernel/linux-xlnx"
	echo "to run this script.  Try running build in the kernel directory."
	echo ""
	exit 20
    fi
}

IN_XSA="$1"

if [ ! -f "$IN_XSA" ]; then
    echo "Usage: $0 XSA_FILE.xsa"
    exit 20
fi

OUTDIR1=out_kernel
OUTDIR2=out_uboot
TMPDIR=tmp

DESIGN=`basename "$IN_XSA" | sed 's/[.].*//'`
DTS1="$OUTDIR1/${DESIGN}.dts"
DTB1="$OUTDIR1/${DESIGN}.dtb"
DTS2="$OUTDIR2/${DESIGN}.dts"
DTB2="$OUTDIR2/${DESIGN}.dtb"
XSA="${DESIGN}.xsa"

#if [ ! -f "$DTS" ]; then
#    echo "No Device Tree \"$DTS\" exists; building it."
#elif [ ! -f "$DTB" ]; then
#    echo "No Device Tree \"$DTB\" exists; building it."
#else
#    if [ "$IN_XSA" -nt "$DTS" ]; then
#	echo "Rebuilding \"$DTS\"; the XSA file \"$IN_XSA\" is newer."
#    elif [ "$IN_XSA" -nt "$DTB" ]; then
#	echo "Rebuilding \"$DTB\"; the XSA file \"$IN_XSA\" is newer."
#    else
#	echo "Skipping build of \"$DTS\" and \"$DTB\"; the XSA file \"$IN_XSA\" is older."
#	exit 0
#    fi
#fi

depend_exe ../u-boot-xlnx/exe/dtc
#depend_dir ../kernel/linux-xlnx

rm -f "$DTS1" "$DTB1" "$DTS2" "$DTB2"

rm -rf "$TMPDIR"
mkdir -p "$TMPDIR"
mkdir -p "$OUTDIR1"
mkdir -p "$OUTDIR2"


cp "$IN_XSA" "$TMPDIR/$XSA"

(cd "$TMPDIR"; unzip "$XSA")

HWH=`echo "$TMPDIR"/*.hwh`

if [ ! -f "$HWH" ]; then
    echo ""
    echo "  The XSA file wasn't properly unzipped, to find the Hardware Handoff HWH file."
    echo ""
    exit 20
fi

(cd hwh_to_dts; make)

hwh_to_dts/write_device_tree/exe/write_device_tree "$HWH" "$TMPDIR/my_system.dts"

####################################################
#
# Use the device tree info shipped with the Linux kernel for the Linux kernel
#
mkdir "$TMPDIR"/kernel_dts
cp ../kernel/linux-*/arch/arm64/boot/dts/xilinx/zynqmp*.dtsi "$TMPDIR"/kernel_dts/
cp -r ../kernel/linux-*/include/dt-bindings "$TMPDIR"/kernel_dts/
cp "$TMPDIR/my_system.dts" "$TMPDIR"/kernel_dts/

cpp -nostdinc -I "$TMPDIR"/kernel_dts -I "$TMPDIR"/kernel_dts/dt-bindings/clock -I arch  -undef -x assembler-with-cpp  "$TMPDIR"/kernel_dts/my_system.dts -o - | sed 's@.*bootargs.*@  bootargs = "earlycon console=ttyPS0,115200 clk_ignore_unused rootwait root=/dev/mmcblk0p2 rw earlyprintk net.ifnames=0";@' >$DTS1

../u-boot-xlnx/exe/dtc -@ -o "$DTB1" "$DTS1"


##############################################
#
# Use the device tree info from Xilinx to work with the Xilinx uboot
#

if [ ! -d device-tree-xlnx ]; then
    if [ ! -f device-tree-xlnx.tgz ]; then
	echo ""
	echo ""
	echo "  Have no local copy of device-tree-xlnx.  Fetching and creating local copy."
	echo ""
	echo ""
	git clone https://github.com/Xilinx/device-tree-xlnx
	#(cd dtg; git checkout xilinx-v2020.2)
	tar czf device-tree-xlnx.tgz device-tree-xlnx
    else
	tar xzf device-tree-xlnx.tgz
    fi
fi


mkdir "$TMPDIR"/uboot_dts
cp -r device-tree-xlnx/device_tree/data/kernel_dtsi/2021.2/include "$TMPDIR"/uboot_dts/
cp ./device-tree-xlnx/device_tree/data/kernel_dtsi/2021.2/zynqmp/* "$TMPDIR"/uboot_dts/
cp "$TMPDIR/my_system.dts" "$TMPDIR"/uboot_dts/

cpp -nostdinc -I "$TMPDIR"/uboot_dts/include -I arch  -undef -x assembler-with-cpp  "$TMPDIR"/uboot_dts/my_system.dts -o - | sed 's@.*bootargs.*@  bootargs = "earlycon console=ttyPS0,115200 clk_ignore_unused rootwait root=/dev/mmcblk0p2 rw earlyprintk net.ifnames=0";@' >$DTS2

../u-boot-xlnx/exe/dtc -@ -o "$DTB2" "$DTS2"

######################################################################


if [ -f "$DTS1" -a -f "$DTB1" ]; then
    echo ""
    echo "SUCCESS!  Device tree created in \"${DTS1}\"."
    echo "          Compiled version in \"${DTB1}\"."
    echo ""
    rm -rf "$TMPDIR" device-tree-xlnx
else
    echo ""
    echo "ERROR!  Couldn't create device tree $DTS1 of compiled version $DTB1."
    echo "        Leaving intermediate files for debugging."
    echo ""
    exit 20
fi

if [ -f "$DTS2" -a -f "$DTB2" ]; then
    echo ""
    echo "SUCCESS!  Device tree created in \"${DTS2}\"."
    echo "          Compiled version in \"${DTB2}\"."
    echo ""
    rm -rf "$TMPDIR" device-tree-xlnx
else
    echo ""
    echo "ERROR!  Couldn't create device tree $DTS2 of compiled version $DTB2."
    echo "        Leaving intermediate files for debugging."
    echo ""
    exit 20
fi
