#!/bin/bash -e

myerror()
{
    echo ""
    echo "ERROR at this step.  Aborting."
    echo ""
    exit 20
}


echo "**********************************************************************"
echo "**"
echo "**   Building Linux kernel"
echo "**"
echo "**********************************************************************"
(cd kernel && ./build.sh) || myerror


echo "**********************************************************************"
echo "**"
echo "**   Building boot files."
echo "**"
echo "**********************************************************************"
(cd boot && ./build.sh) || myerror


echo "**********************************************************************"
echo "**"
echo "**   Building files for hardware handoff to C++."
echo "**"
echo "**********************************************************************"
(cd xsa_to_c++ && ./build.sh) || myerror


echo ""
echo ""
echo "Script finished successfully."
echo ""
echo "BOOT files are in:"
echo ""
ls -R boot/out/*

echo ""
echo "To use the boot files, rename the appropriate file to BOOT.BIN, rename the apprpriate file to image.ub,"
echo "and copy BOOT.BIN, image.ub, and BOOT.SCR onto the VFAT-formatted first partition of an sd card."
echo "Use this to boot your board.  For new boards or changes in the ZYNQ processor block IP, put the"
echo "new XSA file from Vivado into the boot/inputs/XSA directory and re-build.  Note that ZYNQ IP settings"
echo "must be correct for your board.  Read they STYNQ information on how to configure it."
echo ""

echo "You will also need a filesystem on the second partition.  Build this with the build script in"
echo "the filesystem directory.  The build script will end with installation instructions."
echo ""

echo "After the filesystem, you will need to write C++ programs to drive the hardware.  The information"
echo "needed to talk to the hardware is extracted from the HWH file inside the XSA file."
echo "The files to interface C++ with the PL design are in:"
echo ""
ls -R xsa_to_c++/out

echo ""
echo "To use these .cc and .hh files, include the .hh file from your program and use the"
echo "settings that are stored in the structures to interface with the devices in the PL."
echo "For new hardware designs, put your XSA file produced by Vivado into the"
echo "xsa_to_c++/inputs directory, and build again to get correct files.  Note that"
echo "the XSA doesn't need to be updated when producing boot files unless the ZYNQ processor"
echo "block has changed.  Also note that the .cc and .hh files don't need to be updated"
echo "in your C++ code unless something significant on the PL AXI bus has changed."
echo ""



