#!/bin/sh

VERSION=6.15

TARFILE=linux-${VERSION}.tar.xz
KERNEL_DIR=linux-${VERSION}

if [ ! -f "$TARFILE" ]; then
    echo "Local tar file \"$TARFILE\" doesn't exist.  Fetching it."

    wget https://cdn.kernel.org/pub/linux/kernel/v6.x/$TARFILE
fi

#
# Get kernel files
#
if [ ! -d "$KERNEL_DIR" ]; then
    echo "Kernel directory missing.  Unarchiving it."
    tar xf "$TARFILE"
fi

export CROSS_COMPILE=

LOCAL_ARCH=`arch`

if [ "$LOCAL_ARCH" != aarch64 ]; then

    CROSS_COMPILE=aarch64-linux-gnu-

fi

gcc_compiler=`which "${CROSS}gcc"`

if [ "$gcc_compiler" = "" ]; then

    echo "GCC Compiler ${CROSS}gcc is missing."
    exit 20
fi


cd "$KERNEL_DIR"

CONFFILE=inputs/STYNQ-${VERSION}.config

if [ ! -f "../$CONFFILE" ]; then
    echo ""
    echo "Missing config file \"$CONFFILE\"."
    echo "Configure from scratch?  ctrl-d=yes, ctrl-c=no"
    echo ""
    cat
else
    echo ""
    echo "Configuration file \"$CONFFILE\" exists."
    echo "To configure from scratch, delete or rename this file."
    echo "Configure starting with this config file?"
    echo "ctrl-d=yes, ctrl-c=no"
    echo ""
    cat
    cp ../$CONFFILE .config    
fi


#
# Run menuconfig to change the options
#

make ARCH=arm64 menuconfig


echo ""
echo "To save this configuration, run the command"
echo ""
echo "  cp $KERNEL_DIR/.config inputs/STYNQ.config"
echo ""
echo "The configuration won't be used by build.sh unless you do this."
echo ""
echo "Once you have done this, build.sh can be run to build the kernel."
echo ""
