#!/bin/bash -e

make

rm -rf out
mkdir out

for file in inputs/*.xsa; do

    base=`basename $file`
    design=`echo "$base" | sed 's/[.]xsa//'`

    tmp=tmp-"$base"

    rm -rf "$tmp"
    mkdir "$tmp"

    (cd "$tmp"; unzip ../"$file")

    cp "$tmp"/*.hwh "$tmp"/"$design".hwh
    
    (cd "$tmp"; ../hwh_to_c++/exe/hwh_to_c++ "$design".hwh)

    cp "$tmp"/*.cc "$tmp"/*.hh out/

    rm -rf "$tmp"
    
done
