
/*
 * Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., http://www.fsf.org/about/contact/
 *
 */


#ifndef WRITESTREAM_HH
#define WRITESTREAM_HH

#include <stdio.h>
#include "String.hh"

#define WRITESTREAM_BUFFERSIZE  1024

class writestream
{
  FILE *fp;
  unsigned char buffer[WRITESTREAM_BUFFERSIZE];
  int writeindex;
  bool close_file_on_exit;

  writestream(const writestream&); // make private so it can't be used.

public:

  writestream(FILE* fp);
  writestream(const char* name);
  ~writestream();

  writestream& spaces(int i) { while(i--) *this << ' '; return *this; }

  writestream& operator << (String* s) { return *this << *s;}
  writestream& operator << (String& s) { if((char*)s) *this << (char*)s; return *this;}
  writestream& operator << (char c);
  writestream& operator << (const char* c);
  writestream& operator << (int c);
  writestream& operator << (long c);
  writestream& operator << (float c);
};

#endif
