
/*
 * Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., http://www.fsf.org/about/contact/
 *
 */


#include "writestream.hh"
#include <stdlib.h>

writestream::writestream(const char* name)
{
  fp = fopen(name, "w");
  if(!fp)
    {
      printf("Can't open output stream \"%s\".\n", name);
      exit(10);
    }
  writeindex=0;
  close_file_on_exit = true;
}

writestream::writestream(FILE* fp)
{
  this->fp = fp;
  writeindex=0;
  close_file_on_exit = false;
}

writestream::~writestream()
{
  int num;

  if(writeindex>0)
    {
      num = fwrite(buffer, 1, writeindex, fp);
      if(num!=writeindex)
	{
	  printf("Failed to fully flush output file!\n");
	}
    }

  if(close_file_on_exit)
    fclose(fp);
}

writestream&
writestream::operator << ( char c )
{
  int num;

  buffer[writeindex++] = c;

  if(writeindex==WRITESTREAM_BUFFERSIZE)
    {
      num = fwrite(buffer, 1, WRITESTREAM_BUFFERSIZE, fp);
      if(num!=WRITESTREAM_BUFFERSIZE)
	{
	  printf("Failed to write full buffer to output file!\n");
	  exit(10);
	}

      writeindex=0;
    }

  return *this;
}

writestream&
writestream::operator << ( const char* c )
{
  while(*c)
    operator<<(*c++);

  return *this;
}

writestream&
writestream::operator << ( int c )
{    
  char buff[100];

  sprintf(buff, "%d", c);
  return operator<<(buff);
}

writestream&
writestream::operator << ( long c )
{    
  char buff[100];

  sprintf(buff, "%ld", c);
  return operator<<(buff);
}

writestream&
writestream::operator << ( float c )
{    
  char buff[100];

  //  gcvt(c, 6, buff);
  sprintf(buff, "%g", c);
  return operator<<(buff);
}
