#*****************************************************************************************
# Vivado (TM) v2024.2 (64-bit)
#
# BxB_Demo1.tcl: Tcl script for re-creating project 'BxB_Demo1'
#
# Generated by Vivado on Mon Jun 16 15:07:40 MST 2025
# IP Build 5239520 on Sun Nov 10 16:12:51 MST 2024
#
# This file contains the Vivado Tcl commands for re-creating the project to the state*
# when this script was generated. In order to re-create the project, please source this
# file in the Vivado Tcl Shell.
#
# * Note that the runs in the created project will be configured the same way as the
#   original project, however they will not be launched automatically. To regenerate the
#   run results please launch the synthesis/implementation runs as needed.
#
#*****************************************************************************************
# NOTE: In order to use this script for source control purposes, please make sure that the
#       following files are added to the source control system:-
#
# 1. This project restoration tcl script (BxB_Demo1.tcl) that was generated.
#
# 2. The following source(s) files that were local or imported into the original project.
#    (Please see the '$orig_proj_dir' and '$origin_dir' variable setting below at the start of the script)
#
#    <none>
#
# 3. The following remote source files that were added to the original project:-
#
#    "/data/code/fpga_hw/fpga_hw_RFSoC4x2_STYNQ/Design_from_tcl_scripted/RFSoC4x2_BxBDemo1_0.000/verilog/AXI_DNA.v"
#    "/data/code/fpga_hw/fpga_hw_RFSoC4x2_STYNQ/Design_from_tcl_scripted/RFSoC4x2_BxBDemo1_0.000/verilog/pl_sysref.v"
#    "/data/code/fpga_hw/fpga_hw_RFSoC4x2_STYNQ/Design_from_tcl_scripted/RFSoC4x2_BxBDemo1_0.000/pin_constraints.xdc"
#
#*****************************************************************************************

# Check file required for this script exists
proc checkRequiredFiles { origin_dir} {
  set status true
  set files [list \
 "[file normalize "$origin_dir/../verilog/AXI_DNA.v"]"\
 "[file normalize "$origin_dir/../verilog/pl_sysref.v"]"\
 "[file normalize "$origin_dir/../pin_constraints.xdc"]"\
  ]
  foreach ifile $files {
    if { ![file isfile $ifile] } {
      puts " Could not find remote file $ifile "
      set status false
    }
  }

  set paths [list \
 "[file normalize "$origin_dir/[file normalize "$origin_dir/../IP_INTEGRATOR"]"]"\
  ]
  foreach ipath $paths {
    if { ![file isdirectory $ipath] } {
      puts " Could not access $ipath "
      set status false
    }
  }

  return $status
}
# Set the reference directory for source file relative paths (by default the value is script directory path)
set origin_dir "."

# Use origin directory path location variable, if specified in the tcl shell
if { [info exists ::origin_dir_loc] } {
  set origin_dir $::origin_dir_loc
}

# Set the project name
set _xil_proj_name_ "BxB_Demo1"

# Use project name variable, if specified in the tcl shell
if { [info exists ::user_project_name] } {
  set _xil_proj_name_ $::user_project_name
}

variable script_file
set script_file "BxB_Demo1.tcl"

# Help information for this script
proc print_help {} {
  variable script_file
  puts "\nDescription:"
  puts "Recreate a Vivado project from this script. The created project will be"
  puts "functionally equivalent to the original project for which this script was"
  puts "generated. The script contains commands for creating a project, filesets,"
  puts "runs, adding/importing sources and setting properties on various objects.\n"
  puts "Syntax:"
  puts "$script_file"
  puts "$script_file -tclargs \[--origin_dir <path>\]"
  puts "$script_file -tclargs \[--project_name <name>\]"
  puts "$script_file -tclargs \[--help\]\n"
  puts "Usage:"
  puts "Name                   Description"
  puts "-------------------------------------------------------------------------"
  puts "\[--origin_dir <path>\]  Determine source file paths wrt this path. Default"
  puts "                       origin_dir path value is \".\", otherwise, the value"
  puts "                       that was set with the \"-paths_relative_to\" switch"
  puts "                       when this script was generated.\n"
  puts "\[--project_name <name>\] Create project with the specified name. Default"
  puts "                       name is the name of the project from where this"
  puts "                       script was generated.\n"
  puts "\[--help\]               Print help information for this script"
  puts "-------------------------------------------------------------------------\n"
  exit 0
}

if { $::argc > 0 } {
  for {set i 0} {$i < $::argc} {incr i} {
    set option [string trim [lindex $::argv $i]]
    switch -regexp -- $option {
      "--origin_dir"   { incr i; set origin_dir [lindex $::argv $i] }
      "--project_name" { incr i; set _xil_proj_name_ [lindex $::argv $i] }
      "--help"         { print_help }
      default {
        if { [regexp {^-} $option] } {
          puts "ERROR: Unknown option '$option' specified, please type '$script_file -tclargs --help' for usage info.\n"
          return 1
        }
      }
    }
  }
}

# Set the directory path for the original project from where this script was exported
set orig_proj_dir "[file normalize "$origin_dir/"]"

# Check for paths and files needed for project creation
set validate_required 0
if { $validate_required } {
  if { [checkRequiredFiles $origin_dir] } {
    puts "Tcl file $script_file is valid. All files required for project creation is accesable. "
  } else {
    puts "Tcl file $script_file is not valid. Not all files required for project creation is accesable. "
    return
  }
}

# Create project
create_project ${_xil_proj_name_} ./${_xil_proj_name_} -part xczu48dr-fsvg1517-2-e

# Set the directory path for the new project
set proj_dir [get_property directory [current_project]]

# Reconstruct message rules
# None

# Set project properties
set obj [current_project]
set_property -name "default_lib" -value "xil_defaultlib" -objects $obj
set_property -name "enable_resource_estimation" -value "0" -objects $obj
set_property -name "enable_vhdl_2008" -value "1" -objects $obj
set_property -name "ip_cache_permissions" -value "read write" -objects $obj
set_property -name "ip_output_repo" -value "$proj_dir/${_xil_proj_name_}.cache/ip" -objects $obj
set_property -name "mem.enable_memory_map_generation" -value "1" -objects $obj
set_property -name "part" -value "xczu48dr-fsvg1517-2-e" -objects $obj
set_property -name "revised_directory_structure" -value "1" -objects $obj
set_property -name "sim.central_dir" -value "$proj_dir/${_xil_proj_name_}.ip_user_files" -objects $obj
set_property -name "sim.ip.auto_export_scripts" -value "1" -objects $obj
set_property -name "simulator_language" -value "Mixed" -objects $obj
set_property -name "sim_compile_state" -value "1" -objects $obj
set_property -name "use_inline_hdl_ip" -value "1" -objects $obj
set_property -name "webtalk.modelsim_export_sim" -value "8" -objects $obj
set_property -name "webtalk.questa_export_sim" -value "8" -objects $obj
set_property -name "webtalk.riviera_export_sim" -value "8" -objects $obj
set_property -name "webtalk.vcs_export_sim" -value "8" -objects $obj
set_property -name "webtalk.xcelium_export_sim" -value "1" -objects $obj
set_property -name "webtalk.xsim_export_sim" -value "8" -objects $obj
set_property -name "xpm_libraries" -value "XPM_CDC XPM_MEMORY" -objects $obj

# Create 'sources_1' fileset (if not found)
if {[string equal [get_filesets -quiet sources_1] ""]} {
  create_fileset -srcset sources_1
}

# Set IP repository paths
set obj [get_filesets sources_1]
if { $obj != {} } {
   set_property "ip_repo_paths" "[file normalize "$origin_dir/../IP_INTEGRATOR"]" $obj

   # Rebuild user ip_repo's index before adding any source files
   update_ip_catalog -rebuild
}

# Set 'sources_1' fileset object
set obj [get_filesets sources_1]
set files [list \
 [file normalize "${origin_dir}/../verilog/AXI_DNA.v"] \
 [file normalize "${origin_dir}/../verilog/pl_sysref.v"] \
]
add_files -norecurse -fileset $obj $files

# Set 'sources_1' fileset file properties for remote files
# None

# Set 'sources_1' fileset file properties for local files
# None

# Set 'sources_1' fileset properties
set obj [get_filesets sources_1]
set_property -name "dataflow_viewer_settings" -value "min_width=16" -objects $obj
set_property -name "top" -value "design_1_wrapper" -objects $obj
set_property -name "top_auto_set" -value "0" -objects $obj

# Create 'constrs_1' fileset (if not found)
if {[string equal [get_filesets -quiet constrs_1] ""]} {
  create_fileset -constrset constrs_1
}

# Set 'constrs_1' fileset object
set obj [get_filesets constrs_1]

# Add/Import constrs file and set constrs file properties
set file "[file normalize "$origin_dir/../pin_constraints.xdc"]"
set file_added [add_files -norecurse -fileset $obj [list $file]]
set file "$origin_dir/../pin_constraints.xdc"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets constrs_1] [list "*$file"]]
set_property -name "file_type" -value "XDC" -objects $file_obj
set_property -name "processing_order" -value "LATE" -objects $file_obj

# Set 'constrs_1' fileset properties
set obj [get_filesets constrs_1]
set_property -name "target_part" -value "xczu48dr-fsvg1517-2-e" -objects $obj

# Create 'sim_1' fileset (if not found)
if {[string equal [get_filesets -quiet sim_1] ""]} {
  create_fileset -simset sim_1
}

# Set 'sim_1' fileset object
set obj [get_filesets sim_1]
# Empty (no sources present)

# Set 'sim_1' fileset properties
set obj [get_filesets sim_1]
set_property -name "sim_wrapper_top" -value "1" -objects $obj
set_property -name "top" -value "design_1_wrapper" -objects $obj
set_property -name "top_auto_set" -value "0" -objects $obj
set_property -name "top_lib" -value "xil_defaultlib" -objects $obj

# Set 'utils_1' fileset object
set obj [get_filesets utils_1]
# Empty (no sources present)

# Set 'utils_1' fileset properties
set obj [get_filesets utils_1]


# Adding sources referenced in BDs, if not already added
if { [get_files [list AXI_DNA.v]] == "" } {
  import_files -quiet -fileset sources_1 /data/code/fpga_hw/fpga_hw_RFSoC4x2_STYNQ/Design_from_tcl_scripted/RFSoC4x2_BxBDemo1_0.000/verilog/AXI_DNA.v
}
if { [get_files [list pl_sysref.v]] == "" } {
  import_files -quiet -fileset sources_1 /data/code/fpga_hw/fpga_hw_RFSoC4x2_STYNQ/Design_from_tcl_scripted/RFSoC4x2_BxBDemo1_0.000/verilog/pl_sysref.v
}


# Proc to create BD design_1
proc cr_bd_design_1 { parentCell } {
# The design that will be created by this Tcl proc contains the following 
# module references:
# AXI_DNA, pl_sysref



  # CHANGE DESIGN NAME HERE
  set design_name design_1

  common::send_gid_msg -ssname BD::TCL -id 2010 -severity "INFO" "Currently there is no design <$design_name> in project, so creating one..."

  create_bd_design $design_name

  set bCheckIPsPassed 1
  ##################################################################
  # CHECK IPs
  ##################################################################
  set bCheckIPs 1
  if { $bCheckIPs == 1 } {
     set list_check_ips "\ 
  bitbybitsp.com:UTILITY:clock_measurement:1.4\
  bitbybitsp.com:UTILITY:spectrum_capture_control:1.1\
  bitbybitsp.com:UTILITY:white_gaussian_noise:1.0\
  xilinx.com:ip:xlconstant:1.1\
  xilinx.com:ip:xlslice:1.0\
  bitbybitsp.com:UTILITY:real_sample_capture:1.2\
  xilinx.com:ip:axi_gpio:2.0\
  xilinx.com:ip:zynq_ultra_ps_e:3.5\
  xilinx.com:ip:proc_sys_reset:5.0\
  bitbybitsp.com:UTILITY:add:1.0\
  bitbybitsp.com:UTILITY:sine:1.0\
  bitbybitsp.com:UTILITY:split:1.0\
  bitbybitsp.com:UTILITY:swept_spread_phase_generator:1.0\
  bitbybitsp.com:UTILITY:spectral_capture_96000R_12:1.2\
  bitbybitsp.com:UTILITY:sample_interleave:1.0\
  bitbybitsp.com:UTILITY:simple_trigger:1.5\
  xilinx.com:ip:usp_rf_data_converter:2.6\
  "

   set list_ips_missing ""
   common::send_gid_msg -ssname BD::TCL -id 2011 -severity "INFO" "Checking if the following IPs exist in the project's IP catalog: $list_check_ips ."

   foreach ip_vlnv $list_check_ips {
      set ip_obj [get_ipdefs -all $ip_vlnv]
      if { $ip_obj eq "" } {
         lappend list_ips_missing $ip_vlnv
      }
   }

   if { $list_ips_missing ne "" } {
      catch {common::send_gid_msg -ssname BD::TCL -id 2012 -severity "ERROR" "The following IPs are not found in the IP Catalog:\n  $list_ips_missing\n\nResolution: Please add the repository containing the IP(s) to the project." }
      set bCheckIPsPassed 0
   }

  }

  ##################################################################
  # CHECK Modules
  ##################################################################
  set bCheckModules 1
  if { $bCheckModules == 1 } {
     set list_check_mods "\ 
  AXI_DNA\
  pl_sysref\
  "

   set list_mods_missing ""
   common::send_gid_msg -ssname BD::TCL -id 2020 -severity "INFO" "Checking if the following modules exist in the project's sources: $list_check_mods ."

   foreach mod_vlnv $list_check_mods {
      if { [can_resolve_reference $mod_vlnv] == 0 } {
         lappend list_mods_missing $mod_vlnv
      }
   }

   if { $list_mods_missing ne "" } {
      catch {common::send_gid_msg -ssname BD::TCL -id 2021 -severity "ERROR" "The following module(s) are not found in the project: $list_mods_missing" }
      common::send_gid_msg -ssname BD::TCL -id 2022 -severity "INFO" "Please add source files for the missing module(s) above."
      set bCheckIPsPassed 0
   }
}

  if { $bCheckIPsPassed != 1 } {
    common::send_gid_msg -ssname BD::TCL -id 2023 -severity "WARNING" "Will not continue with creation of design due to the error(s) above."
    return 3
  }

  
# Hierarchical cell: ADC_DAC
proc create_hier_cell_ADC_DAC { parentCell nameHier } {

  variable script_folder

  if { $parentCell eq "" || $nameHier eq "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2092 -severity "ERROR" "create_hier_cell_ADC_DAC() - Empty argument(s)!"}
     return
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2090 -severity "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2091 -severity "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj

  # Create cell and set as current instance
  set hier_obj [create_bd_cell -type hier $nameHier]
  current_bd_instance $hier_obj

  # Create interface pins
  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:aximm_rtl:1.0 s_axi

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 s00_axis

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 s10_axis

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 dac1_clk_0

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:diff_analog_io_rtl:1.0 vin0_01_0

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:display_usp_rf_data_converter:diff_pins_rtl:1.0 sysref_in_0

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:diff_analog_io_rtl:1.0 vin0_23_1

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:diff_analog_io_rtl:1.0 vin2_01_1

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:diff_analog_io_rtl:1.0 vin2_23_1

  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 m00_axis

  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 m02_axis

  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 m20_axis

  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 m22_axis

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 adc0_clk_0

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 adc2_clk_0

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 dac0_clk_0

  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:diff_analog_io_rtl:1.0 vout00_0

  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:diff_analog_io_rtl:1.0 vout20_0


  # Create pins
  create_bd_pin -dir O -type clk clk_adc0
  create_bd_pin -dir O -type clk clk_adc2
  create_bd_pin -dir O -type clk clk_dac0
  create_bd_pin -dir I -type clk s_axi_aclk
  create_bd_pin -dir I -type rst s_axi_aresetn
  create_bd_pin -dir I user_sysref_adc
  create_bd_pin -dir I -type rst m1_axis_aresetn
  create_bd_pin -dir I -type clk m1_axis_aclk
  create_bd_pin -dir O -type clk clk_dac2
  create_bd_pin -dir I user_sysref_dac

  # Create instance: usp_rf_data_converter_1, and set properties
  set usp_rf_data_converter_1 [ create_bd_cell -type ip -vlnv xilinx.com:ip:usp_rf_data_converter:2.6 usp_rf_data_converter_1 ]
  set_property -dict [list \
    CONFIG.ADC0_Outclk_Freq {312.500} \
    CONFIG.ADC0_Refclk_Freq {5000.000} \
    CONFIG.ADC0_Sampling_Rate {5} \
    CONFIG.ADC2_Outclk_Freq {312.500} \
    CONFIG.ADC2_Refclk_Freq {5000.000} \
    CONFIG.ADC2_Sampling_Rate {5} \
    CONFIG.ADC_Coarse_Mixer_Freq02 {3} \
    CONFIG.ADC_Coarse_Mixer_Freq20 {3} \
    CONFIG.ADC_Coarse_Mixer_Freq22 {3} \
    CONFIG.ADC_Data_Width00 {12} \
    CONFIG.ADC_Data_Width02 {12} \
    CONFIG.ADC_Data_Width20 {12} \
    CONFIG.ADC_Data_Width22 {12} \
    CONFIG.ADC_Decimation_Mode02 {1} \
    CONFIG.ADC_Decimation_Mode20 {1} \
    CONFIG.ADC_Decimation_Mode22 {1} \
    CONFIG.ADC_Mixer_Type02 {1} \
    CONFIG.ADC_Mixer_Type20 {1} \
    CONFIG.ADC_Mixer_Type22 {1} \
    CONFIG.ADC_OBS22 {false} \
    CONFIG.ADC_Slice02_Enable {true} \
    CONFIG.ADC_Slice20_Enable {true} \
    CONFIG.ADC_Slice22_Enable {true} \
    CONFIG.DAC0_Outclk_Freq {52.083} \
    CONFIG.DAC0_Refclk_Freq {6666.667} \
    CONFIG.DAC0_Sampling_Rate {6.666666666} \
    CONFIG.DAC2_Outclk_Freq {416.667} \
    CONFIG.DAC2_Refclk_Freq {6666.667} \
    CONFIG.DAC2_Sampling_Rate {6.666666666} \
    CONFIG.DAC_Coarse_Mixer_Freq00 {3} \
    CONFIG.DAC_Coarse_Mixer_Freq20 {3} \
    CONFIG.DAC_Interpolation_Mode00 {1} \
    CONFIG.DAC_Interpolation_Mode20 {1} \
    CONFIG.DAC_Mixer_Type00 {1} \
    CONFIG.DAC_Mixer_Type20 {1} \
    CONFIG.DAC_Slice00_Enable {true} \
    CONFIG.DAC_Slice20_Enable {true} \
  ] $usp_rf_data_converter_1


  # Create interface connections
  connect_bd_intf_net -intf_net adc0_clk_0_1 [get_bd_intf_pins adc0_clk_0] [get_bd_intf_pins usp_rf_data_converter_1/adc0_clk]
  connect_bd_intf_net -intf_net adc2_clk_0_1 [get_bd_intf_pins adc2_clk_0] [get_bd_intf_pins usp_rf_data_converter_1/adc2_clk]
  connect_bd_intf_net -intf_net dac0_clk_0_1 [get_bd_intf_pins dac0_clk_0] [get_bd_intf_pins usp_rf_data_converter_1/dac0_clk]
  connect_bd_intf_net -intf_net dac1_clk_0_1 [get_bd_intf_pins dac1_clk_0] [get_bd_intf_pins usp_rf_data_converter_1/dac2_clk]
  connect_bd_intf_net -intf_net s00_axis_1 [get_bd_intf_pins s00_axis] [get_bd_intf_pins usp_rf_data_converter_1/s00_axis]
  connect_bd_intf_net -intf_net s10_axis_1 [get_bd_intf_pins s10_axis] [get_bd_intf_pins usp_rf_data_converter_1/s20_axis]
  connect_bd_intf_net -intf_net s_axi_1 [get_bd_intf_pins s_axi] [get_bd_intf_pins usp_rf_data_converter_1/s_axi]
  connect_bd_intf_net -intf_net sysref_in_0_1 [get_bd_intf_pins sysref_in_0] [get_bd_intf_pins usp_rf_data_converter_1/sysref_in]
  connect_bd_intf_net -intf_net usp_rf_data_converter_1_m00_axis [get_bd_intf_pins m00_axis] [get_bd_intf_pins usp_rf_data_converter_1/m00_axis]
  connect_bd_intf_net -intf_net usp_rf_data_converter_1_m02_axis [get_bd_intf_pins m02_axis] [get_bd_intf_pins usp_rf_data_converter_1/m02_axis]
  connect_bd_intf_net -intf_net usp_rf_data_converter_1_m20_axis [get_bd_intf_pins m20_axis] [get_bd_intf_pins usp_rf_data_converter_1/m20_axis]
  connect_bd_intf_net -intf_net usp_rf_data_converter_1_m22_axis [get_bd_intf_pins m22_axis] [get_bd_intf_pins usp_rf_data_converter_1/m22_axis]
  connect_bd_intf_net -intf_net usp_rf_data_converter_1_vout00 [get_bd_intf_pins vout00_0] [get_bd_intf_pins usp_rf_data_converter_1/vout00]
  connect_bd_intf_net -intf_net usp_rf_data_converter_1_vout20 [get_bd_intf_pins vout20_0] [get_bd_intf_pins usp_rf_data_converter_1/vout20]
  connect_bd_intf_net -intf_net vin0_01_0_1 [get_bd_intf_pins vin0_01_0] [get_bd_intf_pins usp_rf_data_converter_1/vin0_01]
  connect_bd_intf_net -intf_net vin0_23_1_1 [get_bd_intf_pins vin0_23_1] [get_bd_intf_pins usp_rf_data_converter_1/vin0_23]
  connect_bd_intf_net -intf_net vin2_01_1_1 [get_bd_intf_pins vin2_01_1] [get_bd_intf_pins usp_rf_data_converter_1/vin2_01]
  connect_bd_intf_net -intf_net vin2_23_1_1 [get_bd_intf_pins vin2_23_1] [get_bd_intf_pins usp_rf_data_converter_1/vin2_23]

  # Create port connections
  connect_bd_net -net m1_axis_aclk_1  [get_bd_pins m1_axis_aclk] \
  [get_bd_pins usp_rf_data_converter_1/m0_axis_aclk] \
  [get_bd_pins usp_rf_data_converter_1/m2_axis_aclk] \
  [get_bd_pins usp_rf_data_converter_1/s0_axis_aclk] \
  [get_bd_pins usp_rf_data_converter_1/s2_axis_aclk]
  connect_bd_net -net m1_axis_aresetn_1  [get_bd_pins m1_axis_aresetn] \
  [get_bd_pins usp_rf_data_converter_1/m0_axis_aresetn] \
  [get_bd_pins usp_rf_data_converter_1/m2_axis_aresetn] \
  [get_bd_pins usp_rf_data_converter_1/s0_axis_aresetn] \
  [get_bd_pins usp_rf_data_converter_1/s2_axis_aresetn]
  connect_bd_net -net s_axi_aclk_1  [get_bd_pins s_axi_aclk] \
  [get_bd_pins usp_rf_data_converter_1/s_axi_aclk]
  connect_bd_net -net s_axi_aresetn_1  [get_bd_pins s_axi_aresetn] \
  [get_bd_pins usp_rf_data_converter_1/s_axi_aresetn]
  connect_bd_net -net usp_rf_data_converter_1_clk_adc0  [get_bd_pins usp_rf_data_converter_1/clk_adc0] \
  [get_bd_pins clk_adc0]
  connect_bd_net -net usp_rf_data_converter_1_clk_adc2  [get_bd_pins usp_rf_data_converter_1/clk_adc2] \
  [get_bd_pins clk_adc2]
  connect_bd_net -net usp_rf_data_converter_1_clk_dac0  [get_bd_pins usp_rf_data_converter_1/clk_dac0] \
  [get_bd_pins clk_dac0]
  connect_bd_net -net usp_rf_data_converter_1_clk_dac2  [get_bd_pins usp_rf_data_converter_1/clk_dac2] \
  [get_bd_pins clk_dac2]

  # Restore current instance
  current_bd_instance $oldCurInst
}
  
# Hierarchical cell: Function_Gen1
proc create_hier_cell_Function_Gen1 { parentCell nameHier } {

  variable script_folder

  if { $parentCell eq "" || $nameHier eq "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2092 -severity "ERROR" "create_hier_cell_Function_Gen1() - Empty argument(s)!"}
     return
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2090 -severity "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2091 -severity "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj

  # Create cell and set as current instance
  set hier_obj [create_bd_cell -type hier $nameHier]
  current_bd_instance $hier_obj

  # Create interface pins
  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 OUT_AXIS

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:aximm_rtl:1.0 S_AXI

  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 OUT_DUP_AXIS

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 IN_2_AXIS

  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 OUT_DUP_AXIS_2


  # Create pins
  create_bd_pin -dir I -type clk OUT_AXIS_aclk
  create_bd_pin -dir I -type rst OUT_AXIS_aresetn
  create_bd_pin -dir I -type clk S_AXI_ACLK
  create_bd_pin -dir I -type rst S_AXI_ARESETN

  # Create instance: add_0, and set properties
  set add_0 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:add:1.0 add_0 ]
  set_property CONFIG.AXIS_SAMPLES_PER_CLOCK {16} $add_0


  set_property SELECTED_SIM_MODEL rtl  $add_0

  # Create instance: sine_0, and set properties
  set sine_0 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:sine:1.0 sine_0 ]
  set_property CONFIG.SAMPLES_PER_CLOCK {16} $sine_0


  set_property SELECTED_SIM_MODEL rtl  $sine_0

  # Create instance: split_0, and set properties
  set split_0 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:split:1.0 split_0 ]
  set_property CONFIG.AXIS_SAMPLES_PER_CLOCK {16} $split_0


  set_property SELECTED_SIM_MODEL rtl  $split_0

  # Create instance: swept_spread_phase_g_0, and set properties
  set swept_spread_phase_g_0 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:swept_spread_phase_generator:1.0 swept_spread_phase_g_0 ]
  set_property CONFIG.AXIS_SAMPLES_PER_CLOCK {16} $swept_spread_phase_g_0


  set_property SELECTED_SIM_MODEL rtl  $swept_spread_phase_g_0

  # Create interface connections
  connect_bd_intf_net -intf_net Conn1 [get_bd_intf_pins IN_2_AXIS] [get_bd_intf_pins add_0/IN_2_AXIS]
  connect_bd_intf_net -intf_net add_0_OUT_AXIS [get_bd_intf_pins OUT_AXIS] [get_bd_intf_pins add_0/OUT_AXIS]
  connect_bd_intf_net -intf_net add_0_OUT_DUP_AXIS [get_bd_intf_pins add_0/OUT_DUP_AXIS] [get_bd_intf_pins split_0/IN_1_AXIS]
  connect_bd_intf_net -intf_net ps8_0_axi_periph_M04_AXI [get_bd_intf_pins S_AXI] [get_bd_intf_pins swept_spread_phase_g_0/S_AXI]
  connect_bd_intf_net -intf_net sine_0_OUT_AXIS [get_bd_intf_pins sine_0/OUT_AXIS] [get_bd_intf_pins add_0/IN_1_AXIS]
  connect_bd_intf_net -intf_net split_0_OUT_AXIS [get_bd_intf_pins OUT_DUP_AXIS] [get_bd_intf_pins split_0/OUT_AXIS]
  connect_bd_intf_net -intf_net split_0_OUT_DUP_AXIS [get_bd_intf_pins OUT_DUP_AXIS_2] [get_bd_intf_pins split_0/OUT_DUP_AXIS]
  connect_bd_intf_net -intf_net swept_spread_phase_g_0_OUT_AXIS [get_bd_intf_pins swept_spread_phase_g_0/OUT_AXIS] [get_bd_intf_pins sine_0/IN_AXIS]

  # Create port connections
  connect_bd_net -net DAC_AXIS_PL_CLK  [get_bd_pins OUT_AXIS_aclk] \
  [get_bd_pins add_0/clk] \
  [get_bd_pins sine_0/clk] \
  [get_bd_pins split_0/clk] \
  [get_bd_pins swept_spread_phase_g_0/OUT_AXIS_aclk]
  connect_bd_net -net proc_sys_reset_1_peripheral_aresetn  [get_bd_pins OUT_AXIS_aresetn] \
  [get_bd_pins add_0/resetn] \
  [get_bd_pins sine_0/resetn] \
  [get_bd_pins split_0/resetn] \
  [get_bd_pins swept_spread_phase_g_0/OUT_AXIS_aresetn]
  connect_bd_net -net rst_ps8_0_99M_peripheral_aresetn  [get_bd_pins S_AXI_ARESETN] \
  [get_bd_pins swept_spread_phase_g_0/S_AXI_ARESETN]
  connect_bd_net -net swept_spread_phase_g_0_sine_shift_right_o  [get_bd_pins swept_spread_phase_g_0/sine_shift_right_o] \
  [get_bd_pins sine_0/shift_right_i]
  connect_bd_net -net zynq_ultra_ps_e_0_pl_clk0  [get_bd_pins S_AXI_ACLK] \
  [get_bd_pins swept_spread_phase_g_0/S_AXI_ACLK]

  # Restore current instance
  current_bd_instance $oldCurInst
}
  
# Hierarchical cell: trigger
proc create_hier_cell_trigger { parentCell nameHier } {

  variable script_folder

  if { $parentCell eq "" || $nameHier eq "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2092 -severity "ERROR" "create_hier_cell_trigger() - Empty argument(s)!"}
     return
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2090 -severity "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2091 -severity "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj

  # Create cell and set as current instance
  set hier_obj [create_bd_cell -type hier $nameHier]
  current_bd_instance $hier_obj

  # Create interface pins
  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 PASS_2_AXIS

  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 PASS_0_AXIS

  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 PASS_1_AXIS

  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 PASS_3_AXIS

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:aximm_rtl:1.0 S_AXI

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 IN_0_AXIS

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 IN_1_AXIS

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 IN_2_AXIS

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 IN_3_AXIS


  # Create pins
  create_bd_pin -dir I -type clk fpga_refclk
  create_bd_pin -dir I -type rst IN_AXIS_aresetn
  create_bd_pin -dir I -type rst S_AXI_ARESETN
  create_bd_pin -dir O collect
  create_bd_pin -dir I external_trigger
  create_bd_pin -dir I -type clk S_AXI_ACLK

  # Create instance: sample_interleave_0, and set properties
  set sample_interleave_0 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:sample_interleave:1.0 sample_interleave_0 ]
  set_property -dict [list \
    CONFIG.IN_SAMPLES_PER_CLOCK {12} \
    CONFIG.MULTIPLIER {1} \
  ] $sample_interleave_0


  set_property SELECTED_SIM_MODEL rtl  $sample_interleave_0

  # Create instance: sample_interleave_1, and set properties
  set sample_interleave_1 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:sample_interleave:1.0 sample_interleave_1 ]
  set_property -dict [list \
    CONFIG.IN_SAMPLES_PER_CLOCK {12} \
    CONFIG.MULTIPLIER {1} \
  ] $sample_interleave_1


  set_property SELECTED_SIM_MODEL rtl  $sample_interleave_1

  # Create instance: sample_interleave_2, and set properties
  set sample_interleave_2 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:sample_interleave:1.0 sample_interleave_2 ]
  set_property -dict [list \
    CONFIG.IN_SAMPLES_PER_CLOCK {12} \
    CONFIG.MULTIPLIER {1} \
  ] $sample_interleave_2


  set_property SELECTED_SIM_MODEL rtl  $sample_interleave_2

  # Create instance: sample_interleave_3, and set properties
  set sample_interleave_3 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:sample_interleave:1.0 sample_interleave_3 ]
  set_property -dict [list \
    CONFIG.IN_SAMPLES_PER_CLOCK {12} \
    CONFIG.MULTIPLIER {1} \
  ] $sample_interleave_3


  set_property SELECTED_SIM_MODEL rtl  $sample_interleave_3

  # Create instance: simple_trigger_1, and set properties
  set simple_trigger_1 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:simple_trigger:1.5 simple_trigger_1 ]
  set_property CONFIG.AXIS_SAMPLES_PER_CLOCK {12} $simple_trigger_1


  set_property SELECTED_SIM_MODEL rtl  $simple_trigger_1

  # Create interface connections
  connect_bd_intf_net -intf_net Conn3 [get_bd_intf_pins PASS_2_AXIS] [get_bd_intf_pins simple_trigger_1/PASS_2_AXIS]
  connect_bd_intf_net -intf_net Conn5 [get_bd_intf_pins PASS_0_AXIS] [get_bd_intf_pins simple_trigger_1/PASS_0_AXIS]
  connect_bd_intf_net -intf_net Conn7 [get_bd_intf_pins PASS_1_AXIS] [get_bd_intf_pins simple_trigger_1/PASS_1_AXIS]
  connect_bd_intf_net -intf_net Conn8 [get_bd_intf_pins PASS_3_AXIS] [get_bd_intf_pins simple_trigger_1/PASS_3_AXIS]
  connect_bd_intf_net -intf_net Conn9 [get_bd_intf_pins S_AXI] [get_bd_intf_pins simple_trigger_1/S_AXI]
  connect_bd_intf_net -intf_net IN_0_AXIS_1 [get_bd_intf_pins IN_0_AXIS] [get_bd_intf_pins sample_interleave_0/IN_AXIS]
  connect_bd_intf_net -intf_net IN_1_AXIS_1 [get_bd_intf_pins IN_1_AXIS] [get_bd_intf_pins sample_interleave_1/IN_AXIS]
  connect_bd_intf_net -intf_net IN_2_AXIS_1 [get_bd_intf_pins IN_2_AXIS] [get_bd_intf_pins sample_interleave_2/IN_AXIS]
  connect_bd_intf_net -intf_net IN_3_AXIS_1 [get_bd_intf_pins IN_3_AXIS] [get_bd_intf_pins sample_interleave_3/IN_AXIS]
  connect_bd_intf_net -intf_net sample_interleave_0_OUT_AXIS [get_bd_intf_pins sample_interleave_0/OUT_AXIS] [get_bd_intf_pins simple_trigger_1/IN_0_AXIS]
  connect_bd_intf_net -intf_net sample_interleave_1_OUT_AXIS [get_bd_intf_pins sample_interleave_1/OUT_AXIS] [get_bd_intf_pins simple_trigger_1/IN_1_AXIS]
  connect_bd_intf_net -intf_net sample_interleave_2_OUT_AXIS [get_bd_intf_pins sample_interleave_2/OUT_AXIS] [get_bd_intf_pins simple_trigger_1/IN_2_AXIS]
  connect_bd_intf_net -intf_net sample_interleave_3_OUT_AXIS [get_bd_intf_pins sample_interleave_3/OUT_AXIS] [get_bd_intf_pins simple_trigger_1/IN_3_AXIS]

  # Create port connections
  connect_bd_net -net IN_AXIS_aresetn_1  [get_bd_pins IN_AXIS_aresetn] \
  [get_bd_pins sample_interleave_0/resetn] \
  [get_bd_pins sample_interleave_1/resetn] \
  [get_bd_pins sample_interleave_2/resetn] \
  [get_bd_pins sample_interleave_3/resetn] \
  [get_bd_pins simple_trigger_1/IN_AXIS_aresetn]
  connect_bd_net -net S_AXI_ACLK_1  [get_bd_pins S_AXI_ACLK] \
  [get_bd_pins simple_trigger_1/S_AXI_ACLK]
  connect_bd_net -net S_AXI_ARESETN_1  [get_bd_pins S_AXI_ARESETN] \
  [get_bd_pins simple_trigger_1/S_AXI_ARESETN]
  connect_bd_net -net external_trigger_1  [get_bd_pins external_trigger] \
  [get_bd_pins simple_trigger_1/external_trigger]
  connect_bd_net -net fpga_refclk_1  [get_bd_pins fpga_refclk] \
  [get_bd_pins sample_interleave_0/clk] \
  [get_bd_pins sample_interleave_1/clk] \
  [get_bd_pins sample_interleave_2/clk] \
  [get_bd_pins sample_interleave_3/clk] \
  [get_bd_pins simple_trigger_1/IN_AXIS_aclk]
  connect_bd_net -net simple_trigger_1_collect  [get_bd_pins simple_trigger_1/collect] \
  [get_bd_pins collect]

  # Restore current instance
  current_bd_instance $oldCurInst
}
  
# Hierarchical cell: spect
proc create_hier_cell_spect { parentCell nameHier } {

  variable script_folder

  if { $parentCell eq "" || $nameHier eq "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2092 -severity "ERROR" "create_hier_cell_spect() - Empty argument(s)!"}
     return
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2090 -severity "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2091 -severity "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj

  # Create cell and set as current instance
  set hier_obj [create_bd_cell -type hier $nameHier]
  current_bd_instance $hier_obj

  # Create interface pins
  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 EARLY_AXIS

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 LATE_AXIS

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:aximm_rtl:1.0 S_AXI


  # Create pins
  create_bd_pin -dir I -type clk AXIS_aclk
  create_bd_pin -dir I -type rst AXIS_aresetn
  create_bd_pin -dir I -type clk S_AXI_ACLK
  create_bd_pin -dir I -type rst S_AXI_ARESETN

  # Create instance: spectral_capture_960_0, and set properties
  set spectral_capture_960_0 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:spectral_capture_96000R_12:1.2 spectral_capture_960_0 ]
  set_property CONFIG.AXIS_SAMPLES_PER_CLOCK {12} $spectral_capture_960_0


  set_property SELECTED_SIM_MODEL rtl  $spectral_capture_960_0

  # Create interface connections
  connect_bd_intf_net -intf_net EARLY_AXIS_1 [get_bd_intf_pins EARLY_AXIS] [get_bd_intf_pins spectral_capture_960_0/EARLY_AXIS]
  connect_bd_intf_net -intf_net LATE_AXIS_1 [get_bd_intf_pins LATE_AXIS] [get_bd_intf_pins spectral_capture_960_0/LATE_AXIS]
  connect_bd_intf_net -intf_net S_AXI_1 [get_bd_intf_pins S_AXI] [get_bd_intf_pins spectral_capture_960_0/S_AXI]

  # Create port connections
  connect_bd_net -net AXIS_aclk_1  [get_bd_pins AXIS_aclk] \
  [get_bd_pins spectral_capture_960_0/AXIS_aclk]
  connect_bd_net -net AXIS_aresetn_1  [get_bd_pins AXIS_aresetn] \
  [get_bd_pins spectral_capture_960_0/AXIS_aresetn]
  connect_bd_net -net S_AXI_ACLK_1  [get_bd_pins S_AXI_ACLK] \
  [get_bd_pins spectral_capture_960_0/S_AXI_ACLK]
  connect_bd_net -net S_AXI_ARESETN_1  [get_bd_pins S_AXI_ARESETN] \
  [get_bd_pins spectral_capture_960_0/S_AXI_ARESETN]

  # Restore current instance
  current_bd_instance $oldCurInst
}
  
# Hierarchical cell: Function_Gen0
proc create_hier_cell_Function_Gen0 { parentCell nameHier } {

  variable script_folder

  if { $parentCell eq "" || $nameHier eq "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2092 -severity "ERROR" "create_hier_cell_Function_Gen0() - Empty argument(s)!"}
     return
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2090 -severity "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2091 -severity "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj

  # Create cell and set as current instance
  set hier_obj [create_bd_cell -type hier $nameHier]
  current_bd_instance $hier_obj

  # Create interface pins
  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 OUT_AXIS

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:aximm_rtl:1.0 S_AXI

  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 OUT_DUP_AXIS

  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 IN_2_AXIS

  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 OUT_DUP_AXIS_2


  # Create pins
  create_bd_pin -dir I -type clk OUT_AXIS_aclk
  create_bd_pin -dir I -type rst OUT_AXIS_aresetn
  create_bd_pin -dir I -type clk S_AXI_ACLK
  create_bd_pin -dir I -type rst S_AXI_ARESETN

  # Create instance: add_0, and set properties
  set add_0 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:add:1.0 add_0 ]
  set_property CONFIG.AXIS_SAMPLES_PER_CLOCK {16} $add_0


  set_property SELECTED_SIM_MODEL rtl  $add_0

  # Create instance: sine_0, and set properties
  set sine_0 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:sine:1.0 sine_0 ]
  set_property CONFIG.SAMPLES_PER_CLOCK {16} $sine_0


  set_property SELECTED_SIM_MODEL rtl  $sine_0

  # Create instance: split_0, and set properties
  set split_0 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:split:1.0 split_0 ]
  set_property CONFIG.AXIS_SAMPLES_PER_CLOCK {16} $split_0


  set_property SELECTED_SIM_MODEL rtl  $split_0

  # Create instance: swept_spread_phase_g_0, and set properties
  set swept_spread_phase_g_0 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:swept_spread_phase_generator:1.0 swept_spread_phase_g_0 ]
  set_property CONFIG.AXIS_SAMPLES_PER_CLOCK {16} $swept_spread_phase_g_0


  set_property SELECTED_SIM_MODEL rtl  $swept_spread_phase_g_0

  # Create interface connections
  connect_bd_intf_net -intf_net Conn1 [get_bd_intf_pins IN_2_AXIS] [get_bd_intf_pins add_0/IN_2_AXIS]
  connect_bd_intf_net -intf_net add_0_OUT_AXIS [get_bd_intf_pins OUT_AXIS] [get_bd_intf_pins add_0/OUT_AXIS]
  connect_bd_intf_net -intf_net add_0_OUT_DUP_AXIS [get_bd_intf_pins add_0/OUT_DUP_AXIS] [get_bd_intf_pins split_0/IN_1_AXIS]
  connect_bd_intf_net -intf_net ps8_0_axi_periph_M04_AXI [get_bd_intf_pins S_AXI] [get_bd_intf_pins swept_spread_phase_g_0/S_AXI]
  connect_bd_intf_net -intf_net sine_0_OUT_AXIS [get_bd_intf_pins sine_0/OUT_AXIS] [get_bd_intf_pins add_0/IN_1_AXIS]
  connect_bd_intf_net -intf_net split_0_OUT_AXIS [get_bd_intf_pins OUT_DUP_AXIS] [get_bd_intf_pins split_0/OUT_AXIS]
  connect_bd_intf_net -intf_net split_0_OUT_DUP_AXIS [get_bd_intf_pins OUT_DUP_AXIS_2] [get_bd_intf_pins split_0/OUT_DUP_AXIS]
  connect_bd_intf_net -intf_net swept_spread_phase_g_0_OUT_AXIS [get_bd_intf_pins swept_spread_phase_g_0/OUT_AXIS] [get_bd_intf_pins sine_0/IN_AXIS]

  # Create port connections
  connect_bd_net -net DAC_AXIS_PL_CLK  [get_bd_pins OUT_AXIS_aclk] \
  [get_bd_pins add_0/clk] \
  [get_bd_pins sine_0/clk] \
  [get_bd_pins split_0/clk] \
  [get_bd_pins swept_spread_phase_g_0/OUT_AXIS_aclk]
  connect_bd_net -net proc_sys_reset_1_peripheral_aresetn  [get_bd_pins OUT_AXIS_aresetn] \
  [get_bd_pins add_0/resetn] \
  [get_bd_pins sine_0/resetn] \
  [get_bd_pins split_0/resetn] \
  [get_bd_pins swept_spread_phase_g_0/OUT_AXIS_aresetn]
  connect_bd_net -net rst_ps8_0_99M_peripheral_aresetn  [get_bd_pins S_AXI_ARESETN] \
  [get_bd_pins swept_spread_phase_g_0/S_AXI_ARESETN]
  connect_bd_net -net swept_spread_phase_g_0_sine_shift_right_o  [get_bd_pins swept_spread_phase_g_0/sine_shift_right_o] \
  [get_bd_pins sine_0/shift_right_i]
  connect_bd_net -net zynq_ultra_ps_e_0_pl_clk0  [get_bd_pins S_AXI_ACLK] \
  [get_bd_pins swept_spread_phase_g_0/S_AXI_ACLK]

  # Restore current instance
  current_bd_instance $oldCurInst
}
  
# Hierarchical cell: hier_rsts
proc create_hier_cell_hier_rsts { parentCell nameHier } {

  variable script_folder

  if { $parentCell eq "" || $nameHier eq "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2092 -severity "ERROR" "create_hier_cell_hier_rsts() - Empty argument(s)!"}
     return
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2090 -severity "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2091 -severity "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj

  # Create cell and set as current instance
  set hier_obj [create_bd_cell -type hier $nameHier]
  current_bd_instance $hier_obj

  # Create interface pins

  # Create pins
  create_bd_pin -dir I -type clk slowest_sync_clk
  create_bd_pin -dir I -type rst ext_reset_in
  create_bd_pin -dir O -from 0 -to 0 -type rst peripheral_aresetn
  create_bd_pin -dir I -type clk slowest_sync_clk2
  create_bd_pin -dir O -from 0 -to 0 -type rst peripheral_aresetn2
  create_bd_pin -dir I dcm_locked
  create_bd_pin -dir O -from 0 -to 0 -type rst interconnect_aresetn
  create_bd_pin -dir O -from 0 -to 0 -type rst interconnect_aresetn1

  # Create instance: reset_dac_clk, and set properties
  set reset_dac_clk [ create_bd_cell -type ip -vlnv xilinx.com:ip:proc_sys_reset:5.0 reset_dac_clk ]

  set_property SELECTED_SIM_MODEL rtl  $reset_dac_clk

  # Create instance: rst_ps8_0_99M, and set properties
  set rst_ps8_0_99M [ create_bd_cell -type ip -vlnv xilinx.com:ip:proc_sys_reset:5.0 rst_ps8_0_99M ]

  set_property SELECTED_SIM_MODEL rtl  $rst_ps8_0_99M

  # Create port connections
  connect_bd_net -net dcm_locked_1  [get_bd_pins dcm_locked] \
  [get_bd_pins reset_dac_clk/dcm_locked]
  connect_bd_net -net proc_sys_reset_1_peripheral_aresetn  [get_bd_pins reset_dac_clk/peripheral_aresetn] \
  [get_bd_pins peripheral_aresetn]
  connect_bd_net -net reset_dac_clk_interconnect_aresetn  [get_bd_pins reset_dac_clk/interconnect_aresetn] \
  [get_bd_pins interconnect_aresetn]
  connect_bd_net -net rst_ps8_0_99M_interconnect_aresetn  [get_bd_pins rst_ps8_0_99M/interconnect_aresetn] \
  [get_bd_pins interconnect_aresetn1]
  connect_bd_net -net rst_ps8_0_99M_peripheral_aresetn  [get_bd_pins rst_ps8_0_99M/peripheral_aresetn] \
  [get_bd_pins peripheral_aresetn2]
  connect_bd_net -net usp_rf_data_converter_0_clk_dac0  [get_bd_pins slowest_sync_clk] \
  [get_bd_pins reset_dac_clk/slowest_sync_clk]
  connect_bd_net -net zynq_ultra_ps_e_0_pl_clk0  [get_bd_pins slowest_sync_clk2] \
  [get_bd_pins rst_ps8_0_99M/slowest_sync_clk]
  connect_bd_net -net zynq_ultra_ps_e_0_pl_resetn0  [get_bd_pins ext_reset_in] \
  [get_bd_pins reset_dac_clk/ext_reset_in] \
  [get_bd_pins rst_ps8_0_99M/ext_reset_in]

  # Restore current instance
  current_bd_instance $oldCurInst
}
  variable script_folder

  if { $parentCell eq "" } {
     set parentCell [get_bd_cells /]
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2090 -severity "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2091 -severity "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj


  # Create interface ports
  set vin0_01_0 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_analog_io_rtl:1.0 vin0_01_0 ]

  set dac1_clk_0 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 dac1_clk_0 ]

  set sysref_in_0 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:display_usp_rf_data_converter:diff_pins_rtl:1.0 sysref_in_0 ]

  set clk104_pl_sysref [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 clk104_pl_sysref ]

  set vin0_23_1 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_analog_io_rtl:1.0 vin0_23_1 ]

  set vin2_01_1 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_analog_io_rtl:1.0 vin2_01_1 ]

  set vin2_23_1 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_analog_io_rtl:1.0 vin2_23_1 ]

  set adc0_clk_0 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 adc0_clk_0 ]

  set adc2_clk_0 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 adc2_clk_0 ]

  set dac0_clk_0 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 dac0_clk_0 ]

  set vout00_0 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:diff_analog_io_rtl:1.0 vout00_0 ]

  set vout20_0 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:diff_analog_io_rtl:1.0 vout20_0 ]


  # Create ports

  # Create instance: hier_rsts
  create_hier_cell_hier_rsts [current_bd_instance .] hier_rsts

  # Create instance: Function_Gen0
  create_hier_cell_Function_Gen0 [current_bd_instance .] Function_Gen0

  # Create instance: spect
  create_hier_cell_spect [current_bd_instance .] spect

  # Create instance: trigger
  create_hier_cell_trigger [current_bd_instance .] trigger

  # Create instance: Function_Gen1
  create_hier_cell_Function_Gen1 [current_bd_instance .] Function_Gen1

  # Create instance: ADC_DAC
  create_hier_cell_ADC_DAC [current_bd_instance .] ADC_DAC

  # Create instance: AXI_DNA_0, and set properties
  set block_name AXI_DNA
  set block_cell_name AXI_DNA_0
  if { [catch {set AXI_DNA_0 [create_bd_cell -type module -reference $block_name $block_cell_name] } errmsg] } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2095 -severity "ERROR" "Unable to add referenced block <$block_name>. Please add the files for ${block_name}'s definition into the project."}
     return 1
   } elseif { $AXI_DNA_0 eq "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2096 -severity "ERROR" "Unable to referenced block <$block_name>. Please add the files for ${block_name}'s definition into the project."}
     return 1
   }
    set_property CONFIG.C_S_AXI_ADDR_WIDTH {5} $AXI_DNA_0


  set_property SELECTED_SIM_MODEL rtl  $AXI_DNA_0

  # Create instance: clock_measurement_0, and set properties
  set clock_measurement_0 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:clock_measurement:1.4 clock_measurement_0 ]
  set_property -dict [list \
    CONFIG.CLOCK_MEASUREMENT_ID {0xCCCCCCCC} \
    CONFIG.EXPECTED_CLK_0_FREQ_HZ {312500000} \
    CONFIG.EXPECTED_CLK_1_FREQ_HZ {312500000} \
    CONFIG.EXPECTED_CLK_2_FREQ_HZ {52083333} \
    CONFIG.EXPECTED_CLK_3_FREQ_HZ {416666667} \
    CONFIG.NUM_CLOCKS {4} \
    CONFIG.REF_CLOCK_FREQ_HZ {99990000} \
  ] $clock_measurement_0


  set_property SELECTED_SIM_MODEL rtl  $clock_measurement_0

  # Create instance: spectrum_capture_con_0, and set properties
  set spectrum_capture_con_0 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:spectrum_capture_control:1.1 spectrum_capture_con_0 ]
  set_property CONFIG.AXIS_SAMPLES_PER_CLOCK {12} $spectrum_capture_con_0


  set_property SELECTED_SIM_MODEL rtl  $spectrum_capture_con_0

  # Create instance: spectrum_capture_con_1, and set properties
  set spectrum_capture_con_1 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:spectrum_capture_control:1.1 spectrum_capture_con_1 ]
  set_property CONFIG.AXIS_SAMPLES_PER_CLOCK {12} $spectrum_capture_con_1


  set_property SELECTED_SIM_MODEL rtl  $spectrum_capture_con_1

  # Create instance: white_gaussian_noise_0, and set properties
  set white_gaussian_noise_0 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:white_gaussian_noise:1.0 white_gaussian_noise_0 ]
  set_property -dict [list \
    CONFIG.AXIS_SAMPLES_PER_CLOCK {16} \
    CONFIG.ENABLE_RANDOMIZER {0} \
  ] $white_gaussian_noise_0


  set_property SELECTED_SIM_MODEL rtl  $white_gaussian_noise_0

  # Create instance: xlconstant_0, and set properties
  set xlconstant_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:xlconstant:1.1 xlconstant_0 ]
  set_property CONFIG.CONST_VAL {0} $xlconstant_0


  set_property SELECTED_SIM_MODEL rtl  $xlconstant_0

  # Create instance: xlslice_0, and set properties
  set xlslice_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:xlslice:1.0 xlslice_0 ]
  set_property -dict [list \
    CONFIG.DIN_FROM {2} \
    CONFIG.DIN_TO {2} \
    CONFIG.DIN_WIDTH {6} \
    CONFIG.DOUT_WIDTH {1} \
  ] $xlslice_0


  set_property SELECTED_SIM_MODEL rtl  $xlslice_0

  # Create instance: real_sample_capture_00, and set properties
  set real_sample_capture_00 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:real_sample_capture:1.2 real_sample_capture_00 ]
  set_property -dict [list \
    CONFIG.AXIS_SAMPLES_PER_CLOCK {12} \
    CONFIG.BRAM_LENGTH {2048} \
  ] $real_sample_capture_00


  set_property SELECTED_SIM_MODEL rtl  $real_sample_capture_00

  # Create instance: real_sample_capture_01, and set properties
  set real_sample_capture_01 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:real_sample_capture:1.2 real_sample_capture_01 ]
  set_property -dict [list \
    CONFIG.AXIS_SAMPLES_PER_CLOCK {12} \
    CONFIG.BRAM_LENGTH {2048} \
  ] $real_sample_capture_01


  set_property SELECTED_SIM_MODEL rtl  $real_sample_capture_01

  # Create instance: real_sample_capture_02, and set properties
  set real_sample_capture_02 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:real_sample_capture:1.2 real_sample_capture_02 ]
  set_property -dict [list \
    CONFIG.AXIS_SAMPLES_PER_CLOCK {12} \
    CONFIG.BRAM_LENGTH {2048} \
  ] $real_sample_capture_02


  set_property SELECTED_SIM_MODEL rtl  $real_sample_capture_02

  # Create instance: real_sample_capture_03, and set properties
  set real_sample_capture_03 [ create_bd_cell -type ip -vlnv bitbybitsp.com:UTILITY:real_sample_capture:1.2 real_sample_capture_03 ]
  set_property -dict [list \
    CONFIG.AXIS_SAMPLES_PER_CLOCK {12} \
    CONFIG.BRAM_LENGTH {2048} \
  ] $real_sample_capture_03


  set_property SELECTED_SIM_MODEL rtl  $real_sample_capture_03

  # Create instance: xlconstant_1, and set properties
  set xlconstant_1 [ create_bd_cell -type ip -vlnv xilinx.com:ip:xlconstant:1.1 xlconstant_1 ]

  set_property SELECTED_SIM_MODEL rtl  $xlconstant_1

  # Create instance: pl_sysref_0, and set properties
  set block_name pl_sysref
  set block_cell_name pl_sysref_0
  if { [catch {set pl_sysref_0 [create_bd_cell -type module -reference $block_name $block_cell_name] } errmsg] } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2095 -severity "ERROR" "Unable to add referenced block <$block_name>. Please add the files for ${block_name}'s definition into the project."}
     return 1
   } elseif { $pl_sysref_0 eq "" } {
     catch {common::send_gid_msg -ssname BD::TCL -id 2096 -severity "ERROR" "Unable to referenced block <$block_name>. Please add the files for ${block_name}'s definition into the project."}
     return 1
   }
  
  set_property SELECTED_SIM_MODEL rtl  $pl_sysref_0

  # Create instance: axi_gpio_dac, and set properties
  set axi_gpio_dac [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_gpio:2.0 axi_gpio_dac ]
  set_property -dict [list \
    CONFIG.C_ALL_OUTPUTS {1} \
    CONFIG.C_ALL_OUTPUTS_2 {1} \
    CONFIG.C_GPIO2_WIDTH {6} \
    CONFIG.C_GPIO_WIDTH {1} \
    CONFIG.C_IS_DUAL {1} \
  ] $axi_gpio_dac


  set_property SELECTED_SIM_MODEL rtl  $axi_gpio_dac

  # Create instance: axi_interconnect_0, and set properties
  set axi_interconnect_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_interconnect:2.1 axi_interconnect_0 ]
  set_property -dict [list \
    CONFIG.M00_HAS_REGSLICE {4} \
    CONFIG.M01_HAS_REGSLICE {4} \
    CONFIG.NUM_MI {12} \
    CONFIG.S00_HAS_REGSLICE {4} \
  ] $axi_interconnect_0


  # Create instance: ps8_0_axi_periph, and set properties
  set ps8_0_axi_periph [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_interconnect:2.1 ps8_0_axi_periph ]
  set_property -dict [list \
    CONFIG.ENABLE_ADVANCED_OPTIONS {1} \
    CONFIG.M00_HAS_REGSLICE {4} \
    CONFIG.M01_HAS_REGSLICE {4} \
    CONFIG.M02_HAS_REGSLICE {4} \
    CONFIG.M03_HAS_REGSLICE {4} \
    CONFIG.M04_HAS_REGSLICE {4} \
    CONFIG.M05_HAS_REGSLICE {4} \
    CONFIG.M06_HAS_REGSLICE {4} \
    CONFIG.M07_HAS_REGSLICE {4} \
    CONFIG.M08_HAS_REGSLICE {4} \
    CONFIG.M09_HAS_REGSLICE {4} \
    CONFIG.M10_HAS_REGSLICE {4} \
    CONFIG.M11_HAS_REGSLICE {4} \
    CONFIG.M12_HAS_REGSLICE {4} \
    CONFIG.M13_HAS_REGSLICE {4} \
    CONFIG.M14_HAS_REGSLICE {4} \
    CONFIG.M15_HAS_REGSLICE {4} \
    CONFIG.NUM_MI {17} \
    CONFIG.S00_HAS_REGSLICE {4} \
    CONFIG.XBAR_DATA_WIDTH {32} \
  ] $ps8_0_axi_periph


  # Create instance: zynq_ultra_ps_e_0, and set properties
  set zynq_ultra_ps_e_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:zynq_ultra_ps_e:3.5 zynq_ultra_ps_e_0 ]
  set_property -dict [list \
    CONFIG.CAN0_BOARD_INTERFACE {custom} \
    CONFIG.CAN1_BOARD_INTERFACE {custom} \
    CONFIG.CSU_BOARD_INTERFACE {custom} \
    CONFIG.DP_BOARD_INTERFACE {custom} \
    CONFIG.GEM0_BOARD_INTERFACE {custom} \
    CONFIG.GEM1_BOARD_INTERFACE {custom} \
    CONFIG.GEM2_BOARD_INTERFACE {custom} \
    CONFIG.GEM3_BOARD_INTERFACE {custom} \
    CONFIG.GPIO_BOARD_INTERFACE {custom} \
    CONFIG.IIC0_BOARD_INTERFACE {custom} \
    CONFIG.IIC1_BOARD_INTERFACE {custom} \
    CONFIG.NAND_BOARD_INTERFACE {custom} \
    CONFIG.PCIE_BOARD_INTERFACE {custom} \
    CONFIG.PJTAG_BOARD_INTERFACE {custom} \
    CONFIG.PMU_BOARD_INTERFACE {custom} \
    CONFIG.PSU_BANK_0_IO_STANDARD {LVCMOS33} \
    CONFIG.PSU_BANK_1_IO_STANDARD {LVCMOS18} \
    CONFIG.PSU_BANK_2_IO_STANDARD {LVCMOS18} \
    CONFIG.PSU_BANK_3_IO_STANDARD {LVCMOS18} \
    CONFIG.PSU_DDR_RAM_HIGHADDR {0xFFFFFFFF} \
    CONFIG.PSU_DDR_RAM_HIGHADDR_OFFSET {0x800000000} \
    CONFIG.PSU_DDR_RAM_LOWADDR_OFFSET {0x80000000} \
    CONFIG.PSU_IMPORT_BOARD_PRESET {} \
    CONFIG.PSU_MIO_0_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_0_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_0_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_0_SLEW {slow} \
    CONFIG.PSU_MIO_10_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_10_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_10_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_10_SLEW {slow} \
    CONFIG.PSU_MIO_11_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_11_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_11_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_11_SLEW {slow} \
    CONFIG.PSU_MIO_12_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_12_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_12_POLARITY {Default} \
    CONFIG.PSU_MIO_12_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_12_SLEW {slow} \
    CONFIG.PSU_MIO_13_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_13_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_13_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_13_SLEW {slow} \
    CONFIG.PSU_MIO_14_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_14_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_14_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_14_SLEW {slow} \
    CONFIG.PSU_MIO_15_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_15_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_15_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_15_SLEW {slow} \
    CONFIG.PSU_MIO_16_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_16_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_16_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_16_SLEW {slow} \
    CONFIG.PSU_MIO_17_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_17_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_17_POLARITY {Default} \
    CONFIG.PSU_MIO_17_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_17_SLEW {slow} \
    CONFIG.PSU_MIO_18_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_18_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_18_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_18_SLEW {fast} \
    CONFIG.PSU_MIO_19_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_19_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_19_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_19_SLEW {slow} \
    CONFIG.PSU_MIO_1_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_1_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_1_SLEW {slow} \
    CONFIG.PSU_MIO_20_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_20_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_20_POLARITY {Default} \
    CONFIG.PSU_MIO_20_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_20_SLEW {slow} \
    CONFIG.PSU_MIO_21_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_21_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_21_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_21_SLEW {slow} \
    CONFIG.PSU_MIO_22_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_22_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_22_SLEW {slow} \
    CONFIG.PSU_MIO_23_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_23_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_23_POLARITY {Default} \
    CONFIG.PSU_MIO_23_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_23_SLEW {slow} \
    CONFIG.PSU_MIO_24_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_24_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_25_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_25_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_26_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_26_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_26_POLARITY {Default} \
    CONFIG.PSU_MIO_26_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_26_SLEW {slow} \
    CONFIG.PSU_MIO_27_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_27_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_27_SLEW {fast} \
    CONFIG.PSU_MIO_28_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_28_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_29_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_29_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_29_SLEW {fast} \
    CONFIG.PSU_MIO_2_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_2_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_2_SLEW {slow} \
    CONFIG.PSU_MIO_30_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_30_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_31_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_31_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_31_POLARITY {Default} \
    CONFIG.PSU_MIO_31_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_31_SLEW {slow} \
    CONFIG.PSU_MIO_32_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_32_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_32_SLEW {slow} \
    CONFIG.PSU_MIO_33_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_33_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_34_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_34_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_34_POLARITY {Default} \
    CONFIG.PSU_MIO_34_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_34_SLEW {slow} \
    CONFIG.PSU_MIO_35_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_35_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_35_POLARITY {Default} \
    CONFIG.PSU_MIO_35_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_35_SLEW {slow} \
    CONFIG.PSU_MIO_36_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_36_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_36_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_36_SLEW {slow} \
    CONFIG.PSU_MIO_37_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_37_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_37_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_37_SLEW {slow} \
    CONFIG.PSU_MIO_38_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_38_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_38_SLEW {slow} \
    CONFIG.PSU_MIO_39_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_39_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_39_SLEW {slow} \
    CONFIG.PSU_MIO_3_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_3_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_3_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_3_SLEW {slow} \
    CONFIG.PSU_MIO_40_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_40_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_40_SLEW {slow} \
    CONFIG.PSU_MIO_41_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_41_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_41_SLEW {slow} \
    CONFIG.PSU_MIO_42_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_42_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_42_SLEW {slow} \
    CONFIG.PSU_MIO_43_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_43_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_43_SLEW {slow} \
    CONFIG.PSU_MIO_44_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_44_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_45_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_45_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_46_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_46_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_47_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_47_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_48_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_48_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_49_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_49_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_4_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_4_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_4_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_4_SLEW {slow} \
    CONFIG.PSU_MIO_50_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_50_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_50_SLEW {slow} \
    CONFIG.PSU_MIO_51_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_51_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_51_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_51_SLEW {slow} \
    CONFIG.PSU_MIO_52_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_52_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_53_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_53_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_54_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_54_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_54_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_54_SLEW {slow} \
    CONFIG.PSU_MIO_55_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_55_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_56_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_56_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_56_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_56_SLEW {slow} \
    CONFIG.PSU_MIO_57_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_57_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_57_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_57_SLEW {slow} \
    CONFIG.PSU_MIO_58_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_58_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_58_SLEW {slow} \
    CONFIG.PSU_MIO_59_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_59_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_59_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_59_SLEW {slow} \
    CONFIG.PSU_MIO_5_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_5_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_5_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_5_SLEW {slow} \
    CONFIG.PSU_MIO_60_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_60_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_60_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_60_SLEW {slow} \
    CONFIG.PSU_MIO_61_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_61_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_61_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_61_SLEW {slow} \
    CONFIG.PSU_MIO_62_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_62_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_62_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_62_SLEW {slow} \
    CONFIG.PSU_MIO_63_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_63_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_63_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_63_SLEW {slow} \
    CONFIG.PSU_MIO_64_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_64_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_65_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_65_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_66_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_66_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_66_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_66_SLEW {slow} \
    CONFIG.PSU_MIO_67_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_67_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_68_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_68_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_68_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_68_SLEW {slow} \
    CONFIG.PSU_MIO_69_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_69_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_69_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_69_SLEW {slow} \
    CONFIG.PSU_MIO_6_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_6_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_6_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_6_SLEW {slow} \
    CONFIG.PSU_MIO_70_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_70_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_70_SLEW {fast} \
    CONFIG.PSU_MIO_71_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_71_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_71_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_71_SLEW {fast} \
    CONFIG.PSU_MIO_72_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_72_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_72_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_72_SLEW {fast} \
    CONFIG.PSU_MIO_73_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_73_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_73_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_73_SLEW {fast} \
    CONFIG.PSU_MIO_74_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_74_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_74_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_74_SLEW {fast} \
    CONFIG.PSU_MIO_75_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_75_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_75_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_75_SLEW {fast} \
    CONFIG.PSU_MIO_76_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_76_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_76_POLARITY {Default} \
    CONFIG.PSU_MIO_76_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_76_SLEW {slow} \
    CONFIG.PSU_MIO_77_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_77_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_77_POLARITY {Default} \
    CONFIG.PSU_MIO_77_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_77_SLEW {slow} \
    CONFIG.PSU_MIO_7_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_7_INPUT_TYPE {cmos} \
    CONFIG.PSU_MIO_7_POLARITY {Default} \
    CONFIG.PSU_MIO_7_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_7_SLEW {slow} \
    CONFIG.PSU_MIO_8_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_8_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_8_POLARITY {Default} \
    CONFIG.PSU_MIO_8_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_8_SLEW {slow} \
    CONFIG.PSU_MIO_9_DRIVE_STRENGTH {12} \
    CONFIG.PSU_MIO_9_INPUT_TYPE {schmitt} \
    CONFIG.PSU_MIO_9_PULLUPDOWN {pullup} \
    CONFIG.PSU_MIO_9_SLEW {slow} \
    CONFIG.PSU_MIO_TREE_PERIPHERALS {SPI 0#SPI 0#SPI 0#SPI 0#SPI 0#SPI 0#SPI 1#GPIO0 MIO#GPIO0 MIO#SPI 1#SPI 1#SPI 1#GPIO0 MIO#SD 0#SD 0#SD 0#SD 0#GPIO0 MIO#I2C 0#I2C 0#GPIO0 MIO#SD 0#SD 0#GPIO0 MIO#SD\
0#SD 0#GPIO1 MIO#DPAUX#DPAUX#DPAUX#DPAUX#GPIO1 MIO#UART 1#UART 1#GPIO1 MIO#GPIO1 MIO#I2C 1#I2C 1#Gem 1#Gem 1#Gem 1#Gem 1#Gem 1#Gem 1#Gem 1#Gem 1#Gem 1#Gem 1#Gem 1#Gem 1#MDIO 1#MDIO 1#USB 0#USB 0#USB 0#USB\
0#USB 0#USB 0#USB 0#USB 0#USB 0#USB 0#USB 0#USB 0#USB 1#USB 1#USB 1#USB 1#USB 1#USB 1#USB 1#USB 1#USB 1#USB 1#USB 1#USB 1#GPIO2 MIO#GPIO2 MIO} \
    CONFIG.PSU_MIO_TREE_SIGNALS {sclk_out#n_ss_out[2]#n_ss_out[1]#n_ss_out[0]#miso#mosi#sclk_out#gpio0[7]#gpio0[8]#n_ss_out[0]#miso#mosi#gpio0[12]#sdio0_data_out[0]#sdio0_data_out[1]#sdio0_data_out[2]#sdio0_data_out[3]#gpio0[17]#scl_out#sda_out#gpio0[20]#sdio0_cmd_out#sdio0_clk_out#gpio0[23]#sdio0_cd_n#sdio0_wp#gpio1[26]#dp_aux_data_out#dp_hot_plug_detect#dp_aux_data_oe#dp_aux_data_in#gpio1[31]#txd#rxd#gpio1[34]#gpio1[35]#scl_out#sda_out#rgmii_tx_clk#rgmii_txd[0]#rgmii_txd[1]#rgmii_txd[2]#rgmii_txd[3]#rgmii_tx_ctl#rgmii_rx_clk#rgmii_rxd[0]#rgmii_rxd[1]#rgmii_rxd[2]#rgmii_rxd[3]#rgmii_rx_ctl#gem1_mdc#gem1_mdio_out#ulpi_clk_in#ulpi_dir#ulpi_tx_data[2]#ulpi_nxt#ulpi_tx_data[0]#ulpi_tx_data[1]#ulpi_stp#ulpi_tx_data[3]#ulpi_tx_data[4]#ulpi_tx_data[5]#ulpi_tx_data[6]#ulpi_tx_data[7]#ulpi_clk_in#ulpi_dir#ulpi_tx_data[2]#ulpi_nxt#ulpi_tx_data[0]#ulpi_tx_data[1]#ulpi_stp#ulpi_tx_data[3]#ulpi_tx_data[4]#ulpi_tx_data[5]#ulpi_tx_data[6]#ulpi_tx_data[7]#gpio2[76]#gpio2[77]}\
\
    CONFIG.PSU_PERIPHERAL_BOARD_PRESET {} \
    CONFIG.PSU_SD0_INTERNAL_BUS_WIDTH {4} \
    CONFIG.PSU_SD1_INTERNAL_BUS_WIDTH {8} \
    CONFIG.PSU_SMC_CYCLE_T0 {NA} \
    CONFIG.PSU_SMC_CYCLE_T1 {NA} \
    CONFIG.PSU_SMC_CYCLE_T2 {NA} \
    CONFIG.PSU_SMC_CYCLE_T3 {NA} \
    CONFIG.PSU_SMC_CYCLE_T4 {NA} \
    CONFIG.PSU_SMC_CYCLE_T5 {NA} \
    CONFIG.PSU_SMC_CYCLE_T6 {NA} \
    CONFIG.PSU_USB3__DUAL_CLOCK_ENABLE {1} \
    CONFIG.PSU_VALUE_SILVERSION {3} \
    CONFIG.PSU__ACPU0__POWER__ON {1} \
    CONFIG.PSU__ACPU1__POWER__ON {1} \
    CONFIG.PSU__ACPU2__POWER__ON {1} \
    CONFIG.PSU__ACPU3__POWER__ON {1} \
    CONFIG.PSU__ACTUAL__IP {1} \
    CONFIG.PSU__ACT_DDR_FREQ_MHZ {1199.999756} \
    CONFIG.PSU__AUX_REF_CLK__FREQMHZ {33.333} \
    CONFIG.PSU__CAN0_LOOP_CAN1__ENABLE {0} \
    CONFIG.PSU__CAN0__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__CAN1__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__CRF_APB__ACPU_CTRL__ACT_FREQMHZ {1199.999756} \
    CONFIG.PSU__CRF_APB__ACPU_CTRL__DIVISOR0 {1} \
    CONFIG.PSU__CRF_APB__ACPU_CTRL__FREQMHZ {1200} \
    CONFIG.PSU__CRF_APB__ACPU_CTRL__SRCSEL {APLL} \
    CONFIG.PSU__CRF_APB__ACPU__FRAC_ENABLED {0} \
    CONFIG.PSU__CRF_APB__AFI0_REF_CTRL__ACT_FREQMHZ {667} \
    CONFIG.PSU__CRF_APB__AFI0_REF_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRF_APB__AFI0_REF_CTRL__FREQMHZ {667} \
    CONFIG.PSU__CRF_APB__AFI0_REF_CTRL__SRCSEL {DPLL} \
    CONFIG.PSU__CRF_APB__AFI0_REF__ENABLE {0} \
    CONFIG.PSU__CRF_APB__AFI1_REF_CTRL__ACT_FREQMHZ {667} \
    CONFIG.PSU__CRF_APB__AFI1_REF_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRF_APB__AFI1_REF_CTRL__FREQMHZ {667} \
    CONFIG.PSU__CRF_APB__AFI1_REF_CTRL__SRCSEL {DPLL} \
    CONFIG.PSU__CRF_APB__AFI1_REF__ENABLE {0} \
    CONFIG.PSU__CRF_APB__AFI2_REF_CTRL__ACT_FREQMHZ {667} \
    CONFIG.PSU__CRF_APB__AFI2_REF_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRF_APB__AFI2_REF_CTRL__FREQMHZ {667} \
    CONFIG.PSU__CRF_APB__AFI2_REF_CTRL__SRCSEL {DPLL} \
    CONFIG.PSU__CRF_APB__AFI2_REF__ENABLE {0} \
    CONFIG.PSU__CRF_APB__AFI3_REF_CTRL__ACT_FREQMHZ {667} \
    CONFIG.PSU__CRF_APB__AFI3_REF_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRF_APB__AFI3_REF_CTRL__FREQMHZ {667} \
    CONFIG.PSU__CRF_APB__AFI3_REF_CTRL__SRCSEL {DPLL} \
    CONFIG.PSU__CRF_APB__AFI3_REF__ENABLE {0} \
    CONFIG.PSU__CRF_APB__AFI4_REF_CTRL__ACT_FREQMHZ {667} \
    CONFIG.PSU__CRF_APB__AFI4_REF_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRF_APB__AFI4_REF_CTRL__FREQMHZ {667} \
    CONFIG.PSU__CRF_APB__AFI4_REF_CTRL__SRCSEL {DPLL} \
    CONFIG.PSU__CRF_APB__AFI4_REF__ENABLE {0} \
    CONFIG.PSU__CRF_APB__AFI5_REF_CTRL__ACT_FREQMHZ {667} \
    CONFIG.PSU__CRF_APB__AFI5_REF_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRF_APB__AFI5_REF_CTRL__FREQMHZ {667} \
    CONFIG.PSU__CRF_APB__AFI5_REF_CTRL__SRCSEL {DPLL} \
    CONFIG.PSU__CRF_APB__AFI5_REF__ENABLE {0} \
    CONFIG.PSU__CRF_APB__APLL_CTRL__DIV2 {1} \
    CONFIG.PSU__CRF_APB__APLL_CTRL__FBDIV {72} \
    CONFIG.PSU__CRF_APB__APLL_CTRL__FRACFREQ {27.138} \
    CONFIG.PSU__CRF_APB__APLL_CTRL__SRCSEL {PSS_REF_CLK} \
    CONFIG.PSU__CRF_APB__APLL_TO_LPD_CTRL__DIVISOR0 {3} \
    CONFIG.PSU__CRF_APB__APM_CTRL__ACT_FREQMHZ {1} \
    CONFIG.PSU__CRF_APB__APM_CTRL__DIVISOR0 {1} \
    CONFIG.PSU__CRF_APB__APM_CTRL__FREQMHZ {1} \
    CONFIG.PSU__CRF_APB__DBG_FPD_CTRL__ACT_FREQMHZ {249.999954} \
    CONFIG.PSU__CRF_APB__DBG_FPD_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRF_APB__DBG_FPD_CTRL__FREQMHZ {250} \
    CONFIG.PSU__CRF_APB__DBG_FPD_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRF_APB__DBG_TRACE_CTRL__ACT_FREQMHZ {250} \
    CONFIG.PSU__CRF_APB__DBG_TRACE_CTRL__DIVISOR0 {5} \
    CONFIG.PSU__CRF_APB__DBG_TRACE_CTRL__FREQMHZ {250} \
    CONFIG.PSU__CRF_APB__DBG_TRACE_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRF_APB__DBG_TSTMP_CTRL__ACT_FREQMHZ {249.999954} \
    CONFIG.PSU__CRF_APB__DBG_TSTMP_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRF_APB__DBG_TSTMP_CTRL__FREQMHZ {250} \
    CONFIG.PSU__CRF_APB__DBG_TSTMP_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRF_APB__DDR_CTRL__ACT_FREQMHZ {599.999878} \
    CONFIG.PSU__CRF_APB__DDR_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRF_APB__DDR_CTRL__FREQMHZ {1200} \
    CONFIG.PSU__CRF_APB__DDR_CTRL__SRCSEL {DPLL} \
    CONFIG.PSU__CRF_APB__DPDMA_REF_CTRL__ACT_FREQMHZ {599.999878} \
    CONFIG.PSU__CRF_APB__DPDMA_REF_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRF_APB__DPDMA_REF_CTRL__FREQMHZ {600} \
    CONFIG.PSU__CRF_APB__DPDMA_REF_CTRL__SRCSEL {DPLL} \
    CONFIG.PSU__CRF_APB__DPLL_CTRL__DIV2 {1} \
    CONFIG.PSU__CRF_APB__DPLL_CTRL__FBDIV {72} \
    CONFIG.PSU__CRF_APB__DPLL_CTRL__FRACFREQ {27.138} \
    CONFIG.PSU__CRF_APB__DPLL_CTRL__SRCSEL {PSS_REF_CLK} \
    CONFIG.PSU__CRF_APB__DPLL_TO_LPD_CTRL__DIVISOR0 {3} \
    CONFIG.PSU__CRF_APB__DP_AUDIO_REF_CTRL__ACT_FREQMHZ {24.999996} \
    CONFIG.PSU__CRF_APB__DP_AUDIO_REF_CTRL__DIVISOR0 {21} \
    CONFIG.PSU__CRF_APB__DP_AUDIO_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRF_APB__DP_AUDIO_REF_CTRL__FREQMHZ {25} \
    CONFIG.PSU__CRF_APB__DP_AUDIO_REF_CTRL__SRCSEL {RPLL} \
    CONFIG.PSU__CRF_APB__DP_AUDIO__FRAC_ENABLED {0} \
    CONFIG.PSU__CRF_APB__DP_STC_REF_CTRL__ACT_FREQMHZ {26.249996} \
    CONFIG.PSU__CRF_APB__DP_STC_REF_CTRL__DIVISOR0 {20} \
    CONFIG.PSU__CRF_APB__DP_STC_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRF_APB__DP_STC_REF_CTRL__FREQMHZ {27} \
    CONFIG.PSU__CRF_APB__DP_STC_REF_CTRL__SRCSEL {RPLL} \
    CONFIG.PSU__CRF_APB__DP_VIDEO_REF_CTRL__ACT_FREQMHZ {299.999939} \
    CONFIG.PSU__CRF_APB__DP_VIDEO_REF_CTRL__DIVISOR0 {4} \
    CONFIG.PSU__CRF_APB__DP_VIDEO_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRF_APB__DP_VIDEO_REF_CTRL__FREQMHZ {300} \
    CONFIG.PSU__CRF_APB__DP_VIDEO_REF_CTRL__SRCSEL {DPLL} \
    CONFIG.PSU__CRF_APB__DP_VIDEO__FRAC_ENABLED {0} \
    CONFIG.PSU__CRF_APB__GDMA_REF_CTRL__ACT_FREQMHZ {599.999878} \
    CONFIG.PSU__CRF_APB__GDMA_REF_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRF_APB__GDMA_REF_CTRL__FREQMHZ {600} \
    CONFIG.PSU__CRF_APB__GDMA_REF_CTRL__SRCSEL {DPLL} \
    CONFIG.PSU__CRF_APB__GPU_REF_CTRL__ACT_FREQMHZ {0} \
    CONFIG.PSU__CRF_APB__GPU_REF_CTRL__DIVISOR0 {3} \
    CONFIG.PSU__CRF_APB__GPU_REF_CTRL__FREQMHZ {500} \
    CONFIG.PSU__CRF_APB__GPU_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRF_APB__GTGREF0_REF_CTRL__ACT_FREQMHZ {-1} \
    CONFIG.PSU__CRF_APB__GTGREF0_REF_CTRL__DIVISOR0 {-1} \
    CONFIG.PSU__CRF_APB__GTGREF0_REF_CTRL__FREQMHZ {-1} \
    CONFIG.PSU__CRF_APB__GTGREF0_REF_CTRL__SRCSEL {NA} \
    CONFIG.PSU__CRF_APB__GTGREF0__ENABLE {NA} \
    CONFIG.PSU__CRF_APB__PCIE_REF_CTRL__ACT_FREQMHZ {250} \
    CONFIG.PSU__CRF_APB__PCIE_REF_CTRL__DIVISOR0 {6} \
    CONFIG.PSU__CRF_APB__SATA_REF_CTRL__ACT_FREQMHZ {249.997498} \
    CONFIG.PSU__CRF_APB__SATA_REF_CTRL__DIVISOR0 {5} \
    CONFIG.PSU__CRF_APB__TOPSW_LSBUS_CTRL__ACT_FREQMHZ {99.999985} \
    CONFIG.PSU__CRF_APB__TOPSW_LSBUS_CTRL__DIVISOR0 {5} \
    CONFIG.PSU__CRF_APB__TOPSW_LSBUS_CTRL__FREQMHZ {100} \
    CONFIG.PSU__CRF_APB__TOPSW_LSBUS_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRF_APB__TOPSW_MAIN_CTRL__ACT_FREQMHZ {399.999908} \
    CONFIG.PSU__CRF_APB__TOPSW_MAIN_CTRL__DIVISOR0 {3} \
    CONFIG.PSU__CRF_APB__TOPSW_MAIN_CTRL__FREQMHZ {533.33} \
    CONFIG.PSU__CRF_APB__TOPSW_MAIN_CTRL__SRCSEL {DPLL} \
    CONFIG.PSU__CRF_APB__VPLL_CTRL__DIV2 {1} \
    CONFIG.PSU__CRF_APB__VPLL_CTRL__FBDIV {90} \
    CONFIG.PSU__CRF_APB__VPLL_CTRL__FRACFREQ {300} \
    CONFIG.PSU__CRF_APB__VPLL_CTRL__SRCSEL {PSS_REF_CLK} \
    CONFIG.PSU__CRF_APB__VPLL_TO_LPD_CTRL__DIVISOR0 {4} \
    CONFIG.PSU__CRL_APB__ADMA_REF_CTRL__ACT_FREQMHZ {524.999939} \
    CONFIG.PSU__CRL_APB__ADMA_REF_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRL_APB__ADMA_REF_CTRL__FREQMHZ {500} \
    CONFIG.PSU__CRL_APB__ADMA_REF_CTRL__SRCSEL {RPLL} \
    CONFIG.PSU__CRL_APB__AFI6_REF_CTRL__ACT_FREQMHZ {500} \
    CONFIG.PSU__CRL_APB__AFI6_REF_CTRL__DIVISOR0 {3} \
    CONFIG.PSU__CRL_APB__AFI6_REF_CTRL__FREQMHZ {500} \
    CONFIG.PSU__CRL_APB__AFI6_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__AFI6__ENABLE {0} \
    CONFIG.PSU__CRL_APB__AMS_REF_CTRL__ACT_FREQMHZ {49.999992} \
    CONFIG.PSU__CRL_APB__AMS_REF_CTRL__DIVISOR0 {30} \
    CONFIG.PSU__CRL_APB__AMS_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__AMS_REF_CTRL__FREQMHZ {50} \
    CONFIG.PSU__CRL_APB__AMS_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__CAN0_REF_CTRL__ACT_FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__CAN0_REF_CTRL__DIVISOR0 {15} \
    CONFIG.PSU__CRL_APB__CAN0_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__CAN0_REF_CTRL__FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__CAN0_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__CAN1_REF_CTRL__ACT_FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__CAN1_REF_CTRL__DIVISOR0 {15} \
    CONFIG.PSU__CRL_APB__CAN1_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__CAN1_REF_CTRL__FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__CAN1_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__CPU_R5_CTRL__ACT_FREQMHZ {499.999908} \
    CONFIG.PSU__CRL_APB__CPU_R5_CTRL__DIVISOR0 {3} \
    CONFIG.PSU__CRL_APB__CPU_R5_CTRL__FREQMHZ {500} \
    CONFIG.PSU__CRL_APB__CPU_R5_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__CSU_PLL_CTRL__ACT_FREQMHZ {180} \
    CONFIG.PSU__CRL_APB__CSU_PLL_CTRL__DIVISOR0 {3} \
    CONFIG.PSU__CRL_APB__CSU_PLL_CTRL__SRCSEL {SysOsc} \
    CONFIG.PSU__CRL_APB__DBG_LPD_CTRL__ACT_FREQMHZ {249.999954} \
    CONFIG.PSU__CRL_APB__DBG_LPD_CTRL__DIVISOR0 {6} \
    CONFIG.PSU__CRL_APB__DBG_LPD_CTRL__FREQMHZ {250} \
    CONFIG.PSU__CRL_APB__DBG_LPD_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__DEBUG_R5_ATCLK_CTRL__ACT_FREQMHZ {1000} \
    CONFIG.PSU__CRL_APB__DEBUG_R5_ATCLK_CTRL__DIVISOR0 {6} \
    CONFIG.PSU__CRL_APB__DEBUG_R5_ATCLK_CTRL__FREQMHZ {1000} \
    CONFIG.PSU__CRL_APB__DEBUG_R5_ATCLK_CTRL__SRCSEL {RPLL} \
    CONFIG.PSU__CRL_APB__DLL_REF_CTRL__ACT_FREQMHZ {1499.999756} \
    CONFIG.PSU__CRL_APB__DLL_REF_CTRL__FREQMHZ {1500} \
    CONFIG.PSU__CRL_APB__DLL_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__GEM0_REF_CTRL__ACT_FREQMHZ {125} \
    CONFIG.PSU__CRL_APB__GEM0_REF_CTRL__DIVISOR0 {12} \
    CONFIG.PSU__CRL_APB__GEM0_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__GEM0_REF_CTRL__FREQMHZ {125} \
    CONFIG.PSU__CRL_APB__GEM0_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__GEM1_REF_CTRL__ACT_FREQMHZ {124.999977} \
    CONFIG.PSU__CRL_APB__GEM1_REF_CTRL__DIVISOR0 {12} \
    CONFIG.PSU__CRL_APB__GEM1_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__GEM1_REF_CTRL__FREQMHZ {125} \
    CONFIG.PSU__CRL_APB__GEM1_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__GEM2_REF_CTRL__ACT_FREQMHZ {125} \
    CONFIG.PSU__CRL_APB__GEM2_REF_CTRL__DIVISOR0 {12} \
    CONFIG.PSU__CRL_APB__GEM2_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__GEM2_REF_CTRL__FREQMHZ {125} \
    CONFIG.PSU__CRL_APB__GEM2_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__GEM3_REF_CTRL__ACT_FREQMHZ {124.998749} \
    CONFIG.PSU__CRL_APB__GEM3_REF_CTRL__DIVISOR0 {12} \
    CONFIG.PSU__CRL_APB__GEM3_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__GEM3_REF_CTRL__FREQMHZ {125} \
    CONFIG.PSU__CRL_APB__GEM3_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__GEM_TSU_REF_CTRL__ACT_FREQMHZ {249.999954} \
    CONFIG.PSU__CRL_APB__GEM_TSU_REF_CTRL__DIVISOR0 {6} \
    CONFIG.PSU__CRL_APB__GEM_TSU_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__GEM_TSU_REF_CTRL__FREQMHZ {250} \
    CONFIG.PSU__CRL_APB__GEM_TSU_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__I2C0_REF_CTRL__ACT_FREQMHZ {99.999985} \
    CONFIG.PSU__CRL_APB__I2C0_REF_CTRL__DIVISOR0 {15} \
    CONFIG.PSU__CRL_APB__I2C0_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__I2C0_REF_CTRL__FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__I2C0_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__I2C1_REF_CTRL__ACT_FREQMHZ {99.999985} \
    CONFIG.PSU__CRL_APB__I2C1_REF_CTRL__DIVISOR0 {15} \
    CONFIG.PSU__CRL_APB__I2C1_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__I2C1_REF_CTRL__FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__I2C1_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__IOPLL_CTRL__DIV2 {1} \
    CONFIG.PSU__CRL_APB__IOPLL_CTRL__FBDIV {90} \
    CONFIG.PSU__CRL_APB__IOPLL_CTRL__FRACFREQ {27.138} \
    CONFIG.PSU__CRL_APB__IOPLL_CTRL__SRCSEL {PSS_REF_CLK} \
    CONFIG.PSU__CRL_APB__IOPLL_TO_FPD_CTRL__DIVISOR0 {3} \
    CONFIG.PSU__CRL_APB__IOU_SWITCH_CTRL__ACT_FREQMHZ {262.499969} \
    CONFIG.PSU__CRL_APB__IOU_SWITCH_CTRL__DIVISOR0 {4} \
    CONFIG.PSU__CRL_APB__IOU_SWITCH_CTRL__FREQMHZ {250} \
    CONFIG.PSU__CRL_APB__IOU_SWITCH_CTRL__SRCSEL {RPLL} \
    CONFIG.PSU__CRL_APB__LPD_LSBUS_CTRL__ACT_FREQMHZ {99.999985} \
    CONFIG.PSU__CRL_APB__LPD_LSBUS_CTRL__DIVISOR0 {15} \
    CONFIG.PSU__CRL_APB__LPD_LSBUS_CTRL__FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__LPD_LSBUS_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__LPD_SWITCH_CTRL__ACT_FREQMHZ {524.999939} \
    CONFIG.PSU__CRL_APB__LPD_SWITCH_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRL_APB__LPD_SWITCH_CTRL__FREQMHZ {500} \
    CONFIG.PSU__CRL_APB__LPD_SWITCH_CTRL__SRCSEL {RPLL} \
    CONFIG.PSU__CRL_APB__NAND_REF_CTRL__ACT_FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__NAND_REF_CTRL__DIVISOR0 {15} \
    CONFIG.PSU__CRL_APB__NAND_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__NAND_REF_CTRL__FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__NAND_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__OCM_MAIN_CTRL__ACT_FREQMHZ {500} \
    CONFIG.PSU__CRL_APB__OCM_MAIN_CTRL__DIVISOR0 {3} \
    CONFIG.PSU__CRL_APB__OCM_MAIN_CTRL__FREQMHZ {500} \
    CONFIG.PSU__CRL_APB__OCM_MAIN_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__PCAP_CTRL__ACT_FREQMHZ {187.499969} \
    CONFIG.PSU__CRL_APB__PCAP_CTRL__DIVISOR0 {8} \
    CONFIG.PSU__CRL_APB__PCAP_CTRL__FREQMHZ {200} \
    CONFIG.PSU__CRL_APB__PCAP_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__PL0_REF_CTRL__ACT_FREQMHZ {99.999985} \
    CONFIG.PSU__CRL_APB__PL0_REF_CTRL__DIVISOR0 {15} \
    CONFIG.PSU__CRL_APB__PL0_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__PL0_REF_CTRL__FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__PL0_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__PL1_REF_CTRL__ACT_FREQMHZ {374.996246} \
    CONFIG.PSU__CRL_APB__PL1_REF_CTRL__DIVISOR0 {4} \
    CONFIG.PSU__CRL_APB__PL1_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__PL2_REF_CTRL__ACT_FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__PL2_REF_CTRL__DIVISOR0 {4} \
    CONFIG.PSU__CRL_APB__PL2_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__PL3_REF_CTRL__ACT_FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__PL3_REF_CTRL__DIVISOR0 {4} \
    CONFIG.PSU__CRL_APB__PL3_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__QSPI_REF_CTRL__ACT_FREQMHZ {124.998749} \
    CONFIG.PSU__CRL_APB__QSPI_REF_CTRL__DIVISOR0 {12} \
    CONFIG.PSU__CRL_APB__QSPI_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__QSPI_REF_CTRL__FREQMHZ {125} \
    CONFIG.PSU__CRL_APB__QSPI_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__RPLL_CTRL__DIV2 {1} \
    CONFIG.PSU__CRL_APB__RPLL_CTRL__FBDIV {63} \
    CONFIG.PSU__CRL_APB__RPLL_CTRL__FRACFREQ {25} \
    CONFIG.PSU__CRL_APB__RPLL_CTRL__SRCSEL {PSS_REF_CLK} \
    CONFIG.PSU__CRL_APB__RPLL_TO_FPD_CTRL__DIVISOR0 {2} \
    CONFIG.PSU__CRL_APB__SDIO0_REF_CTRL__ACT_FREQMHZ {187.499969} \
    CONFIG.PSU__CRL_APB__SDIO0_REF_CTRL__DIVISOR0 {8} \
    CONFIG.PSU__CRL_APB__SDIO0_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__SDIO0_REF_CTRL__FREQMHZ {200} \
    CONFIG.PSU__CRL_APB__SDIO0_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__SDIO1_REF_CTRL__ACT_FREQMHZ {187.498123} \
    CONFIG.PSU__CRL_APB__SDIO1_REF_CTRL__DIVISOR0 {7} \
    CONFIG.PSU__CRL_APB__SDIO1_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__SDIO1_REF_CTRL__FREQMHZ {200} \
    CONFIG.PSU__CRL_APB__SDIO1_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__SPI0_REF_CTRL__ACT_FREQMHZ {187.499969} \
    CONFIG.PSU__CRL_APB__SPI0_REF_CTRL__DIVISOR0 {8} \
    CONFIG.PSU__CRL_APB__SPI0_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__SPI0_REF_CTRL__FREQMHZ {200} \
    CONFIG.PSU__CRL_APB__SPI0_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__SPI1_REF_CTRL__ACT_FREQMHZ {187.499969} \
    CONFIG.PSU__CRL_APB__SPI1_REF_CTRL__DIVISOR0 {8} \
    CONFIG.PSU__CRL_APB__SPI1_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__SPI1_REF_CTRL__FREQMHZ {200} \
    CONFIG.PSU__CRL_APB__SPI1_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__TIMESTAMP_REF_CTRL__ACT_FREQMHZ {33.333328} \
    CONFIG.PSU__CRL_APB__TIMESTAMP_REF_CTRL__FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__TIMESTAMP_REF_CTRL__SRCSEL {PSS_REF_CLK} \
    CONFIG.PSU__CRL_APB__UART0_REF_CTRL__ACT_FREQMHZ {99.999001} \
    CONFIG.PSU__CRL_APB__UART0_REF_CTRL__DIVISOR0 {15} \
    CONFIG.PSU__CRL_APB__UART0_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__UART0_REF_CTRL__FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__UART0_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__UART1_REF_CTRL__ACT_FREQMHZ {99.999985} \
    CONFIG.PSU__CRL_APB__UART1_REF_CTRL__DIVISOR0 {15} \
    CONFIG.PSU__CRL_APB__UART1_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__UART1_REF_CTRL__FREQMHZ {100} \
    CONFIG.PSU__CRL_APB__UART1_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__USB0_BUS_REF_CTRL__ACT_FREQMHZ {249.999954} \
    CONFIG.PSU__CRL_APB__USB0_BUS_REF_CTRL__DIVISOR0 {6} \
    CONFIG.PSU__CRL_APB__USB0_BUS_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__USB0_BUS_REF_CTRL__FREQMHZ {250} \
    CONFIG.PSU__CRL_APB__USB0_BUS_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__USB1_BUS_REF_CTRL__ACT_FREQMHZ {249.999954} \
    CONFIG.PSU__CRL_APB__USB1_BUS_REF_CTRL__DIVISOR0 {6} \
    CONFIG.PSU__CRL_APB__USB1_BUS_REF_CTRL__DIVISOR1 {1} \
    CONFIG.PSU__CRL_APB__USB1_BUS_REF_CTRL__FREQMHZ {250} \
    CONFIG.PSU__CRL_APB__USB1_BUS_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__USB3_DUAL_REF_CTRL__ACT_FREQMHZ {19.999996} \
    CONFIG.PSU__CRL_APB__USB3_DUAL_REF_CTRL__DIVISOR0 {25} \
    CONFIG.PSU__CRL_APB__USB3_DUAL_REF_CTRL__DIVISOR1 {3} \
    CONFIG.PSU__CRL_APB__USB3_DUAL_REF_CTRL__FREQMHZ {20} \
    CONFIG.PSU__CRL_APB__USB3_DUAL_REF_CTRL__SRCSEL {IOPLL} \
    CONFIG.PSU__CRL_APB__USB3__ENABLE {1} \
    CONFIG.PSU__CSUPMU__PERIPHERAL__VALID {0} \
    CONFIG.PSU__CSU__CSU_TAMPER_0__ENABLE {0} \
    CONFIG.PSU__CSU__CSU_TAMPER_10__ENABLE {0} \
    CONFIG.PSU__CSU__CSU_TAMPER_11__ENABLE {0} \
    CONFIG.PSU__CSU__CSU_TAMPER_12__ENABLE {0} \
    CONFIG.PSU__CSU__CSU_TAMPER_1__ENABLE {0} \
    CONFIG.PSU__CSU__CSU_TAMPER_2__ENABLE {0} \
    CONFIG.PSU__CSU__CSU_TAMPER_3__ENABLE {0} \
    CONFIG.PSU__CSU__CSU_TAMPER_4__ENABLE {0} \
    CONFIG.PSU__CSU__CSU_TAMPER_5__ENABLE {0} \
    CONFIG.PSU__CSU__CSU_TAMPER_6__ENABLE {0} \
    CONFIG.PSU__CSU__CSU_TAMPER_7__ENABLE {0} \
    CONFIG.PSU__CSU__CSU_TAMPER_8__ENABLE {0} \
    CONFIG.PSU__CSU__CSU_TAMPER_9__ENABLE {0} \
    CONFIG.PSU__CSU__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__DDRC__AL {0} \
    CONFIG.PSU__DDRC__BG_ADDR_COUNT {1} \
    CONFIG.PSU__DDRC__BRC_MAPPING {ROW_BANK_COL} \
    CONFIG.PSU__DDRC__BUS_WIDTH {64 Bit} \
    CONFIG.PSU__DDRC__CL {16} \
    CONFIG.PSU__DDRC__CLOCK_STOP_EN {0} \
    CONFIG.PSU__DDRC__COMPONENTS {Components} \
    CONFIG.PSU__DDRC__CWL {12} \
    CONFIG.PSU__DDRC__DDR4_ADDR_MAPPING {0} \
    CONFIG.PSU__DDRC__DDR4_CAL_MODE_ENABLE {0} \
    CONFIG.PSU__DDRC__DDR4_CRC_CONTROL {0} \
    CONFIG.PSU__DDRC__DDR4_MAXPWR_SAVING_EN {0} \
    CONFIG.PSU__DDRC__DDR4_T_REF_MODE {0} \
    CONFIG.PSU__DDRC__DDR4_T_REF_RANGE {Normal (0-85)} \
    CONFIG.PSU__DDRC__DEVICE_CAPACITY {8192 MBits} \
    CONFIG.PSU__DDRC__DM_DBI {DM_NO_DBI} \
    CONFIG.PSU__DDRC__DRAM_WIDTH {16 Bits} \
    CONFIG.PSU__DDRC__ECC {Disabled} \
    CONFIG.PSU__DDRC__ECC_SCRUB {0} \
    CONFIG.PSU__DDRC__ENABLE {1} \
    CONFIG.PSU__DDRC__ENABLE_2T_TIMING {0} \
    CONFIG.PSU__DDRC__ENABLE_DP_SWITCH {0} \
    CONFIG.PSU__DDRC__EN_2ND_CLK {0} \
    CONFIG.PSU__DDRC__FGRM {1X} \
    CONFIG.PSU__DDRC__FREQ_MHZ {1} \
    CONFIG.PSU__DDRC__LPDDR3_DUALRANK_SDP {0} \
    CONFIG.PSU__DDRC__LP_ASR {manual normal} \
    CONFIG.PSU__DDRC__MEMORY_TYPE {DDR 4} \
    CONFIG.PSU__DDRC__PARITY_ENABLE {0} \
    CONFIG.PSU__DDRC__PER_BANK_REFRESH {0} \
    CONFIG.PSU__DDRC__PHY_DBI_MODE {0} \
    CONFIG.PSU__DDRC__PLL_BYPASS {0} \
    CONFIG.PSU__DDRC__PWR_DOWN_EN {0} \
    CONFIG.PSU__DDRC__RANK_ADDR_COUNT {0} \
    CONFIG.PSU__DDRC__RD_DQS_CENTER {0} \
    CONFIG.PSU__DDRC__ROW_ADDR_COUNT {16} \
    CONFIG.PSU__DDRC__SELF_REF_ABORT {0} \
    CONFIG.PSU__DDRC__SPEED_BIN {DDR4_2400R} \
    CONFIG.PSU__DDRC__STATIC_RD_MODE {0} \
    CONFIG.PSU__DDRC__TRAIN_DATA_EYE {1} \
    CONFIG.PSU__DDRC__TRAIN_READ_GATE {1} \
    CONFIG.PSU__DDRC__TRAIN_WRITE_LEVEL {1} \
    CONFIG.PSU__DDRC__T_FAW {30.0} \
    CONFIG.PSU__DDRC__T_RAS_MIN {32} \
    CONFIG.PSU__DDRC__T_RC {45.32} \
    CONFIG.PSU__DDRC__T_RCD {16} \
    CONFIG.PSU__DDRC__T_RP {16} \
    CONFIG.PSU__DDRC__VIDEO_BUFFER_SIZE {0} \
    CONFIG.PSU__DDRC__VREF {1} \
    CONFIG.PSU__DDR_HIGH_ADDRESS_GUI_ENABLE {1} \
    CONFIG.PSU__DDR_QOS_ENABLE {0} \
    CONFIG.PSU__DDR_QOS_HP0_RDQOS {} \
    CONFIG.PSU__DDR_QOS_HP0_WRQOS {} \
    CONFIG.PSU__DDR_QOS_HP1_RDQOS {} \
    CONFIG.PSU__DDR_QOS_HP1_WRQOS {} \
    CONFIG.PSU__DDR_QOS_HP2_RDQOS {} \
    CONFIG.PSU__DDR_QOS_HP2_WRQOS {} \
    CONFIG.PSU__DDR_QOS_HP3_RDQOS {} \
    CONFIG.PSU__DDR_QOS_HP3_WRQOS {} \
    CONFIG.PSU__DDR_SW_REFRESH_ENABLED {1} \
    CONFIG.PSU__DDR__INTERFACE__FREQMHZ {600.000} \
    CONFIG.PSU__DEVICE_TYPE {RFSOC} \
    CONFIG.PSU__DISPLAYPORT__LANE0__ENABLE {1} \
    CONFIG.PSU__DISPLAYPORT__LANE0__IO {GT Lane1} \
    CONFIG.PSU__DISPLAYPORT__LANE1__ENABLE {1} \
    CONFIG.PSU__DISPLAYPORT__LANE1__IO {GT Lane0} \
    CONFIG.PSU__DISPLAYPORT__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__DLL__ISUSED {1} \
    CONFIG.PSU__DPAUX__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__DPAUX__PERIPHERAL__IO {MIO 27 .. 30} \
    CONFIG.PSU__DP__LANE_SEL {Dual Lower} \
    CONFIG.PSU__DP__REF_CLK_FREQ {27} \
    CONFIG.PSU__DP__REF_CLK_SEL {Ref Clk0} \
    CONFIG.PSU__ENABLE__DDR__REFRESH__SIGNALS {0} \
    CONFIG.PSU__ENET0__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__ENET1__FIFO__ENABLE {0} \
    CONFIG.PSU__ENET1__GRP_MDIO__ENABLE {1} \
    CONFIG.PSU__ENET1__GRP_MDIO__IO {MIO 50 .. 51} \
    CONFIG.PSU__ENET1__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__ENET1__PERIPHERAL__IO {MIO 38 .. 49} \
    CONFIG.PSU__ENET1__PTP__ENABLE {0} \
    CONFIG.PSU__ENET1__TSU__ENABLE {0} \
    CONFIG.PSU__ENET2__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__ENET3__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__EN_AXI_STATUS_PORTS {0} \
    CONFIG.PSU__EN_EMIO_TRACE {0} \
    CONFIG.PSU__EP__IP {0} \
    CONFIG.PSU__EXPAND__CORESIGHT {0} \
    CONFIG.PSU__EXPAND__FPD_SLAVES {0} \
    CONFIG.PSU__EXPAND__GIC {0} \
    CONFIG.PSU__EXPAND__LOWER_LPS_SLAVES {0} \
    CONFIG.PSU__EXPAND__UPPER_LPS_SLAVES {0} \
    CONFIG.PSU__FPD_SLCR__WDT1__ACT_FREQMHZ {99.999001} \
    CONFIG.PSU__FPGA_PL0_ENABLE {1} \
    CONFIG.PSU__FPGA_PL1_ENABLE {0} \
    CONFIG.PSU__FPGA_PL2_ENABLE {0} \
    CONFIG.PSU__FPGA_PL3_ENABLE {0} \
    CONFIG.PSU__FP__POWER__ON {1} \
    CONFIG.PSU__FTM__CTI_IN_0 {0} \
    CONFIG.PSU__FTM__CTI_IN_1 {0} \
    CONFIG.PSU__FTM__CTI_IN_2 {0} \
    CONFIG.PSU__FTM__CTI_IN_3 {0} \
    CONFIG.PSU__FTM__CTI_OUT_0 {0} \
    CONFIG.PSU__FTM__CTI_OUT_1 {0} \
    CONFIG.PSU__FTM__CTI_OUT_2 {0} \
    CONFIG.PSU__FTM__CTI_OUT_3 {0} \
    CONFIG.PSU__FTM__GPI {0} \
    CONFIG.PSU__FTM__GPO {0} \
    CONFIG.PSU__GEM1_COHERENCY {0} \
    CONFIG.PSU__GEM1_ROUTE_THROUGH_FPD {0} \
    CONFIG.PSU__GEM__TSU__ENABLE {0} \
    CONFIG.PSU__GEN_IPI_0__MASTER {APU} \
    CONFIG.PSU__GEN_IPI_10__MASTER {NONE} \
    CONFIG.PSU__GEN_IPI_1__MASTER {RPU0} \
    CONFIG.PSU__GEN_IPI_2__MASTER {RPU1} \
    CONFIG.PSU__GEN_IPI_3__MASTER {PMU} \
    CONFIG.PSU__GEN_IPI_4__MASTER {PMU} \
    CONFIG.PSU__GEN_IPI_5__MASTER {PMU} \
    CONFIG.PSU__GEN_IPI_6__MASTER {PMU} \
    CONFIG.PSU__GEN_IPI_7__MASTER {NONE} \
    CONFIG.PSU__GEN_IPI_8__MASTER {NONE} \
    CONFIG.PSU__GEN_IPI_9__MASTER {NONE} \
    CONFIG.PSU__GPIO0_MIO__IO {MIO 0 .. 25} \
    CONFIG.PSU__GPIO0_MIO__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__GPIO1_MIO__IO {MIO 26 .. 51} \
    CONFIG.PSU__GPIO1_MIO__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__GPIO2_MIO__IO {MIO 52 .. 77} \
    CONFIG.PSU__GPIO2_MIO__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__GPIO_EMIO_WIDTH {41} \
    CONFIG.PSU__GPIO_EMIO__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__GPIO_EMIO__PERIPHERAL__IO {41} \
    CONFIG.PSU__GPIO_EMIO__WIDTH {[94:0]} \
    CONFIG.PSU__GPU_PP0__POWER__ON {0} \
    CONFIG.PSU__GPU_PP1__POWER__ON {0} \
    CONFIG.PSU__GT_REF_CLK__FREQMHZ {33.333} \
    CONFIG.PSU__GT__LINK_SPEED {HBR} \
    CONFIG.PSU__GT__PRE_EMPH_LVL_4 {0} \
    CONFIG.PSU__GT__VLT_SWNG_LVL_4 {0} \
    CONFIG.PSU__HPM0_FPD__NUM_READ_THREADS {4} \
    CONFIG.PSU__HPM0_FPD__NUM_WRITE_THREADS {4} \
    CONFIG.PSU__HPM0_LPD__NUM_READ_THREADS {4} \
    CONFIG.PSU__HPM0_LPD__NUM_WRITE_THREADS {4} \
    CONFIG.PSU__HPM1_FPD__NUM_READ_THREADS {4} \
    CONFIG.PSU__HPM1_FPD__NUM_WRITE_THREADS {4} \
    CONFIG.PSU__I2C0_LOOP_I2C1__ENABLE {0} \
    CONFIG.PSU__I2C0__GRP_INT__ENABLE {0} \
    CONFIG.PSU__I2C0__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__I2C0__PERIPHERAL__IO {MIO 18 .. 19} \
    CONFIG.PSU__I2C1__GRP_INT__ENABLE {0} \
    CONFIG.PSU__I2C1__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__I2C1__PERIPHERAL__IO {MIO 36 .. 37} \
    CONFIG.PSU__IOU_SLCR__IOU_TTC_APB_CLK__TTC0_SEL {APB} \
    CONFIG.PSU__IOU_SLCR__IOU_TTC_APB_CLK__TTC1_SEL {APB} \
    CONFIG.PSU__IOU_SLCR__IOU_TTC_APB_CLK__TTC2_SEL {APB} \
    CONFIG.PSU__IOU_SLCR__IOU_TTC_APB_CLK__TTC3_SEL {APB} \
    CONFIG.PSU__IOU_SLCR__TTC0__ACT_FREQMHZ {100} \
    CONFIG.PSU__IOU_SLCR__TTC1__ACT_FREQMHZ {100} \
    CONFIG.PSU__IOU_SLCR__TTC2__ACT_FREQMHZ {100} \
    CONFIG.PSU__IOU_SLCR__TTC3__ACT_FREQMHZ {100} \
    CONFIG.PSU__IOU_SLCR__WDT0__ACT_FREQMHZ {99.999001} \
    CONFIG.PSU__IRQ_P2F_ADMA_CHAN__INT {0} \
    CONFIG.PSU__IRQ_P2F_AIB_AXI__INT {0} \
    CONFIG.PSU__IRQ_P2F_AMS__INT {0} \
    CONFIG.PSU__IRQ_P2F_APM_FPD__INT {0} \
    CONFIG.PSU__IRQ_P2F_APU_COMM__INT {0} \
    CONFIG.PSU__IRQ_P2F_APU_CPUMNT__INT {0} \
    CONFIG.PSU__IRQ_P2F_APU_CTI__INT {0} \
    CONFIG.PSU__IRQ_P2F_APU_EXTERR__INT {0} \
    CONFIG.PSU__IRQ_P2F_APU_IPI__INT {0} \
    CONFIG.PSU__IRQ_P2F_APU_L2ERR__INT {0} \
    CONFIG.PSU__IRQ_P2F_APU_PMU__INT {0} \
    CONFIG.PSU__IRQ_P2F_APU_REGS__INT {0} \
    CONFIG.PSU__IRQ_P2F_ATB_LPD__INT {0} \
    CONFIG.PSU__IRQ_P2F_CLKMON__INT {0} \
    CONFIG.PSU__IRQ_P2F_DPDMA__INT {0} \
    CONFIG.PSU__IRQ_P2F_DPORT__INT {0} \
    CONFIG.PSU__IRQ_P2F_EFUSE__INT {0} \
    CONFIG.PSU__IRQ_P2F_ENT1_WAKEUP__INT {0} \
    CONFIG.PSU__IRQ_P2F_ENT1__INT {0} \
    CONFIG.PSU__IRQ_P2F_FPD_APB__INT {0} \
    CONFIG.PSU__IRQ_P2F_FPD_ATB_ERR__INT {0} \
    CONFIG.PSU__IRQ_P2F_FP_WDT__INT {0} \
    CONFIG.PSU__IRQ_P2F_GDMA_CHAN__INT {0} \
    CONFIG.PSU__IRQ_P2F_GPIO__INT {0} \
    CONFIG.PSU__IRQ_P2F_GPU__INT {0} \
    CONFIG.PSU__IRQ_P2F_I2C0__INT {0} \
    CONFIG.PSU__IRQ_P2F_I2C1__INT {0} \
    CONFIG.PSU__IRQ_P2F_LPD_APB__INT {0} \
    CONFIG.PSU__IRQ_P2F_LPD_APM__INT {0} \
    CONFIG.PSU__IRQ_P2F_LP_WDT__INT {0} \
    CONFIG.PSU__IRQ_P2F_OCM_ERR__INT {0} \
    CONFIG.PSU__IRQ_P2F_PCIE_DMA__INT {0} \
    CONFIG.PSU__IRQ_P2F_PCIE_LEGACY__INT {0} \
    CONFIG.PSU__IRQ_P2F_PCIE_MSC__INT {0} \
    CONFIG.PSU__IRQ_P2F_PCIE_MSI__INT {0} \
    CONFIG.PSU__IRQ_P2F_PL_IPI__INT {0} \
    CONFIG.PSU__IRQ_P2F_R5_CORE0_ECC_ERR__INT {0} \
    CONFIG.PSU__IRQ_P2F_R5_CORE1_ECC_ERR__INT {0} \
    CONFIG.PSU__IRQ_P2F_RPU_IPI__INT {0} \
    CONFIG.PSU__IRQ_P2F_RPU_PERMON__INT {0} \
    CONFIG.PSU__IRQ_P2F_RTC_ALARM__INT {0} \
    CONFIG.PSU__IRQ_P2F_RTC_SECONDS__INT {0} \
    CONFIG.PSU__IRQ_P2F_SATA__INT {0} \
    CONFIG.PSU__IRQ_P2F_SDIO0_WAKE__INT {0} \
    CONFIG.PSU__IRQ_P2F_SDIO0__INT {0} \
    CONFIG.PSU__IRQ_P2F_UART1__INT {0} \
    CONFIG.PSU__IRQ_P2F_USB3_ENDPOINT__INT0 {0} \
    CONFIG.PSU__IRQ_P2F_USB3_ENDPOINT__INT1 {0} \
    CONFIG.PSU__IRQ_P2F_USB3_OTG__INT0 {0} \
    CONFIG.PSU__IRQ_P2F_USB3_OTG__INT1 {0} \
    CONFIG.PSU__IRQ_P2F_USB3_PMU_WAKEUP__INT {0} \
    CONFIG.PSU__IRQ_P2F_XMPU_FPD__INT {0} \
    CONFIG.PSU__IRQ_P2F_XMPU_LPD__INT {0} \
    CONFIG.PSU__IRQ_P2F__INTF_FPD_SMMU__INT {0} \
    CONFIG.PSU__IRQ_P2F__INTF_PPD_CCI__INT {0} \
    CONFIG.PSU__L2_BANK0__POWER__ON {1} \
    CONFIG.PSU__LPDMA0_COHERENCY {0} \
    CONFIG.PSU__LPDMA1_COHERENCY {0} \
    CONFIG.PSU__LPDMA2_COHERENCY {0} \
    CONFIG.PSU__LPDMA3_COHERENCY {0} \
    CONFIG.PSU__LPDMA4_COHERENCY {0} \
    CONFIG.PSU__LPDMA5_COHERENCY {0} \
    CONFIG.PSU__LPDMA6_COHERENCY {0} \
    CONFIG.PSU__LPDMA7_COHERENCY {0} \
    CONFIG.PSU__LPD_SLCR__CSUPMU_WDT_CLK_SEL__SELECT {APB} \
    CONFIG.PSU__LPD_SLCR__CSUPMU__ACT_FREQMHZ {100} \
    CONFIG.PSU__LPD_SLCR__CSUPMU__FREQMHZ {100} \
    CONFIG.PSU__MAXIGP0__DATA_WIDTH {32} \
    CONFIG.PSU__MAXIGP1__DATA_WIDTH {128} \
    CONFIG.PSU__M_AXI_GP0_SUPPORTS_NARROW_BURST {1} \
    CONFIG.PSU__M_AXI_GP1_SUPPORTS_NARROW_BURST {1} \
    CONFIG.PSU__M_AXI_GP2_SUPPORTS_NARROW_BURST {1} \
    CONFIG.PSU__NAND__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__NAND__READY_BUSY__ENABLE {0} \
    CONFIG.PSU__NUM_FABRIC_RESETS {1} \
    CONFIG.PSU__OCM_BANK0__POWER__ON {1} \
    CONFIG.PSU__OCM_BANK1__POWER__ON {1} \
    CONFIG.PSU__OCM_BANK2__POWER__ON {1} \
    CONFIG.PSU__OCM_BANK3__POWER__ON {1} \
    CONFIG.PSU__OVERRIDE_HPX_QOS {0} \
    CONFIG.PSU__OVERRIDE__BASIC_CLOCK {1} \
    CONFIG.PSU__PCIE__ACS_VIOLAION {0} \
    CONFIG.PSU__PCIE__AER_CAPABILITY {0} \
    CONFIG.PSU__PCIE__CLASS_CODE_BASE {} \
    CONFIG.PSU__PCIE__CLASS_CODE_INTERFACE {} \
    CONFIG.PSU__PCIE__CLASS_CODE_SUB {} \
    CONFIG.PSU__PCIE__DEVICE_ID {} \
    CONFIG.PSU__PCIE__INTX_GENERATION {0} \
    CONFIG.PSU__PCIE__MSIX_CAPABILITY {0} \
    CONFIG.PSU__PCIE__MSI_CAPABILITY {0} \
    CONFIG.PSU__PCIE__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__PCIE__PERIPHERAL__ENDPOINT_ENABLE {1} \
    CONFIG.PSU__PCIE__PERIPHERAL__ROOTPORT_ENABLE {0} \
    CONFIG.PSU__PCIE__RESET__POLARITY {Active Low} \
    CONFIG.PSU__PCIE__REVISION_ID {} \
    CONFIG.PSU__PCIE__SUBSYSTEM_ID {} \
    CONFIG.PSU__PCIE__SUBSYSTEM_VENDOR_ID {} \
    CONFIG.PSU__PCIE__VENDOR_ID {} \
    CONFIG.PSU__PJTAG__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__PL_CLK0_BUF {TRUE} \
    CONFIG.PSU__PL__POWER__ON {1} \
    CONFIG.PSU__PMU__GPO2__POLARITY {low} \
    CONFIG.PSU__PMU__GPO3__POLARITY {low} \
    CONFIG.PSU__PMU__GPO4__POLARITY {low} \
    CONFIG.PSU__PMU__GPO5__POLARITY {low} \
    CONFIG.PSU__PMU__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__PRESET_APPLIED {1} \
    CONFIG.PSU__PROTECTION__DDR_SEGMENTS {NONE} \
    CONFIG.PSU__PROTECTION__ENABLE {0} \
    CONFIG.PSU__PROTECTION__FPD_SEGMENTS {SA:0xFD1A0000 ;SIZE:1280;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU Firmware      |      SA:0xFD000000 ;SIZE:64;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU\
Firmware      |      SA:0xFD010000 ;SIZE:64;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU Firmware      |      SA:0xFD020000 ;SIZE:64;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU\
Firmware      |      SA:0xFD030000 ;SIZE:64;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU Firmware      |      SA:0xFD040000 ;SIZE:64;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU\
Firmware      |      SA:0xFD050000 ;SIZE:64;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU Firmware      |      SA:0xFD610000 ;SIZE:512;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU\
Firmware      |      SA:0xFD5D0000 ;SIZE:64;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU Firmware} \
    CONFIG.PSU__PROTECTION__LPD_SEGMENTS {SA:0xFF980000 ;SIZE:64;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU Firmware|SA:0xFF5E0000 ;SIZE:2560;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU\
Firmware|SA:0xFFCC0000 ;SIZE:64;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU Firmware|SA:0xFF180000 ;SIZE:768;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU Firmware|SA:0xFF410000\
;SIZE:640;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU Firmware|SA:0xFFA70000 ;SIZE:64;UNIT:KB ;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU Firmware|SA:0xFF9A0000 ;SIZE:64;UNIT:KB\
;RegionTZ:Secure ;WrAllowed:Read/Write;subsystemId:PMU Firmware} \
    CONFIG.PSU__PROTECTION__MASTERS {USB1:NonSecure;1|USB0:NonSecure;1|S_AXI_LPD:NA;0|S_AXI_HPC1_FPD:NA;0|S_AXI_HPC0_FPD:NA;0|S_AXI_HP3_FPD:NA;0|S_AXI_HP2_FPD:NA;0|S_AXI_HP1_FPD:NA;0|S_AXI_HP0_FPD:NA;0|S_AXI_ACP:NA;0|S_AXI_ACE:NA;0|SD1:NonSecure;0|SD0:NonSecure;1|SATA1:NonSecure;0|SATA0:NonSecure;0|RPU1:Secure;1|RPU0:Secure;1|QSPI:NonSecure;0|PMU:NA;1|PCIe:NonSecure;0|NAND:NonSecure;0|LDMA:NonSecure;1|GPU:NonSecure;1|GEM3:NonSecure;0|GEM2:NonSecure;0|GEM1:NonSecure;1|GEM0:NonSecure;0|FDMA:NonSecure;1|DP:NonSecure;1|DAP:NA;1|Coresight:NA;1|CSU:NA;1|APU:NA;1}\
\
    CONFIG.PSU__PROTECTION__MASTERS_TZ {GEM0:NonSecure|SD1:NonSecure|GEM2:NonSecure|GEM1:NonSecure|GEM3:NonSecure|PCIe:NonSecure|DP:NonSecure|NAND:NonSecure|GPU:NonSecure|USB1:NonSecure|USB0:NonSecure|LDMA:NonSecure|FDMA:NonSecure|QSPI:NonSecure|SD0:NonSecure}\
\
    CONFIG.PSU__PROTECTION__OCM_SEGMENTS {NONE} \
    CONFIG.PSU__PROTECTION__PRESUBSYSTEMS {NONE} \
    CONFIG.PSU__PROTECTION__SLAVES {LPD;USB3_1_XHCI;FE300000;FE3FFFFF;1|LPD;USB3_1;FF9E0000;FF9EFFFF;1|LPD;USB3_0_XHCI;FE200000;FE2FFFFF;1|LPD;USB3_0;FF9D0000;FF9DFFFF;1|LPD;UART1;FF010000;FF01FFFF;1|LPD;UART0;FF000000;FF00FFFF;0|LPD;TTC3;FF140000;FF14FFFF;0|LPD;TTC2;FF130000;FF13FFFF;0|LPD;TTC1;FF120000;FF12FFFF;0|LPD;TTC0;FF110000;FF11FFFF;0|FPD;SWDT1;FD4D0000;FD4DFFFF;0|LPD;SWDT0;FF150000;FF15FFFF;0|LPD;SPI1;FF050000;FF05FFFF;1|LPD;SPI0;FF040000;FF04FFFF;1|FPD;SMMU_REG;FD5F0000;FD5FFFFF;1|FPD;SMMU;FD800000;FDFFFFFF;1|FPD;SIOU;FD3D0000;FD3DFFFF;1|FPD;SERDES;FD400000;FD47FFFF;1|LPD;SD1;FF170000;FF17FFFF;0|LPD;SD0;FF160000;FF16FFFF;1|FPD;SATA;FD0C0000;FD0CFFFF;0|LPD;RTC;FFA60000;FFA6FFFF;1|LPD;RSA_CORE;FFCE0000;FFCEFFFF;1|LPD;RPU;FF9A0000;FF9AFFFF;1|LPD;R5_TCM_RAM_GLOBAL;FFE00000;FFE3FFFF;1|LPD;R5_1_Instruction_Cache;FFEC0000;FFECFFFF;1|LPD;R5_1_Data_Cache;FFED0000;FFEDFFFF;1|LPD;R5_1_BTCM_GLOBAL;FFEB0000;FFEBFFFF;1|LPD;R5_1_ATCM_GLOBAL;FFE90000;FFE9FFFF;1|LPD;R5_0_Instruction_Cache;FFE40000;FFE4FFFF;1|LPD;R5_0_Data_Cache;FFE50000;FFE5FFFF;1|LPD;R5_0_BTCM_GLOBAL;FFE20000;FFE2FFFF;1|LPD;R5_0_ATCM_GLOBAL;FFE00000;FFE0FFFF;1|LPD;QSPI_Linear_Address;C0000000;DFFFFFFF;1|LPD;QSPI;FF0F0000;FF0FFFFF;0|LPD;PMU_RAM;FFDC0000;FFDDFFFF;1|LPD;PMU_GLOBAL;FFD80000;FFDBFFFF;1|FPD;PCIE_MAIN;FD0E0000;FD0EFFFF;0|FPD;PCIE_LOW;E0000000;EFFFFFFF;0|FPD;PCIE_HIGH2;8000000000;BFFFFFFFFF;0|FPD;PCIE_HIGH1;600000000;7FFFFFFFF;0|FPD;PCIE_DMA;FD0F0000;FD0FFFFF;0|FPD;PCIE_ATTRIB;FD480000;FD48FFFF;0|LPD;OCM_XMPU_CFG;FFA70000;FFA7FFFF;1|LPD;OCM_SLCR;FF960000;FF96FFFF;1|OCM;OCM;FFFC0000;FFFFFFFF;1|LPD;NAND;FF100000;FF10FFFF;0|LPD;MBISTJTAG;FFCF0000;FFCFFFFF;1|LPD;LPD_XPPU_SINK;FF9C0000;FF9CFFFF;1|LPD;LPD_XPPU;FF980000;FF98FFFF;1|LPD;LPD_SLCR_SECURE;FF4B0000;FF4DFFFF;1|LPD;LPD_SLCR;FF410000;FF4AFFFF;1|LPD;LPD_GPV;FE100000;FE1FFFFF;1|LPD;LPD_DMA_7;FFAF0000;FFAFFFFF;1|LPD;LPD_DMA_6;FFAE0000;FFAEFFFF;1|LPD;LPD_DMA_5;FFAD0000;FFADFFFF;1|LPD;LPD_DMA_4;FFAC0000;FFACFFFF;1|LPD;LPD_DMA_3;FFAB0000;FFABFFFF;1|LPD;LPD_DMA_2;FFAA0000;FFAAFFFF;1|LPD;LPD_DMA_1;FFA90000;FFA9FFFF;1|LPD;LPD_DMA_0;FFA80000;FFA8FFFF;1|LPD;IPI_CTRL;FF380000;FF3FFFFF;1|LPD;IOU_SLCR;FF180000;FF23FFFF;1|LPD;IOU_SECURE_SLCR;FF240000;FF24FFFF;1|LPD;IOU_SCNTRS;FF260000;FF26FFFF;1|LPD;IOU_SCNTR;FF250000;FF25FFFF;1|LPD;IOU_GPV;FE000000;FE0FFFFF;1|LPD;I2C1;FF030000;FF03FFFF;1|LPD;I2C0;FF020000;FF02FFFF;1|FPD;GPU;FD4B0000;FD4BFFFF;0|LPD;GPIO;FF0A0000;FF0AFFFF;1|LPD;GEM3;FF0E0000;FF0EFFFF;0|LPD;GEM2;FF0D0000;FF0DFFFF;0|LPD;GEM1;FF0C0000;FF0CFFFF;1|LPD;GEM0;FF0B0000;FF0BFFFF;0|FPD;FPD_XMPU_SINK;FD4F0000;FD4FFFFF;1|FPD;FPD_XMPU_CFG;FD5D0000;FD5DFFFF;1|FPD;FPD_SLCR_SECURE;FD690000;FD6CFFFF;1|FPD;FPD_SLCR;FD610000;FD68FFFF;1|FPD;FPD_DMA_CH7;FD570000;FD57FFFF;1|FPD;FPD_DMA_CH6;FD560000;FD56FFFF;1|FPD;FPD_DMA_CH5;FD550000;FD55FFFF;1|FPD;FPD_DMA_CH4;FD540000;FD54FFFF;1|FPD;FPD_DMA_CH3;FD530000;FD53FFFF;1|FPD;FPD_DMA_CH2;FD520000;FD52FFFF;1|FPD;FPD_DMA_CH1;FD510000;FD51FFFF;1|FPD;FPD_DMA_CH0;FD500000;FD50FFFF;1|LPD;EFUSE;FFCC0000;FFCCFFFF;1|FPD;Display\
Port;FD4A0000;FD4AFFFF;1|FPD;DPDMA;FD4C0000;FD4CFFFF;1|FPD;DDR_XMPU5_CFG;FD050000;FD05FFFF;1|FPD;DDR_XMPU4_CFG;FD040000;FD04FFFF;1|FPD;DDR_XMPU3_CFG;FD030000;FD03FFFF;1|FPD;DDR_XMPU2_CFG;FD020000;FD02FFFF;1|FPD;DDR_XMPU1_CFG;FD010000;FD01FFFF;1|FPD;DDR_XMPU0_CFG;FD000000;FD00FFFF;1|FPD;DDR_QOS_CTRL;FD090000;FD09FFFF;1|FPD;DDR_PHY;FD080000;FD08FFFF;1|DDR;DDR_LOW;0;7FFFFFFF;1|DDR;DDR_HIGH;800000000;87FFFFFFF;1|FPD;DDDR_CTRL;FD070000;FD070FFF;1|LPD;Coresight;FE800000;FEFFFFFF;1|LPD;CSU_DMA;FFC80000;FFC9FFFF;1|LPD;CSU;FFCA0000;FFCAFFFF;1|LPD;CRL_APB;FF5E0000;FF85FFFF;1|FPD;CRF_APB;FD1A0000;FD2DFFFF;1|FPD;CCI_REG;FD5E0000;FD5EFFFF;1|LPD;CAN1;FF070000;FF07FFFF;0|LPD;CAN0;FF060000;FF06FFFF;0|FPD;APU;FD5C0000;FD5CFFFF;1|LPD;APM_INTC_IOU;FFA20000;FFA2FFFF;1|LPD;APM_FPD_LPD;FFA30000;FFA3FFFF;1|FPD;APM_5;FD490000;FD49FFFF;1|FPD;APM_0;FD0B0000;FD0BFFFF;1|LPD;APM2;FFA10000;FFA1FFFF;1|LPD;APM1;FFA00000;FFA0FFFF;1|LPD;AMS;FFA50000;FFA5FFFF;1|FPD;AFI_5;FD3B0000;FD3BFFFF;1|FPD;AFI_4;FD3A0000;FD3AFFFF;1|FPD;AFI_3;FD390000;FD39FFFF;1|FPD;AFI_2;FD380000;FD38FFFF;1|FPD;AFI_1;FD370000;FD37FFFF;1|FPD;AFI_0;FD360000;FD36FFFF;1|LPD;AFIFM6;FF9B0000;FF9BFFFF;1|FPD;ACPU_GIC;F9010000;F907FFFF;1}\
\
    CONFIG.PSU__PROTECTION__SUBSYSTEMS {PMU Firmware:PMU} \
    CONFIG.PSU__PSS_ALT_REF_CLK__ENABLE {0} \
    CONFIG.PSU__PSS_ALT_REF_CLK__FREQMHZ {33.333} \
    CONFIG.PSU__PSS_REF_CLK__FREQMHZ {33.33333} \
    CONFIG.PSU__QSPI__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__REPORT__DBGLOG {0} \
    CONFIG.PSU__RPU_COHERENCY {0} \
    CONFIG.PSU__RPU__POWER__ON {1} \
    CONFIG.PSU__SATA__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__SD0_COHERENCY {0} \
    CONFIG.PSU__SD0_ROUTE_THROUGH_FPD {0} \
    CONFIG.PSU__SD0__CLK_50_SDR_ITAP_DLY {0x15} \
    CONFIG.PSU__SD0__CLK_50_SDR_OTAP_DLY {0x5} \
    CONFIG.PSU__SD0__DATA_TRANSFER_MODE {4Bit} \
    CONFIG.PSU__SD0__GRP_CD__ENABLE {1} \
    CONFIG.PSU__SD0__GRP_CD__IO {MIO 24} \
    CONFIG.PSU__SD0__GRP_POW__ENABLE {0} \
    CONFIG.PSU__SD0__GRP_WP__ENABLE {1} \
    CONFIG.PSU__SD0__GRP_WP__IO {MIO 25} \
    CONFIG.PSU__SD0__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__SD0__PERIPHERAL__IO {MIO 13 .. 16 21 22} \
    CONFIG.PSU__SD0__SLOT_TYPE {SD 2.0} \
    CONFIG.PSU__SD1__CLK_100_SDR_OTAP_DLY {0x3} \
    CONFIG.PSU__SD1__CLK_200_SDR_OTAP_DLY {0x3} \
    CONFIG.PSU__SD1__CLK_50_DDR_ITAP_DLY {0x3D} \
    CONFIG.PSU__SD1__CLK_50_DDR_OTAP_DLY {0x4} \
    CONFIG.PSU__SD1__CLK_50_SDR_ITAP_DLY {0x15} \
    CONFIG.PSU__SD1__CLK_50_SDR_OTAP_DLY {0x5} \
    CONFIG.PSU__SD1__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__SD1__RESET__ENABLE {0} \
    CONFIG.PSU__SPI0_LOOP_SPI1__ENABLE {0} \
    CONFIG.PSU__SPI0__GRP_SS0__IO {MIO 3} \
    CONFIG.PSU__SPI0__GRP_SS1__ENABLE {1} \
    CONFIG.PSU__SPI0__GRP_SS1__IO {MIO 2} \
    CONFIG.PSU__SPI0__GRP_SS2__ENABLE {1} \
    CONFIG.PSU__SPI0__GRP_SS2__IO {MIO 1} \
    CONFIG.PSU__SPI0__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__SPI0__PERIPHERAL__IO {MIO 0 .. 5} \
    CONFIG.PSU__SPI1__GRP_SS0__IO {MIO 9} \
    CONFIG.PSU__SPI1__GRP_SS1__ENABLE {0} \
    CONFIG.PSU__SPI1__GRP_SS2__ENABLE {0} \
    CONFIG.PSU__SPI1__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__SPI1__PERIPHERAL__IO {MIO 6 .. 11} \
    CONFIG.PSU__SWDT0__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__SWDT0__PERIPHERAL__IO {NA} \
    CONFIG.PSU__SWDT1__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__SWDT1__PERIPHERAL__IO {NA} \
    CONFIG.PSU__TCM0A__POWER__ON {1} \
    CONFIG.PSU__TCM0B__POWER__ON {1} \
    CONFIG.PSU__TCM1A__POWER__ON {1} \
    CONFIG.PSU__TCM1B__POWER__ON {1} \
    CONFIG.PSU__TESTSCAN__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__TRACE__INTERNAL_WIDTH {32} \
    CONFIG.PSU__TRACE__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__TRISTATE__INVERTED {1} \
    CONFIG.PSU__TSU__BUFG_PORT_PAIR {0} \
    CONFIG.PSU__TTC0__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__TTC0__PERIPHERAL__IO {NA} \
    CONFIG.PSU__TTC1__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__TTC1__PERIPHERAL__IO {NA} \
    CONFIG.PSU__TTC2__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__TTC2__PERIPHERAL__IO {NA} \
    CONFIG.PSU__TTC3__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__TTC3__PERIPHERAL__IO {NA} \
    CONFIG.PSU__UART0_LOOP_UART1__ENABLE {0} \
    CONFIG.PSU__UART0__PERIPHERAL__ENABLE {0} \
    CONFIG.PSU__UART1__BAUD_RATE {115200} \
    CONFIG.PSU__UART1__MODEM__ENABLE {0} \
    CONFIG.PSU__UART1__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__UART1__PERIPHERAL__IO {MIO 32 .. 33} \
    CONFIG.PSU__USB0_COHERENCY {0} \
    CONFIG.PSU__USB0__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__USB0__PERIPHERAL__IO {MIO 52 .. 63} \
    CONFIG.PSU__USB0__REF_CLK_FREQ {100} \
    CONFIG.PSU__USB0__REF_CLK_SEL {Ref Clk1} \
    CONFIG.PSU__USB1_COHERENCY {0} \
    CONFIG.PSU__USB1__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__USB1__PERIPHERAL__IO {MIO 64 .. 75} \
    CONFIG.PSU__USB1__REF_CLK_FREQ {100} \
    CONFIG.PSU__USB1__REF_CLK_SEL {Ref Clk1} \
    CONFIG.PSU__USB2_0__EMIO__ENABLE {0} \
    CONFIG.PSU__USB2_1__EMIO__ENABLE {0} \
    CONFIG.PSU__USB3_0__EMIO__ENABLE {0} \
    CONFIG.PSU__USB3_0__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__USB3_0__PERIPHERAL__IO {GT Lane2} \
    CONFIG.PSU__USB3_1__EMIO__ENABLE {0} \
    CONFIG.PSU__USB3_1__PERIPHERAL__ENABLE {1} \
    CONFIG.PSU__USB3_1__PERIPHERAL__IO {GT Lane3} \
    CONFIG.PSU__USB__RESET__MODE {Boot Pin} \
    CONFIG.PSU__USB__RESET__POLARITY {Active Low} \
    CONFIG.PSU__USE__ADMA {0} \
    CONFIG.PSU__USE__APU_LEGACY_INTERRUPT {0} \
    CONFIG.PSU__USE__AUDIO {0} \
    CONFIG.PSU__USE__CLK {0} \
    CONFIG.PSU__USE__CLK0 {0} \
    CONFIG.PSU__USE__CLK1 {0} \
    CONFIG.PSU__USE__CLK2 {0} \
    CONFIG.PSU__USE__CLK3 {0} \
    CONFIG.PSU__USE__CROSS_TRIGGER {0} \
    CONFIG.PSU__USE__DDR_INTF_REQUESTED {0} \
    CONFIG.PSU__USE__DEBUG__TEST {0} \
    CONFIG.PSU__USE__EVENT_RPU {0} \
    CONFIG.PSU__USE__FABRIC__RST {1} \
    CONFIG.PSU__USE__FTM {0} \
    CONFIG.PSU__USE__GDMA {0} \
    CONFIG.PSU__USE__IRQ {0} \
    CONFIG.PSU__USE__IRQ0 {1} \
    CONFIG.PSU__USE__IRQ1 {0} \
    CONFIG.PSU__USE__M_AXI_GP0 {1} \
    CONFIG.PSU__USE__M_AXI_GP1 {1} \
    CONFIG.PSU__USE__M_AXI_GP2 {0} \
    CONFIG.PSU__USE__PROC_EVENT_BUS {0} \
    CONFIG.PSU__USE__RPU_LEGACY_INTERRUPT {0} \
    CONFIG.PSU__USE__RST0 {0} \
    CONFIG.PSU__USE__RST1 {0} \
    CONFIG.PSU__USE__RST2 {0} \
    CONFIG.PSU__USE__RST3 {0} \
    CONFIG.PSU__USE__RTC {0} \
    CONFIG.PSU__USE__STM {0} \
    CONFIG.PSU__USE__S_AXI_ACE {0} \
    CONFIG.PSU__USE__S_AXI_ACP {0} \
    CONFIG.PSU__USE__S_AXI_GP0 {0} \
    CONFIG.PSU__USE__S_AXI_GP1 {0} \
    CONFIG.PSU__USE__S_AXI_GP2 {0} \
    CONFIG.PSU__USE__S_AXI_GP3 {0} \
    CONFIG.PSU__USE__S_AXI_GP4 {0} \
    CONFIG.PSU__USE__S_AXI_GP5 {0} \
    CONFIG.PSU__USE__S_AXI_GP6 {0} \
    CONFIG.PSU__USE__USB3_0_HUB {0} \
    CONFIG.PSU__USE__USB3_1_HUB {0} \
    CONFIG.PSU__USE__VIDEO {0} \
    CONFIG.PSU__VIDEO_REF_CLK__ENABLE {0} \
    CONFIG.PSU__VIDEO_REF_CLK__FREQMHZ {33.333} \
    CONFIG.QSPI_BOARD_INTERFACE {custom} \
    CONFIG.SATA_BOARD_INTERFACE {custom} \
    CONFIG.SD0_BOARD_INTERFACE {custom} \
    CONFIG.SD1_BOARD_INTERFACE {custom} \
    CONFIG.SPI0_BOARD_INTERFACE {custom} \
    CONFIG.SPI1_BOARD_INTERFACE {custom} \
    CONFIG.SUBPRESET1 {Custom} \
    CONFIG.SUBPRESET2 {Custom} \
    CONFIG.SWDT0_BOARD_INTERFACE {custom} \
    CONFIG.SWDT1_BOARD_INTERFACE {custom} \
    CONFIG.TRACE_BOARD_INTERFACE {custom} \
    CONFIG.TTC0_BOARD_INTERFACE {custom} \
    CONFIG.TTC1_BOARD_INTERFACE {custom} \
    CONFIG.TTC2_BOARD_INTERFACE {custom} \
    CONFIG.TTC3_BOARD_INTERFACE {custom} \
    CONFIG.UART0_BOARD_INTERFACE {custom} \
    CONFIG.UART1_BOARD_INTERFACE {custom} \
    CONFIG.USB0_BOARD_INTERFACE {custom} \
    CONFIG.USB1_BOARD_INTERFACE {custom} \
  ] $zynq_ultra_ps_e_0


  set_property SELECTED_SIM_MODEL rtl  $zynq_ultra_ps_e_0

  # Create interface connections
  connect_bd_intf_net -intf_net ADC_DAC_vout00_0 [get_bd_intf_ports vout00_0] [get_bd_intf_pins ADC_DAC/vout00_0]
  connect_bd_intf_net -intf_net ADC_DAC_vout20_0 [get_bd_intf_ports vout20_0] [get_bd_intf_pins ADC_DAC/vout20_0]
  connect_bd_intf_net -intf_net Function_Gen0_OUT_AXIS [get_bd_intf_pins Function_Gen0/OUT_AXIS] [get_bd_intf_pins ADC_DAC/s00_axis]
  connect_bd_intf_net -intf_net Function_Gen1_OUT_AXIS [get_bd_intf_pins ADC_DAC/s10_axis] [get_bd_intf_pins Function_Gen1/OUT_AXIS]
  connect_bd_intf_net -intf_net IN_0_AXIS_1 [get_bd_intf_pins trigger/IN_0_AXIS] [get_bd_intf_pins ADC_DAC/m00_axis]
  connect_bd_intf_net -intf_net IN_1_AXIS_1 [get_bd_intf_pins trigger/IN_1_AXIS] [get_bd_intf_pins ADC_DAC/m02_axis]
  connect_bd_intf_net -intf_net IN_2_AXIS_1 [get_bd_intf_pins trigger/IN_2_AXIS] [get_bd_intf_pins ADC_DAC/m20_axis]
  connect_bd_intf_net -intf_net IN_3_AXIS_1 [get_bd_intf_pins trigger/IN_3_AXIS] [get_bd_intf_pins ADC_DAC/m22_axis]
  connect_bd_intf_net -intf_net adc0_clk_0_1 [get_bd_intf_ports adc0_clk_0] [get_bd_intf_pins ADC_DAC/adc0_clk_0]
  connect_bd_intf_net -intf_net adc2_clk_0_1 [get_bd_intf_ports adc2_clk_0] [get_bd_intf_pins ADC_DAC/adc2_clk_0]
  connect_bd_intf_net -intf_net axi_interconnect_0_M01_AXI [get_bd_intf_pins axi_gpio_dac/S_AXI] [get_bd_intf_pins axi_interconnect_0/M01_AXI]
  connect_bd_intf_net -intf_net axi_interconnect_0_M03_AXI [get_bd_intf_pins real_sample_capture_00/S_AXI] [get_bd_intf_pins axi_interconnect_0/M03_AXI]
  connect_bd_intf_net -intf_net axi_interconnect_0_M04_AXI [get_bd_intf_pins real_sample_capture_01/S_AXI] [get_bd_intf_pins axi_interconnect_0/M04_AXI]
  connect_bd_intf_net -intf_net axi_interconnect_0_M05_AXI [get_bd_intf_pins real_sample_capture_02/S_AXI] [get_bd_intf_pins axi_interconnect_0/M05_AXI]
  connect_bd_intf_net -intf_net axi_interconnect_0_M06_AXI [get_bd_intf_pins real_sample_capture_03/S_AXI] [get_bd_intf_pins axi_interconnect_0/M06_AXI]
  connect_bd_intf_net -intf_net dac0_clk_0_1 [get_bd_intf_ports dac0_clk_0] [get_bd_intf_pins ADC_DAC/dac0_clk_0]
  connect_bd_intf_net -intf_net dac1_clk_0_1 [get_bd_intf_ports dac1_clk_0] [get_bd_intf_pins ADC_DAC/dac1_clk_0]
  connect_bd_intf_net -intf_net pl_sysref_0_1 [get_bd_intf_ports clk104_pl_sysref] [get_bd_intf_pins pl_sysref_0/pl_sysref]
  connect_bd_intf_net -intf_net ps8_0_axi_periph_M00_AXI [get_bd_intf_pins ps8_0_axi_periph/M00_AXI] [get_bd_intf_pins ADC_DAC/s_axi]
  connect_bd_intf_net -intf_net ps8_0_axi_periph_M01_AXI [get_bd_intf_pins ps8_0_axi_periph/M01_AXI] [get_bd_intf_pins AXI_DNA_0/S_AXI]
  connect_bd_intf_net -intf_net ps8_0_axi_periph_M02_AXI [get_bd_intf_pins ps8_0_axi_periph/M02_AXI] [get_bd_intf_pins trigger/S_AXI]
  connect_bd_intf_net -intf_net ps8_0_axi_periph_M03_AXI [get_bd_intf_pins spectrum_capture_con_0/S_AXI] [get_bd_intf_pins ps8_0_axi_periph/M03_AXI]
  connect_bd_intf_net -intf_net ps8_0_axi_periph_M04_AXI [get_bd_intf_pins Function_Gen0/S_AXI] [get_bd_intf_pins ps8_0_axi_periph/M04_AXI]
  connect_bd_intf_net -intf_net ps8_0_axi_periph_M05_AXI [get_bd_intf_pins ps8_0_axi_periph/M05_AXI] [get_bd_intf_pins Function_Gen1/S_AXI]
  connect_bd_intf_net -intf_net ps8_0_axi_periph_M12_AXI [get_bd_intf_pins spectrum_capture_con_1/S_AXI] [get_bd_intf_pins ps8_0_axi_periph/M12_AXI]
  connect_bd_intf_net -intf_net ps8_0_axi_periph_M13_AXI [get_bd_intf_pins spect/S_AXI] [get_bd_intf_pins ps8_0_axi_periph/M13_AXI]
  connect_bd_intf_net -intf_net ps8_0_axi_periph_M14_AXI [get_bd_intf_pins white_gaussian_noise_0/S_AXI] [get_bd_intf_pins ps8_0_axi_periph/M14_AXI]
  connect_bd_intf_net -intf_net ps8_0_axi_periph_M15_AXI [get_bd_intf_pins clock_measurement_0/S_AXI] [get_bd_intf_pins ps8_0_axi_periph/M15_AXI]
  connect_bd_intf_net -intf_net real_sample_capture_00_PASS_AXIS [get_bd_intf_pins real_sample_capture_00/PASS_AXIS] [get_bd_intf_pins spectrum_capture_con_0/IN_0_AXIS]
  connect_bd_intf_net -intf_net real_sample_capture_01_PASS_AXIS [get_bd_intf_pins spectrum_capture_con_0/IN_1_AXIS] [get_bd_intf_pins real_sample_capture_01/PASS_AXIS]
  connect_bd_intf_net -intf_net real_sample_capture_02_PASS_AXIS [get_bd_intf_pins spectrum_capture_con_0/IN_2_AXIS] [get_bd_intf_pins real_sample_capture_02/PASS_AXIS]
  connect_bd_intf_net -intf_net real_sample_capture_03_PASS_AXIS [get_bd_intf_pins spectrum_capture_con_0/IN_3_AXIS] [get_bd_intf_pins real_sample_capture_03/PASS_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_OUT_AXIS [get_bd_intf_pins spect/EARLY_AXIS] [get_bd_intf_pins spectrum_capture_con_0/OUT_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_0_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_0_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_0_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_10_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_10_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_10_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_11_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_11_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_11_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_12_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_12_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_12_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_13_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_13_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_13_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_14_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_14_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_14_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_15_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_15_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_15_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_1_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_1_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_1_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_2_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_2_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_2_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_3_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_3_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_3_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_4_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_4_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_4_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_5_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_5_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_5_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_6_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_6_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_6_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_7_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_7_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_7_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_8_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_8_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_8_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_0_PASS_9_AXIS [get_bd_intf_pins spectrum_capture_con_1/IN_9_AXIS] [get_bd_intf_pins spectrum_capture_con_0/PASS_9_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_1_OUT_AXIS [get_bd_intf_pins spect/LATE_AXIS] [get_bd_intf_pins spectrum_capture_con_1/OUT_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_1_PASS_0_AXIS [get_bd_intf_pins spectrum_capture_con_1/PASS_0_AXIS] [get_bd_intf_pins spectrum_capture_con_0/IN_8_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_1_PASS_10_AXIS [get_bd_intf_pins spectrum_capture_con_1/PASS_10_AXIS] [get_bd_intf_pins spectrum_capture_con_0/IN_6_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_1_PASS_11_AXIS [get_bd_intf_pins spectrum_capture_con_1/PASS_11_AXIS] [get_bd_intf_pins spectrum_capture_con_0/IN_7_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_1_PASS_1_AXIS [get_bd_intf_pins spectrum_capture_con_1/PASS_1_AXIS] [get_bd_intf_pins spectrum_capture_con_0/IN_9_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_1_PASS_2_AXIS [get_bd_intf_pins spectrum_capture_con_1/PASS_2_AXIS] [get_bd_intf_pins spectrum_capture_con_0/IN_10_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_1_PASS_3_AXIS [get_bd_intf_pins spectrum_capture_con_1/PASS_3_AXIS] [get_bd_intf_pins spectrum_capture_con_0/IN_11_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_1_PASS_4_AXIS [get_bd_intf_pins spectrum_capture_con_1/PASS_4_AXIS] [get_bd_intf_pins spectrum_capture_con_0/IN_12_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_1_PASS_5_AXIS [get_bd_intf_pins spectrum_capture_con_1/PASS_5_AXIS] [get_bd_intf_pins spectrum_capture_con_0/IN_13_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_1_PASS_6_AXIS [get_bd_intf_pins spectrum_capture_con_1/PASS_6_AXIS] [get_bd_intf_pins spectrum_capture_con_0/IN_14_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_1_PASS_7_AXIS [get_bd_intf_pins spectrum_capture_con_1/PASS_7_AXIS] [get_bd_intf_pins spectrum_capture_con_0/IN_15_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_1_PASS_8_AXIS [get_bd_intf_pins spectrum_capture_con_1/PASS_8_AXIS] [get_bd_intf_pins spectrum_capture_con_0/IN_4_AXIS]
  connect_bd_intf_net -intf_net spectrum_capture_con_1_PASS_9_AXIS [get_bd_intf_pins spectrum_capture_con_1/PASS_9_AXIS] [get_bd_intf_pins spectrum_capture_con_0/IN_5_AXIS]
  connect_bd_intf_net -intf_net sysref_in_0_1 [get_bd_intf_ports sysref_in_0] [get_bd_intf_pins ADC_DAC/sysref_in_0]
  connect_bd_intf_net -intf_net trigger_PASS_0_AXIS [get_bd_intf_pins real_sample_capture_00/IN_AXIS] [get_bd_intf_pins trigger/PASS_0_AXIS]
  connect_bd_intf_net -intf_net trigger_PASS_1_AXIS [get_bd_intf_pins real_sample_capture_01/IN_AXIS] [get_bd_intf_pins trigger/PASS_1_AXIS]
  connect_bd_intf_net -intf_net trigger_PASS_2_AXIS [get_bd_intf_pins real_sample_capture_02/IN_AXIS] [get_bd_intf_pins trigger/PASS_2_AXIS]
  connect_bd_intf_net -intf_net trigger_PASS_3_AXIS [get_bd_intf_pins real_sample_capture_03/IN_AXIS] [get_bd_intf_pins trigger/PASS_3_AXIS]
  connect_bd_intf_net -intf_net vin0_01_0_1 [get_bd_intf_ports vin0_01_0] [get_bd_intf_pins ADC_DAC/vin0_01_0]
  connect_bd_intf_net -intf_net vin0_23_1_1 [get_bd_intf_ports vin0_23_1] [get_bd_intf_pins ADC_DAC/vin0_23_1]
  connect_bd_intf_net -intf_net vin2_01_1_1 [get_bd_intf_ports vin2_01_1] [get_bd_intf_pins ADC_DAC/vin2_01_1]
  connect_bd_intf_net -intf_net vin2_23_1_1 [get_bd_intf_ports vin2_23_1] [get_bd_intf_pins ADC_DAC/vin2_23_1]
  connect_bd_intf_net -intf_net white_gaussian_noise_0_OUT_0_AXIS [get_bd_intf_pins white_gaussian_noise_0/OUT_0_AXIS] [get_bd_intf_pins Function_Gen0/IN_2_AXIS]
  connect_bd_intf_net -intf_net white_gaussian_noise_0_OUT_1_AXIS [get_bd_intf_pins white_gaussian_noise_0/OUT_1_AXIS] [get_bd_intf_pins Function_Gen1/IN_2_AXIS]
  connect_bd_intf_net -intf_net zynq_ultra_ps_e_0_M_AXI_HPM0_FPD [get_bd_intf_pins zynq_ultra_ps_e_0/M_AXI_HPM0_FPD] [get_bd_intf_pins ps8_0_axi_periph/S00_AXI]
  connect_bd_intf_net -intf_net zynq_ultra_ps_e_0_M_AXI_HPM1_FPD [get_bd_intf_pins zynq_ultra_ps_e_0/M_AXI_HPM1_FPD] [get_bd_intf_pins axi_interconnect_0/S00_AXI]

  # Create port connections
  create_bd_net ADC_DAC_clk_dac2
  connect_bd_net -net [get_bd_nets ADC_DAC_clk_dac2]  [get_bd_pins ADC_DAC/clk_dac2] \
  [get_bd_pins Function_Gen0/OUT_AXIS_aclk] \
  [get_bd_pins hier_rsts/slowest_sync_clk] \
  [get_bd_pins spect/AXIS_aclk] \
  [get_bd_pins trigger/fpga_refclk] \
  [get_bd_pins Function_Gen1/OUT_AXIS_aclk] \
  [get_bd_pins ADC_DAC/m1_axis_aclk] \
  [get_bd_pins spectrum_capture_con_0/IN_AXIS_aclk] \
  [get_bd_pins spectrum_capture_con_1/IN_AXIS_aclk] \
  [get_bd_pins white_gaussian_noise_0/OUT_AXIS_aclk] \
  [get_bd_pins real_sample_capture_00/IN_AXIS_aclk] \
  [get_bd_pins real_sample_capture_01/IN_AXIS_aclk] \
  [get_bd_pins real_sample_capture_02/IN_AXIS_aclk] \
  [get_bd_pins real_sample_capture_03/IN_AXIS_aclk] \
  [get_bd_pins pl_sysref_0/high_speed_pl_clk] \
  [get_bd_pins clock_measurement_0/CLK_3]
  connect_bd_net -net ARESETN_2  [get_bd_pins hier_rsts/interconnect_aresetn1] \
  [get_bd_pins real_sample_capture_00/S_AXI_ARESETN] \
  [get_bd_pins real_sample_capture_01/S_AXI_ARESETN] \
  [get_bd_pins real_sample_capture_02/S_AXI_ARESETN] \
  [get_bd_pins real_sample_capture_03/S_AXI_ARESETN] \
  [get_bd_pins axi_gpio_dac/s_axi_aresetn] \
  [get_bd_pins axi_interconnect_0/ARESETN] \
  [get_bd_pins axi_interconnect_0/S00_ARESETN] \
  [get_bd_pins axi_interconnect_0/M00_ARESETN] \
  [get_bd_pins axi_interconnect_0/M01_ARESETN] \
  [get_bd_pins axi_interconnect_0/M02_ARESETN] \
  [get_bd_pins axi_interconnect_0/M03_ARESETN] \
  [get_bd_pins axi_interconnect_0/M04_ARESETN] \
  [get_bd_pins axi_interconnect_0/M05_ARESETN] \
  [get_bd_pins axi_interconnect_0/M06_ARESETN] \
  [get_bd_pins axi_interconnect_0/M07_ARESETN] \
  [get_bd_pins axi_interconnect_0/M08_ARESETN] \
  [get_bd_pins axi_interconnect_0/M09_ARESETN] \
  [get_bd_pins axi_interconnect_0/M10_ARESETN] \
  [get_bd_pins axi_interconnect_0/M11_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/ARESETN]
  connect_bd_net -net axi_gpio_dac_gpio2_io_o  [get_bd_pins axi_gpio_dac/gpio2_io_o] \
  [get_bd_pins xlslice_0/Din]
  connect_bd_net -net pl_sysref_0_user_sysref_adc  [get_bd_pins pl_sysref_0/user_sysref_adc] \
  [get_bd_pins ADC_DAC/user_sysref_adc]
  connect_bd_net -net pl_sysref_0_user_sysref_dac  [get_bd_pins pl_sysref_0/user_sysref_dac] \
  [get_bd_pins ADC_DAC/user_sysref_dac]
  connect_bd_net -net proc_sys_reset_1_peripheral_aresetn  [get_bd_pins hier_rsts/peripheral_aresetn] \
  [get_bd_pins Function_Gen0/OUT_AXIS_aresetn] \
  [get_bd_pins spect/AXIS_aresetn] \
  [get_bd_pins trigger/IN_AXIS_aresetn] \
  [get_bd_pins Function_Gen1/OUT_AXIS_aresetn] \
  [get_bd_pins ADC_DAC/m1_axis_aresetn] \
  [get_bd_pins spectrum_capture_con_0/IN_AXIS_aresetn] \
  [get_bd_pins spectrum_capture_con_1/IN_AXIS_aresetn] \
  [get_bd_pins white_gaussian_noise_0/OUT_AXIS_aresetn] \
  [get_bd_pins real_sample_capture_00/IN_AXIS_aresetn] \
  [get_bd_pins real_sample_capture_01/IN_AXIS_aresetn] \
  [get_bd_pins real_sample_capture_02/IN_AXIS_aresetn] \
  [get_bd_pins real_sample_capture_03/IN_AXIS_aresetn]
  connect_bd_net -net rst_ps8_0_99M_peripheral_aresetn  [get_bd_pins hier_rsts/peripheral_aresetn2] \
  [get_bd_pins Function_Gen0/S_AXI_ARESETN] \
  [get_bd_pins spect/S_AXI_ARESETN] \
  [get_bd_pins trigger/S_AXI_ARESETN] \
  [get_bd_pins Function_Gen1/S_AXI_ARESETN] \
  [get_bd_pins ADC_DAC/s_axi_aresetn] \
  [get_bd_pins AXI_DNA_0/S_AXI_ARESETN] \
  [get_bd_pins clock_measurement_0/S_AXI_ARESETN] \
  [get_bd_pins spectrum_capture_con_0/S_AXI_ARESETN] \
  [get_bd_pins spectrum_capture_con_1/S_AXI_ARESETN] \
  [get_bd_pins white_gaussian_noise_0/S_AXI_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/S00_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M00_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M01_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M02_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M03_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M04_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M05_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M06_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M07_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M08_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M09_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M10_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M11_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M12_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M13_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M14_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M15_ARESETN] \
  [get_bd_pins ps8_0_axi_periph/M16_ARESETN]
  connect_bd_net -net trig_cap  [get_bd_pins trigger/collect] \
  [get_bd_pins real_sample_capture_00/collect] \
  [get_bd_pins real_sample_capture_01/collect] \
  [get_bd_pins real_sample_capture_02/collect] \
  [get_bd_pins real_sample_capture_03/collect]
  connect_bd_net -net usp_rf_data_converter_0_clk_adc0  [get_bd_pins ADC_DAC/clk_adc0] \
  [get_bd_pins clock_measurement_0/CLK_0]
  connect_bd_net -net usp_rf_data_converter_0_clk_adc2  [get_bd_pins ADC_DAC/clk_adc2] \
  [get_bd_pins clock_measurement_0/CLK_1]
  connect_bd_net -net usp_rf_data_converter_0_clk_dac0  [get_bd_pins ADC_DAC/clk_dac0] \
  [get_bd_pins pl_sysref_0/pl_clk] \
  [get_bd_pins clock_measurement_0/CLK_2]
  connect_bd_net -net xlconstant_0_dout  [get_bd_pins xlconstant_0/dout] \
  [get_bd_pins trigger/external_trigger]
  connect_bd_net -net xlconstant_1_dout  [get_bd_pins xlconstant_1/dout] \
  [get_bd_pins hier_rsts/dcm_locked]
  connect_bd_net -net xlslice_0_Dout  [get_bd_pins xlslice_0/Dout] \
  [get_bd_pins pl_sysref_0/selNeg]
  connect_bd_net -net zynq_ultra_ps_e_0_pl_clk0  [get_bd_pins zynq_ultra_ps_e_0/pl_clk0] \
  [get_bd_pins hier_rsts/slowest_sync_clk2] \
  [get_bd_pins Function_Gen0/S_AXI_ACLK] \
  [get_bd_pins spect/S_AXI_ACLK] \
  [get_bd_pins trigger/S_AXI_ACLK] \
  [get_bd_pins Function_Gen1/S_AXI_ACLK] \
  [get_bd_pins ADC_DAC/s_axi_aclk] \
  [get_bd_pins AXI_DNA_0/S_AXI_ACLK] \
  [get_bd_pins clock_measurement_0/REF_CLK] \
  [get_bd_pins clock_measurement_0/S_AXI_ACLK] \
  [get_bd_pins spectrum_capture_con_0/S_AXI_ACLK] \
  [get_bd_pins spectrum_capture_con_1/S_AXI_ACLK] \
  [get_bd_pins white_gaussian_noise_0/S_AXI_ACLK] \
  [get_bd_pins real_sample_capture_00/S_AXI_ACLK] \
  [get_bd_pins real_sample_capture_01/S_AXI_ACLK] \
  [get_bd_pins real_sample_capture_02/S_AXI_ACLK] \
  [get_bd_pins real_sample_capture_03/S_AXI_ACLK] \
  [get_bd_pins axi_gpio_dac/s_axi_aclk] \
  [get_bd_pins axi_interconnect_0/ACLK] \
  [get_bd_pins axi_interconnect_0/S00_ACLK] \
  [get_bd_pins axi_interconnect_0/M00_ACLK] \
  [get_bd_pins axi_interconnect_0/M01_ACLK] \
  [get_bd_pins axi_interconnect_0/M02_ACLK] \
  [get_bd_pins axi_interconnect_0/M03_ACLK] \
  [get_bd_pins axi_interconnect_0/M04_ACLK] \
  [get_bd_pins axi_interconnect_0/M05_ACLK] \
  [get_bd_pins axi_interconnect_0/M06_ACLK] \
  [get_bd_pins axi_interconnect_0/M07_ACLK] \
  [get_bd_pins axi_interconnect_0/M08_ACLK] \
  [get_bd_pins axi_interconnect_0/M09_ACLK] \
  [get_bd_pins axi_interconnect_0/M10_ACLK] \
  [get_bd_pins axi_interconnect_0/M11_ACLK] \
  [get_bd_pins ps8_0_axi_periph/ACLK] \
  [get_bd_pins ps8_0_axi_periph/S00_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M00_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M01_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M02_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M03_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M04_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M05_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M06_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M07_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M08_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M09_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M10_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M11_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M12_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M13_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M14_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M15_ACLK] \
  [get_bd_pins ps8_0_axi_periph/M16_ACLK] \
  [get_bd_pins zynq_ultra_ps_e_0/maxihpm0_fpd_aclk] \
  [get_bd_pins zynq_ultra_ps_e_0/maxihpm1_fpd_aclk]
  connect_bd_net -net zynq_ultra_ps_e_0_pl_resetn0  [get_bd_pins zynq_ultra_ps_e_0/pl_resetn0] \
  [get_bd_pins hier_rsts/ext_reset_in]

  # Create address segments
  assign_bd_address -offset 0xA0040000 -range 0x00010000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs AXI_DNA_0/S_AXI/reg0] -force
  assign_bd_address -offset 0xB2000000 -range 0x00001000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs axi_gpio_dac/S_AXI/Reg] -force
  assign_bd_address -offset 0xA00A0000 -range 0x00010000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs clock_measurement_0/S_AXI/reg0] -force
  assign_bd_address -offset 0xB0000000 -range 0x00020000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs real_sample_capture_00/S_AXI/reg0] -force
  assign_bd_address -offset 0xB0020000 -range 0x00020000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs real_sample_capture_01/S_AXI/reg0] -force
  assign_bd_address -offset 0xB0040000 -range 0x00020000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs real_sample_capture_02/S_AXI/reg0] -force
  assign_bd_address -offset 0xB0060000 -range 0x00020000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs real_sample_capture_03/S_AXI/reg0] -force
  assign_bd_address -offset 0xA0060000 -range 0x00020000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs trigger/simple_trigger_1/S_AXI/reg0] -force
  assign_bd_address -offset 0xA0400000 -range 0x00400000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs spect/spectral_capture_960_0/S_AXI/reg0] -force
  assign_bd_address -offset 0xA0080000 -range 0x00010000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs spectrum_capture_con_0/S_AXI/reg0] -force
  assign_bd_address -offset 0xA0090000 -range 0x00010000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs spectrum_capture_con_1/S_AXI/reg0] -force
  assign_bd_address -offset 0xA0110000 -range 0x00010000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs Function_Gen1/swept_spread_phase_g_0/S_AXI/reg0] -force
  assign_bd_address -offset 0xA0100000 -range 0x00010000 -with_name SEG_swept_spread_phase_g_0_reg05 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs Function_Gen0/swept_spread_phase_g_0/S_AXI/reg0] -force
  assign_bd_address -offset 0xA0000000 -range 0x00040000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs ADC_DAC/usp_rf_data_converter_1/s_axi/Reg] -force
  assign_bd_address -offset 0xA0050000 -range 0x00010000 -target_address_space [get_bd_addr_spaces zynq_ultra_ps_e_0/Data] [get_bd_addr_segs white_gaussian_noise_0/S_AXI/reg0] -force

  # Perform GUI Layout
  regenerate_bd_layout -layout_string {
   "ActiveEmotionalView":"Default View",
   "Default View_ScaleFactor":"0.382946",
   "Default View_TopLeft":"-178,-593",
   "ExpandedHierarchyInLayout":"",
   "guistr":"# # String gsaved with Nlview 7.8.0 2024-04-26 e1825d835c VDI=44 GEI=38 GUI=JA:21.0 TLS
#  -string -flagsOSRD
preplace port vin0_01_0 -pg 1 -lvl 0 -x -20 -y 1690 -defaultsOSRD
preplace port dac1_clk_0 -pg 1 -lvl 0 -x -20 -y 1660 -defaultsOSRD
preplace port sysref_in_0 -pg 1 -lvl 0 -x -20 -y 490 -defaultsOSRD
preplace port clk104_pl_sysref -pg 1 -lvl 0 -x -20 -y 1630 -defaultsOSRD
preplace port vin0_23_1 -pg 1 -lvl 0 -x -20 -y 620 -defaultsOSRD
preplace port vin2_01_1 -pg 1 -lvl 0 -x -20 -y 650 -defaultsOSRD
preplace port vin2_23_1 -pg 1 -lvl 0 -x -20 -y 680 -defaultsOSRD
preplace port adc0_clk_0 -pg 1 -lvl 0 -x -20 -y 710 -defaultsOSRD
preplace port adc2_clk_0 -pg 1 -lvl 0 -x -20 -y 740 -defaultsOSRD
preplace port dac0_clk_0 -pg 1 -lvl 0 -x -20 -y 770 -defaultsOSRD
preplace port vout00_0 -pg 1 -lvl 12 -x 4320 -y 1640 -defaultsOSRD
preplace port vout20_0 -pg 1 -lvl 12 -x 4320 -y 1670 -defaultsOSRD
preplace inst hier_rsts -pg 1 -lvl 2 -x 540 -y 850 -defaultsOSRD
preplace inst Function_Gen0 -pg 1 -lvl 5 -x 1890 -y 1290 -defaultsOSRD
preplace inst spect -pg 1 -lvl 11 -x 4190 -y 1550 -defaultsOSRD
preplace inst trigger -pg 1 -lvl 7 -x 2660 -y 720 -defaultsOSRD
preplace inst Function_Gen1 -pg 1 -lvl 5 -x 1890 -y 870 -defaultsOSRD
preplace inst ADC_DAC -pg 1 -lvl 6 -x 2310 -y 740 -defaultsOSRD
preplace inst AXI_DNA_0 -pg 1 -lvl 4 -x 1490 -y 1200 -defaultsOSRD
preplace inst clock_measurement_0 -pg 1 -lvl 4 -x 1490 -y 1440 -defaultsOSRD
preplace inst spectrum_capture_con_0 -pg 1 -lvl 9 -x 3490 -y 1050 -defaultsOSRD
preplace inst spectrum_capture_con_1 -pg 1 -lvl 10 -x 3820 -y 1080 -defaultsOSRD
preplace inst white_gaussian_noise_0 -pg 1 -lvl 4 -x 1490 -y 1010 -defaultsOSRD
preplace inst xlconstant_0 -pg 1 -lvl 6 -x 2310 -y 1050 -defaultsOSRD
preplace inst xlslice_0 -pg 1 -lvl 4 -x 1490 -y 840 -defaultsOSRD
preplace inst real_sample_capture_00 -pg 1 -lvl 8 -x 3050 -y 440 -defaultsOSRD
preplace inst real_sample_capture_01 -pg 1 -lvl 8 -x 3050 -y 880 -defaultsOSRD
preplace inst real_sample_capture_02 -pg 1 -lvl 8 -x 3050 -y 660 -defaultsOSRD
preplace inst real_sample_capture_03 -pg 1 -lvl 8 -x 3050 -y 1530 -defaultsOSRD
preplace inst xlconstant_1 -pg 1 -lvl 1 -x 110 -y 880 -defaultsOSRD
preplace inst pl_sysref_0 -pg 1 -lvl 5 -x 1890 -y 1480 -defaultsOSRD
preplace inst axi_gpio_dac -pg 1 -lvl 4 -x 1490 -y 410 -defaultsOSRD
preplace inst axi_interconnect_0 -pg 1 -lvl 3 -x 1050 -y 330 -defaultsOSRD
preplace inst ps8_0_axi_periph -pg 1 -lvl 3 -x 1050 -y 1210 -defaultsOSRD
preplace inst zynq_ultra_ps_e_0 -pg 1 -lvl 2 -x 540 -y 590 -defaultsOSRD
preplace netloc ADC_DAC_clk_dac2 1 1 10 220 1690 NJ 1690 1320 1590 1700 970 2060 490 2510 460 2880 1190 3230 1310 3660 1470 4080J
preplace netloc ARESETN_2 1 2 6 890 730 1220 490 1710J 470 NJ 470 NJ 470 2820
preplace netloc axi_gpio_dac_gpio2_io_o 1 3 2 1330 500 1630
preplace netloc pl_sysref_0_user_sysref_adc 1 5 1 2170 850n
preplace netloc pl_sysref_0_user_sysref_dac 1 5 1 2180 910n
preplace netloc proc_sys_reset_1_peripheral_aresetn 1 2 9 900J 770 1220 1300 1730 980 2050 480 2520 450 2890 1210 3220 1320 3670 1480 4040J
preplace netloc rst_ps8_0_99M_peripheral_aresetn 1 2 9 860 1650 1310 1600 1670 690 2110 460 2500 350 2840J 320 3190 1330 3680 1370 4070J
preplace netloc trig_cap 1 7 1 2900 460n
preplace netloc usp_rf_data_converter_0_clk_adc0 1 3 4 1350 1570 NJ 1570 NJ 1570 2460
preplace netloc usp_rf_data_converter_0_clk_adc2 1 3 4 1340 1580 NJ 1580 NJ 1580 2450
preplace netloc usp_rf_data_converter_0_clk_dac0 1 3 4 1330 1310 1640 1390 NJ 1390 2440
preplace netloc xlconstant_0_dout 1 6 1 2520J 790n
preplace netloc xlconstant_1_dout 1 1 1 NJ 880
preplace netloc xlslice_0_Dout 1 4 1 1650J 840n
preplace netloc zynq_ultra_ps_e_0_pl_clk0 1 1 10 230 760 870 1680 1260 770 1720 760 2140 500 2470 510 2910 1230 3200 1370 3650 1590 NJ
preplace netloc zynq_ultra_ps_e_0_pl_resetn0 1 1 2 240 730 840
preplace netloc ADC_DAC_vout00_0 1 6 6 2480J 300 NJ 300 NJ 300 NJ 300 NJ 300 4300J
preplace netloc ADC_DAC_vout20_0 1 6 6 2490J 320 2830J 310 NJ 310 NJ 310 NJ 310 4290J
preplace netloc Function_Gen0_OUT_AXIS 1 5 1 2120 590n
preplace netloc Function_Gen1_OUT_AXIS 1 5 1 2080 610n
preplace netloc IN_0_AXIS_1 1 6 1 N 650
preplace netloc IN_1_AXIS_1 1 6 1 N 670
preplace netloc IN_2_AXIS_1 1 6 1 N 690
preplace netloc IN_3_AXIS_1 1 6 1 N 710
preplace netloc adc0_clk_0_1 1 0 6 NJ 710 NJ 710 NJ 710 NJ 710 NJ 710 2090J
preplace netloc adc2_clk_0_1 1 0 6 NJ 740 NJ 740 NJ 740 NJ 740 NJ 740 2100J
preplace netloc axi_interconnect_0_M01_AXI 1 3 1 1210 240n
preplace netloc axi_interconnect_0_M03_AXI 1 3 5 NJ 280 NJ 280 NJ 280 NJ 280 2890
preplace netloc axi_interconnect_0_M04_AXI 1 3 5 NJ 300 NJ 300 NJ 300 2470J 310 2810
preplace netloc axi_interconnect_0_M05_AXI 1 3 5 NJ 320 NJ 320 NJ 320 2470J 330 2870
preplace netloc axi_interconnect_0_M06_AXI 1 3 5 1200 330 NJ 330 NJ 330 2460J 340 2850J
preplace netloc dac0_clk_0_1 1 0 6 20J 750 NJ 750 NJ 750 NJ 750 NJ 750 2070J
preplace netloc dac1_clk_0_1 1 0 6 NJ 1660 NJ 1660 NJ 1660 1200J 1630 NJ 1630 2160J
preplace netloc pl_sysref_0_1 1 0 5 NJ 1630 NJ 1630 840J 1670 1330J 1650 1730J
preplace netloc ps8_0_axi_periph_M00_AXI 1 3 3 1250 570 NJ 570 NJ
preplace netloc ps8_0_axi_periph_M01_AXI 1 3 1 1300 1070n
preplace netloc ps8_0_axi_periph_M02_AXI 1 3 4 1240 510 NJ 510 NJ 510 2460J
preplace netloc ps8_0_axi_periph_M03_AXI 1 3 6 1280 1280 1680J 1170 NJ 1170 NJ 1170 NJ 1170 NJ
preplace netloc ps8_0_axi_periph_M04_AXI 1 3 2 1250 1290 1710J
preplace netloc ps8_0_axi_periph_M05_AXI 1 3 2 1270 780 1700J
preplace netloc ps8_0_axi_periph_M12_AXI 1 3 7 1240J 1660 NJ 1660 NJ 1660 NJ 1660 NJ 1660 NJ 1660 3640
preplace netloc ps8_0_axi_periph_M13_AXI 1 3 8 1210 1640 NJ 1640 NJ 1640 NJ 1640 2800J 1650 3190J 1530 NJ 1530 NJ
preplace netloc ps8_0_axi_periph_M14_AXI 1 3 1 1290 970n
preplace netloc ps8_0_axi_periph_M15_AXI 1 3 1 1200 1350n
preplace netloc real_sample_capture_00_PASS_AXIS 1 8 1 3350 430n
preplace netloc real_sample_capture_01_PASS_AXIS 1 8 1 N 870
preplace netloc real_sample_capture_02_PASS_AXIS 1 8 1 3200 650n
preplace netloc real_sample_capture_03_PASS_AXIS 1 8 1 3210 910n
preplace netloc spectrum_capture_con_0_OUT_AXIS 1 9 2 3630 1490 NJ
preplace netloc spectrum_capture_con_0_PASS_0_AXIS 1 9 1 N 880
preplace netloc spectrum_capture_con_0_PASS_10_AXIS 1 9 1 N 1080
preplace netloc spectrum_capture_con_0_PASS_11_AXIS 1 9 1 N 1100
preplace netloc spectrum_capture_con_0_PASS_12_AXIS 1 9 1 N 1120
preplace netloc spectrum_capture_con_0_PASS_13_AXIS 1 9 1 N 1140
preplace netloc spectrum_capture_con_0_PASS_14_AXIS 1 9 1 N 1160
preplace netloc spectrum_capture_con_0_PASS_15_AXIS 1 9 1 N 1180
preplace netloc spectrum_capture_con_0_PASS_1_AXIS 1 9 1 N 900
preplace netloc spectrum_capture_con_0_PASS_2_AXIS 1 9 1 N 920
preplace netloc spectrum_capture_con_0_PASS_3_AXIS 1 9 1 N 940
preplace netloc spectrum_capture_con_0_PASS_4_AXIS 1 9 1 N 960
preplace netloc spectrum_capture_con_0_PASS_5_AXIS 1 9 1 N 980
preplace netloc spectrum_capture_con_0_PASS_6_AXIS 1 9 1 N 1000
preplace netloc spectrum_capture_con_0_PASS_7_AXIS 1 9 1 N 1020
preplace netloc spectrum_capture_con_0_PASS_8_AXIS 1 9 1 N 1040
preplace netloc spectrum_capture_con_0_PASS_9_AXIS 1 9 1 N 1060
preplace netloc spectrum_capture_con_1_OUT_AXIS 1 10 1 4090 1230n
preplace netloc spectrum_capture_con_1_PASS_0_AXIS 1 8 3 3330 1340 NJ 1340 4070
preplace netloc spectrum_capture_con_1_PASS_10_AXIS 1 8 3 3240 1460 NJ 1460 4060
preplace netloc spectrum_capture_con_1_PASS_11_AXIS 1 8 3 3250 1450 NJ 1450 3960
preplace netloc spectrum_capture_con_1_PASS_1_AXIS 1 8 3 3310 1350 NJ 1350 4050
preplace netloc spectrum_capture_con_1_PASS_2_AXIS 1 8 3 3290 1360 NJ 1360 4040
preplace netloc spectrum_capture_con_1_PASS_3_AXIS 1 8 3 3350 1380 NJ 1380 4030
preplace netloc spectrum_capture_con_1_PASS_4_AXIS 1 8 3 3340 1390 NJ 1390 4020
preplace netloc spectrum_capture_con_1_PASS_5_AXIS 1 8 3 3320 1400 NJ 1400 4010
preplace netloc spectrum_capture_con_1_PASS_6_AXIS 1 8 3 3300 1410 NJ 1410 4000
preplace netloc spectrum_capture_con_1_PASS_7_AXIS 1 8 3 3280 1420 NJ 1420 3990
preplace netloc spectrum_capture_con_1_PASS_8_AXIS 1 8 3 3270 1430 NJ 1430 3980
preplace netloc spectrum_capture_con_1_PASS_9_AXIS 1 8 3 3260 1440 NJ 1440 3970
preplace netloc sysref_in_0_1 1 0 6 NJ 490 NJ 490 880J 670 NJ 670 NJ 670 NJ
preplace netloc trigger_PASS_0_AXIS 1 7 1 2830 380n
preplace netloc trigger_PASS_1_AXIS 1 7 1 2800 720n
preplace netloc trigger_PASS_2_AXIS 1 7 1 2860 600n
preplace netloc trigger_PASS_3_AXIS 1 7 1 2830 740n
preplace netloc vin0_01_0_1 1 0 6 10J 690 NJ 690 NJ 690 1230J 650 NJ 650 NJ
preplace netloc vin0_23_1_1 1 0 6 0J 480 NJ 480 900J 680 NJ 680 NJ 680 2150J
preplace netloc vin2_01_1_1 1 0 6 NJ 650 190J 720 NJ 720 NJ 720 NJ 720 2100J
preplace netloc vin2_23_1_1 1 0 6 0J 700 NJ 700 NJ 700 NJ 700 NJ 700 2130J
preplace netloc white_gaussian_noise_0_OUT_0_AXIS 1 4 1 1690 940n
preplace netloc white_gaussian_noise_0_OUT_1_AXIS 1 4 1 1660 840n
preplace netloc zynq_ultra_ps_e_0_M_AXI_HPM0_FPD 1 2 1 850 550n
preplace netloc zynq_ultra_ps_e_0_M_AXI_HPM1_FPD 1 2 1 840 50n
levelinfo -pg 1 -20 110 540 1050 1490 1890 2310 2660 3050 3490 3820 4190 4320
pagesize -pg 1 -db -bbox -sgen -190 -10 4430 1710
"
}

  # Restore current instance
  current_bd_instance $oldCurInst

  validate_bd_design
  save_bd_design
  close_bd_design $design_name 
}
# End of cr_bd_design_1()

cr_bd_design_1 ""
set_property GENERATE_SYNTH_CHECKPOINT "0" [get_files design_1.bd ] 
set_property REGISTERED_WITH_MANAGER "1" [get_files design_1.bd ] 

#call make_wrapper to create wrapper files
if { [get_property IS_LOCKED [ get_files -norecurse [list design_1.bd]] ] == 1  } {
  import_files -fileset sources_1 [file normalize "${origin_dir}/BxB_Demo1.gen/sources_1/bd/design_1/hdl/design_1_wrapper.v" ]
} else {
  set wrapper_path [make_wrapper -fileset sources_1 -files [ get_files -norecurse [list design_1.bd]] -top]
  add_files -norecurse -fileset sources_1 $wrapper_path
}


set idrFlowPropertiesConstraints ""
catch {
 set idrFlowPropertiesConstraints [get_param runs.disableIDRFlowPropertyConstraints]
 set_param runs.disableIDRFlowPropertyConstraints 1
}

# Create 'synth_1' run (if not found)
if {[string equal [get_runs -quiet synth_1] ""]} {
    create_run -name synth_1 -part xczu48dr-fsvg1517-2-e -flow {Vivado Synthesis 2024} -strategy "Vivado Synthesis Defaults" -report_strategy {No Reports} -constrset constrs_1
} else {
  set_property strategy "Vivado Synthesis Defaults" [get_runs synth_1]
  set_property flow "Vivado Synthesis 2024" [get_runs synth_1]
}
set obj [get_runs synth_1]
set_property set_report_strategy_name 1 $obj
set_property report_strategy {Vivado Synthesis Default Reports} $obj
set_property set_report_strategy_name 0 $obj
# Create 'synth_1_synth_report_utilization_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs synth_1] synth_1_synth_report_utilization_0] "" ] } {
  create_report_config -report_name synth_1_synth_report_utilization_0 -report_type report_utilization:1.0 -steps synth_design -runs synth_1
}
set obj [get_report_configs -of_objects [get_runs synth_1] synth_1_synth_report_utilization_0]
if { $obj != "" } {

}
set obj [get_runs synth_1]
set_property -name "part" -value "xczu48dr-fsvg1517-2-e" -objects $obj
set_property -name "auto_incremental_checkpoint" -value "1" -objects $obj
set_property -name "strategy" -value "Vivado Synthesis Defaults" -objects $obj

# set the current synth run
current_run -synthesis [get_runs synth_1]

# Create 'impl_1' run (if not found)
if {[string equal [get_runs -quiet impl_1] ""]} {
    create_run -name impl_1 -part xczu48dr-fsvg1517-2-e -flow {Vivado Implementation 2024} -strategy "Vivado Implementation Defaults" -report_strategy {No Reports} -constrset constrs_1 -parent_run synth_1
} else {
  set_property strategy "Vivado Implementation Defaults" [get_runs impl_1]
  set_property flow "Vivado Implementation 2024" [get_runs impl_1]
}
set obj [get_runs impl_1]
set_property set_report_strategy_name 1 $obj
set_property report_strategy {Vivado Implementation Default Reports} $obj
set_property set_report_strategy_name 0 $obj
# Create 'impl_1_init_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_init_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_init_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps init_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_init_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj
set_property -name "options.max_paths" -value "10" -objects $obj
set_property -name "options.report_unconstrained" -value "1" -objects $obj

}
# Create 'impl_1_opt_report_drc_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_opt_report_drc_0] "" ] } {
  create_report_config -report_name impl_1_opt_report_drc_0 -report_type report_drc:1.0 -steps opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_opt_report_drc_0]
if { $obj != "" } {

}
# Create 'impl_1_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_opt_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj
set_property -name "options.max_paths" -value "10" -objects $obj
set_property -name "options.report_unconstrained" -value "1" -objects $obj

}
# Create 'impl_1_power_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_power_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_power_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps power_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_power_opt_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj
set_property -name "options.max_paths" -value "10" -objects $obj
set_property -name "options.report_unconstrained" -value "1" -objects $obj

}
# Create 'impl_1_place_report_io_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_io_0] "" ] } {
  create_report_config -report_name impl_1_place_report_io_0 -report_type report_io:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_io_0]
if { $obj != "" } {

}
# Create 'impl_1_place_report_utilization_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_utilization_0] "" ] } {
  create_report_config -report_name impl_1_place_report_utilization_0 -report_type report_utilization:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_utilization_0]
if { $obj != "" } {

}
# Create 'impl_1_place_report_control_sets_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_control_sets_0] "" ] } {
  create_report_config -report_name impl_1_place_report_control_sets_0 -report_type report_control_sets:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_control_sets_0]
if { $obj != "" } {
set_property -name "options.verbose" -value "1" -objects $obj

}
# Create 'impl_1_place_report_incremental_reuse_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_incremental_reuse_0] "" ] } {
  create_report_config -report_name impl_1_place_report_incremental_reuse_0 -report_type report_incremental_reuse:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_incremental_reuse_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_place_report_incremental_reuse_1' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_incremental_reuse_1] "" ] } {
  create_report_config -report_name impl_1_place_report_incremental_reuse_1 -report_type report_incremental_reuse:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_incremental_reuse_1]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_place_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_place_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj
set_property -name "options.max_paths" -value "10" -objects $obj
set_property -name "options.report_unconstrained" -value "1" -objects $obj

}
# Create 'impl_1_post_place_power_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_post_place_power_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_post_place_power_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps post_place_power_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_post_place_power_opt_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj
set_property -name "options.max_paths" -value "10" -objects $obj
set_property -name "options.report_unconstrained" -value "1" -objects $obj

}
# Create 'impl_1_phys_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_phys_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_phys_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps phys_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_phys_opt_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj
set_property -name "options.max_paths" -value "10" -objects $obj
set_property -name "options.report_unconstrained" -value "1" -objects $obj

}
# Create 'impl_1_route_report_drc_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_drc_0] "" ] } {
  create_report_config -report_name impl_1_route_report_drc_0 -report_type report_drc:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_drc_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_methodology_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_methodology_0] "" ] } {
  create_report_config -report_name impl_1_route_report_methodology_0 -report_type report_methodology:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_methodology_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_power_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_power_0] "" ] } {
  create_report_config -report_name impl_1_route_report_power_0 -report_type report_power:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_power_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_route_status_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_route_status_0] "" ] } {
  create_report_config -report_name impl_1_route_report_route_status_0 -report_type report_route_status:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_route_status_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_route_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_timing_summary_0]
if { $obj != "" } {
set_property -name "options.max_paths" -value "10" -objects $obj
set_property -name "options.report_unconstrained" -value "1" -objects $obj

}
# Create 'impl_1_route_report_incremental_reuse_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_incremental_reuse_0] "" ] } {
  create_report_config -report_name impl_1_route_report_incremental_reuse_0 -report_type report_incremental_reuse:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_incremental_reuse_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_clock_utilization_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_clock_utilization_0] "" ] } {
  create_report_config -report_name impl_1_route_report_clock_utilization_0 -report_type report_clock_utilization:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_clock_utilization_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_bus_skew_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_bus_skew_0] "" ] } {
  create_report_config -report_name impl_1_route_report_bus_skew_0 -report_type report_bus_skew:1.1 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_bus_skew_0]
if { $obj != "" } {
set_property -name "options.warn_on_violation" -value "1" -objects $obj

}
# Create 'impl_1_post_route_phys_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_post_route_phys_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_post_route_phys_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps post_route_phys_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_post_route_phys_opt_report_timing_summary_0]
if { $obj != "" } {
set_property -name "options.max_paths" -value "10" -objects $obj
set_property -name "options.report_unconstrained" -value "1" -objects $obj
set_property -name "options.warn_on_violation" -value "1" -objects $obj

}
# Create 'impl_1_post_route_phys_opt_report_bus_skew_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_post_route_phys_opt_report_bus_skew_0] "" ] } {
  create_report_config -report_name impl_1_post_route_phys_opt_report_bus_skew_0 -report_type report_bus_skew:1.1 -steps post_route_phys_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_post_route_phys_opt_report_bus_skew_0]
if { $obj != "" } {
set_property -name "options.warn_on_violation" -value "1" -objects $obj

}
set obj [get_runs impl_1]
set_property -name "part" -value "xczu48dr-fsvg1517-2-e" -objects $obj
set_property -name "strategy" -value "Vivado Implementation Defaults" -objects $obj
set_property -name "steps.opt_design.args.directive" -value "NoBramPowerOpt" -objects $obj
set_property -name "steps.write_bitstream.args.readback_file" -value "0" -objects $obj
set_property -name "steps.write_bitstream.args.verbose" -value "0" -objects $obj

# set the current impl run
current_run -implementation [get_runs impl_1]
catch {
 if { $idrFlowPropertiesConstraints != {} } {
   set_param runs.disableIDRFlowPropertyConstraints $idrFlowPropertiesConstraints
 }
}

puts "INFO: Project created:${_xil_proj_name_}"
# Create 'drc_1' gadget (if not found)
if {[string equal [get_dashboard_gadgets  [ list "drc_1" ] ] ""]} {
create_dashboard_gadget -name {drc_1} -type drc
}
set obj [get_dashboard_gadgets [ list "drc_1" ] ]
set_property -name "reports" -value "impl_1#impl_1_route_report_drc_0" -objects $obj

# Create 'methodology_1' gadget (if not found)
if {[string equal [get_dashboard_gadgets  [ list "methodology_1" ] ] ""]} {
create_dashboard_gadget -name {methodology_1} -type methodology
}
set obj [get_dashboard_gadgets [ list "methodology_1" ] ]
set_property -name "reports" -value "impl_1#impl_1_route_report_methodology_0" -objects $obj

# Create 'power_1' gadget (if not found)
if {[string equal [get_dashboard_gadgets  [ list "power_1" ] ] ""]} {
create_dashboard_gadget -name {power_1} -type power
}
set obj [get_dashboard_gadgets [ list "power_1" ] ]
set_property -name "reports" -value "impl_1#impl_1_route_report_power_0" -objects $obj

# Create 'timing_1' gadget (if not found)
if {[string equal [get_dashboard_gadgets  [ list "timing_1" ] ] ""]} {
create_dashboard_gadget -name {timing_1} -type timing
}
set obj [get_dashboard_gadgets [ list "timing_1" ] ]
set_property -name "reports" -value "impl_1#impl_1_route_report_timing_summary_0" -objects $obj

# Create 'utilization_1' gadget (if not found)
if {[string equal [get_dashboard_gadgets  [ list "utilization_1" ] ] ""]} {
create_dashboard_gadget -name {utilization_1} -type utilization
}
set obj [get_dashboard_gadgets [ list "utilization_1" ] ]
set_property -name "reports" -value "synth_1#synth_1_synth_report_utilization_0" -objects $obj
set_property -name "run.step" -value "synth_design" -objects $obj
set_property -name "run.type" -value "synthesis" -objects $obj

# Create 'utilization_2' gadget (if not found)
if {[string equal [get_dashboard_gadgets  [ list "utilization_2" ] ] ""]} {
create_dashboard_gadget -name {utilization_2} -type utilization
}
set obj [get_dashboard_gadgets [ list "utilization_2" ] ]
set_property -name "reports" -value "impl_1#impl_1_place_report_utilization_0" -objects $obj

move_dashboard_gadget -name {utilization_1} -row 0 -col 0
move_dashboard_gadget -name {power_1} -row 1 -col 0
move_dashboard_gadget -name {drc_1} -row 2 -col 0
move_dashboard_gadget -name {timing_1} -row 0 -col 1
move_dashboard_gadget -name {utilization_2} -row 1 -col 1
move_dashboard_gadget -name {methodology_1} -row 2 -col 1
