
# Loading additional proc with user specified bodies to compute parameter values.
source [file join [file dirname [file dirname [info script]]] gui/clock_measurement_v1_4.gtcl]

# Definitional proc to organize widgets for parameters.
proc init_gui { IPINST } {
  ipgui::add_param $IPINST -name "Component_Name"
  #Adding Page
  set Page_0 [ipgui::add_page $IPINST -name "Page 0"]
  set NUM_CLOCKS [ipgui::add_param $IPINST -name "NUM_CLOCKS" -parent ${Page_0}]
  set_property tooltip {Number of input clocks for frequency measurement.} ${NUM_CLOCKS}
  set REF_CLOCK_FREQ_HZ [ipgui::add_param $IPINST -name "REF_CLOCK_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {Set to the frequency of the reference clock.} ${REF_CLOCK_FREQ_HZ}
  set EXPECTED_CLK_0_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_0_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 0 in Hertz, to be read by software.} ${EXPECTED_CLK_0_FREQ_HZ}
  set EXPECTED_CLK_1_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_1_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 1 in Hertz, to be read by software.} ${EXPECTED_CLK_1_FREQ_HZ}
  set EXPECTED_CLK_2_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_2_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 2 in Hertz, to be read by software.} ${EXPECTED_CLK_2_FREQ_HZ}
  set EXPECTED_CLK_3_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_3_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 3 in Hertz, to be read by software.} ${EXPECTED_CLK_3_FREQ_HZ}
  set EXPECTED_CLK_4_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_4_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 4 in Hertz, to be read by software.} ${EXPECTED_CLK_4_FREQ_HZ}
  set EXPECTED_CLK_5_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_5_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 5 in Hertz, to be read by software.} ${EXPECTED_CLK_5_FREQ_HZ}
  set EXPECTED_CLK_6_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_6_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 6 in Hertz, to be read by software.} ${EXPECTED_CLK_6_FREQ_HZ}
  set EXPECTED_CLK_7_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_7_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 7 in Hertz, to be read by software.} ${EXPECTED_CLK_7_FREQ_HZ}
  set EXPECTED_CLK_8_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_8_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 8 in Hertz, to be read by software.} ${EXPECTED_CLK_8_FREQ_HZ}
  set EXPECTED_CLK_9_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_9_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 9 in Hertz, to be read by software.} ${EXPECTED_CLK_9_FREQ_HZ}
  set EXPECTED_CLK_10_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_10_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 10 in Hertz, to be read by software.} ${EXPECTED_CLK_10_FREQ_HZ}
  set EXPECTED_CLK_11_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_11_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 11 in Hertz, to be read by software.} ${EXPECTED_CLK_11_FREQ_HZ}
  set EXPECTED_CLK_12_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_12_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 12 in Hertz, to be read by software.} ${EXPECTED_CLK_12_FREQ_HZ}
  set EXPECTED_CLK_13_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_13_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 13 in Hertz, to be read by software.} ${EXPECTED_CLK_13_FREQ_HZ}
  set EXPECTED_CLK_14_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_14_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 14 in Hertz, to be read by software.} ${EXPECTED_CLK_14_FREQ_HZ}
  set EXPECTED_CLK_15_FREQ_HZ [ipgui::add_param $IPINST -name "EXPECTED_CLK_15_FREQ_HZ" -parent ${Page_0}]
  set_property tooltip {This sets the expected clock frequency for clock 15 in Hertz, to be read by software.} ${EXPECTED_CLK_15_FREQ_HZ}
  set CLOCK_MEASUREMENT_ID [ipgui::add_param $IPINST -name "CLOCK_MEASUREMENT_ID" -parent ${Page_0}]
  set_property tooltip {This is the contents that will be read from the ID register.} ${CLOCK_MEASUREMENT_ID}


}

proc update_PARAM_VALUE.AXI_BYTES_PER_WORD { PARAM_VALUE.AXI_BYTES_PER_WORD PARAM_VALUE.AXI_BITS_PER_WORD } {
	# Procedure called to update AXI_BYTES_PER_WORD when any of the dependent parameters in the arguments change
	
	set AXI_BYTES_PER_WORD ${PARAM_VALUE.AXI_BYTES_PER_WORD}
	set AXI_BITS_PER_WORD ${PARAM_VALUE.AXI_BITS_PER_WORD}
	set values(AXI_BITS_PER_WORD) [get_property value $AXI_BITS_PER_WORD]
	set_property value [gen_USERPARAMETER_AXI_BYTES_PER_WORD_VALUE $values(AXI_BITS_PER_WORD)] $AXI_BYTES_PER_WORD
}

proc validate_PARAM_VALUE.AXI_BYTES_PER_WORD { PARAM_VALUE.AXI_BYTES_PER_WORD } {
	# Procedure called to validate AXI_BYTES_PER_WORD
	return true
}

proc update_PARAM_VALUE.AXI_BYTE_ADDR_WIDTH { PARAM_VALUE.AXI_BYTE_ADDR_WIDTH PARAM_VALUE.NUM_REGISTERS } {
	# Procedure called to update AXI_BYTE_ADDR_WIDTH when any of the dependent parameters in the arguments change
	
	set AXI_BYTE_ADDR_WIDTH ${PARAM_VALUE.AXI_BYTE_ADDR_WIDTH}
	set NUM_REGISTERS ${PARAM_VALUE.NUM_REGISTERS}
	set values(NUM_REGISTERS) [get_property value $NUM_REGISTERS]
	set_property value [gen_USERPARAMETER_AXI_BYTE_ADDR_WIDTH_VALUE $values(NUM_REGISTERS)] $AXI_BYTE_ADDR_WIDTH
}

proc validate_PARAM_VALUE.AXI_BYTE_ADDR_WIDTH { PARAM_VALUE.AXI_BYTE_ADDR_WIDTH } {
	# Procedure called to validate AXI_BYTE_ADDR_WIDTH
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_0_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_0_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_0_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_0_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_0_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_0_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_0_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_0_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_0_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_0_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_0_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_10_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_10_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_10_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_10_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_10_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_10_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_10_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_10_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_10_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_10_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_10_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_11_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_11_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_11_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_11_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_11_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_11_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_11_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_11_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_11_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_11_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_11_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_12_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_12_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_12_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_12_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_12_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_12_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_12_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_12_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_12_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_12_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_12_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_13_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_13_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_13_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_13_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_13_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_13_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_13_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_13_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_13_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_13_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_13_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_14_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_14_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_14_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_14_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_14_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_14_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_14_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_14_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_14_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_14_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_14_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_15_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_15_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_15_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_15_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_15_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_15_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_15_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_15_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_15_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_15_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_15_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_1_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_1_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_1_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_1_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_1_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_1_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_1_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_1_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_1_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_1_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_1_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_2_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_2_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_2_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_2_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_2_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_2_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_2_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_2_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_2_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_2_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_2_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_3_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_3_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_3_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_3_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_3_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_3_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_3_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_3_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_3_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_3_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_3_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_4_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_4_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_4_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_4_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_4_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_4_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_4_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_4_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_4_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_4_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_4_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_5_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_5_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_5_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_5_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_5_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_5_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_5_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_5_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_5_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_5_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_5_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_6_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_6_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_6_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_6_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_6_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_6_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_6_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_6_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_6_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_6_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_6_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_7_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_7_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_7_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_7_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_7_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_7_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_7_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_7_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_7_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_7_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_7_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_8_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_8_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_8_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_8_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_8_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_8_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_8_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_8_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_8_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_8_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_8_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.EXPECTED_CLK_9_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_9_FREQ_HZ PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update EXPECTED_CLK_9_FREQ_HZ when any of the dependent parameters in the arguments change
	
	set EXPECTED_CLK_9_FREQ_HZ ${PARAM_VALUE.EXPECTED_CLK_9_FREQ_HZ}
	set NUM_CLOCKS ${PARAM_VALUE.NUM_CLOCKS}
	set values(NUM_CLOCKS) [get_property value $NUM_CLOCKS]
	if { [gen_USERPARAMETER_EXPECTED_CLK_9_FREQ_HZ_ENABLEMENT $values(NUM_CLOCKS)] } {
		set_property enabled true $EXPECTED_CLK_9_FREQ_HZ
	} else {
		set_property enabled false $EXPECTED_CLK_9_FREQ_HZ
	}
}

proc validate_PARAM_VALUE.EXPECTED_CLK_9_FREQ_HZ { PARAM_VALUE.EXPECTED_CLK_9_FREQ_HZ } {
	# Procedure called to validate EXPECTED_CLK_9_FREQ_HZ
	return true
}

proc update_PARAM_VALUE.AXI_BITS_PER_WORD { PARAM_VALUE.AXI_BITS_PER_WORD } {
	# Procedure called to update AXI_BITS_PER_WORD when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.AXI_BITS_PER_WORD { PARAM_VALUE.AXI_BITS_PER_WORD } {
	# Procedure called to validate AXI_BITS_PER_WORD
	return true
}

proc update_PARAM_VALUE.CLOCK_MEASUREMENT_ID { PARAM_VALUE.CLOCK_MEASUREMENT_ID } {
	# Procedure called to update CLOCK_MEASUREMENT_ID when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.CLOCK_MEASUREMENT_ID { PARAM_VALUE.CLOCK_MEASUREMENT_ID } {
	# Procedure called to validate CLOCK_MEASUREMENT_ID
	return true
}

proc update_PARAM_VALUE.NUM_CLOCKS { PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to update NUM_CLOCKS when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.NUM_CLOCKS { PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to validate NUM_CLOCKS
	return true
}

proc update_PARAM_VALUE.NUM_REGISTERS { PARAM_VALUE.NUM_REGISTERS } {
	# Procedure called to update NUM_REGISTERS when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.NUM_REGISTERS { PARAM_VALUE.NUM_REGISTERS } {
	# Procedure called to validate NUM_REGISTERS
	return true
}

proc update_PARAM_VALUE.REF_CLOCK_FREQ_HZ { PARAM_VALUE.REF_CLOCK_FREQ_HZ } {
	# Procedure called to update REF_CLOCK_FREQ_HZ when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.REF_CLOCK_FREQ_HZ { PARAM_VALUE.REF_CLOCK_FREQ_HZ } {
	# Procedure called to validate REF_CLOCK_FREQ_HZ
	return true
}


proc update_MODELPARAM_VALUE.NUM_CLOCKS { MODELPARAM_VALUE.NUM_CLOCKS PARAM_VALUE.NUM_CLOCKS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.NUM_CLOCKS}] ${MODELPARAM_VALUE.NUM_CLOCKS}
}

proc update_MODELPARAM_VALUE.REF_CLOCK_FREQ_HZ { MODELPARAM_VALUE.REF_CLOCK_FREQ_HZ PARAM_VALUE.REF_CLOCK_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.REF_CLOCK_FREQ_HZ}] ${MODELPARAM_VALUE.REF_CLOCK_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_0_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_0_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_0_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_0_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_0_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_1_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_1_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_1_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_1_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_1_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_2_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_2_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_2_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_2_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_2_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_3_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_3_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_3_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_3_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_3_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_4_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_4_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_4_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_4_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_4_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_5_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_5_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_5_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_5_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_5_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_6_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_6_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_6_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_6_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_6_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_7_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_7_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_7_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_7_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_7_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_8_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_8_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_8_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_8_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_8_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_9_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_9_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_9_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_9_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_9_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_10_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_10_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_10_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_10_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_10_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_11_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_11_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_11_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_11_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_11_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_12_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_12_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_12_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_12_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_12_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_13_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_13_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_13_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_13_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_13_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_14_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_14_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_14_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_14_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_14_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.EXPECTED_CLK_15_FREQ_HZ { MODELPARAM_VALUE.EXPECTED_CLK_15_FREQ_HZ PARAM_VALUE.EXPECTED_CLK_15_FREQ_HZ } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXPECTED_CLK_15_FREQ_HZ}] ${MODELPARAM_VALUE.EXPECTED_CLK_15_FREQ_HZ}
}

proc update_MODELPARAM_VALUE.CLOCK_MEASUREMENT_ID { MODELPARAM_VALUE.CLOCK_MEASUREMENT_ID PARAM_VALUE.CLOCK_MEASUREMENT_ID } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.CLOCK_MEASUREMENT_ID}] ${MODELPARAM_VALUE.CLOCK_MEASUREMENT_ID}
}

proc update_MODELPARAM_VALUE.AXI_BITS_PER_WORD { MODELPARAM_VALUE.AXI_BITS_PER_WORD PARAM_VALUE.AXI_BITS_PER_WORD } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.AXI_BITS_PER_WORD}] ${MODELPARAM_VALUE.AXI_BITS_PER_WORD}
}

proc update_MODELPARAM_VALUE.AXI_BYTES_PER_WORD { MODELPARAM_VALUE.AXI_BYTES_PER_WORD PARAM_VALUE.AXI_BYTES_PER_WORD } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.AXI_BYTES_PER_WORD}] ${MODELPARAM_VALUE.AXI_BYTES_PER_WORD}
}

proc update_MODELPARAM_VALUE.NUM_REGISTERS { MODELPARAM_VALUE.NUM_REGISTERS PARAM_VALUE.NUM_REGISTERS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.NUM_REGISTERS}] ${MODELPARAM_VALUE.NUM_REGISTERS}
}

proc update_MODELPARAM_VALUE.AXI_BYTE_ADDR_WIDTH { MODELPARAM_VALUE.AXI_BYTE_ADDR_WIDTH PARAM_VALUE.AXI_BYTE_ADDR_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.AXI_BYTE_ADDR_WIDTH}] ${MODELPARAM_VALUE.AXI_BYTE_ADDR_WIDTH}
}

