
# Loading additional proc with user specified bodies to compute parameter values.
source [file join [file dirname [file dirname [info script]]] gui/sample_interleave_v1_0.gtcl]

# Definitional proc to organize widgets for parameters.
proc init_gui { IPINST } {
  ipgui::add_param $IPINST -name "Component_Name"
  #Adding Page
  set Page_0 [ipgui::add_page $IPINST -name "Page 0"]
  ipgui::add_param $IPINST -name "BITS_PER_SAMPLE" -parent ${Page_0}
  ipgui::add_param $IPINST -name "IN_SAMPLES_PER_CLOCK" -parent ${Page_0}
  ipgui::add_param $IPINST -name "MULTIPLIER" -parent ${Page_0}
  ipgui::add_param $IPINST -name "OUT_SAMPLES_PER_CLOCK" -parent ${Page_0}
  ipgui::add_param $IPINST -name "TDEST_WIDTH" -parent ${Page_0}
  ipgui::add_param $IPINST -name "TID_WIDTH" -parent ${Page_0}


}

proc update_PARAM_VALUE.IN_AXIS_BUS_WIDTH { PARAM_VALUE.IN_AXIS_BUS_WIDTH PARAM_VALUE.BITS_PER_SAMPLE PARAM_VALUE.IN_SAMPLES_PER_CLOCK } {
	# Procedure called to update IN_AXIS_BUS_WIDTH when any of the dependent parameters in the arguments change
	
	set IN_AXIS_BUS_WIDTH ${PARAM_VALUE.IN_AXIS_BUS_WIDTH}
	set BITS_PER_SAMPLE ${PARAM_VALUE.BITS_PER_SAMPLE}
	set IN_SAMPLES_PER_CLOCK ${PARAM_VALUE.IN_SAMPLES_PER_CLOCK}
	set values(BITS_PER_SAMPLE) [get_property value $BITS_PER_SAMPLE]
	set values(IN_SAMPLES_PER_CLOCK) [get_property value $IN_SAMPLES_PER_CLOCK]
	set_property value [gen_USERPARAMETER_IN_AXIS_BUS_WIDTH_VALUE $values(BITS_PER_SAMPLE) $values(IN_SAMPLES_PER_CLOCK)] $IN_AXIS_BUS_WIDTH
}

proc validate_PARAM_VALUE.IN_AXIS_BUS_WIDTH { PARAM_VALUE.IN_AXIS_BUS_WIDTH } {
	# Procedure called to validate IN_AXIS_BUS_WIDTH
	return true
}

proc update_PARAM_VALUE.OUT_AXIS_BUS_WIDTH { PARAM_VALUE.OUT_AXIS_BUS_WIDTH PARAM_VALUE.BITS_PER_SAMPLE PARAM_VALUE.OUT_SAMPLES_PER_CLOCK } {
	# Procedure called to update OUT_AXIS_BUS_WIDTH when any of the dependent parameters in the arguments change
	
	set OUT_AXIS_BUS_WIDTH ${PARAM_VALUE.OUT_AXIS_BUS_WIDTH}
	set BITS_PER_SAMPLE ${PARAM_VALUE.BITS_PER_SAMPLE}
	set OUT_SAMPLES_PER_CLOCK ${PARAM_VALUE.OUT_SAMPLES_PER_CLOCK}
	set values(BITS_PER_SAMPLE) [get_property value $BITS_PER_SAMPLE]
	set values(OUT_SAMPLES_PER_CLOCK) [get_property value $OUT_SAMPLES_PER_CLOCK]
	set_property value [gen_USERPARAMETER_OUT_AXIS_BUS_WIDTH_VALUE $values(BITS_PER_SAMPLE) $values(OUT_SAMPLES_PER_CLOCK)] $OUT_AXIS_BUS_WIDTH
}

proc validate_PARAM_VALUE.OUT_AXIS_BUS_WIDTH { PARAM_VALUE.OUT_AXIS_BUS_WIDTH } {
	# Procedure called to validate OUT_AXIS_BUS_WIDTH
	return true
}

proc update_PARAM_VALUE.OUT_SAMPLES_PER_CLOCK { PARAM_VALUE.OUT_SAMPLES_PER_CLOCK PARAM_VALUE.MULTIPLIER PARAM_VALUE.IN_SAMPLES_PER_CLOCK } {
	# Procedure called to update OUT_SAMPLES_PER_CLOCK when any of the dependent parameters in the arguments change
	
	set OUT_SAMPLES_PER_CLOCK ${PARAM_VALUE.OUT_SAMPLES_PER_CLOCK}
	set MULTIPLIER ${PARAM_VALUE.MULTIPLIER}
	set IN_SAMPLES_PER_CLOCK ${PARAM_VALUE.IN_SAMPLES_PER_CLOCK}
	set values(MULTIPLIER) [get_property value $MULTIPLIER]
	set values(IN_SAMPLES_PER_CLOCK) [get_property value $IN_SAMPLES_PER_CLOCK]
	set_property value [gen_USERPARAMETER_OUT_SAMPLES_PER_CLOCK_VALUE $values(MULTIPLIER) $values(IN_SAMPLES_PER_CLOCK)] $OUT_SAMPLES_PER_CLOCK
}

proc validate_PARAM_VALUE.OUT_SAMPLES_PER_CLOCK { PARAM_VALUE.OUT_SAMPLES_PER_CLOCK } {
	# Procedure called to validate OUT_SAMPLES_PER_CLOCK
	return true
}

proc update_PARAM_VALUE.TDEST_DUMMY_WIDTH { PARAM_VALUE.TDEST_DUMMY_WIDTH PARAM_VALUE.TDEST_WIDTH } {
	# Procedure called to update TDEST_DUMMY_WIDTH when any of the dependent parameters in the arguments change
	
	set TDEST_DUMMY_WIDTH ${PARAM_VALUE.TDEST_DUMMY_WIDTH}
	set TDEST_WIDTH ${PARAM_VALUE.TDEST_WIDTH}
	set values(TDEST_WIDTH) [get_property value $TDEST_WIDTH]
	set_property value [gen_USERPARAMETER_TDEST_DUMMY_WIDTH_VALUE $values(TDEST_WIDTH)] $TDEST_DUMMY_WIDTH
}

proc validate_PARAM_VALUE.TDEST_DUMMY_WIDTH { PARAM_VALUE.TDEST_DUMMY_WIDTH } {
	# Procedure called to validate TDEST_DUMMY_WIDTH
	return true
}

proc update_PARAM_VALUE.TID_DUMMY_WIDTH { PARAM_VALUE.TID_DUMMY_WIDTH PARAM_VALUE.TID_WIDTH } {
	# Procedure called to update TID_DUMMY_WIDTH when any of the dependent parameters in the arguments change
	
	set TID_DUMMY_WIDTH ${PARAM_VALUE.TID_DUMMY_WIDTH}
	set TID_WIDTH ${PARAM_VALUE.TID_WIDTH}
	set values(TID_WIDTH) [get_property value $TID_WIDTH]
	set_property value [gen_USERPARAMETER_TID_DUMMY_WIDTH_VALUE $values(TID_WIDTH)] $TID_DUMMY_WIDTH
}

proc validate_PARAM_VALUE.TID_DUMMY_WIDTH { PARAM_VALUE.TID_DUMMY_WIDTH } {
	# Procedure called to validate TID_DUMMY_WIDTH
	return true
}

proc update_PARAM_VALUE.BITS_PER_SAMPLE { PARAM_VALUE.BITS_PER_SAMPLE } {
	# Procedure called to update BITS_PER_SAMPLE when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.BITS_PER_SAMPLE { PARAM_VALUE.BITS_PER_SAMPLE } {
	# Procedure called to validate BITS_PER_SAMPLE
	return true
}

proc update_PARAM_VALUE.IN_SAMPLES_PER_CLOCK { PARAM_VALUE.IN_SAMPLES_PER_CLOCK } {
	# Procedure called to update IN_SAMPLES_PER_CLOCK when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.IN_SAMPLES_PER_CLOCK { PARAM_VALUE.IN_SAMPLES_PER_CLOCK } {
	# Procedure called to validate IN_SAMPLES_PER_CLOCK
	return true
}

proc update_PARAM_VALUE.MULTIPLIER { PARAM_VALUE.MULTIPLIER } {
	# Procedure called to update MULTIPLIER when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.MULTIPLIER { PARAM_VALUE.MULTIPLIER } {
	# Procedure called to validate MULTIPLIER
	return true
}

proc update_PARAM_VALUE.TDEST_WIDTH { PARAM_VALUE.TDEST_WIDTH } {
	# Procedure called to update TDEST_WIDTH when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.TDEST_WIDTH { PARAM_VALUE.TDEST_WIDTH } {
	# Procedure called to validate TDEST_WIDTH
	return true
}

proc update_PARAM_VALUE.TID_WIDTH { PARAM_VALUE.TID_WIDTH } {
	# Procedure called to update TID_WIDTH when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.TID_WIDTH { PARAM_VALUE.TID_WIDTH } {
	# Procedure called to validate TID_WIDTH
	return true
}


proc update_MODELPARAM_VALUE.IN_SAMPLES_PER_CLOCK { MODELPARAM_VALUE.IN_SAMPLES_PER_CLOCK PARAM_VALUE.IN_SAMPLES_PER_CLOCK } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.IN_SAMPLES_PER_CLOCK}] ${MODELPARAM_VALUE.IN_SAMPLES_PER_CLOCK}
}

proc update_MODELPARAM_VALUE.BITS_PER_SAMPLE { MODELPARAM_VALUE.BITS_PER_SAMPLE PARAM_VALUE.BITS_PER_SAMPLE } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.BITS_PER_SAMPLE}] ${MODELPARAM_VALUE.BITS_PER_SAMPLE}
}

proc update_MODELPARAM_VALUE.MULTIPLIER { MODELPARAM_VALUE.MULTIPLIER PARAM_VALUE.MULTIPLIER } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.MULTIPLIER}] ${MODELPARAM_VALUE.MULTIPLIER}
}

proc update_MODELPARAM_VALUE.TID_WIDTH { MODELPARAM_VALUE.TID_WIDTH PARAM_VALUE.TID_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TID_WIDTH}] ${MODELPARAM_VALUE.TID_WIDTH}
}

proc update_MODELPARAM_VALUE.TDEST_WIDTH { MODELPARAM_VALUE.TDEST_WIDTH PARAM_VALUE.TDEST_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TDEST_WIDTH}] ${MODELPARAM_VALUE.TDEST_WIDTH}
}

proc update_MODELPARAM_VALUE.OUT_SAMPLES_PER_CLOCK { MODELPARAM_VALUE.OUT_SAMPLES_PER_CLOCK PARAM_VALUE.OUT_SAMPLES_PER_CLOCK } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.OUT_SAMPLES_PER_CLOCK}] ${MODELPARAM_VALUE.OUT_SAMPLES_PER_CLOCK}
}

proc update_MODELPARAM_VALUE.IN_AXIS_BUS_WIDTH { MODELPARAM_VALUE.IN_AXIS_BUS_WIDTH PARAM_VALUE.IN_AXIS_BUS_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.IN_AXIS_BUS_WIDTH}] ${MODELPARAM_VALUE.IN_AXIS_BUS_WIDTH}
}

proc update_MODELPARAM_VALUE.OUT_AXIS_BUS_WIDTH { MODELPARAM_VALUE.OUT_AXIS_BUS_WIDTH PARAM_VALUE.OUT_AXIS_BUS_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.OUT_AXIS_BUS_WIDTH}] ${MODELPARAM_VALUE.OUT_AXIS_BUS_WIDTH}
}

proc update_MODELPARAM_VALUE.TID_DUMMY_WIDTH { MODELPARAM_VALUE.TID_DUMMY_WIDTH PARAM_VALUE.TID_DUMMY_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TID_DUMMY_WIDTH}] ${MODELPARAM_VALUE.TID_DUMMY_WIDTH}
}

proc update_MODELPARAM_VALUE.TDEST_DUMMY_WIDTH { MODELPARAM_VALUE.TDEST_DUMMY_WIDTH PARAM_VALUE.TDEST_DUMMY_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TDEST_DUMMY_WIDTH}] ${MODELPARAM_VALUE.TDEST_DUMMY_WIDTH}
}

