
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2018-2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use, distribute, and modify
// this work, so long as such uses are non-commercial in nature,
// so long as any derived works are offered on the same terms,
// and so long as attribution is given to the original author.
// For further details, see the Creative Commons License
// "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

`define w assign
`define r always@(posedge clk)

   
(* DONT_TOUCH = "YES" *)
module delay_with_reset
  #( 
     parameter   DELAY                = 0,
     parameter   BIT_WIDTH            = 1,

     parameter  TOTAL_BITS            = BIT_WIDTH*DELAY,
     parameter  SHIFTED_BITS          = TOTAL_BITS - BIT_WIDTH
   )
   (
    input                  reset,
    input                  clk,
    input [BIT_WIDTH-1:0]  in_i,
    output [BIT_WIDTH-1:0] out_o
   );

   generate
      if(DELAY==0)
        begin
           `w out_o = in_i;
        end
      else if(DELAY==1)
        begin
           reg [BIT_WIDTH-1:0] buffer_r = 0;
           `r buffer_r <= reset ? 0 : in_i;
           `w out_o = buffer_r;
        end
      else
        begin
           reg [TOTAL_BITS-1:0] buffer_r = 0;
           `r buffer_r <= reset ? 0 : { buffer_r[SHIFTED_BITS-1:0], in_i };
           `w out_o = buffer_r[SHIFTED_BITS +: BIT_WIDTH];
        end

   endgenerate
            
endmodule // delay

