
# Loading additional proc with user specified bodies to compute parameter values.
source [file join [file dirname [file dirname [info script]]] gui/spectral_capture_96000R_12_v1_2.gtcl]

# Definitional proc to organize widgets for parameters.
proc init_gui { IPINST } {
  ipgui::add_param $IPINST -name "Component_Name"
  #Adding Page
  set Page_0 [ipgui::add_page $IPINST -name "Page 0"]
  ipgui::add_param $IPINST -name "AXIS_BITS_PER_SAMPLE" -parent ${Page_0}
  ipgui::add_param $IPINST -name "AXIS_SAMPLES_PER_CLOCK" -parent ${Page_0}
  ipgui::add_param $IPINST -name "AXI_BITS_PER_WORD" -parent ${Page_0}
  ipgui::add_param $IPINST -name "AXI_BYTES_PER_WORD" -parent ${Page_0}
  ipgui::add_param $IPINST -name "EXTERNAL_CAPTURE_DELAY" -parent ${Page_0} -widget checkBox
  ipgui::add_param $IPINST -name "EXTERNAL_COLLECT" -parent ${Page_0} -widget checkBox
  set READ_DELAYS [ipgui::add_param $IPINST -name "READ_DELAYS" -parent ${Page_0}]
  set_property tooltip {Number of extra delays in the read path.  If the AXI-S clock is slow or the AXI clock is fast, more delays are needed.} ${READ_DELAYS}
  ipgui::add_param $IPINST -name "STATIC_SHIFTS" -parent ${Page_0}


}

proc update_PARAM_VALUE.AXIS_BUS_WIDTH { PARAM_VALUE.AXIS_BUS_WIDTH PARAM_VALUE.AXIS_BITS_PER_SAMPLE PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK } {
	# Procedure called to update AXIS_BUS_WIDTH when any of the dependent parameters in the arguments change
	
	set AXIS_BUS_WIDTH ${PARAM_VALUE.AXIS_BUS_WIDTH}
	set AXIS_BITS_PER_SAMPLE ${PARAM_VALUE.AXIS_BITS_PER_SAMPLE}
	set AXIS_SAMPLES_PER_CLOCK ${PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK}
	set values(AXIS_BITS_PER_SAMPLE) [get_property value $AXIS_BITS_PER_SAMPLE]
	set values(AXIS_SAMPLES_PER_CLOCK) [get_property value $AXIS_SAMPLES_PER_CLOCK]
	set_property value [gen_USERPARAMETER_AXIS_BUS_WIDTH_VALUE $values(AXIS_BITS_PER_SAMPLE) $values(AXIS_SAMPLES_PER_CLOCK)] $AXIS_BUS_WIDTH
}

proc validate_PARAM_VALUE.AXIS_BUS_WIDTH { PARAM_VALUE.AXIS_BUS_WIDTH } {
	# Procedure called to validate AXIS_BUS_WIDTH
	return true
}

proc update_PARAM_VALUE.AXI_BYTES_PER_WORD { PARAM_VALUE.AXI_BYTES_PER_WORD PARAM_VALUE.AXI_BITS_PER_WORD } {
	# Procedure called to update AXI_BYTES_PER_WORD when any of the dependent parameters in the arguments change
	
	set AXI_BYTES_PER_WORD ${PARAM_VALUE.AXI_BYTES_PER_WORD}
	set AXI_BITS_PER_WORD ${PARAM_VALUE.AXI_BITS_PER_WORD}
	set values(AXI_BITS_PER_WORD) [get_property value $AXI_BITS_PER_WORD]
	set_property value [gen_USERPARAMETER_AXI_BYTES_PER_WORD_VALUE $values(AXI_BITS_PER_WORD)] $AXI_BYTES_PER_WORD
}

proc validate_PARAM_VALUE.AXI_BYTES_PER_WORD { PARAM_VALUE.AXI_BYTES_PER_WORD } {
	# Procedure called to validate AXI_BYTES_PER_WORD
	return true
}

proc update_PARAM_VALUE.AXIS_BITS_PER_SAMPLE { PARAM_VALUE.AXIS_BITS_PER_SAMPLE } {
	# Procedure called to update AXIS_BITS_PER_SAMPLE when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.AXIS_BITS_PER_SAMPLE { PARAM_VALUE.AXIS_BITS_PER_SAMPLE } {
	# Procedure called to validate AXIS_BITS_PER_SAMPLE
	return true
}

proc update_PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK { PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK } {
	# Procedure called to update AXIS_SAMPLES_PER_CLOCK when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK { PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK } {
	# Procedure called to validate AXIS_SAMPLES_PER_CLOCK
	return true
}

proc update_PARAM_VALUE.AXI_BITS_PER_WORD { PARAM_VALUE.AXI_BITS_PER_WORD } {
	# Procedure called to update AXI_BITS_PER_WORD when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.AXI_BITS_PER_WORD { PARAM_VALUE.AXI_BITS_PER_WORD } {
	# Procedure called to validate AXI_BITS_PER_WORD
	return true
}

proc update_PARAM_VALUE.AXI_BYTE_ADDR_WIDTH_PLUS { PARAM_VALUE.AXI_BYTE_ADDR_WIDTH_PLUS } {
	# Procedure called to update AXI_BYTE_ADDR_WIDTH_PLUS when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.AXI_BYTE_ADDR_WIDTH_PLUS { PARAM_VALUE.AXI_BYTE_ADDR_WIDTH_PLUS } {
	# Procedure called to validate AXI_BYTE_ADDR_WIDTH_PLUS
	return true
}

proc update_PARAM_VALUE.EXTERNAL_CAPTURE_DELAY { PARAM_VALUE.EXTERNAL_CAPTURE_DELAY } {
	# Procedure called to update EXTERNAL_CAPTURE_DELAY when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.EXTERNAL_CAPTURE_DELAY { PARAM_VALUE.EXTERNAL_CAPTURE_DELAY } {
	# Procedure called to validate EXTERNAL_CAPTURE_DELAY
	return true
}

proc update_PARAM_VALUE.EXTERNAL_COLLECT { PARAM_VALUE.EXTERNAL_COLLECT } {
	# Procedure called to update EXTERNAL_COLLECT when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.EXTERNAL_COLLECT { PARAM_VALUE.EXTERNAL_COLLECT } {
	# Procedure called to validate EXTERNAL_COLLECT
	return true
}

proc update_PARAM_VALUE.READ_DELAYS { PARAM_VALUE.READ_DELAYS } {
	# Procedure called to update READ_DELAYS when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.READ_DELAYS { PARAM_VALUE.READ_DELAYS } {
	# Procedure called to validate READ_DELAYS
	return true
}

proc update_PARAM_VALUE.STATIC_SHIFTS { PARAM_VALUE.STATIC_SHIFTS } {
	# Procedure called to update STATIC_SHIFTS when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.STATIC_SHIFTS { PARAM_VALUE.STATIC_SHIFTS } {
	# Procedure called to validate STATIC_SHIFTS
	return true
}


proc update_MODELPARAM_VALUE.AXIS_SAMPLES_PER_CLOCK { MODELPARAM_VALUE.AXIS_SAMPLES_PER_CLOCK PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.AXIS_SAMPLES_PER_CLOCK}] ${MODELPARAM_VALUE.AXIS_SAMPLES_PER_CLOCK}
}

proc update_MODELPARAM_VALUE.AXIS_BITS_PER_SAMPLE { MODELPARAM_VALUE.AXIS_BITS_PER_SAMPLE PARAM_VALUE.AXIS_BITS_PER_SAMPLE } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.AXIS_BITS_PER_SAMPLE}] ${MODELPARAM_VALUE.AXIS_BITS_PER_SAMPLE}
}

proc update_MODELPARAM_VALUE.AXIS_BUS_WIDTH { MODELPARAM_VALUE.AXIS_BUS_WIDTH PARAM_VALUE.AXIS_BUS_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.AXIS_BUS_WIDTH}] ${MODELPARAM_VALUE.AXIS_BUS_WIDTH}
}

proc update_MODELPARAM_VALUE.AXI_BITS_PER_WORD { MODELPARAM_VALUE.AXI_BITS_PER_WORD PARAM_VALUE.AXI_BITS_PER_WORD } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.AXI_BITS_PER_WORD}] ${MODELPARAM_VALUE.AXI_BITS_PER_WORD}
}

proc update_MODELPARAM_VALUE.AXI_BYTES_PER_WORD { MODELPARAM_VALUE.AXI_BYTES_PER_WORD PARAM_VALUE.AXI_BYTES_PER_WORD } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.AXI_BYTES_PER_WORD}] ${MODELPARAM_VALUE.AXI_BYTES_PER_WORD}
}

proc update_MODELPARAM_VALUE.AXI_BYTE_ADDR_WIDTH_PLUS { MODELPARAM_VALUE.AXI_BYTE_ADDR_WIDTH_PLUS PARAM_VALUE.AXI_BYTE_ADDR_WIDTH_PLUS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.AXI_BYTE_ADDR_WIDTH_PLUS}] ${MODELPARAM_VALUE.AXI_BYTE_ADDR_WIDTH_PLUS}
}

proc update_MODELPARAM_VALUE.EXTERNAL_COLLECT { MODELPARAM_VALUE.EXTERNAL_COLLECT PARAM_VALUE.EXTERNAL_COLLECT } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXTERNAL_COLLECT}] ${MODELPARAM_VALUE.EXTERNAL_COLLECT}
}

proc update_MODELPARAM_VALUE.EXTERNAL_CAPTURE_DELAY { MODELPARAM_VALUE.EXTERNAL_CAPTURE_DELAY PARAM_VALUE.EXTERNAL_CAPTURE_DELAY } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EXTERNAL_CAPTURE_DELAY}] ${MODELPARAM_VALUE.EXTERNAL_CAPTURE_DELAY}
}

proc update_MODELPARAM_VALUE.READ_DELAYS { MODELPARAM_VALUE.READ_DELAYS PARAM_VALUE.READ_DELAYS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.READ_DELAYS}] ${MODELPARAM_VALUE.READ_DELAYS}
}

proc update_MODELPARAM_VALUE.STATIC_SHIFTS { MODELPARAM_VALUE.STATIC_SHIFTS PARAM_VALUE.STATIC_SHIFTS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.STATIC_SHIFTS}] ${MODELPARAM_VALUE.STATIC_SHIFTS}
}

