
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2021-2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use, distribute, and modify
// this work, so long as such uses are non-commercial in nature,
// so long as any derived works are offered on the same terms,
// and so long as attribution is given to the original author.
// For further details, see the Creative Commons License
// "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//


`timescale 1ps / 1ps

`define w assign
`define r always@(posedge clk)


module pn32
  #(
    parameter   PN_TAP = 27
    )
   (
    input      clk,
    input      enable,
    input      in_i,
    output reg out_o
    );

   reg [31:0]    pn_r           = 0;
   wire          pn_in_w;

   initial out_o = 1;

   `w pn_in_w = in_i ^ out_o ^ pn_r[PN_TAP];
   `r pn_r <= enable ? { pn_r, pn_in_w } : pn_r;
   `r out_o <= pn_r[PN_TAP];
   
endmodule
