
set_property -dict {PACKAGE_PIN B9    IOSTANDARD LVDS_25 } [get_ports clk104_pl_sysref_clk_n]
set_property -dict {PACKAGE_PIN B10   IOSTANDARD LVDS_25 } [get_ports clk104_pl_sysref_clk_p]


#
# Kept just to remember how to do it, when using external pins.
# don't expect these to match anything for any particular board.
#
#set_property IOSTANDARD LVDS [get_ports pl_sysref_0_clk_p]
#set_property PACKAGE_PIN AK17 [get_ports pl_sysref_0_clk_p]
#set_property DIFF_TERM_ADV TERM_100 [get_ports pl_sysref_0_clk_p]
#
#set_property IOSTANDARD LVCMOS18 [get_ports led_bit0]
#set_property PACKAGE_PIN AR13    [get_ports led_bit0]



#
# The attribute FALSE_PATH_DEST is not a Vivado-supported
# attribute.  However, Vivado does keep it and carry it along
# with registers that are marked with it.  So here we can
# use TCL commands to find those registers marked as FALSE_PATH_DEST
# in the source code, and set all paths to them as false paths.
# Thus the source code label is made to have an effect with this command.
#
# This allows the path between clocks in synchronizers to be marked
# as false in the source code, since they have been carefully designed
# in the source code to recover from any timing issues.
#
set_false_path -to [get_cells -hier -filter {(FALSE_PATH_DEST == 1)}]

