#!/bin/bash

TOPDIRS=.

if [ $# -ge 1 ]; then
    TOPDIRS="$*"
fi

print_it()
{
    TOPDIR=$1
    CHIP=$2

    FILES=$TOPDIR/*_0.0??/vivado.log
    
    for F in $FILES ; do

	DIR=`dirname "$F"`

	TOP=`echo $DIR | sed 's@^[.]/@@'`
	
	file="${TOP}/vivado.log"
        
	PART=`grep "Loading part" $file | sed 's/.*part[ ]*//' | sort -u`
	
	#echo "TOPX is \"$TOPX\", CHIP is \"$CHIP\""    1>&2
	#echo "file is \"$file\", PART is \"$PART\""  1>&2
	
	if [ "$PART" != "$CHIP" ]; then
	    #echo "Directory \"$TOP\" Part to Chip mismatch, PART=\"$PART\" vs CHIP=\"$CHIP\"." 1>&2
            continue
	fi
	
	if [ -f $TOP/*.bin ]; then
	    STATUS=GOOD
	else
	    STATUS=BAD
	fi
	
	TMFILE=`find "$TOP" -name '*timing_summary_routed.rpt' 2>/dev/null`
	
	if [ ! -f "$TMFILE" ]; then
	    
	    STATUS=BAD
	    Source=""
	    Destination=""
	    Freq=0
	    #echo "Missing timing file in directory \"$TOP\"" 1>&2
            continue
	    
	else

	    #
	    # With multiple clocks in a design, look only at the performance of the one that is typically worst
	    # for a quick summary.
	    #
	    Period=`egrep '^[ ]*RFDAC2_CLK' "$TMFILE" 2>/dev/null | head -1 | sed 's/.*[}]//; s/^[^0-9]*//; s/[ ].*//'`
	    
	      #echo Target period is $Period ns
	    
	    Slack=`cat "$TMFILE" | sed '/Inter Clock/q' | egrep '^[ ]*RFDAC2_CLK'  2>/dev/null | tail -1 | sed 's/^[ ]*[^ ]*[ ]*//; s/[ ].*//'`
	    
	    #echo Timing slack is $Slack ns

            
	    if [ "$Period" != "" ]; then
		TargetFreq=`echo "1000 / $Period" | bc -l`
	    else
		TargetFreq=0
	    fi

	    if [ "$Period" != "" -a "$Slack" != "" ]; then
		Freq=`echo "1000 / ( $Period - $Slack )" | bc -l`
	    else
		Freq=0
	    fi
            
	    #echo Frequency is $Freq MHz 1>&2
	    
	    Source=`cat $TMFILE | sed '/VIOLATED/{s/.*:[ ]*//;s/[ ].*//;n;n;s/.*//;n;p};d' | grep 'Source:' 2>/dev/null | head -1 | sed 's/.*:[ ]*//'`
	    
	    Destination=`cat $TMFILE | sed '/VIOLATED/{s/.*:[ ]*//;s/[ ].*//;n;n;s/.*//;n;p};d' | egrep 'Destination:' 2>/dev/null | head -1 | sed 's/.*:[ ]*//'`

	    if [ "$Source" = "" ]; then
		Source="NO TIMING VIOLATION"
		Destination="NO TIMING VIOLATION"
	    fi
	    
	    #echo Source is      $Source
	    #echo Destination is $Destination
            
	fi

	TOPNUM=`echo $TOP | sed 's/.*_//; s@/.*@@'`

	if [ "$STATUS" = GOOD ]; then
	    STATUS=`printf "%6.2fMHz" $TargetFreq`
	fi
	
	printf "%5s  %9s %7.1fMHz   From: %sXXXX" "$TOPNUM" "$STATUS"  $Freq "$Source"
	printf "                                To: %s\n"  "$Destination"
    done
}




for TOPDIR in $TOPDIRS; do
  for file in ${TOPDIR}/*_0.0??/vivado.log; do
      #CHIP=`head -1 $file | sed 's/.*"-device"[ ]*"//; s/".*//' | sed y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/`
      CHIP=`grep "Loading part" $file | sed 's/.*part[ ]*//'`
      CHIPS="$CHIPS $CHIP"
  done
done

CHIPS=`(for i in $CHIPS; do echo $i; done) | sort -u`

#echo "CHIPS are $CHIPS" 1>&2

for CHIP in $CHIPS; do

    echo ""
    echo   "***********************************************************************************************************"
    printf "**                                  %30s                                       **\n" $CHIP
    echo   "***********************************************************************************************************"
    
    echo ""
    echo "DIRECTORY  TARGET   Speed     Limiting Path"

    for TOPDIR in $TOPDIRS; do

	#DIRS=`ls -d $TOP/FFT*/*.bit 2>/dev/null | grep -i $DIRECTION | grep -i $TYPE`
        #DIRS=`ls -d */*/FFT*/vivado.log 2>/dev/null | grep -i $DIRECTION | grep -i $TYPE`
	
	    
	print_it $TOPDIR $CHIP | sort -k3nr | sed 's/XXXX/\
/'	    

    done

    echo ""

done

