#!/bin/sh

#
# Must be run as root
#
if [ `id -u` != "0" ]; then
    echo ""
    echo "This script must be run as root.  Use sudo."
    echo ""
    exit 20
fi

ROOT_NOPATH=STYNQ_filesystem
ROOT="$PWD/$ROOT_NOPATH"
BACKUP=$ROOT_NOPATH.tgz

#
# These umounts are in case the script is re-run after a failure.
# in that case, these may be left mounted.  They should not be mounted
# as we start again, so umount them just in case.  Failures in the
# umount are likely.
#
umount "$ROOT"/sys  >/dev/null 2>&1 || true
umount "$ROOT"/dev  >/dev/null 2>&1 || true
umount "$ROOT"/proc >/dev/null 2>&1 || true

umount "$ROOT"/sys  >/dev/null 2>&1 || true
umount "$ROOT"/dev  >/dev/null 2>&1 || true
umount "$ROOT"/proc >/dev/null 2>&1 || true

sudo rm -rf "$ROOT"

rm -f *~ "$BACKUP"
