#
# (C) Copyright 2007-2012 PetaLogix Qld Pty Ltd
# Based on original code:
# (C) Copyright 2007-2014 Michal Simek
# (C) Copyright 2014-2022 Xilinx, Inc.
# (C) Copyright 2022 Advanced Micro Devices, Inc. All Rights Reserved.
#
# Michal SIMEK <monstr@monstr.eu>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#

proc generate {drv_handle} {
    # try to source the common tcl procs
    # assuming the order of return is based on repo priority
    foreach i [get_sw_cores device_tree] {
        set common_tcl_file "[get_property "REPOSITORY" $i]/data/common_proc.tcl"
        if {[file exists $common_tcl_file]} {
            source $common_tcl_file
            break
        }
    }
    set compatible [get_comp_str $drv_handle]
    set compatible [append compatible " " "xlnx,xps-uartlite-1.00.a"]
    set_drv_prop $drv_handle compatible "$compatible" stringlist
    set config_baud [get_property CONFIG.dt_setbaud [get_os]]
    set ip [get_cells -hier $drv_handle]
    set consoleip [get_property CONFIG.console_device [get_os]]
    if { [string match -nocase $consoleip $ip] } {
        set ip_type [get_property IP_NAME $ip]
	if {!$config_baud} {
		if { [string match -nocase $ip_type] } {
			hsi::utils::set_os_parameter_value "console" "ttyUL0,115200"
		} else {
			hsi::utils::set_os_parameter_value "console" "ttyUL0,[hsi::utils::get_ip_param_value $ip C_BAUDRATE]"
		}
	} else {
		hsi::utils::set_os_parameter_value "console" "ttyUL0,$config_baud"
	}
    }

    set_drv_conf_prop $drv_handle C_BAUDRATE current-speed int
    set proc_type [get_sw_proc_prop IP_NAME]
    switch $proc_type {
             "microblaze"   {
                 gen_dev_ccf_binding $drv_handle "s_axi_aclk"
	      }
    }
}
