// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use, distribute, and modify
// this work, so long as such uses are non-commercial in nature,
// so long as any derived works are offered on the same terms,
// and so long as attribution is given to the original author.
// For further details, see the Creative Commons License
// "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//



#ifndef DATA_UPDATE_HH
#define DATA_UPDATE_HH

#include "graph_data.hh"
#include "data_sources.hh"

struct graph_config
{
  graph_type              type;
  graph_data_type         data_type;
  int                     num_hw_sources;
  int                     source_list_number      [graph::MAX_GRAPHS];  // index into hw_source_list
  int                     reference;                                    // adc/dac number, reference for xfer functions
  int                     num_points;
  int                     interleave;
  double                  x_data_start;
  double                  x_data_step;
  double                  y_scale_factor;
  char                    title              [200];
  char                    x_label            [200];
  char                    y_label            [200];
  double                  xmin;
  double                  xmax;
  double                  ymin;
  double                  ymax;
  averaging_type          averaging;   // Only for spectral graphs
};

graph*            hw_graph_create      (graph_config& gc);
graph_config      default_gc           (graph_type gt);
void              print_gc             (const graph_config& gc);

struct hw_source
{
  graph_type       type;
  int              source_number_sw;
  int              default_reference_sw;  // Default reference number if this source is selected as the "to" in a xfer
  graph_data_type  data_type;
  //  uint32_t         hw_address;
  int              num_points;
  int              interleave;
  double           x_data_start_step_1;
  double           xmin_step_1;
  double           xmax_step_1;
  double           ymin_scale_1;
  double           ymax_scale_1;
};

//
// hw_source_list is to be defined in the main application, since they
// vary from application to application.
extern hw_source hw_source_list[];
extern int num_hw_sources;


void data_init();
void data_start_capture();
void data_end_capture_update_to_plot();
void x_axis_scale_list_init();

struct hw_pfb_spectrum
{
  uint32_t collect;
  uint32_t late_delay;
  uint32_t spectrum_done;
  uint32_t capture_offset;
  uint32_t samples_per_section;
  uint32_t num_sections;
  uint32_t num_streams_early;
  uint32_t num_streams_late;
};



#endif
