// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use, distribute, and modify
// this work, so long as such uses are non-commercial in nature,
// so long as any derived works are offered on the same terms,
// and so long as attribution is given to the original author.
// For further details, see the Creative Commons License
// "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//


#ifndef INTRO_HH
#define INTRO_HH

#include "window.hh"
#include "global_beep.hh"
#include "draw_text.hh"
#include "event_types.hh"
#include "send_events.hh"

class intro : public window
{
  const static int blink_interval = 10;
  int              blink_count;
  bool             blink_on;
  float            ratio;
  static bool      copyright_printed;
public:

  static bool display_initializing_clocks;
  static bool failed_initializing_clocks;
  static bool clocks_initialized;
  static bool demo_is_ready;
  
  //virtual void     calculate_width_and_height(int& calc_width, int& calc_height, int desired_height, float ratio);

  virtual void     layout();
  virtual void     draw_dirty();
  virtual void     draw_dynamic();

                   intro();
                   ~intro();
};



#endif
