// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use, distribute, and modify
// this work, so long as such uses are non-commercial in nature,
// so long as any derived works are offered on the same terms,
// and so long as attribution is given to the original author.
// For further details, see the Creative Commons License
// "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//


#ifndef MENU_CONFIG_HH
#define MENU_CONFIG_HH

#include "menu.hh"
#include "bxbapp_config.hh"
#include "select_one.hh"
#include "button.hh"
#include "number_box.hh"

class menu_config : public menu
{
  void add(menu* m); // This type of menu is terminal; can't add children.  Thus make this private.
  
public:

  menu* graph_menu;  // Only here so that we can adjust graphs if the sampling rate changes.

  int config_select_sel_x_offset;
  int config_select_sel_y_offset;
  int config_select_sel_width;
  int config_select_sel_height;

  button*     restart_button;
  number_box* ADC_freq;
  select_one* config_select;
  
  connection<multiselect, selection_changed_event, menu_config, int, int>* c_restart;
  connection<select_one, selection_changed_event, menu_config, int, int>*  c_config_select;
  connection<number_box, double, menu_config, int, int>*                   c_number;

  const static color REGIONCOLOR        = GREY3;

  virtual bool handle_event(my_event& me);
  virtual void draw_dirty();
  virtual void draw_dynamic();
  virtual void layout();

  virtual void this_selected();

  double ADC_frequency_MHz;
  double closest_ADC_frequency_MHz;
  
  void number_event();
  
  menu_config(const char* tagname, menu* graph_menu, color bg=BLACK);
  ~menu_config();
};



#endif
