// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use, distribute, and modify
// this work, so long as such uses are non-commercial in nature,
// so long as any derived works are offered on the same terms,
// and so long as attribution is given to the original author.
// For further details, see the Creative Commons License
// "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//


#ifndef MENU_TRIGGER_SELECT_HH
#define MENU_TRIGGER_SELECT_HH

#include "menu.hh"
#include "select_one.hh"
#include "event_types.hh"
#include "number_box.hh"

class menu_trigger_select : public menu
{
  void add(menu* m); // This type of menu is terminal; can't add children.  Thus make this private.
  
public:

  static int     trigger_source;
  static int     num_sources;
  static double  trigger_level;
  static double  trigger_hysteresis;
  
  int trigger_source_sel_x_offset;
  int trigger_source_sel_y_offset;
  int trigger_source_sel_width;
  int trigger_source_sel_height;

  int trigger_level_sel_x_offset;
  int trigger_level_sel_y_offset;
  int trigger_level_sel_width;
  int trigger_level_sel_height;

  select_one* trigger_source_sel;
  number_box* trigger_level_sel;
  
  connection<select_one, selection_changed_event, menu_trigger_select, int, int>* c_trigger;

  const static color REGIONCOLOR        = GREY3;

  virtual bool handle_event(my_event& me);
  virtual void draw_dirty();
  virtual void draw_dynamic();
  virtual void layout();

  virtual void this_selected();
  
  menu_trigger_select(const char* tagname, color bg=BLACK);
  ~menu_trigger_select();
};



#endif
