// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use, distribute, and modify
// this work, so long as such uses are non-commercial in nature,
// so long as any derived works are offered on the same terms,
// and so long as attribution is given to the original author.
// For further details, see the Creative Commons License
// "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//



#include <sys/types.h>
#include <dirent.h>
#include <string.h>

#include "displays.hh"
#include "document_dir.hh"
#include "menu_action.hh"


extern void menu_document_action(menu_action* ma, bool selected, void* data);


//
// This function takes a directory and finds potential
// document directories within it.  It could also be a
// directory containing a document.
//
void document_dir(menu* parent, const char* base_dir, const char* dir)
{
  char full_directory[400];
  char first_page[400];

  sprintf(full_directory, "%s/%s", base_dir, dir);
  sprintf(first_page,     "%s_001.svg", dir);
  
  DIR* dp = opendir(full_directory);

  if(!dp)
    return;

  bool has_subdirs = false;
  
  for(;;)
    {
      dirent *de = readdir(dp);
      if(!de)
	break;

      if(!strcmp(first_page, de->d_name))
	{
	  docfile* docdata = new docfile;
	  sprintf(docdata->base_dir, "%s", base_dir);
	  sprintf(docdata->name,     "%s", dir);
	  menu_action* ma = new menu_action(dir, menu_document_action, docdata);
	  parent->add(ma);
	}

      if(de->d_type==DT_DIR && de->d_name[0]!='.')
	has_subdirs = true;
    }
  
  if(has_subdirs)
    {
      menu* m = new menu(dir); parent -> add(m);

      rewinddir(dp);

      for(;;)
	{
	  dirent *de = readdir(dp);
	  if(!de)
	    break;
	 
	  if(de->d_type==DT_DIR && de->d_name[0]!='.')
	    document_dir(m, full_directory, de->d_name);
	}
    }
	  
  closedir(dp);
}

