
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef DISPLAYPORTSTATUS_HH
#define DISPLAYPORTSTATUS_HH

#include <stdint.h>

class DisplayPortStatus
{
public:
  bool is_OK(bool print);
  void print();
  
  volatile uint32_t* dp_regs;

  DisplayPortStatus(bool verbose);
  ~DisplayPortStatus();

private:
  uint32_t dp(int reg) { return dp_regs[reg/4]; }  // Convert to 32-bit-word address to byte address
};


#endif
