
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef ARE_YOU_SURE_HH
#define ARE_YOU_SURE_HH

#include "button.hh"
#include "multiwindow.hh"
#include "displays.hh"


typedef void are_you_sure_function(void* /* data from the caller */, int /* selected value */);


class are_you_sure : public multiwindow
{
public:

  display*         d;

  const static int MAX_STRING  = 200;

  color            BG_COLOR;
  color            BUTTON_COLOR;
  color            TEXT_COLOR;
  color            ACTIONTEXTCOLOR;
  color            TITLE_COLOR;
  
  //int              text_font_height;
  int              font_height;

  int              circle_width;

  char             title[MAX_STRING];
  char             end_text_0[MAX_STRING];
  char             end_text_1[MAX_STRING];
  char             end_text_2[MAX_STRING];
  char             end_text_3[MAX_STRING];

  button*          b_end[4];

  are_you_sure_function* func;
  void*                  func_data;
  
  connection<button, selection_changed_event, are_you_sure, int, int>*  c_end[4];

  virtual void     draw_dynamic();  
  virtual bool     handle_event(my_event& me);

  virtual void     layout();
  virtual void     draw_dirty();
  
  bool got_char(char c);
  bool add_char(char c);
  
  
  are_you_sure(display*               d,
	       const char*            title,
	       const char*            end_text_0,
	       const char*            end_text_1,
	       const char*            end_text_2,
	       const char*            end_text_3,
	       are_you_sure_function  func,
	       void*                  func_data);

  ~are_you_sure();
};


//
// This can't just stop and wait for a return.  Instead, it exits
// immediately after creating the are_you_sure dialog.  Execution
// of whatever tasks we're sure or not sure about is performed by
// a call to func once the user selects something.
//
void ask_are_you_sure(display*               d,
		      const char*            title,
		      const char*            end_text_0,
		      const char*            end_text_1,
		      const char*            end_text_2,
		      const char*            end_text_3,
		      are_you_sure_function  func,
		      void*                  func_data);

#endif
