
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef DRAW_TEXT_HH
#define DRAW_TEXT_HH


#include "color.hh"
#include "panel.hh"


#define DRAW_TEXT_X_LEFT     0x00
#define DRAW_TEXT_X_CENTER   0x01
#define DRAW_TEXT_X_RIGHT    0x02
#define DRAW_TEXT_X_MASK     0x03

#define DRAW_TEXT_Y_BOTTOM   0x00
#define DRAW_TEXT_Y_CENTER   0x10
#define DRAW_TEXT_Y_TOP      0x20
#define DRAW_TEXT_Y_MASK     0x30

#define DRAW_TEXT_ROTATE_0        0x000
#define DRAW_TEXT_ROTATE_90_LEFT  0x100
#define DRAW_TEXT_ROTATE_90_RIGHT 0x200
#define DRAW_TEXT_ROTATE_MASK     0x300

#define MAX_COLORS 22

void global_draw_text(const char* text, color c, panel* p, int x, int y, int flags = 0);

//
// multicolor text uses ASCII x = 10 (0x0A) and up to indicate a switch to color
// c[x-10].
//
void global_draw_multicolored_text(const char* text, color* c, panel* p, int x, int y, int flags = 0);

int  global_calculate_text_width(const char* text);
int  global_calculate_text_height(const char* text);

void global_set_text_size(int height_pixels);
int  global_get_text_size();


#endif
