
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef MULTISELECT_HH
#define MULTISELECT_HH

#include "multiwindow.hh"
#include "layout.hh"
#include "global_beep.hh"
#include "draw_text.hh"
#include "all_svg.hh"
#include "backing_panel.hh"
#include "event_types.hh"
#include "send_events.hh"

class multiselect : public window, public sending_base_class<selection_changed_event, int>
{
public:

  
  const static int MAX_STRING  = 200;
  const static int MAX_ITEMS   = 20;

  char title      [MAX_STRING];  // If string has zero length, don't display title
  
  int  num_items;
  char item_name  [MAX_ITEMS][MAX_STRING];
  bool selected   [MAX_ITEMS];
  bool disabled   [MAX_ITEMS];

  color textcolor                [MAX_ITEMS];
  color selectedtextcolor        [MAX_ITEMS];
  color selected_highlight_color [MAX_ITEMS];
  
  color GROUPCOLOR;
  color SELECTED_HIGHLIGHT_COLOR;
  color TEXTCOLOR;
  color SELECTEDTEXTCOLOR;
  color DISABLEDTEXTCOLOR;
  color TITLECOLOR;

  int allowed_height;

  int below_title_margin;
  int below_title_offset;
  
  int top_margin;
  int bottom_margin;
  int left_margin;
  int right_margin;

  int selection_margin;

  int extra_text_x_margin;  // If title is bigger than items, this centers items under title
  
  int item_left_offset;
  int item_width;
  int item_height;
  
  int item_select_height;
  int item_select_width;
  int item_select_left_offset;
  
  int item_x_center_offset;
  
  int item_area_height;

  int item_font_height;
  int item_y_spacing;
  int item_max_y_spacing;
  int max_item_width;

  int circle_width;

  int max_selected;

  int highlight_count;
  
  void              set_text_color(int item, color c);
  void              set_selected_text_color(int item, color c);
  void              set_selected_highlight_color(int item, color c);

  int               get_num_selected();

  virtual int       calculate_item_width(int item);

  virtual void      calculate_width_and_height(int& calc_width, int& calc_height, int desired_height, float ratio);

  virtual void      draw_item(int num);

  virtual void      select(int num);
  virtual void      deselect(int num);

  virtual void      draw_dynamic();
  virtual void      draw_dirty();
  virtual bool      handle_event(my_event& me);

  virtual void      layout();

  void              set_title(const char* txt);
  
  void add(const char* item_name, bool start_selected=false, bool disabled=false);
  
  multiselect(const char* title, int max_selected=-1, color bg=BLACK);
  ~multiselect();
};



#endif
