
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef MULTIWINDOW_HH
#define MULTIWINDOW_HH

#include "panel.hh"
#include "subpanel.hh"
#include "color.hh"
#include "point.hh"

#include "window.hh"
#include "List.hh"
#include "layout.hh"

class multiwindow : public window
{
public:
  
  int            num_subwindows;
  List<window>*  subwindows;
  layout_plan*   layout_calculator;

  int            target_aspect_x;
  int            target_aspect_y;
  bool           force_aspect;

  // Called from events
  virtual bool   handle_event         (my_event& me);
  void           add                  (window* win, bool stealthy = false);
  void           remove               (window* win);
  void           remove_no_delete     (window* win);  // For when a window removes itself, while in the process of deletion.
  void           remove_all           ();
  
  // Called from vertical blank redraw, in this order, as needed.
  virtual void   layout               ();
  virtual void   draw_dirty           ();
  virtual void   draw_dynamic         ();

  // Function for updating data indepently from drawing it
  virtual void   update_data          ();

                 multiwindow          (color bg);
  virtual        ~multiwindow         ();
};



#endif
