
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef NUMBER_BOX_HH
#define NUMBER_BOX_HH

#include "window.hh"
#include "global_beep.hh"
#include "draw_text.hh"
#include "event_types.hh"
#include "send_events.hh"
#include "axis_scale.hh"

class number_box : public window, public sending_base_class<double, int>
{
public:

  const static int MAX_STRING  = 200;

  float            ratio;
  
  color            BG_COLOR;
  color            FG_COLOR;
  color            NUM_COLOR;
  color            TEXT_COLOR;
  color            GROUPCOLOR;
  color            TITLECOLOR;
  
  int              allowed_height;
  
  int              top_margin;
  int              bottom_margin;
  int              left_margin;
  int              right_margin;

  int              between_x_margin;
  int              number_width;
  int              title_bottom_margin;
  int              between_y_margin;

  int              font_height;
  int              circle_width;
  int              highlight_count;

  int              number_x_margin;
  int              number_y_margin;
  
  char             text[MAX_STRING];

  double*          value;

  axis_scale*      axis_scale_list;
  int              num_axis_scales;

  graph_type       type;
  int              num_of_type;

  int              text_max_width;

  double           min_value;
  double           max_value;
  
  virtual void     calculate_width_and_height(int& calc_width, int& calc_height, int desired_height, float ratio);

  virtual void     layout();
  virtual void     draw_dirty();
  virtual void     draw_dynamic();

  virtual bool     handle_event(my_event& me);


  bool             get_number(const char* text, int num_selected);

  bool             number_ok(double value);

  void             set_title(const char* txt);
  
                   number_box(const char* number_box_name,
			      double*     value,
			      double      min_value,
			      double      max_value,
			      axis_scale* axis_scale_list,
			      int         num_axis_scales,
			      graph_type  type,
			      int         font_size,
			      int         x_margin,
			      int         y_margin,
			      color       textcolor,
			      color       fg,
			      color       bg=BLACK);
  
                   ~number_box();
};



#endif
