
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef NUMERIC_ENTRY_HH
#define NUMERIC_ENTRY_HH

#include "button.hh"
#include "multiwindow.hh"
#include "displays.hh"


typedef bool return_function(void*, const char*, int);


class numeric_entry : public multiwindow
{
public:

  display*         d;

  const static int MAX_ENTRY   = 12;
  const static int MAX_STRING  = 200;

  color            BG_COLOR;
  color            BUTTON_COLOR;
  color            TEXT_COLOR;
  color            ACTIONTEXTCOLOR;
  color            TITLE_COLOR;
  
  int              text_font_height;
  int              font_height;

  int              circle_width;

  char             title[MAX_STRING];
  char             end_text_0[MAX_STRING];
  char             end_text_1[MAX_STRING];
  char             end_text_2[MAX_STRING];
  char             end_text_3[MAX_STRING];

  bool             integer_only;
  bool             positive_only;

  bool             got_decimal_point;

  char             entry[MAX_STRING];
  int              current_entry_point;

  return_function* rtn;
  void*            rtn_data;
  
  button*          b_num[10];
  button*          b_p;
  button*          b_pm;

  button*          b_delete;
  
  button*          b_end[4];


  int button_margin;

  //
  // x-layout
  //
  int left_margin;
  int right_margin;
  int right_column_margin;

  int button_width;
  
  int del_width;

  int right_column_width;

  int text_width_full;
  int text_margin;
  int text_width;

  //
  // y-layout
  //
  int top_margin;
  int bottom_margin;

  int button_height;
  int del_height;

  int title_height;
  int title_margin;

  int text_height;
  int text_height_full;
  int below_text_margin;


  connection<button, selection_changed_event, numeric_entry, char, int>*  c_p;
  connection<button, selection_changed_event, numeric_entry, char, int>*  c_pm;
  connection<button, selection_changed_event, numeric_entry, char, int>*  c_delete;

  connection<button, selection_changed_event, numeric_entry, char, int>*  c_num[10];
  connection<button, selection_changed_event, numeric_entry, char, int>*  c_end[4];


  virtual void     draw_dynamic();  
  virtual bool     handle_event(my_event& me);

  virtual void     layout();
  virtual void     draw_dirty();
  
  bool got_char(char c);
  bool add_char(char c);
  
  
  numeric_entry(display*         d,
		const char*      title,
		const char*      end_text_0,
		const char*      end_text_1,
		const char*      end_text_2,
		const char*      end_text_3,
		bool             integer_only,
		bool             positive_only,
		return_function  rtn,
		void*            rtn_data);

  ~numeric_entry();
};



#endif
