
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef SVG_WINDOW_HH
#define SVG_WINDOW_HH

#include "panel.hh"
#include "subpanel.hh"
#include "color.hh"
#include "point.hh"

#include "window.hh"
#include "List.hh"
#include "layout.hh"

class svg_window : public window
{
public:
  uint8_t* svg_data;
  int      svg_data_length;
  
  virtual void layout ();

  svg_window(uint8_t* svg_data, int svg_data_length, color bg=BLACK);
  virtual ~svg_window();
};



inline svg_window::svg_window(uint8_t* svg_data, int svg_data_length, color bg) : window(bg)
{
  this->svg_data         = svg_data;
  this->svg_data_length  = svg_data_length;
}


inline svg_window::~svg_window()
{
}


inline void svg_window::layout()
{
  clear(bgcolor);
  draw_svg_from_data(svg_data, svg_data_length);
}



#endif
