
// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef TOUCHSCREEN_CALIBRATION_HH
#define TOUCHSCREEN_CALIBRATION_HH

#include "window.hh"


class touchscreen_calibration : public window
{
  local_display*   d;

  const static int blink_interval = 100;
  int              blink_count;
  bool             blink_on;
  float            ratio;


  const static int cal_length_x = 20;
  const static int cal_length_y = 20;
  const static int cal_offset_x = 200;
  const static int cal_offset_y = 200;

  int              cal_step;
  
  const static int pointer_display_interval = 200;
  int              last_me_x;
  int              last_me_y;
  int              last_x;
  int              last_y;
  int              last_count;
  int              match_center_x;
  int              match_center_y;
  color            match_color;
  
  float            touchscreen_x_offset;
  float            touchscreen_y_offset;
  float            touchscreen_x_gain;
  float            touchscreen_y_gain;

public:

  //virtual void     calculate_width_and_height(int& calc_width, int& calc_height, int desired_height, float ratio);

  virtual bool     handle_event(my_event& me);

  virtual void     layout();
  virtual void     draw_dirty();
  virtual void     draw_dynamic();

                   touchscreen_calibration(local_display* d);
                   ~touchscreen_calibration();
};

#endif
