
/*
 * Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., http://www.fsf.org/about/contact/
 *
 */


#ifndef TOKENS_HH
#define TOKENS_HH

#include "readstream.hh"
#include "parse_support.hh"
#include "string.h"

//
// Note that token names must be in static storage, since Token
// does not copy them.
//
class Token
{
  const char* tokentext;
  const void* tokendata;

public:
  operator int()   { return (long)   tokendata; }
  operator const char*() { return (const char*) tokendata; }
  operator const int*()  { return (const int*)  tokendata; }
  operator const long*() { return (const long*) tokendata; }
  operator const void*() { return (const void*) tokendata; }

  const void* data() { return tokendata; }

  Token(const char*t, long   d) { tokentext=t; tokendata=(void*)d; }
  Token(const char*t, const char* d) { tokentext=t; tokendata=(void*)d; }
  Token(const char*t, const int*  d) { tokentext=t; tokendata=(void*)d; }
  Token(const char*t, const long* d) { tokentext=t; tokendata=(void*)d; }
  Token(const char*t, const void* d) { tokentext=t; tokendata=(void*)d; }
  ~Token() {}

  const char* text() { return tokentext; }
  int match(char* s);
};

class TokenList;

typedef void TokenListSetupFunction(TokenList& tl);

#define TOKENLIST_MAXTOKENS 100

class TokenList
{
  const char* termchars;
  int numtokens;
  Token* tokens[TOKENLIST_MAXTOKENS];
  int maxlength;

public:
  TokenList(TokenListSetupFunction tl, const char* tchars);
  ~TokenList() { int i; for(i=0; i<numtokens; i++) delete tokens[i]; }

  void addToken(Token* t);
  void addToken(const char*t, long   d)      { addToken(new Token(t,d)); }
  void addToken(const char*t, const char* d) { addToken(new Token(t,d)); }
  void addToken(const char*t, const int*  d) { addToken(new Token(t,d)); }
  void addToken(const char*t, const long* d) { addToken(new Token(t,d)); }
  void addToken(const char*t, const void* d) { addToken(new Token(t,d)); }

  void printExpecting();
  Token* matchToken(readstream& r);
};

#endif
