

#include <stdio.h>
#include <unistd.h>
#include "physical_memory.hh"

int main(void)
{
  uint32_t r;
  uint32_t v0 = 0x00000000;
  uint32_t v1 = 0xFFFFFFFF;
  physical_memory<uint32_t> pm(0xA00C0000, 2);


  // Set gpio to outputs:  Offset 1 gets 0.
  pm.write_offset(1, v0);

  
  pm.write_offset(0, v1);
  r = pm.read_offset(0);
  printf("Wrote 0x%08X, read 0x%08X\n", v1, r);

  pm.write_offset(0, v0);
  r = pm.read_offset(0);
  printf("Wrote 0x%08X, read 0x%08X\n", v0, r);

  pm.write_offset(0, v1);
  r = pm.read_offset(0);
  printf("Wrote 0x%08X, read 0x%08X\n", v1, r);


  // Blink LEDs in counting pattern.  Offset 0 gets the data.
  for(int i=0;;i++)
    {
      pm.write_offset(0, i);
      //sleep(1);
      usleep(100000);
    }
  
  return 0;
}
