// SPDX-License-Identifier: CC-BY-NC-ND-4.0
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial NoDerivatives 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-ND-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-ND-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  This work may be distributed in unmodified form,
// but derivatives of this work may not be distributed.  For further
// details, see the Creative Commons License "CC-BY-NC-ND-4.0".
//
// You should have received a copy of the CC-BY-NC-ND-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-nd/4.0/>.
//

#ifndef PROTOCOL_HTTP_HH
#define PROTOCOL_HTTP_HH

#include <libwebsockets.h>


//
// Functions to call to add new http files dynamically to server.
//
void         add_http_file           (const char* path, const unsigned char* data, int data_length);
const char*  get_http_path_for_data  (const unsigned char* data);



typedef struct { const char* path; int length; const unsigned char* data; } web_files;

#define MAX_WFILES 1000
extern web_files  wfiles[MAX_WFILES];
extern int        num_wfiles;


int callback_http(struct lws *               wsi,
		  enum lws_callback_reasons  reason,
		  void *                     user,
		  void *                     in,
		  size_t                     len);


struct http_progress
{
  web_files*  wfile;            // For when the file is in memory
  FILE*       fp;               // For when the file is on disk
  long        fp_bytes_total;   // Only for files on disk
  long        bytes_sent;
};


#endif

