/******************************************************************************
*
* Copyright (C) 2018 Xilinx, Inc.  All rights reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* XILINX  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
* OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
* Except as contained in this notice, the name of the Xilinx shall not be used
* in advertising or otherwise to promote the sale, use or other dealings in
* this Software without prior written authorization from Xilinx.
*
******************************************************************************/
/****************************************************************************/
/**
*
* @file xrfdc_clk.c
*
* This file contains a programming example for using the lmx2594 and lmk04028
* clock generator.
* This example configures the lmx2594  to 20 frequencies. If 0 is passed
* then the chip is powered down.
* For zcu111 board users are expected to define XPS_BOARD_ZCU111 macro
* while compiling this example.
*
*
* <pre>
*
* MODIFICATION HISTORY:
*
* Ver   Who    Date     Changes
* ----- -----  -------- -----------------------------------------------------
* 1.0   sd     04/11/18 First release
* 4.0   sd     05/22/18 Updated lmx configuration
* 5.0   sd     09/05/18 Updated lmx reset sequence
*
* </pre>
*
*****************************************************************************/

/***************************** Include Files ********************************/

#ifndef __BAREMETAL__
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <limits.h>
#include <dirent.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>

#define XIIC_BLOCK_MAX	16	/* Max data length */
#define I2C_SMBUS_WRITE	0
#define I2C_SMBUS_I2C_BLOCK  6

#else
#include "xparameters.h"
#include "sleep.h"
#include "xuartps.h"
#include "xiicps.h"
#include "xil_printf.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
XIicPs Iic; /* Instance of the IIC Device */

#endif
#include "xrfdc_clk.h"

#define LMK04208_count 26
#define LMX2594_A_count 113
#define MAX_FREQ  27
typedef struct {
	int XFrequency;
	unsigned int LMX2594_A[LMX2594_A_count];
} XClockingLmx;

XClockingLmx ClockingLmx[MAX_FREQ] = {
	{5120000, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816,
	6881313, 6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040,
	6359176, 6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240,
	5832704, 5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632,
	5308416, 5269094, 5177382, 5111811, 5046272, 4980748, 4918080, 4849664,
	4784191, 4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876,
	4259840, 4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857,
	3735584, 3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800,
	3228032, 3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512,
	2686976, 2621440, 2555905, 2490368, 2425604, 2359376, 2293764, 2228224,
	2170401, 2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440,
	1639972, 1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748,
	1114412, 1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364,
	532480, 475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372, }},
	{3932160, {7340032, 7274496, 7208960, 7143424, 7077888,
	7012352, 6946816, 6881313, 6815744, 6750208, 6700928, 6619153, 6553600,
	6488064, 6423040, 6359176, 6291456, 6225920, 6160384, 6094848, 6029312,
	5963776, 5898240, 5832704, 5767168, 5701632, 5636096, 5624576, 5505025,
	5439488, 5381632, 5308416, 5269094, 5177382, 5111811, 5046272, 4980748,
	4917248, 4849664, 4784191, 4718593, 4653185, 4637520, 4521984, 4457448,
	4390912, 4325876, 4259840, 4199304, 4128768, 4064034, 3997864, 3932160,
	3866625, 3833857, 3735584, 3670016, 3604480, 3538944, 3473408, 3409952,
	3342464, 3276800, 3228032, 3146496, 3080960, 3016700, 2998476, 2886691,
	2818048, 2752512, 2686976, 2621440, 2555905, 2490368, 2425604, 2359360,
	2293764, 2228224, 2170401, 2098067, 2049004, 1978764, 1913228, 1836168,
	1769474, 1707440, 1639972, 1574682, 1507452, 1441793, 1377281, 1368136,
	1255351, 1179748, 1114412, 1048704, 984655, 925264, 868352, 806913,
	720920, 659672, 591364, 532480, 475314, 444418, 327880, 264771, 198210,
	132352, 67592, 9372, }},
	{1474560, {7340032, 7274496, 7208960, 7143424, 7077888,
	7012352, 6946816, 6881313, 6815744, 6750208, 6700928, 6619153, 6553600,
	6488064, 6423040, 6359176, 6291456, 6225920, 6160384, 6094848, 6029312,
	5963776, 5898240, 5832704, 5767168, 5701632, 5636096, 5624576, 5505025,
	5439488, 5381632, 5308416, 5269094, 5177382, 5111811, 5046272, 4980748,
	4917376, 4849664, 4784191, 4718593, 4653185, 4637520, 4521984, 4457448,
	4390912, 4325876, 4259840, 4199304, 4128768, 4064034, 3997864, 3932160,
	3866625, 3833857, 3735584, 3670016, 3604480, 3538944, 3473408, 3409952,
	3342464, 3276800, 3228032, 3146496, 3080960, 3016700, 2998476, 2886819,
	2818048, 2752512, 2686976, 2621440, 2555905, 2490368, 2425604, 2359368,
	2293764, 2228224, 2170401, 2098067, 2049004, 1978764, 1913228, 1836168,
	1769474, 1707440, 1639972, 1574682, 1507452, 1441793, 1377281, 1368136,
	1255351, 1179748, 1114412, 1048704, 984655, 925264, 868352, 806913,
	720920, 659672, 591364, 532480, 475314, 444418, 327880, 264771, 198210,
	132352, 67592, 9372 }},
	{4915200, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816,
	6881313, 6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704, 5767168,
	5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416, 5269094, 5177382,
	5111811, 5046272, 4980748, 4917248, 4849664, 4784191, 4718593, 4653185, 4637520,
	4521984, 4457448, 4390912, 4325876, 4259840, 4199304, 4128768, 4064034, 3997864,
	3932160, 3866625, 3833857, 3735584, 3670016, 3604480, 3538944, 3473408, 3409952,
	3342464, 3276800, 3228032, 3146496, 3080960, 3016700, 2998476, 2886691, 2818048,
	2752512, 2686976, 2621440, 2555905, 2490368, 2425604, 2359376, 2293764, 2228224,
	2170401, 2098067, 2032620, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412, 1048704,
	984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480, 475314, 444418,
	327880, 264771, 198210, 132352, 67592, 9372 }},
	{6553600, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4917248, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2768896, 2686976,
	2621440, 2555905, 2514944, 2425860, 2359402, 2293764, 2228224, 2170401,
	2098067, 2032620, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{6400000, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4917248, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818049, 2752512, 2686976,
	2621440, 2555910, 2490368, 2425860, 2359400, 2293764, 2228224, 2170401,
	2098067, 2032620, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{6389760, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4917248, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512, 2686976,
	2621440, 2555905, 2490368, 2425860, 2359400, 2293764, 2228224, 2170401,
	2098067, 2032620, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{6144000, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4917248, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512, 2686976,
	2621440, 2555905, 2490368, 2425860, 2359396, 2293764, 2228224, 2170401,
	2098067, 2032620, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{5898240, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4917248, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512, 2686976,
	2621440, 2555905, 2490368, 2425860, 2359392, 2293764, 2228224, 2170401,
	2098067, 2032620, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{5734400, {340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4917248, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818049, 2752512, 2686976,
	2621440, 2555907, 2490368, 2425860, 2359389, 2293764, 2228224, 2170401,
	2098067, 2032620, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{4000000, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4917248, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818053, 2752512, 2686976,
	2621440, 2555952, 2490368, 2425604, 2359361, 2293764, 2228224, 2170401,
	2098067, 2032620, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{4096000, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4917248, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818050, 2752512, 2686976,
	2621440, 2555907, 2490368, 2425604, 2359362, 2293764, 2228224, 2170401,
	2098067, 2032620, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{4423680, {7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4917248, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512, 2686976,
	2621440, 2555905, 2490368, 2425604, 2359368, 2293764, 2228224, 2170401,
	2098067, 2032620, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{4669440, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4917248, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512, 2686976,
	2621440, 2555905, 2490368, 2425604, 2359372, 2293764, 2228224, 2170401,
	2098067, 2032620, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{1966080, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816,
	6881313, 6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040,
	6359176, 6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240,
	5832704, 5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632,
	5308416, 5269094, 5177382, 5111811, 5046272, 4980748, 4917312, 4849664,
	4784191, 4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876,
	4259840, 4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857,
	3735584, 3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800,
	3228032, 3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512,
	2686976, 2621440, 2555905, 2490368, 2425604, 2359360, 2293764, 2228224,
	2170401, 2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440,
	1639972, 1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748,
	1114412, 1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364,
	532480, 475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{2048000, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816,
	6881313, 6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040,
	6359176, 6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240,
	5832704, 5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632,
	5308416, 5269094, 5177382, 5111811, 5046272, 4980748, 4917312, 4849664,
	4784191, 4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876,
	4259840, 4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857,
	3735584, 3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800,
	3228032, 3146496, 3080960, 3016700, 2998476, 2886691, 2818050, 2752512,
	2686976, 2621440, 2555907, 2490368, 2425604, 2359362, 2293764, 2228224,
	2170401, 2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440,
	1639972, 1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748,
	1114412, 1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364,
	532480, 475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{2457600, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816,
	6881313, 6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040,
	6359176, 6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240,
	5832704, 5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632,
	5308416, 5269094, 5177382, 5111811, 5046272, 4980748, 4917312, 4849664,
	4784191, 4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876,
	4259840, 4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857,
	3735584, 3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800,
	3228032, 3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512,
	2686976, 2621440, 2555905, 2490368, 2425604, 2359376, 2293764, 2228224,
	2170401, 2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440,
	1639972, 1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748,
	1114412, 1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364,
	532480, 475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372}},
	{2949120, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816,
	6881313, 6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040,
	6359176, 6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240,
	5832704, 5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632,
	5308416, 5269094, 5177382, 5111811, 5046272, 4980748, 4917312, 4849664,
	4784191, 4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876,
	4259840, 4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857,
	3735584, 3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800,
	3228032, 3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512,
	2686976, 2621440, 2555905, 2490368, 2425860, 2359392, 2293764, 2228224,
	2170401, 2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440,
	1639972, 1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748,
	1114412, 1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364,
	532480, 475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372}},
	{3072000, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4917312, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512, 2686976,
	2621440, 2555905, 2490368, 2425860, 2359396, 2293764, 2228224, 2170401,
	2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372}},
	{3276800, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4917312, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818050, 2752512, 2686976,
	2621440, 2555907, 2490368, 2425860, 2359402, 2293764, 2228224, 2170401,
	2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{245760, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816,
	6881313, 6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040,
	6359176, 6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240,
	5832704, 5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632,
	5308416, 5269094, 5177382, 5111811, 5046272, 4980748, 4917696, 4849664,
	4784191, 4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876,
	4259840, 4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857,
	3735584, 3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800,
	3228032, 3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512,
	2686976, 2621440, 2555905, 2490368, 2425604, 2359360, 2293764, 2228224,
	2170401, 2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440,
	1639972, 1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748,
	1114412, 1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364,
	532480, 475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372}},
	{3686400, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4917312, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512, 2686976,
	2621440, 2555905, 2490368, 2425860, 2359416, 2293764, 2228224, 2170401,
	2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{204800, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816,
	6881313, 6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040,
	6359176, 6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240,
	5832704, 5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632,
	5308416, 5269094, 5177382, 5111811, 5046272, 4980748, 4917760, 4849664,
	4784191, 4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876,
	4259840, 4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857,
	3735584, 3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800,
	3228032, 3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512,
	2686976, 2621440, 2555905, 2490368, 2425604, 2359376, 2293764, 2228224,
	2170401, 2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440,
	1639972, 1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748,
	1114412, 1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364,
	532480, 475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372}},
	{409600, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816,
	6881313, 6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040,
	6359176, 6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240,
	5832704, 5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632,
	5308416, 5269094, 5177382, 5111811, 5046272, 4980748, 4917632, 4849664,
	4784191, 4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876,
	4259840, 4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857,
	3735584, 3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800,
	3228032, 3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512,
	2686976, 2621440, 2555905, 2490368, 2425604, 2359376, 2293764, 2228224,
	2170401, 2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440,
	1639972, 1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748,
	1114412, 1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364,
	532480, 475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{491520, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816,
	6881313, 6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040,
	6359176, 6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240,
	5832704, 5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632,
	5308416, 5269094, 5177382, 5111811, 5046272, 4980748, 4917568, 4849664,
	4784191, 4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876,
	4259840, 4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857,
	3735584, 3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800,
	3228032, 3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512,
	2686976, 2621440, 2555905, 2490368, 2425604, 2359360, 2293764, 2228224,
	2170401, 2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440,
	1639972, 1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748,
	1114412, 1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364,
	532480, 475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372 }},
	{737280, {7340032, 7274496, 7208960, 7143424, 7077888, 7012352, 6946816,
	6881313, 6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040,
	6359176, 6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240,
	5832704, 5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632,
	5308416, 5269094, 5177382, 5111811, 5046272, 4980748, 4917504, 4849664,
	4784191, 4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876,
	4259840, 4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857,
	3735584, 3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800,
	3228032, 3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512,
	2686976, 2621440, 2555905, 2490368, 2425604, 2359368, 2293764, 2228224,
	2170401, 2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440,
	1639972, 1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748,
	1114412, 1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364,
	532480, 475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372}},
	{7340032, {7274496, 7208960, 7143424, 7077888, 7012352, 6946816, 6881313,
	6815744, 6750208, 6700928, 6619153, 6553600, 6488064, 6423040, 6359176,
	6291456, 6225920, 6160384, 6094848, 6029312, 5963776, 5898240, 5832704,
	5767168, 5701632, 5636096, 5624576, 5505025, 5439488, 5381632, 5308416,
	5269094, 5177382, 5111811, 5046272, 4980748, 4918080, 4849664, 4784191,
	4718593, 4653185, 4637520, 4521984, 4457448, 4390912, 4325876, 4259840,
	4199304, 4128768, 4064034, 3997864, 3932160, 3866625, 3833857, 3735584,
	3670016, 3604480, 3538944, 3473408, 3409952, 3342464, 3276800, 3228032,
	3146496, 3080960, 3016700, 2998476, 2886691, 2818048, 2752512, 2686976,
	2621440, 2555905, 2490368, 2425604, 2359376, 2293764, 2228224, 2170401,
	2098067, 2049004, 1978764, 1913228, 1836168, 1769474, 1707440, 1639972,
	1574682, 1507452, 1441793, 1377281, 1368136, 1255351, 1179748, 1114412,
	1048704, 984655, 925296, 868352, 806913, 720920, 659672, 591364, 532480,
	475314, 444418, 327880, 264771, 198210, 132352, 67592, 9372}}
};

#ifndef __BAREMETAL__

static inline void IicWriteData(int XIicDevFile, unsigned char command,
                                                   unsigned char length,
                                                   const unsigned char *values)
{
	struct i2c_smbus_ioctl_data args;
	unsigned char Block[XIIC_BLOCK_MAX];
	int Index;
	for (Index = 1; Index <= length; Index++)
		Block[Index] = values[Index-1];
	Block[0] = length;
	args.read_write = I2C_SMBUS_WRITE;
	args.command = command;
	args.size = I2C_SMBUS_I2C_BLOCK;
	args.data = (union i2c_smbus_data *) &Block;
	ioctl(XIicDevFile,I2C_SMBUS,&args);
}

static void Lmx2594Updatei2c(int XIicDevFile,unsigned int  r[LMX2594_A_count])
{
	int Index=0;
	//int val;
	unsigned char tx_array[3];
/*
 * 1. Apply power to device.
 * 2. Program RESET = 1 to reset registers.
 * 3. Program RESET = 0 to remove reset.
 * 4. Program registers as shown in the register map in REVERSE order from highest to lowest.
 * 5. Program register R0 one additional time with FCAL_EN = 1 to ensure that the VCO calibration runs from a
 * stable state.
 */
	tx_array[2] = 0x2;
	tx_array[1] = 0;
	tx_array[0] = 0;
	//val = tx_array[0] | (tx_array[1] << 8) | (tx_array[2] << 16 ) ;
	IicWriteData(XIicDevFile, 0xd, 3, tx_array);
	usleep(100000);
	tx_array[2] = 0;
	tx_array[1] = 0;
	tx_array[0] = 0;
	//val = tx_array[0] | (tx_array[1] << 8) | (tx_array[2] << 16 ) ;
	IicWriteData(XIicDevFile, 0xd, 3, tx_array);
	usleep(100000);
	for (Index = 0; Index < LMX2594_A_count; Index++) {
		tx_array[2] = (unsigned char) (r[Index]) & (0xFF);
		tx_array[1] = (unsigned char) (r[Index] >> 8) & (0xFF);
		tx_array[0] = (unsigned char) (r[Index] >> 16) & (0xFF);
		//val = tx_array[0] | (tx_array[1] << 8) | (tx_array[2] << 16 ) ;
		IicWriteData(XIicDevFile, 0xd, 3, tx_array);
		usleep(100000);
	}
	/* FCAL_EN = 1 */
	tx_array[2] = (unsigned char) (r[112]) & (0xFF);
	tx_array[1] = (unsigned char) (r[112] >> 8) & (0xFF);
	tx_array[0] = (unsigned char) (r[112] >> 16) & (0xFF);
	//val = tx_array[0] | (tx_array[1] << 8) | (tx_array[2] << 16 ) ;
	//printf("LMX configured \n");
	IicWriteData(XIicDevFile, 0xd, 3, tx_array);
}
static int Lmx2594UpdateFreq(int XIicDevFile,int  XFrequency)
{
	int XFreqIndex=0;
	unsigned char tx_array[3];
	//int freq_index=0;
	if (XFrequency == 0) {
		tx_array[2] = 0x3;
		tx_array[1] = 0;
		tx_array[0] = 0;

		IicWriteData(XIicDevFile, 0xd, 3, tx_array);
		return 0;
	}
	for(XFreqIndex=0 ; XFreqIndex< MAX_FREQ; XFreqIndex++) {
		if (ClockingLmx[XFreqIndex].XFrequency == XFrequency) {
			Lmx2594Updatei2c( XIicDevFile, ClockingLmx[XFreqIndex].LMX2594_A);
			return 0;
		}
	}

	printf("configuring default Frequency\n");
	Lmx2594Updatei2c( XIicDevFile, ClockingLmx[0].LMX2594_A);
	return 0;
}
static int Lmk04208UpdateFreq(int XIicDevFile, unsigned int LMK04208_CKin[1][26] )
{
	int Index;
	unsigned char tx_array[4];
	for (Index = 0; Index < LMK04208_count; Index++) {
		tx_array[3] = (unsigned char) (LMK04208_CKin[0][Index]) & (0xFF);
		tx_array[2] = (unsigned char) (LMK04208_CKin[0][Index] >> 8) & (0xFF);
		tx_array[1] = (unsigned char) (LMK04208_CKin[0][Index] >> 16) & (0xFF);
		tx_array[0] = (unsigned char) (LMK04208_CKin[0][Index] >> 24) & (0xFF);
		IicWriteData(XIicDevFile, 2, 4, tx_array);
		usleep(1000);
	}
	return 0;
}
#endif

/****************************************************************************/
/**
*
* This function is used to configure LMK04208
*
* @param	XIicBus is the Controller Id/Bus number.
*           - For Baremetal it is the I2C controller Id to which LMK04208
*             deviceis connected.
*           - For Linux it is the Bus Id to which LMK04208 device is connected.
* @param	LMK04208_CKin is the configuration array to configure the LMK04208.
*
* @return
*		- None
*
* @note   	None
*
****************************************************************************/
void LMK04208ClockConfig(int XIicBus, unsigned int LMK04208_CKin[1][26])
{
#ifdef __BAREMETAL__
	XIicPs_Config *Config_iic;
	int Status;
	u8 tx_array[10];
	u8 rx_array[10];
	u32 ClkRate = 100000;
	int Index;

	Config_iic = XIicPs_LookupConfig(XIicBus);
	if (NULL == Config_iic) {
		return;
	}

	Status = XIicPs_CfgInitialize(&Iic, Config_iic, Config_iic->BaseAddress);
	if (Status != XST_SUCCESS) {
		return;
	}

	Status = XIicPs_SetSClk(&Iic, ClkRate);
	if (Status != XST_SUCCESS) {
		return;
	}

	/*
	 * 0x02-enable Super clock module 0x20- analog I2C power module slaves
	 */
	tx_array[0] = 0x20;
	XIicPs_MasterSendPolled(&Iic, tx_array, 0x01, 0x74);
	while (XIicPs_BusIsBusy(&Iic))
		;
	usleep(25000);

	/*
	 * Receive the Data.
	 */
	Status = XIicPs_MasterRecvPolled(&Iic, rx_array, 1, 0x74);
	if (Status != XST_SUCCESS) {
		return;
	}

	/*
	 * Wait until bus is idle to start another transfer.
	 */
	while (XIicPs_BusIsBusy(&Iic))
		;


	/*
	 * Function Id.
	 */
	tx_array[0] = 0xF0;
	tx_array[1] = 0x02;
	XIicPs_MasterSendPolled(&Iic, tx_array, 0x02, 0x2F);
	while (XIicPs_BusIsBusy(&Iic))
		;
	usleep(25000);

	/*
	 * Receive the Data.
	 */
	Status = XIicPs_MasterRecvPolled(&Iic, rx_array,
			2, 0x2F);
	if (Status != XST_SUCCESS) {
		return;
	}

	/*
	 * Wait until bus is idle to start another transfer.
	 */
	while (XIicPs_BusIsBusy(&Iic));


	for (Index = 0; Index < LMK04208_count; Index++) {
		tx_array[0] = 0x02;
		tx_array[4] = (u8) (LMK04208_CKin[0][Index]) & (0xFF);
		tx_array[3] = (u8) (LMK04208_CKin[0][Index] >> 8) & (0xFF);
		tx_array[2] = (u8) (LMK04208_CKin[0][Index] >> 16) & (0xFF);
		tx_array[1] = (u8) (LMK04208_CKin[0][Index] >> 24) & (0xFF);
		Status = XIicPs_MasterSendPolled(&Iic, tx_array, 0x05, 0x2F);
		usleep(25000);
		while (XIicPs_BusIsBusy(&Iic))
			;
	}

	sleep(2);

	xil_printf("LMK04208 configuration write done\r\n");

#else
	int XIicDevFile;
	char XIicDevFilename[20];

	sprintf(XIicDevFilename, "/dev/i2c-%d", XIicBus);
	XIicDevFile = open(XIicDevFilename, O_RDWR);

	if (ioctl(XIicDevFile, I2C_SLAVE_FORCE, 0x2f) < 0) {
		printf("Error: Could not set address \n");
		return ;
	}

	Lmk04208UpdateFreq( XIicDevFile, LMK04208_CKin);
	close(XIicDevFile);
#endif
}

/****************************************************************************/
/**
*
* This function is used to configure LMX2594
*
* @param	XIicBus is the Controller Id/Bus number.
*           - For Baremetal it is the I2C controller Id to which LMX2594 device
*             is connected.
*           - For Linux it is the Bus Id to which LMX2594 device is connected.
* @param	XFrequency is the frequency used to configure the LMX2594.
*
* @return
*		- None
*
* @note   	None
*
****************************************************************************/
void LMX2594ClockConfig(int XIicBus, int XFrequency)
{
#ifdef __BAREMETAL__
	XIicPs_Config *Config_iic;
	int Status;
	u8 tx_array[10];
	u8 rx_array[10];
	u32 ClkRate = 100000;
	int Index;
	int freq_index=0;
	int XFreqIndex;

	for(XFreqIndex=0 ; XFreqIndex<MAX_FREQ; XFreqIndex++) {
		if (ClockingLmx[XFreqIndex].XFrequency == XFrequency) {
			freq_index =XFreqIndex;
			xil_printf("LMX configured to frequency %d \n", XFrequency);
		}
	}

	Config_iic = XIicPs_LookupConfig(XIicBus);
	if (NULL == Config_iic) {
		return;
	}

	Status = XIicPs_CfgInitialize(&Iic, Config_iic, Config_iic->BaseAddress);
	if (Status != XST_SUCCESS) {
		return;
	}

	Status = XIicPs_SetSClk(&Iic, ClkRate);
	if (Status != XST_SUCCESS) {
		return;
	}

	/*
	 * 0x02-enable Super clock module 0x20- analog I2C power module slaves
	 */
	tx_array[0] = 0x20;
	XIicPs_MasterSendPolled(&Iic, tx_array, 0x01, 0x74);
	while (XIicPs_BusIsBusy(&Iic))
		;
	usleep(25000);

	/*
	 * Receive the Data.
	 */
	Status = XIicPs_MasterRecvPolled(&Iic, rx_array, 1, 0x74);
	if (Status != XST_SUCCESS) {
		return;
	}

	/*
	 * Wait until bus is idle to start another transfer.
	 */
	while (XIicPs_BusIsBusy(&Iic))
		;

	/*
	 * Function Id.
	 */
	tx_array[0] = 0xF0;
	tx_array[1] = 0x02;
	XIicPs_MasterSendPolled(&Iic, tx_array, 0x02, 0x2F);
	while (XIicPs_BusIsBusy(&Iic))
		;
	usleep(25000);

	/*
	 * Receive the Data.
	 */
	Status = XIicPs_MasterRecvPolled(&Iic, rx_array,
			2, 0x2F);
	if (Status != XST_SUCCESS) {
		return;
	}

	/*
	 * Wait until bus is idle to start another transfer.
	 */
	while (XIicPs_BusIsBusy(&Iic));

	tx_array[0]=0x08;
	tx_array[3]=(u8) (0x00);
	tx_array[2]=(u8) (0x00);
	tx_array[1]=(u8) (0x20);
	Status = XIicPs_MasterSendPolled(&Iic,tx_array,0x04,0x2F);
	while (XIicPs_BusIsBusy(&Iic));

	sleep(2);

	tx_array[0]=0x08;
	tx_array[3]=(u8) (0x00);
	tx_array[2]=(u8) (0x00);
	tx_array[1]=(u8) (0x00);
	Status = XIicPs_MasterSendPolled(&Iic,tx_array,0x04,0x2F);
	while (XIicPs_BusIsBusy(&Iic));

	sleep(2);
	for (Index = 0; Index < LMX2594_A_count; Index++) {
		tx_array[0] = 0x08;
		tx_array[3] = (u8) (ClockingLmx[freq_index].LMX2594_A[Index]) & (0xFF);
		tx_array[2] = (u8) (ClockingLmx[freq_index].LMX2594_A[Index] >> 8) & (0xFF);
		tx_array[1] = (u8) (ClockingLmx[freq_index].LMX2594_A[Index] >> 16) & (0xFF);
		Status = XIicPs_MasterSendPolled(&Iic, tx_array, 0x04, 0x2F);
		while (XIicPs_BusIsBusy(&Iic))
			;
		usleep(25000);

	}

	tx_array[0] = 0x08;
	tx_array[3] = (u8) (ClockingLmx[freq_index].LMX2594_A[112]) & (0xFF);
	tx_array[2] = (u8) (ClockingLmx[freq_index].LMX2594_A[112] >> 8) & (0xFF);
	tx_array[1] = (u8) (ClockingLmx[freq_index].LMX2594_A[112] >> 16) & (0xFF);
	Status = XIicPs_MasterSendPolled(&Iic, tx_array, 0x04, 0x2F);
	while (XIicPs_BusIsBusy(&Iic))
		;
	usleep(25000);

	tx_array[0]=0x04;
	tx_array[3]=(u8) (0x00);
	tx_array[2]=(u8) (0x00);
	tx_array[1]=(u8) (0x02);
	Status = XIicPs_MasterSendPolled(&Iic,tx_array,0x04,0x2F);
	while (XIicPs_BusIsBusy(&Iic));

	sleep(2);
	tx_array[0]=0x04;
	tx_array[3]=(u8) (0x00);
	tx_array[2]=(u8) (0x00);
	tx_array[1]=(u8) (0x00);
	Status = XIicPs_MasterSendPolled(&Iic,tx_array,0x04,0x2F);
	while (XIicPs_BusIsBusy(&Iic));

	sleep(2);
	for (Index = 0; Index < LMX2594_A_count; Index++) {
		tx_array[0] = 0x04;
		tx_array[3] = (u8) (ClockingLmx[freq_index].LMX2594_A[Index]) & (0xFF);
		tx_array[2] = (u8) (ClockingLmx[freq_index].LMX2594_A[Index] >> 8) & (0xFF);
		tx_array[1] = (u8) (ClockingLmx[freq_index].LMX2594_A[Index] >> 16) & (0xFF);
		Status = XIicPs_MasterSendPolled(&Iic, tx_array, 0x04, 0x2F);
		while (XIicPs_BusIsBusy(&Iic))
			;
		usleep(25000);

	}

	tx_array[0]=0x04;
	tx_array[3] = (u8) (ClockingLmx[freq_index].LMX2594_A[112]) & (0xFF);
	tx_array[2] = (u8) (ClockingLmx[freq_index].LMX2594_A[112] >> 8) & (0xFF);
	tx_array[1] = (u8) (ClockingLmx[freq_index].LMX2594_A[112] >> 16) & (0xFF);
	Status = XIicPs_MasterSendPolled(&Iic, tx_array, 0x04, 0x2F);
	while (XIicPs_BusIsBusy(&Iic))
		;
	usleep(25000);

	tx_array[0]=0x01;
	tx_array[3]=(u8) (0x00);
	tx_array[2]=(u8) (0x00);
	tx_array[1]=(u8) (0x02);
	Status = XIicPs_MasterSendPolled(&Iic, tx_array, 0x04, 0x2F);
	while (XIicPs_BusIsBusy(&Iic));
	sleep(2);

	tx_array[0]=0x01;
	tx_array[3]=(u8) (0x00);
	tx_array[2]=(u8) (0x00);
	tx_array[1]=(u8) (0x00);
	Status = XIicPs_MasterSendPolled(&Iic, tx_array, 0x04, 0x2F);
	while (XIicPs_BusIsBusy(&Iic));
	sleep(2);

	for (Index = 0; Index < LMX2594_A_count; Index++) {
		tx_array[0] = 0x01;
		tx_array[3] = (u8) (ClockingLmx[freq_index].LMX2594_A[Index]) & (0xFF);
		tx_array[2] = (u8) (ClockingLmx[freq_index].LMX2594_A[Index]>> 8) & (0xFF);
		tx_array[1] = (u8) (ClockingLmx[freq_index].LMX2594_A[Index]>> 16) & (0xFF);
		Status = XIicPs_MasterSendPolled(&Iic, tx_array, 0x04, 0x2F);
		while (XIicPs_BusIsBusy(&Iic))
			;
		usleep(25000);
	}

	tx_array[0] = 0x01;
	tx_array[3] = (u8) (ClockingLmx[freq_index].LMX2594_A[112]) & (0xFF);
	tx_array[2] = (u8) (ClockingLmx[freq_index].LMX2594_A[112] >> 8) & (0xFF);
	tx_array[1] = (u8) (ClockingLmx[freq_index].LMX2594_A[112] >> 16) & (0xFF);
	Status = XIicPs_MasterSendPolled(&Iic, tx_array, 0x04, 0x2F);
	while (XIicPs_BusIsBusy(&Iic))
		;
	usleep(25000);
	xil_printf("I2c1 I2CTOSPI LMX2594 PLL configuration done\r\n");

#else
	int XIicDevFile;
	char XIicDevFilename[20];

	sprintf(XIicDevFilename, "/dev/i2c-%d", XIicBus);
	XIicDevFile = open(XIicDevFilename, O_RDWR);

	if (ioctl(XIicDevFile, I2C_SLAVE_FORCE, 0x2f) < 0) {
		printf("Error: Could not set address \n");
		return ;
	}

	Lmx2594UpdateFreq(XIicDevFile, XFrequency);
#endif
}

