
// SPDX-License-Identifier: GPL-3.0-only
//
// Copyright (C) 2025 Bit by Bit Signal Processing LLC  (https://bxbsp.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, version 3.0 of the License.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

//
// Note:  Some of this code originally started with Patrick Allison's
// libunivrfdc.  There's not so much left of what he was trying to do,
// but I owe him a debt for getting me started.
//

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "metal/sys.h"
#include "hwalloc.hh"


struct metal_device dummy_device;
struct metal_io_region this_region = { 0 };
volatile uint8_t* rf_converter;
static bool debug = false;

int metal_device_open(const char *bus_name,
		      const char *dev_name,
		      struct metal_device **device) {

  if(debug) printf("*****  metal_device_open called.  bus_name=%s, dev_name=%s\n", bus_name, dev_name);

  // OUCH!  It appears I hard-coded the address of the ADC/DAC converter here.
  // This needs fixing.
  rf_converter = hwalloc<uint8_t>(0xA0000000, 256*1024);

  if(!rf_converter)
    {
      printf("Can't allocate rf converter memory window.\n");
      exit(20);
    }
  
  *device = &dummy_device;
  strncpy(dummy_device.name, dev_name, 15);
  return 0;
}

void metal_log( int verbosity,
		const char *format,
		...) {
  va_list args;
  va_start( args, format );
  printf("metal_log<%d>:", verbosity);
  vprintf(format, args);
}

int metal_init(struct metal_init_params* mip)
{
  if(debug) printf("*****  metal_init called.\n");  
  return 0;
}


void metal_device_close(struct metal_device *device)
{
  if(debug) printf("*****  metal_device_close called.\n");
}

struct metal_io_region *metal_device_io_region(struct metal_device *dev,
					       unsigned int index)
{
  static struct metal_io_region s;
  if(debug) printf("*****  metal_io_region called, name=%s, index=%d.\n", dev->name, index);
  return &s;
}

void metal_io_write16( struct metal_io_region *io,
		       unsigned long offset,
		       uint16_t value )
{
  if(debug) printf("*****  metal_io_write16 called.  offset=%ld, value=%ld\n", (long)offset, (long)value);

  *(uint16_t*) (rf_converter+offset) = value;
}

void metal_io_write32( struct metal_io_region *io,
		       unsigned long offset,
		       uint32_t value )
{
  if(debug) printf("*****  metal_io_write32 called.  offset=%ld, value=%ld\n", (long)offset, (long)value);
  
  *(uint32_t*) (rf_converter+offset) = value;
}

uint16_t metal_io_read16( struct metal_io_region *io,
			  unsigned long offset )
{
  if(debug)printf("*****  metal_io_read16 called.  offset=%ld\n", (long)offset);

  uint16_t data = *(volatile uint16_t*) (rf_converter+offset);

  if(debug) printf("                                value=%ld\n", (long)data);

  return data;
}
uint32_t metal_io_read32( struct metal_io_region *io,
			  unsigned long offset )
{
  if(debug) printf("*****  metal_io_read32 called.  offset=%ld\n", (long)offset);

  uint32_t data = *(volatile uint32_t*) (rf_converter+offset);

  if(debug) printf("                                value=%ld\n", (long)data);

  return data;
}

void metal_io_set_device( void * dev,
			  read_function_t read_function,
			  write_function_t write_function)
{
  if(debug) printf("*****  metal_io_set_device called.\n");
}

int metal_linux_get_device_property(struct metal_device *dev,
				    const char *property_name,
				    void *output,
				    int len) {
  if(debug) printf("*****  metal_linux_get_device_property called.\n");
  return 0;
}


void
metal_io_init(struct metal_io_region *io, void *virt,
	      const metal_phys_addr_t *physmap, size_t size,
	      unsigned int page_shift, unsigned int mem_flags,
	      const struct metal_io_ops *ops)
{
  if(debug)
    {
      printf("*****  metal_io_init called.  physmap[0]=%ld, size=%ld, page_shift=%ld\n",
	     (long)physmap[0],
	     (long)size,
	     (long)page_shift);
    }
}


int32_t metal_register_generic_device(struct metal_device *s)
{
  if(debug) printf("*****  metal_register_generic_device called for %s.\n", s->name);
  return 0;
}

void* metal_allocate_memory(uint32_t length)
{
  if(debug) printf("*****  metal_alloc_memory called.\n");
  return (void*) malloc(length);
}

